/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes.impl;

import java.sql.CallableStatement;
import java.sql.SQLException;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.BindingStyle;
import oracle.dbtools.raptor.datatypes.CallableBinding;
import oracle.dbtools.raptor.datatypes.CallableBindingSplitMode;
import oracle.dbtools.raptor.datatypes.DataBinding;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataValue;
import oracle.dbtools.raptor.datatypes.PLSQLBoundBlockBuilder;

public abstract class CallableBindingImpl<P extends DataBinding>
implements CallableBinding<P> {
    private static final String FMT = "%1$-15s %2$-15s %3$-6s %4$-40s\n";
    protected final P param;
    protected final BindingMode mode;
    protected final DataType dataType;
    protected DataValue inputValue;
    protected DataValue outputValue;

    protected CallableBindingImpl(P p) {
        this(p, p.getDataType(), p.getMode());
    }

    protected CallableBindingImpl(P p, DataType dataType, BindingMode bindingMode) {
        this.param = p;
        this.dataType = dataType;
        this.mode = bindingMode;
        this.inputValue = null;
        this.outputValue = null;
    }

    @Override
    public final P getParameter() {
        return this.param;
    }

    @Override
    public final DataType getDataType() {
        return this.dataType;
    }

    @Override
    public final BindingMode getMode() {
        return this.mode;
    }

    @Override
    public abstract void setByNameBindToken(String var1);

    @Override
    public abstract String getByNameBindToken();

    @Override
    public abstract void setByPositionBindToken(String var1);

    @Override
    public abstract String getByPositionBindToken();

    @Override
    public abstract BindingStyle getBindingStyle(BindingMode var1);

    @Override
    public abstract String getBindToken(BindingMode var1);

    @Override
    public final DataValue getInput() throws SQLException {
        return this.inputValue;
    }

    @Override
    public final DataValue getOutput() throws SQLException {
        return this.customOutput();
    }

    protected abstract DataValue customOutput() throws SQLException;

    @Override
    public abstract CallableStatement getCallableStatement();

    protected abstract void setCallableStatement(CallableStatement var1);

    @Override
    public final void bind(CallableStatement callableStatement, DataValue dataValue) throws SQLException {
        this.setCallableStatement(callableStatement);
        this.inputValue = dataValue;
        this.outputValue = null;
        this.customBind(dataValue);
    }

    protected void customBind(DataValue dataValue) throws SQLException {
        switch (this.mode.getEffectiveMode()) {
            case IN: {
                this.customBindIN(dataValue);
                break;
            }
            case OUT: {
                this.customBindOUT();
                break;
            }
            case IN_OUT: {
                this.customBindIN(dataValue);
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindIN(DataValue var1) throws SQLException;

    @Override
    public final void bind(CallableStatement callableStatement) throws SQLException {
        this.setCallableStatement(callableStatement);
        this.inputValue = null;
        this.outputValue = null;
        this.customBind();
    }

    protected void customBind() throws SQLException {
        switch (this.mode.getEffectiveMode()) {
            case OUT: 
            case IN_OUT: {
                this.customBindOUT();
            }
        }
    }

    protected abstract void customBindOUT() throws SQLException;

    @Override
    public final PLSQLBoundBlockBuilder getBuilder() {
        return this.getBuilder(new PLSQLBoundBlockBuilder());
    }

    @Override
    public final PLSQLBoundBlockBuilder getBuilder(PLSQLBoundBlockBuilder pLSQLBoundBlockBuilder) {
        return this.customBuilder(pLSQLBoundBlockBuilder);
    }

    protected abstract PLSQLBoundBlockBuilder customBuilder(PLSQLBoundBlockBuilder var1);

    @Override
    public final void reportBinding(StringBuilder stringBuilder, DataValue dataValue) {
        this.customReportBinding(stringBuilder, dataValue);
    }

    @Override
    public final void reportBinding(StringBuilder stringBuilder, String string, DataValue dataValue) {
        this.customReportBinding(stringBuilder, string, dataValue);
    }

    protected void customReportBinding(StringBuilder stringBuilder, DataValue dataValue) {
        this.customReportBinding(stringBuilder, null, dataValue);
    }

    protected abstract void customReportBinding(StringBuilder var1, String var2, DataValue var3);

    protected final void reportBinding(StringBuilder stringBuilder, String string, String string2, DataType dataType, BindingMode bindingMode, String string3) {
        String string4;
        String string5 = bindingMode == BindingMode.OUT ? string : (string4 = string3 == null ? string : string3);
        if (string2 != null) {
            String string6 = bindingMode.toString();
            stringBuilder.append(String.format(FMT, string2, dataType.getPlainDataTypeString(), string6, string4));
        }
    }

    @Override
    public boolean isSupported(BindingMode bindingMode) {
        return true;
    }

    @Override
    public final CallableBindingSplitMode<P> getSplitModeBinding() {
        return this.customSplitModeBinding();
    }

    protected abstract CallableBindingSplitMode<P> customSplitModeBinding();
}

