/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.datatypes;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.BindContext;
import oracle.dbtools.raptor.datatypes.BindingMode;
import oracle.dbtools.raptor.datatypes.DataParameter;
import oracle.dbtools.raptor.datatypes.DataType;
import oracle.dbtools.raptor.datatypes.DataTypeConnectionProvider;
import oracle.dbtools.raptor.datatypes.DataTypeContext;
import oracle.dbtools.raptor.datatypes.DataTypeProvider;
import oracle.dbtools.raptor.datatypes.DataVariable;
import oracle.dbtools.raptor.datatypes.NamedValue;
import oracle.dbtools.raptor.datatypes.TypeMetadata;
import oracle.dbtools.raptor.datatypes.impl.AbstractDataTypeFactoryImpl;
import oracle.dbtools.raptor.datatypes.impl.BindContextImpl;
import oracle.dbtools.raptor.datatypes.impl.DataParameterImpl;
import oracle.dbtools.raptor.datatypes.impl.DataTypeConnectionProviderImpl;
import oracle.dbtools.raptor.datatypes.impl.DataVariableImpl;
import oracle.dbtools.raptor.datatypes.oracle.plsql.OraclePLSQLDataTypeFactory;
import oracle.dbtools.raptor.datatypes.oracle.sql.OracleSQLDataTypeFactory;
import oracle.jdbc.OracleConnection;

public class DataTypeFactory {
    private static DataTypeFactory instance = null;
    private DataTypeProvider unsupportedDataProvider = null;
    private DataTypeProvider nativeJDBCProviderChain = null;
    private DataTypeProvider oracleProviderChain = null;
    private DataTypeProvider allProviderChain = null;
    private Map<Connection, SoftReference<DataTypeConnectionProvider>> connectionProviderCache = new WeakHashMap<Connection, SoftReference<DataTypeConnectionProvider>>();
    private Map<DataTypeConnectionProvider, SoftReference<DataTypeContext>> contextCache = new WeakHashMap<DataTypeConnectionProvider, SoftReference<DataTypeContext>>();
    private Map<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>> dataTypeCache = new WeakHashMap<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>>();
    private int creates = 0;
    private int frees = 0;
    private int reuses = 0;
    private Timer timer;

    protected DataTypeFactory() {
    }

    public static synchronized DataTypeFactory getInstance() {
        if (instance == null) {
            instance = new DataTypeFactory();
        }
        return instance;
    }

    public DataType getDataType(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        return this.makeDataType(dataTypeContext, typeMetadata);
    }

    public DataType getDataType(DataTypeConnectionProvider dataTypeConnectionProvider, TypeMetadata typeMetadata) {
        return this.getDataType(this.getDataTypeContext(dataTypeConnectionProvider), typeMetadata);
    }

    public DataType getDataType(Connection connection, TypeMetadata typeMetadata) {
        return this.getDataType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public boolean isSupportedType(DataTypeConnectionProvider dataTypeConnectionProvider, TypeMetadata typeMetadata) {
        try {
            DataType dataType = this.getDataType(dataTypeConnectionProvider, typeMetadata);
            return dataType != null && dataType.isSupported();
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, TypeMetadata typeMetadata) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), typeMetadata);
    }

    public boolean isSupportedType(DataTypeConnectionProvider dataTypeConnectionProvider, Integer n) {
        try {
            TypeMetadata typeMetadata = this.getTypeMetadata(dataTypeConnectionProvider, n);
            return this.isSupportedType(dataTypeConnectionProvider, typeMetadata);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, Integer n) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), n);
    }

    public boolean isSupportedType(DataTypeConnectionProvider dataTypeConnectionProvider, Integer n, Object object) {
        try {
            TypeMetadata typeMetadata = this.getTypeMetadata(dataTypeConnectionProvider, n, object);
            return this.isSupportedType(dataTypeConnectionProvider, typeMetadata);
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
            return false;
        }
    }

    public boolean isSupportedType(Connection connection, Integer n, Object object) {
        return this.isSupportedType(this.getDataTypeConnectionProvider(connection), n, object);
    }

    public Set<String> getSupportedTypes(Class<? extends Connection> clazz) {
        return this.getProviderChain(clazz).getSupportedTypes();
    }

    public Set<String> getSupportedTypes(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return this.getSupportedTypes(dataTypeConnectionProvider.getDataTypeConnnectionClass());
    }

    public Set<String> getSupportedTypes(Connection connection) {
        return this.getSupportedTypes(connection.getClass());
    }

    public Set<Integer> getSupportedSQLTypes(Class<? extends Connection> clazz) {
        return this.getProviderChain(clazz).getSupportedSQLTypes();
    }

    public Set<Integer> getSupportedSQLTypes(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return this.getSupportedSQLTypes(dataTypeConnectionProvider.getDataTypeConnnectionClass());
    }

    public Set<Integer> getSupportedSQLTypes(Connection connection) {
        return this.getSupportedSQLTypes(connection.getClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Class<? extends Connection> clazz) {
        return this.getProviderChain(clazz).getSupportedTypeMetadata();
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return this.getSupportedTypeMetadata(dataTypeConnectionProvider.getDataTypeConnnectionClass());
    }

    public Map<String, TypeMetadata> getSupportedTypeMetadata(Connection connection) {
        return this.getSupportedTypeMetadata(connection.getClass());
    }

    public Set<String> getAllSupportedTypes() {
        return this.getAllProviderChain().getSupportedTypes();
    }

    public Set<Integer> getAllSupportedSQLTypes() {
        return this.getAllProviderChain().getSupportedSQLTypes();
    }

    public TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> map) {
        return new TypeMetadata(map);
    }

    public static TypeMetadata getTypeMetadata(Map<TypeMetadata.Attribute, Object> map, boolean bl) {
        return new TypeMetadata(map, bl);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata typeMetadata, Map<TypeMetadata.Attribute, Object> map) {
        return TypeMetadata.overideTypeMetadata(typeMetadata, map);
    }

    public static TypeMetadata getTypeMetadata(TypeMetadata typeMetadata, TypeMetadata typeMetadata2) {
        return TypeMetadata.overideTypeMetadata(typeMetadata, typeMetadata2);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider dataTypeConnectionProvider, Integer n) {
        return this.getProviderChain(dataTypeConnectionProvider).getTypeMetadata(n);
    }

    public TypeMetadata getTypeMetadata(Connection connection, Integer n) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), n);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider dataTypeConnectionProvider, Integer n, Object object) {
        return this.getProviderChain(dataTypeConnectionProvider).getTypeMetadata(this.getDataTypeContext(dataTypeConnectionProvider), n, object);
    }

    public TypeMetadata getTypeMetadata(Connection connection, Integer n, Object object) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), n, object);
    }

    public TypeMetadata getTypeMetadata(DataTypeConnectionProvider dataTypeConnectionProvider, String string) {
        return this.getProviderChain(dataTypeConnectionProvider).getTypeMetadata(string);
    }

    public TypeMetadata getTypeMetadata(Connection connection, String string) {
        return this.getTypeMetadata(this.getDataTypeConnectionProvider(connection), string);
    }

    public DataVariable getDataVariable(String string, DataType dataType, BindingMode bindingMode) {
        return new DataVariableImpl(string, dataType, bindingMode);
    }

    public DataParameter getDataParameter(String string, DataType dataType, BindingMode bindingMode) {
        return new DataParameterImpl(string, dataType, bindingMode);
    }

    public BindContext getBindContext(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return new BindContextImpl(dataTypeConnectionProvider);
    }

    public BindContext getBindContext(Connection connection) {
        return this.getBindContext(this.getDataTypeConnectionProvider(connection));
    }

    private DataTypeContext getDataTypeContext(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return this.makeDataTypeContext(dataTypeConnectionProvider);
    }

    private DataTypeConnectionProvider getDataTypeConnectionProvider(Connection connection) {
        return this.makeDataTypeConnectionProvider(connection);
    }

    private synchronized DataTypeConnectionProvider makeDataTypeConnectionProvider(Connection connection) {
        DataTypeConnectionProvider dataTypeConnectionProvider;
        SoftReference<DataTypeConnectionProvider> softReference = this.connectionProviderCache.get(connection);
        DataTypeConnectionProvider dataTypeConnectionProvider2 = dataTypeConnectionProvider = softReference != null ? softReference.get() : null;
        if (dataTypeConnectionProvider == null) {
            dataTypeConnectionProvider = this.buildDataTypeConnectionProvider(connection);
            this.connectionProviderCache.put(connection, new SoftReference<DataTypeConnectionProvider>(dataTypeConnectionProvider));
            ++this.creates;
        } else {
            ++this.reuses;
        }
        return dataTypeConnectionProvider;
    }

    protected DataTypeConnectionProvider buildDataTypeConnectionProvider(Connection connection) {
        if (connection == null) {
            return new DataTypeConnectionProviderImpl<Class<Connection>>(Connection.class);
        }
        return new DataTypeConnectionProviderImpl<Connection>(connection);
    }

    private synchronized DataTypeContext makeDataTypeContext(DataTypeConnectionProvider dataTypeConnectionProvider) {
        DataTypeContext dataTypeContext;
        SoftReference<DataTypeContext> softReference = this.contextCache.get(dataTypeConnectionProvider);
        DataTypeContext dataTypeContext2 = dataTypeContext = softReference != null ? softReference.get() : null;
        if (dataTypeContext == null) {
            dataTypeContext = new DataTypeContext(this, dataTypeConnectionProvider);
            this.contextCache.put(dataTypeConnectionProvider, new SoftReference<DataTypeContext>(dataTypeContext));
            ++this.creates;
        } else {
            ++this.reuses;
        }
        return dataTypeContext;
    }

    protected DataTypeContext builDataTypeContext(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return new DataTypeContext(this, dataTypeConnectionProvider);
    }

    private synchronized DataType makeDataType(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        DataType dataType = this.lookupDataType(dataTypeContext, typeMetadata);
        if (dataType == null) {
            dataType = this.cacheDataType(dataTypeContext, typeMetadata, this.getProviderChain(dataTypeContext.getDataTypeConnectionProvider()).getDataType(dataTypeContext, typeMetadata));
        } else {
            ++this.reuses;
        }
        return dataType;
    }

    private synchronized DataType lookupDataType(DataTypeContext dataTypeContext, TypeMetadata typeMetadata) {
        DataType dataType = null;
        Map<TypeMetadata, SoftReference<DataType>> map = this.dataTypeCache.get(dataTypeContext);
        if (map != null) {
            SoftReference<DataType> softReference = map.get(typeMetadata);
            dataType = softReference != null ? softReference.get() : null;
        }
        return dataType;
    }

    private synchronized DataType cacheDataType(DataTypeContext dataTypeContext, TypeMetadata typeMetadata, DataType dataType) {
        if (dataType != null) {
            Map<TypeMetadata, SoftReference<DataType>> map = this.dataTypeCache.get(dataTypeContext);
            if (map == null) {
                map = new WeakHashMap<TypeMetadata, SoftReference<DataType>>();
                this.dataTypeCache.put(dataTypeContext, map);
                ++this.creates;
            }
            map.put(typeMetadata, new SoftReference<DataType>(dataType));
            ++this.creates;
        }
        return dataType;
    }

    private synchronized void doCleanupCache() {
        Map.Entry entry;
        Object object;
        Map.Entry<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>> entry2;
        Iterator<Map.Entry<DataTypeContext, Map<TypeMetadata, SoftReference<DataType>>>> iterator = this.dataTypeCache.entrySet().iterator();
        while (iterator.hasNext()) {
            entry2 = iterator.next();
            if (entry2.getValue() == null || ((Map)entry2.getValue()).isEmpty()) {
                iterator.remove();
                ++this.frees;
                continue;
            }
            object = ((Map)entry2.getValue()).entrySet().iterator();
            while (object.hasNext()) {
                entry = object.next();
                if (entry.getValue() != null && ((SoftReference)entry.getValue()).get() != null) continue;
                object.remove();
                ++this.frees;
            }
            if (!((Map)entry2.getValue()).isEmpty()) continue;
            iterator.remove();
            ++this.frees;
        }
        entry2 = this.contextCache.entrySet().iterator();
        while (entry2.hasNext()) {
            object = (Map.Entry)entry2.next();
            if (object.getValue() != null && ((SoftReference)object.getValue()).get() != null) continue;
            entry2.remove();
            ++this.frees;
        }
        object = this.connectionProviderCache.entrySet().iterator();
        while (object.hasNext()) {
            entry = object.next();
            if (entry.getValue() != null && ((SoftReference)entry.getValue()).get() != null) continue;
            object.remove();
            ++this.frees;
        }
    }

    private DataTypeProvider getProviderChain(Class<? extends Connection> clazz) {
        if (OracleConnection.class.isAssignableFrom(clazz)) {
            return this.getOracleProviderChain();
        }
        if (Connection.class.isAssignableFrom(clazz)) {
            return this.getNativeJDBCProviderChain();
        }
        return this.getUnsupportedDataProvider();
    }

    private DataTypeProvider getProviderChain(DataTypeConnectionProvider dataTypeConnectionProvider) {
        return this.getProviderChain(dataTypeConnectionProvider.getDataTypeConnnectionClass());
    }

    private DataTypeProvider getUnsupportedDataProvider() {
        if (this.unsupportedDataProvider == null) {
            this.unsupportedDataProvider = new UnsupportedDataProvider(null);
        }
        return this.unsupportedDataProvider;
    }

    private DataTypeProvider getNativeJDBCProviderChain() {
        if (this.nativeJDBCProviderChain == null) {
            this.nativeJDBCProviderChain = this.getUnsupportedDataProvider();
        }
        return this.nativeJDBCProviderChain;
    }

    private DataTypeProvider getOracleProviderChain() {
        if (this.oracleProviderChain == null) {
            this.oracleProviderChain = new OraclePLSQLDataTypeFactory(new OracleSQLDataTypeFactory(this.getNativeJDBCProviderChain()));
        }
        return this.oracleProviderChain;
    }

    private DataTypeProvider getAllProviderChain() {
        if (this.allProviderChain == null) {
            this.allProviderChain = this.getOracleProviderChain();
        }
        return this.allProviderChain;
    }

    private class UnsupportedDataProvider
    extends AbstractDataTypeFactoryImpl {
        protected UnsupportedDataProvider(DataTypeProvider dataTypeProvider) {
            super(dataTypeProvider, new HashMap<String, NamedValue<Map<TypeMetadata.Attribute, Object>>>());
        }
    }
}

