/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.editableheader;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.raptor.controls.grid.editableheader.EditableHeader;

public class EditableHeaderUI
extends BasicTableHeaderUI {
    @Override
    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler((EditableHeader)this.header);
    }

    public class MouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        private Component dispatchComponent;
        protected EditableHeader header;

        public MouseInputHandler(EditableHeader editableHeader) {
            super(EditableHeaderUI.this);
            this.header = editableHeader;
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = this.header.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(this.header, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this.header, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            super.mousePressed(mouseEvent);
            if (this.header.getResizingColumn() == null) {
                Point point = mouseEvent.getPoint();
                TableColumnModel tableColumnModel = this.header.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(point.x);
                if (n != -1 && this.header.editCellAt(n, mouseEvent)) {
                    this.setDispatchComponent(mouseEvent);
                    this.repostEvent(mouseEvent);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            this.dispatchComponent = null;
        }
    }
}

