/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.util.EventObject;
import javax.swing.Icon;
import javax.swing.table.JTableHeader;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;

public abstract class GridContextMenuItem
implements ContextMenuListener,
Controller {
    protected RaptorGridTable _table = null;

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public void menuWillShow(ContextMenu contextMenu) {
        this.getTableFromContext(contextMenu.getContext());
        if (this._table != null && this.canShow(contextMenu)) {
            this.createAndShowMenu(contextMenu);
        }
    }

    protected abstract void createAndShowMenu(ContextMenu var1);

    protected abstract boolean canShow(ContextMenu var1);

    protected IdeAction createAction(int n, String string, Icon icon) {
        String string2 = StringUtils.stripMnemonic((String)string);
        Integer n2 = new Integer(StringUtils.getMnemonicKeyCode((String)string));
        IdeAction ideAction = IdeAction.get((int)n, null, (String)string2, null, (Integer)n2, (Icon)icon, null, (boolean)true);
        ideAction.setEnabled(true);
        ideAction.addController((Controller)this);
        return ideAction;
    }

    protected void getTableFromContext(Context context) {
        EventObject eventObject = context.getEvent();
        Object object = null;
        if (context.getProperty("RaptorGridTable") != null) {
            object = context.getProperty("RaptorGridTable");
        } else if (eventObject != null) {
            object = eventObject.getSource();
        }
        if (object != null) {
            this.getTableFromSrc(object);
        }
    }

    private void getTableFromSrc(Object object) {
        if (object instanceof RaptorGridTable) {
            this._table = (RaptorGridTable)object;
        } else if (object instanceof JTableHeader) {
            if (((JTableHeader)object).getTable() instanceof RaptorGridTable) {
                this._table = (RaptorGridTable)((JTableHeader)object).getTable();
            }
        } else {
            this._table = null;
        }
    }

    public void releaseGrid() {
        this._table = null;
    }
}

