/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid.contextmenu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JMenuItem;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.dbtools.raptor.controls.ShuttlePanel;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.dialogs.DialogSizeKeeper;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;

public class ColumnSelector
extends GridHeaderContextMenuItem {
    public static final String _cmdGridColumnSelector = "cmdGridColumnSelector";
    public static final int _cmdIdGridColumnSelector = Ide.findOrCreateCmdID((String)"cmdGridColumnSelector");
    private IdeAction _actionGridColumnSelector;
    private JEWTDialog dlg = null;
    private static ColumnSelector _instance = null;
    private JMenuItem _mi = null;

    private ColumnSelector() {
        this.initAction();
    }

    public static GridHeaderContextMenuItem getInstance() {
        if (_instance == null) {
            _instance = new ColumnSelector();
        }
        return _instance;
    }

    private void initAction() {
        if (this._actionGridColumnSelector == null) {
            this._actionGridColumnSelector = this.createAction(_cmdIdGridColumnSelector, Messages.getString("ColumnSelector.1"), null);
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        if (ideAction.getCommandId() == _cmdIdGridColumnSelector && this._table != null) {
            final ShuttlePanel<GridColumn> shuttlePanel = new ShuttlePanel<GridColumn>(Messages.getString("ColumnSelector.0"), Messages.getString("ColumnSelector.3"), Messages.getString("ColumnSelector.4"));
            shuttlePanel.getShuttle().setLayoutReversed(true);
            shuttlePanel.setToList(this._table.getShownColumns());
            shuttlePanel.setFromList(this._table.getHiddenColumns());
            TableColumnRenderer tableColumnRenderer = new TableColumnRenderer(this._table);
            shuttlePanel.setFromListRenderer(tableColumnRenderer);
            shuttlePanel.setToListRenderer(tableColumnRenderer);
            Dimension dimension = shuttlePanel.getPreferredSize();
            dimension.setSize(dimension.getWidth() + 150.0, dimension.getHeight() + 100.0);
            HelpSystem.getHelpSystem().registerTopic(shuttlePanel, "f1_managecolumns_html");
            this.dlg = OnePageWizardDialogFactory.createJEWTDialog(shuttlePanel, null, (String)Messages.getString("ColumnSelector.2"), (int)7);
            this.dlg.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ((JEWTDialog)actionEvent.getSource()).closeDialog(false);
                }
            });
            this.dlg.setSize(dimension);
            this.dlg.setModal(true);
            DialogSizeKeeper.attachToComponent((Component)this.dlg, (String)"Locales selector.dialogSize");
            this.dlg.setLocationRelativeTo(null);
            shuttlePanel.getShuttle().addShuttleListener(new ShuttleListener(){

                public void shuttleItemsMoved(ShuttleEvent shuttleEvent) {
                    ColumnSelector.this.dlg.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
                }

                public void shuttleItemsRemoved(ShuttleEvent shuttleEvent) {
                    ColumnSelector.this.dlg.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
                }

                public void shuttleItemsReordered(ShuttleEvent shuttleEvent) {
                    ColumnSelector.this.dlg.setOKButtonEnabled(shuttlePanel.getToList().size() > 0);
                }
            });
            this.dlg.setVisible(true);
            if (!this.dlg.isCancelled()) {
                this._table.hideColumns(shuttlePanel.getFromList(), shuttlePanel.getToList());
                RaptorGridPersistedSettings.savePersistentSettings(this._table);
            }
            this._table.requestFocusInWindow();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        ideAction.setEnabled(this._table != null && this._table.canColumnSelectNow());
        return true;
    }

    @Override
    protected boolean canShow(ContextMenu contextMenu) {
        return this._table.isColumnSelectorAvailable();
    }

    @Override
    protected void createAndShowMenu(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        contextMenu.add((Component)this._mi);
    }

    private void createJMenuItem(ContextMenu contextMenu) {
        if (this._mi == null) {
            this._mi = contextMenu.createMenuItem((ToggleAction)this._actionGridColumnSelector);
        }
    }

    @Override
    public JMenuItem[] getJMenuItems(ContextMenu contextMenu) {
        this.createJMenuItem(contextMenu);
        return new JMenuItem[]{this._mi};
    }

    private static class TableColumnRenderer
    extends DefaultListCellRenderer {
        TableColumnRenderer(RaptorGridTable raptorGridTable) {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            GridColumn gridColumn = (GridColumn)object;
            this.setText(gridColumn.getOriginal());
            return this;
        }
    }
}

