/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.AbstractRaptorGridModel;
import oracle.dbtools.raptor.controls.grid.ColumnAutoSizer;
import oracle.dbtools.raptor.controls.grid.ColumnHeaderCellRenderer;
import oracle.dbtools.raptor.controls.grid.FinderHighlighter;
import oracle.dbtools.raptor.controls.grid.GridColumn;
import oracle.dbtools.raptor.controls.grid.GridColumnSortParameter;
import oracle.dbtools.raptor.controls.grid.RaptorGridCopyAdapter;
import oracle.dbtools.raptor.controls.grid.RaptorGridPersistedSettings;
import oracle.dbtools.raptor.controls.grid.RaptorGridSearchParameter;
import oracle.dbtools.raptor.controls.grid.contextmenu.ColumnAutoFit;
import oracle.dbtools.raptor.controls.grid.contextmenu.ColumnSelector;
import oracle.dbtools.raptor.controls.grid.contextmenu.CopyColumnHeader;
import oracle.dbtools.raptor.controls.grid.contextmenu.CountRows;
import oracle.dbtools.raptor.controls.grid.contextmenu.DeleteSettings;
import oracle.dbtools.raptor.controls.grid.contextmenu.FindHighlight;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridHeaderContextMenuItem;
import oracle.dbtools.raptor.controls.grid.contextmenu.GridSorter;
import oracle.dbtools.raptor.controls.grid.contextmenu.HeaderMenu;
import oracle.dbtools.raptor.controls.grid.contextmenu.Messages;
import oracle.dbtools.raptor.controls.grid.contextmenu.SingleRecordView;
import oracle.dbtools.util.Debug;
import oracle.dbtools.util.Logger;
import oracle.ide.Context;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.util.MnemonicSolver;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.Pair;

public class RaptorGridTable
extends JTable {
    protected static final long serialVersionUID = 1L;
    protected static final int ROW_NUMBER_WIDTH = 45;
    protected static final int ROW_HEIGHT = 20;
    protected JTable _rowHeader;
    protected RaptorGridCopyAdapter _copyAdapter = null;
    protected KeyStroke copyWithHeader = KeyStroke.getKeyStroke(67, 3, false);
    protected KeyStroke copyHeader = KeyStroke.getKeyStroke(72, 2, false);
    private KeyStroke fetchAll = KeyStroke.getKeyStroke(34, 2, false);
    private KeyStroke fetchEndAll = KeyStroke.getKeyStroke(35, 2, false);
    protected int _lastSelectedRow = -1;
    protected int _lastSelectedCol = -1;
    protected boolean _newRowSelected = false;
    protected boolean _editable = false;
    protected boolean _verticalDisplay = false;
    protected Boolean _isHostedInDialog = null;
    protected boolean isColumnSortingEnabled = true;
    protected boolean isColumnSelectorAvailable = true;
    protected boolean isMultiColSort = true;
    private static ContextMenu _gridCM = new ContextMenu(new MnemonicSolver());
    private static ContextMenu _columnHeaderCM = new ContextMenu();
    private ArrayList<GridContextMenuItem> _localCTXMenuItems;
    private RaptorGridSettingsPersistor _settingsPersistor = new RaptorGridSettingsPersistor();
    private ActionListener _copyPasteListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().compareTo("Copy.With.Header") == 0) {
                RaptorGridTable.this._copyAdapter.copyToClipboard(false, true);
            } else if (actionEvent.getActionCommand().compareTo("Copy.Header") == 0) {
                RaptorGridTable.this._copyAdapter.copyHeadertoClipboard();
            }
        }
    };
    private static MouseListener _contextMenuMouseListener = null;
    protected List<RaptorGridSearchParameter> _highlights = new ArrayList<RaptorGridSearchParameter>();
    private static boolean _initedStatics;
    private boolean _allowContextMenu = true;
    protected View _view = null;
    static final String EVENT_SOURCE = "eventSource";
    private Controller controller = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            int n = ideAction.getCommandId();
            RaptorGridTable raptorGridTable = RaptorGridTable.this;
            Object object = context.getProperty("RGT");
            if (raptorGridTable != object) {
                return false;
            }
            switch (n) {
                case 17: {
                    if (RaptorGridTable.this.getGridCopyAdapter().canCut()) {
                        RaptorGridTable.this.getGridCopyAdapter().copyToClipboard(true);
                    }
                    return true;
                }
                case 18: {
                    if (RaptorGridTable.this.getGridCopyAdapter().canCopy()) {
                        RaptorGridTable.this.getGridCopyAdapter().copyToClipboard();
                    }
                    return true;
                }
                case 19: {
                    RaptorGridTable.this.getGridCopyAdapter().pasteToJTable();
                    return true;
                }
                case 23: {
                    FinderHighlighter.showDialog(RaptorGridTable.this);
                    return true;
                }
                case 22: {
                    RaptorGridTable.this.selectAll();
                    return true;
                }
            }
            return false;
        }

        private boolean shouldUpdate() {
            boolean bl = false;
            if (RaptorGridTable.this.showing) {
                Container container = RaptorGridTable.this;
                do {
                    if (container.hasFocus()) {
                        bl = true;
                        container = null;
                        continue;
                    }
                    if (!((container = container.getParent()) instanceof Window)) continue;
                    container = null;
                } while (container != null);
            }
            return bl;
        }

        public boolean update(IdeAction ideAction, Context context) {
            Object object;
            int n = ideAction.getCommandId();
            if (this.shouldUpdate()) {
                context.setProperty("RGT", (Object)RaptorGridTable.this);
                Logger.info(this.getClass(), (String)("update returning true for Grid" + RaptorGridTable.this.__myGridNum + context));
                if (n == 17) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canCut());
                    return true;
                }
                if (n == 18) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canCopy());
                    return true;
                }
                if (n == 19) {
                    ideAction.setEnabled(RaptorGridTable.this.getGridCopyAdapter().canPaste());
                    return true;
                }
                if (n == 23) {
                    ideAction.setEnabled(true);
                    return true;
                }
                if (n == 22) {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
            if (RaptorGridTable.this == (object = context.getProperty("RGT"))) {
                context.setProperty("RGT", null);
            }
            Logger.info(this.getClass(), (String)("update returning false for Grid" + RaptorGridTable.this.__myGridNum + context));
            return false;
        }
    };
    private ContextMenuListener cmListener = new ContextMenuListener(){

        public boolean handleDefaultAction(Context context) {
            boolean bl = false;
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    if (bl) continue;
                    bl = gridContextMenuItem.handleDefaultAction(context);
                }
            }
            return bl;
        }

        public void menuWillHide(ContextMenu contextMenu) {
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    gridContextMenuItem.menuWillHide(contextMenu);
                }
            }
        }

        public void menuWillShow(ContextMenu contextMenu) {
            if (RaptorGridTable.this._allowContextMenu && RaptorGridTable.this._localCTXMenuItems != null) {
                for (GridContextMenuItem gridContextMenuItem : RaptorGridTable.this._localCTXMenuItems) {
                    gridContextMenuItem.menuWillShow(contextMenu);
                }
            }
        }
    };
    private static int lastGridNum;
    private int __myGridNum;
    static final String yellowBgColor = "#ffffdf";
    static final String grayBgColor = "#dfdfdf";
    static final String yellowBgColor1 = "#ffffd2";
    static final String grayBgColor1 = "#dfd5d1";
    static final Color color00;
    static final Color color01;
    static final Color color10;
    static final Color color11;
    private IdeAction[] ideActions;
    private boolean showing = true;
    private FireUpdateIdeActionsListener fireUpdateIdeActionsListener = new FireUpdateIdeActionsListener();

    public RaptorGridTable() {
        this.__myGridNum = ++lastGridNum;
        this.addAncestorListener(this.fireUpdateIdeActionsListener);
        this.addFocusListener(this.fireUpdateIdeActionsListener);
        this.initStatics();
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.setAutoResizeMode(0);
        this.getTableHeader().setAutoscrolls(true);
        this.setDragEnabled(true);
        this.setDefaultRenderer(TableColumn.class, new DefaultTableCellRenderer());
        this.setSurrendersFocusOnKeystroke(true);
        this.setAutoCreateColumnsFromModel(true);
        this.getTableHeader().addMouseListener(new ColumnAutoSizer());
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        this.setRowHeight(20);
        this._copyAdapter = new RaptorGridCopyAdapter(this);
        this.registerKeyboardAction(this._copyPasteListener, "Copy.With.Header", this.copyWithHeader, 0);
        this.registerKeyboardAction(this._copyPasteListener, "Copy.Header", this.copyHeader, 0);
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    IdeMainWindow.updateVisibleActions();
                }
            }
        });
        _contextMenuMouseListener = new MouseAdapter(){
            private Context _context = new Context();

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showPopup(mouseEvent);
                }
            }

            private void showPopup(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == RaptorGridTable.this) {
                    this._context.setProperty("RaptorGridTable", mouseEvent.getSource());
                    this._context.setEvent((EventObject)mouseEvent);
                    if (RaptorGridTable.this.getView() != null) {
                        this._context.setView(RaptorGridTable.this.getView());
                    }
                    _gridCM.show(this._context);
                } else if (mouseEvent.getSource() == RaptorGridTable.this.getTableHeader()) {
                    this._context.setProperty("RaptorGridTable", mouseEvent.getSource());
                    this._context.setEvent((EventObject)mouseEvent);
                    if (RaptorGridTable.this.getView() != null) {
                        this._context.setView(RaptorGridTable.this.getView());
                    }
                    _columnHeaderCM.show(this._context);
                }
            }
        };
        this.addMouseListener(_contextMenuMouseListener);
        this.getTableHeader().addMouseListener(_contextMenuMouseListener);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                if (mouseEvent.getSource() instanceof JTableHeader) {
                    JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
                    JTable jTable = jTableHeader.getTable();
                    if (jTable.isEditing()) {
                        jTable.getCellEditor().cancelCellEditing();
                    }
                    if (mouseEvent.getClickCount() == 2 && RaptorGridTable.this.canSortNow()) {
                        GridColumn gridColumn;
                        List<? extends GridColumn> list;
                        AbstractRaptorGridModel abstractRaptorGridModel;
                        int n;
                        int n2 = RaptorGridTable.this.columnAtPoint(mouseEvent.getPoint());
                        int n3 = RaptorGridTable.this.convertColumnIndexToModel(n2);
                        int n4 = n = jTableHeader.getResizingColumn() != null ? jTableHeader.getResizingColumn().getModelIndex() : -1;
                        if (n3 != -1 && jTableHeader.getResizingColumn() == null && (abstractRaptorGridModel = RaptorGridTable.this.getGridModel()) != null && abstractRaptorGridModel.isColumnSortable(n3) && (list = abstractRaptorGridModel.getGridColumns()) != null && list.size() > 0 && (gridColumn = list.get(n3)) != null) {
                            for (GridColumn gridColumn2 : list) {
                                if (gridColumn2 == gridColumn) continue;
                                gridColumn2.setSortParameter(null);
                            }
                            GridColumnSortParameter gridColumnSortParameter = gridColumn.getSortParameter();
                            if (gridColumnSortParameter != null) {
                                if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.ASCENDING) {
                                    gridColumnSortParameter.setSortDir(GridColumnSortParameter.SortDir.DESCENDING);
                                    gridColumnSortParameter.setSortOrder(0);
                                } else if (gridColumnSortParameter.getSortDir() == GridColumnSortParameter.SortDir.DESCENDING) {
                                    gridColumn.setSortParameter(null);
                                }
                            } else {
                                gridColumn.setSortParameter(new GridColumnSortParameter(0, GridColumnSortParameter.SortDir.ASCENDING, GridColumnSortParameter.NullsOption.NONE));
                            }
                            RaptorGridTable.this.savePersistentSettings();
                            try {
                                RaptorGridTable.this.refresh();
                            }
                            catch (ExecutionException executionException) {
                                Logger.warn(this.getClass(), (Throwable)executionException);
                            }
                        }
                    } else if (mouseEvent.getClickCount() == 1) {
                        RaptorGridTable.this.setCellSelectionEnabled(false);
                        RaptorGridTable.this.setColumnSelectionAllowed(true);
                        RaptorGridTable.this.setRowSelectionAllowed(false);
                        ColumnAutoFit.select(RaptorGridTable.this.getColumnModel().getSelectionModel(), mouseEvent, RaptorGridTable.this.columnAtPoint(mouseEvent.getPoint()));
                        RaptorGridTable.this.requestFocusInWindow();
                    }
                }
            }
        });
        this.setTransferHandler(new TransferHandler(){

            @Override
            public int getSourceActions(JComponent jComponent) {
                return 3;
            }

            @Override
            public Transferable createTransferable(JComponent jComponent) {
                RaptorGridCopyAdapter raptorGridCopyAdapter = new RaptorGridCopyAdapter((RaptorGridTable)jComponent);
                StringBuilder stringBuilder = new StringBuilder();
                boolean bl = raptorGridCopyAdapter.copyToBuffer(stringBuilder, ",", "\n", RaptorGridCopyAdapter.CopyData.COPY, false);
                if (bl) {
                    return new StringSelection(stringBuilder.toString());
                }
                return null;
            }
        });
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RaptorGridTable.this.getGridModel() != null) {
                    RaptorGridTable.this.scrollToRow(RaptorGridTable.this.getLoadedRowCount(), RaptorGridTable.this._lastSelectedCol);
                    if (RaptorGridTable.this.getGridModel().allRowsFetched()) {
                        return;
                    }
                }
                RaptorGridTable.this.fetchAllRows();
            }
        }, "FetchAll", this.fetchAll, 0);
        this.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (RaptorGridTable.this.getGridModel() != null) {
                    RaptorGridTable.this.scrollToRow(RaptorGridTable.this.getLoadedRowCount(), RaptorGridTable.this._lastSelectedCol);
                    if (RaptorGridTable.this.getGridModel().allRowsFetched()) {
                        RaptorGridTable.this.changeSelection(RaptorGridTable.this.getLoadedRowCount() - 1, RaptorGridTable.this._lastSelectedCol, false, false);
                        return;
                    }
                }
                RaptorGridTable.this.fetchAllRows();
            }
        }, "FetchAll", this.fetchEndAll, 0);
        this.getTableHeader().addMouseListener(this._settingsPersistor);
        this.getColumnModel().addColumnModelListener(this._settingsPersistor);
        this.getActionMap().put("copy", (Action)IdeActions.getEditCopyAction());
        this.getActionMap().put("paste", (Action)IdeActions.getEditPasteAction());
        this.getActionMap().put("cut", (Action)IdeActions.getEditCutAction());
        this.getInputMap(1).put(KeyStroke.getKeyStroke(32, 0), null);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(32, 0), null);
        this.getInputMap(0).put(KeyStroke.getKeyStroke(32, 0), null);
    }

    @Override
    public void selectAll() {
        final AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            if (abstractRaptorGridModel.allRowsFetched()) {
                super.selectAll();
            } else {
                abstractRaptorGridModel.addTableModelListener(new TableModelListener(){

                    @Override
                    public void tableChanged(TableModelEvent tableModelEvent) {
                        abstractRaptorGridModel.removeTableModelListener(this);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                RaptorGridTable.super.selectAll();
                            }
                        });
                    }
                });
                this.fetchAllRows();
            }
        }
    }

    public RaptorGridCopyAdapter getGridCopyAdapter() {
        return this._copyAdapter;
    }

    @Override
    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.setCellSelectionEnabled(true);
        this.setColumnSelectionAllowed(true);
        this.setRowSelectionAllowed(true);
        return super.editCellAt(n, n2, eventObject);
    }

    private boolean processLocalActionKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n);
        ActionMap actionMap = this.getActionMap();
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        boolean bl2 = this.processLocalActionKeyBinding(keyStroke, keyEvent, n, bl);
        String string = "local";
        if (!bl2) {
            if (UIUtils.isUndefined(keyStroke)) {
                bl2 = false;
                string = "undefinedKeyFilter";
            } else if (KeyUtil.isActionKey((KeyStroke)keyStroke)) {
                bl2 = false;
                string = "actionKeyFilter";
            } else if (KeyUtil.isModifierKey((KeyStroke)keyStroke)) {
                bl2 = false;
                string = "modifierKeyFilter";
            } else if (UIUtils.isAccelerator(keyStroke)) {
                bl2 = false;
                string = "acceleratorFilter";
            } else if (n == 1 && this.isFocusOwner() && 27 == keyStroke.getKeyCode()) {
                bl2 = false;
                string = "escapeKeyFilter";
            } else {
                bl2 = super.processKeyBinding(keyStroke, keyEvent, n, bl);
                string = "super";
            }
        }
        if (Debug.DEBUG) {
            Debug.info("RaptoGridTable.processKeyBinding(" + keyStroke.toString() + (n == 0 ? " WHEN_FOCUSED" : (n == 1 ? " WHEN_ANCESTOR_OF_FOCUSED_COMPONENT" : " CONDITION UNKNOWN")) + ") returning processed=" + bl2 + " from " + string);
        }
        return bl2;
    }

    public String getDisplayValueAt(int n, int n2, int n3) {
        String string = null;
        if (n < this.getLoadedRowCount() && n > -1 && n2 < this.getColumnCount() && n2 > -1) {
            AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
            string = abstractRaptorGridModel != null ? abstractRaptorGridModel.getDisplayValueAt(this.convertRowIndexToModel(n), this.convertColumnIndexToModel(n2), n3) : this.getValueAt(n, n2).toString();
        }
        return string;
    }

    public boolean isColumnSortingEnabled() {
        return this.isColumnSortingEnabled;
    }

    public void canSortColumns(boolean bl) {
        this.isColumnSortingEnabled = bl;
    }

    public boolean isMultiColSort() {
        if (!this.isColumnSortingEnabled) {
            return false;
        }
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.isSortable() && this.isMultiColSort && !this.isVerticalDisplay();
        }
        return false;
    }

    public boolean canSortNow() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return !abstractRaptorGridModel.isTaskRunning();
        }
        return true;
    }

    public void canMultiColSort(boolean bl) {
        this.isMultiColSort = bl;
    }

    public String getSortString() {
        if (this.getGridModel() != null) {
            return this.getGridModel().getSortString();
        }
        return null;
    }

    public boolean isFilterApplied() {
        if (this.getGridModel() != null) {
            return this.getGridModel().isFilterApplied();
        }
        return false;
    }

    public void setFilterClause(String string) {
        if (this.getGridModel() != null) {
            this.getGridModel().setFilterClause(string);
            try {
                this.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.severe(this.getClass(), (Throwable)executionException);
            }
        }
    }

    public boolean canAutoFilter(int n) {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null && !abstractRaptorGridModel.isTaskRunning()) {
            return !this.isHostedInDialog();
        }
        return false;
    }

    public String getGridUniqueName() {
        if (this.getGridModel() != null) {
            return this.getGridModel().getModelUniqueName();
        }
        return null;
    }

    public String getDefaultExportName() {
        return null;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setEditable(boolean bl) {
        this._editable = bl;
    }

    public boolean isVerticalDisplay() {
        return this._verticalDisplay;
    }

    public void setVerticalDisplay(boolean bl) {
        this._verticalDisplay = bl;
    }

    public void savePersistentSettings() {
        RaptorGridPersistedSettings.savePersistentSettings(this);
    }

    public void deletePersistentSettings() {
        StringBuilder stringBuilder = new StringBuilder(Messages.getString("DeleteSettings.4"));
        if (RaptorGridPersistedSettings.deletePersistentSettings(this)) {
            stringBuilder.append(Messages.getString("DeleteSettings.2"));
            try {
                this.refresh();
            }
            catch (ExecutionException executionException) {
                Logger.warn(this.getClass(), (Throwable)executionException);
            }
        } else {
            stringBuilder.append(Messages.getString("DeleteSettings.3"));
        }
        MessageDialog.information((Component)this, (Object)stringBuilder, (String)Messages.getString("DeleteSettings.1"), null);
    }

    public void autoScrollColumn(Point point) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!rectangle2.contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x, point.y, 0, 0);
            this.scrollRectToVisible(rectangle3);
        }
    }

    public void scrollToRow(int n, int n2) {
        if (this.getParent() instanceof JViewport) {
            JViewport jViewport = (JViewport)this.getParent();
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Rectangle rectangle2 = jViewport.getViewRect();
            rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
            jViewport.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        int n = tableColumn.getModelIndex();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null && (abstractRaptorGridModel.isSkipColumn(n) || abstractRaptorGridModel.isHiddenColumn(n))) {
            return;
        }
        super.addColumn(tableColumn);
        tableColumn.setHeaderRenderer(ColumnHeaderCellRenderer.INSTANCE);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getFirstRow() == -1 && this.getGridModel() != null && this.getGridModel().getLoadedRowCount() > 0) {
            this._highlights.clear();
            RaptorGridPersistedSettings.applyPersistentSettings(this);
            this.getTableHeader().setReorderingAllowed(true);
        } else if (tableModelEvent.getSource() instanceof AbstractRaptorGridModel && this.getGridModel() != null && tableModelEvent.getType() == 1 && tableModelEvent.getColumn() == -1) {
            if (!this.allRowsFetched()) {
                if (this._lastSelectedRow != -1 && tableModelEvent.getLastRow() + 1 >= this.getGridModel().getLoadedRowCount() && tableModelEvent.getLastRow() - this._lastSelectedRow < this.getGridModel().getFetchSize()) {
                    this.changeSelection(this._lastSelectedRow, this._lastSelectedCol, false, false);
                }
            } else if (this._lastSelectedRow != -1) {
                this.changeSelection(this.getLoadedRowCount() - 1, this._lastSelectedCol, false, false);
                this.scrollToRow(this.getLoadedRowCount() - 1, this._lastSelectedCol);
            }
        }
    }

    public AbstractRaptorGridModel getGridModel() {
        if (this.getModel() instanceof AbstractRaptorGridModel) {
            return (AbstractRaptorGridModel)this.getModel();
        }
        return null;
    }

    public JTable getRowHeader() {
        if (this._rowHeader == null || this.getGridModel() == null) {
            this._rowHeader = new JTable();
            this._rowHeader.setRowHeight(20);
            this._rowHeader.setColumnModel(new RowHeaderTableColumnModel());
            if (this.getGridModel() != null) {
                this._rowHeader.setModel(this.getGridModel().getRowHeaderModel());
            }
            this._rowHeader.setColumnSelectionAllowed(false);
            this._rowHeader.setCellSelectionEnabled(false);
            this._rowHeader.setAutoResizeMode(0);
            this._rowHeader.setSelectionBackground(this._rowHeader.getBackground());
            this._rowHeader.setMaximumSize(new Dimension(45, Integer.MAX_VALUE));
            this._rowHeader.addHierarchyListener(new HierarchyListener(){
                private JViewport view;
                private ChangeListener cl = new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        for (Container container = RaptorGridTable.this.getParent(); container != null; container = container.getParent()) {
                            if (!(container instanceof JViewport)) continue;
                            JViewport jViewport = (JViewport)container;
                            Point point = ((JViewport)changeEvent.getSource()).getViewPosition();
                            Point point2 = jViewport.getViewPosition();
                            if (point.y == point2.y) break;
                            point2.y = point.y;
                            jViewport.setViewPosition(point2);
                            break;
                        }
                    }
                };

                @Override
                public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
                    for (Container container = RaptorGridTable.this._rowHeader.getParent(); container != null; container = container.getParent()) {
                        if (!(container instanceof JViewport)) continue;
                        if (this.view == container) break;
                        if (this.view != null) {
                            this.view.removeChangeListener(this.cl);
                        }
                        this.view = (JViewport)container;
                        this.view.setPreferredSize(RaptorGridTable.this._rowHeader.getMaximumSize());
                        this.view.addChangeListener(this.cl);
                        break;
                    }
                }
            });
            this._rowHeader.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    RaptorGridTable.this.setColumnSelectionAllowed(false);
                    RaptorGridTable.this.setRowSelectionAllowed(true);
                    ColumnAutoFit.select(RaptorGridTable.this.getSelectionModel(), mouseEvent, RaptorGridTable.this.rowAtPoint(mouseEvent.getPoint()));
                    RaptorGridTable.this.requestFocusInWindow();
                }
            });
        }
        return this._rowHeader;
    }

    public void hideColumns(List<GridColumn> list, List<GridColumn> list2) {
        TableColumnModel tableColumnModel = this.getColumnModel();
        while (tableColumnModel.getColumnCount() > 0) {
            tableColumnModel.removeColumn(tableColumnModel.getColumn(0));
        }
        for (GridColumn gridColumn : list) {
            gridColumn.setHidden(true);
        }
        for (int i = 0; i < list2.size(); ++i) {
            GridColumn gridColumn;
            gridColumn = list2.get(i);
            gridColumn.setHidden(false);
        }
        List<? extends GridColumn> list3 = this.getGridModel().getGridColumns();
        for (int i = 0; i < list2.size(); ++i) {
            GridColumn gridColumn = list2.get(i);
            int n = list3.indexOf(gridColumn);
            if (n == -1) continue;
            TableColumn tableColumn = new TableColumn(n);
            this.addColumn(tableColumn);
        }
        ColumnAutoFit.getInstance().restoreLast(this);
    }

    public List<GridColumn> getHiddenColumns() {
        List<GridColumn> list = new ArrayList<GridColumn>();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            list = abstractRaptorGridModel.getHiddenCols();
        }
        return list;
    }

    public List<GridColumn> getShownColumns() {
        ArrayList<GridColumn> arrayList = new ArrayList<GridColumn>();
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        TableColumnModel tableColumnModel = this.getColumnModel();
        Enumeration<TableColumn> enumeration = tableColumnModel.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            GridColumn gridColumn = abstractRaptorGridModel.getGridColumns().get(tableColumn.getModelIndex());
            arrayList.add(gridColumn);
        }
        return arrayList;
    }

    public void setColumnSelectorAvailable(boolean bl) {
        this.isColumnSelectorAvailable = bl;
    }

    public boolean isColumnSelectorAvailable() {
        return this.isColumnSelectorAvailable;
    }

    public boolean canColumnSelectNow() {
        return this.isColumnSelectorAvailable();
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        TableCellRenderer tableCellRenderer;
        Component component;
        String string = null;
        Point point = mouseEvent.getPoint();
        int n = this.columnAtPoint(point);
        int n2 = this.rowAtPoint(point);
        if (n != -1 && n2 != -1 && (component = this.prepareRenderer(tableCellRenderer = this.getCellRenderer(n2, n), n2, n)) instanceof JComponent) {
            Rectangle rectangle = this.getCellRect(n2, n, false);
            if (rectangle.width >= component.getPreferredSize().width) {
                return null;
            }
            point.translate(-rectangle.x, -rectangle.y);
            MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
            string = ((JComponent)component).getToolTipText(mouseEvent2);
        }
        if (string == null) {
            string = this.getToolTipText();
        }
        if (string == null && (string = this.getDisplayValueAt(n2, n, Integer.MAX_VALUE)) != null && string.length() == 0) {
            string = null;
        }
        return string;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n = this.rowAtPoint(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        if (n2 == -1) {
            return null;
        }
        boolean bl = this.getToolTipText() == null ? this.getToolTipText(mouseEvent) != null : true;
        return bl ? this.getCellRect(n, n2, false).getLocation() : null;
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new GridColumnHeader(this.columnModel);
    }

    protected void fetchAllRows() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            try {
                abstractRaptorGridModel.fetchAllRows(true);
            }
            catch (ExecutionException executionException) {
                Logger.warn(this.getClass(), (Throwable)executionException);
            }
        }
    }

    public void refresh() throws ExecutionException {
        this.clearSelection();
        this._lastSelectedRow = -1;
        this._lastSelectedCol = -1;
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            this.getTableHeader().setReorderingAllowed(false);
            abstractRaptorGridModel.refresh();
        } else {
            Logger.severe(this.getClass(), (String)Messages.getString("RaptorGridTable.4"));
        }
    }

    public static void addGridContextMenu(GridContextMenuItem gridContextMenuItem) {
        _gridCM.addContextMenuListener((ContextMenuListener)gridContextMenuItem);
        EditorManager.getEditorManager().getContextMenu().addContextMenuListener((ContextMenuListener)gridContextMenuItem);
    }

    public static void addColumnHeaderContextMenu(GridHeaderContextMenuItem gridHeaderContextMenuItem) {
        _columnHeaderCM.addContextMenuListener((ContextMenuListener)gridHeaderContextMenuItem);
    }

    public static void removeGridContextMenu(GridContextMenuItem gridContextMenuItem) {
        _gridCM.removeContextMenuListener((ContextMenuListener)gridContextMenuItem);
    }

    public static void removeColumnHeaderContextMenu(GridHeaderContextMenuItem gridHeaderContextMenuItem) {
        _columnHeaderCM.removeContextMenuListener((ContextMenuListener)gridHeaderContextMenuItem);
    }

    @Override
    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = null;
        component = super.prepareRenderer(tableCellRenderer, n, n2);
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (this.isZebraRows().booleanValue() && !this.isCellSelected(n, n2)) {
            if (n % 2 == 0 && n2 % 2 == 0) {
                component.setBackground(color00);
            } else if (n % 2 == 0 && n2 % 2 == 1) {
                component.setBackground(color10);
            } else if (n % 2 == 1 && n2 % 2 == 0) {
                component.setBackground(color01);
            } else if (n % 2 == 1 && n2 % 2 == 1) {
                component.setBackground(color11);
            }
        }
        if (!this.isCellSelected(n, n2) && abstractRaptorGridModel != null && component != null) {
            Color color = abstractRaptorGridModel.getRowHighlightColor(this.convertRowIndexToModel(n));
            if (color != null) {
                component.setBackground(color);
            } else {
                Color object = component.getBackground();
                if (object != color) {
                    component.setBackground(object);
                }
            }
        }
        if (!this.isCellSelected(n, n2) && abstractRaptorGridModel != null && component != null) {
            for (RaptorGridSearchParameter raptorGridSearchParameter : this.getSearchParams(false)) {
                Object object;
                if (raptorGridSearchParameter == null || !raptorGridSearchParameter.matches(this, n, n2)) continue;
                Color color = raptorGridSearchParameter.getColor();
                if (color != null) {
                    component.setBackground(color);
                } else {
                    object = component.getBackground();
                    if (object != color) {
                        component.setBackground((Color)object);
                    }
                }
                if (!raptorGridSearchParameter.isHighlightRow()) continue;
                object = this.getColumnModel().getColumns();
                while (object.hasMoreElements()) {
                    TableColumn tableColumn = (TableColumn)object.nextElement();
                    if (tableColumn.getModelIndex() == this.convertColumnIndexToModel(n2)) continue;
                    Component component2 = super.prepareRenderer(tableColumn.getCellRenderer(), n, this.convertColumnIndexToView(tableColumn.getModelIndex()));
                    component2.setBackground(color);
                }
            }
        }
        return component;
    }

    private Boolean isZebraRows() {
        try {
            Class<?> clazz = Class.forName("oracle.dbtools.raptor.config.DBConfig");
            Method method = clazz.getDeclaredMethod("getInstance", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            method = clazz.getDeclaredMethod("getBoolean", String.class);
            String string = "ZEBRA_ROWS";
            return (Boolean)method.invoke(object, string);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public List<RaptorGridSearchParameter> getSearchParams(boolean bl) {
        if (!bl) {
            return this._highlights;
        }
        ArrayList<RaptorGridSearchParameter> arrayList = new ArrayList<RaptorGridSearchParameter>();
        for (RaptorGridSearchParameter raptorGridSearchParameter : this._highlights) {
            if (!raptorGridSearchParameter.isPersist()) continue;
            arrayList.add(raptorGridSearchParameter);
        }
        return arrayList;
    }

    public void addHighLightParam(RaptorGridSearchParameter raptorGridSearchParameter) {
        this._highlights.add(raptorGridSearchParameter);
        if (raptorGridSearchParameter.isPersist()) {
            RaptorGridPersistedSettings.savePersistentSettings(this);
        }
    }

    public void removeHighLightParam(RaptorGridSearchParameter raptorGridSearchParameter) {
        this._highlights.remove(raptorGridSearchParameter);
        if (raptorGridSearchParameter.isPersist()) {
            RaptorGridPersistedSettings.savePersistentSettings(this);
        }
    }

    public int getLoadedRowCount() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.getLoadedRowCount();
        }
        return 0;
    }

    public boolean allRowsFetched() {
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            return abstractRaptorGridModel.allRowsFetched();
        }
        return true;
    }

    public void closeModel() {
        ContextMenuListener contextMenuListener;
        AbstractRaptorGridModel abstractRaptorGridModel = this.getGridModel();
        if (abstractRaptorGridModel != null) {
            abstractRaptorGridModel.closeModel();
        }
        List list = _gridCM.getContextMenuListeners();
        for (Pair object : list) {
            contextMenuListener = (ContextMenuListener)object.second;
            if (contextMenuListener == null || !(contextMenuListener instanceof GridContextMenuItem)) continue;
            ((GridContextMenuItem)contextMenuListener).releaseGrid();
        }
        list = _columnHeaderCM.getContextMenuListeners();
        for (Pair pair : list) {
            contextMenuListener = (ContextMenuListener)pair.second;
            if (contextMenuListener == null || !(contextMenuListener instanceof GridContextMenuItem)) continue;
            ((GridContextMenuItem)contextMenuListener).releaseGrid();
        }
        if (this._localCTXMenuItems != null) {
            for (GridContextMenuItem gridContextMenuItem : this._localCTXMenuItems) {
                gridContextMenuItem.releaseGrid();
            }
            this._localCTXMenuItems.clear();
        }
        this.removeIdeActionController();
        _gridCM.removeContextMenuListener(this.cmListener);
    }

    @Override
    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        super.changeSelection(n, n2, bl, bl2);
        this._lastSelectedRow = this.getSelectedRow();
        this._lastSelectedCol = this.getSelectedColumn();
    }

    private void initStatics() {
        if (!_initedStatics) {
            RaptorGridTable.addGridContextMenu(SingleRecordView.getInstance());
            RaptorGridTable.addGridContextMenu(CountRows.getInstance());
            RaptorGridTable.addGridContextMenu(FindHighlight.getInstance());
            RaptorGridTable.addGridContextMenu(HeaderMenu.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(ColumnAutoFit.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(ColumnSelector.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(GridSorter.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(DeleteSettings.getInstance());
            RaptorGridTable.addColumnHeaderContextMenu(CopyColumnHeader.getInstance());
            _initedStatics = true;
        }
    }

    public ArrayList<GridContextMenuItem> getLocalContextMenuListeners() {
        return this._localCTXMenuItems;
    }

    public void addLocalContextMenuListener(GridContextMenuItem gridContextMenuItem) {
        if (this._localCTXMenuItems == null) {
            this._localCTXMenuItems = new ArrayList();
        }
        this._localCTXMenuItems.add(gridContextMenuItem);
    }

    public ContextMenu getHeaderContextMenu() {
        return _columnHeaderCM;
    }

    public void allowContextMenu(boolean bl) {
        this._allowContextMenu = bl;
    }

    public ContextMenu getContextMenu() {
        if (this._allowContextMenu) {
            return _gridCM;
        }
        return null;
    }

    public View getView() {
        return this._view;
    }

    public void setView(View view) {
        this._view = view;
    }

    public boolean isHostedInDialog() {
        if (this._isHostedInDialog == null) {
            for (Container container = this; container != null; container = container.getParent()) {
                if (!(container instanceof Dialog)) continue;
                this._isHostedInDialog = Boolean.TRUE;
                break;
            }
            if (this._isHostedInDialog == null) {
                this._isHostedInDialog = Boolean.FALSE;
            }
        }
        return this._isHostedInDialog;
    }

    @Override
    public void setModel(TableModel tableModel) {
        this.addIdeActionController();
        _gridCM.addContextMenuListener(this.cmListener);
        super.setModel(tableModel);
    }

    private void initIdeActions() {
        if (null == this.ideActions) {
            this.ideActions = new IdeAction[]{IdeActions.getEditCopyAction(), IdeActions.getEditPasteAction(), IdeActions.getEditCutAction(), IdeActions.getEditSelectAllAction(), IdeActions.getSearchFindAction()};
        }
    }

    private void addIdeActionController() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.addController(this.controller);
        }
    }

    private void removeIdeActionController() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.removeController(this.controller);
        }
    }

    private void updateIdeActions() {
        this.initIdeActions();
        for (IdeAction ideAction : this.ideActions) {
            ideAction.updateAction();
        }
    }

    public RowSelectionIterator iterator() {
        RowSelectionIterator rowSelectionIterator = null;
        if (this.getColumnSelectionAllowed() && !this.getRowSelectionAllowed()) {
            rowSelectionIterator = new AllRowsIterator(new ColumnAllowedSelectionIterator());
        } else if (!this.getColumnSelectionAllowed() && this.getRowSelectionAllowed()) {
            rowSelectionIterator = new RowAllowedSelectionIterator(new AllColumnsIterator());
        } else if (this.getCellSelectionEnabled()) {
            if (this.getSelectionModel().getSelectionMode() == 0 && this.getColumnModel().getSelectionModel().getSelectionMode() == 0) {
                rowSelectionIterator = new SingleRowIterator(new SingleColumnIterator());
            } else {
                int n;
                int n2 = this.getSelectedColumn();
                ColumnSelectionIterator columnSelectionIterator = n2 == (n = this.getColumnModel().getSelectionModel().getMaxSelectionIndex()) ? new SingleColumnIterator(n) : new MultiColumnIterator(n2, n);
                int n3 = this.getSelectedRow();
                int n4 = this.getSelectionModel().getMaxSelectionIndex();
                rowSelectionIterator = n3 == n4 ? new SingleRowIterator(columnSelectionIterator, n4) : new MultiRowIterator(columnSelectionIterator, n3, n4);
            }
        }
        return rowSelectionIterator;
    }

    static {
        lastGridNum = 0;
        color00 = new Color(255, 255, 223);
        color01 = new Color(223, 223, 223);
        color10 = new Color(255, 255, 210);
        color11 = new Color(223, 213, 209);
    }

    protected class MultiRowIterator
    extends RowRangeIterator {
        protected ColumnSelectionIterator nextIterator;

        protected MultiRowIterator(ColumnSelectionIterator columnSelectionIterator, int n, int n2) {
            super(null, n, n2);
            this.nextIterator = columnSelectionIterator;
        }

        @Override
        public MultiRowIterator clone() {
            MultiRowIterator multiRowIterator = (MultiRowIterator)super.clone();
            multiRowIterator.nextIterator = this.nextIterator != null ? this.nextIterator.clone() : null;
            return multiRowIterator;
        }

        @Override
        public int getRowCount() {
            if (this.firstIndex == -1) {
                return 0;
            }
            if (RaptorGridTable.this.getRowCount() < 2) {
                return RaptorGridTable.this.getRowCount();
            }
            return -1;
        }

        @Override
        public boolean hasNext() {
            int n;
            int n2 = n = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
            while (n <= this.lastIndex) {
                if (this.nextIterator == null) {
                    this.nextIterator = this.currentIterator.clone();
                }
                this.nextIterator.setNext(n++);
                if (!this.nextIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                ColumnSelectionIterator columnSelectionIterator = this.currentIterator;
                this.currentIterator = this.nextIterator;
                this.nextIterator = columnSelectionIterator;
                this.pos = this.currentIterator.getRowIndex();
                return this.currentIterator;
            }
            return null;
        }
    }

    protected class AllRowsIterator
    extends RowRangeIterator {
        protected AllRowsIterator(ColumnSelectionIterator columnSelectionIterator) {
            super(columnSelectionIterator, RaptorGridTable.this.getRowCount() > 0 ? 0 : -1, RaptorGridTable.this.getRowCount() > 0 ? RaptorGridTable.this.getRowCount() - 1 : -1);
        }
    }

    protected class SingleRowIterator
    extends RowRangeIterator {
        protected SingleRowIterator(ColumnSelectionIterator columnSelectionIterator, int n) {
            super(columnSelectionIterator, n, n);
        }

        protected SingleRowIterator(ColumnSelectionIterator columnSelectionIterator) {
            this(columnSelectionIterator, raptorGridTable.getSelectedRow());
        }
    }

    protected class RowRangeIterator
    extends RowSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;

        protected RowRangeIterator(ColumnSelectionIterator columnSelectionIterator, int n, int n2) {
            super(columnSelectionIterator);
            if (!(n >= 0 && n2 >= n && n2 <= RaptorGridTable.this.getRowCount() - 1 || n == -1 && n2 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n;
            this.lastIndex = n2;
        }

        @Override
        public RowRangeIterator clone() {
            RowRangeIterator rowRangeIterator = (RowRangeIterator)super.clone();
            rowRangeIterator.firstIndex = this.firstIndex;
            rowRangeIterator.lastIndex = this.lastIndex;
            return rowRangeIterator;
        }

        @Override
        public int getRowCount() {
            return this.firstIndex != -1 ? this.lastIndex - this.firstIndex + 1 : 0;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.lastIndex;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                this.pos = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
                this.currentIterator.setNext(this.pos);
                return this.currentIterator;
            }
            return null;
        }
    }

    protected class RowAllowedSelectionIterator
    extends RowSelectionIterator {
        int[] selectedRows;

        protected RowAllowedSelectionIterator(ColumnSelectionIterator columnSelectionIterator, int[] nArray) {
            super(columnSelectionIterator);
            this.selectedRows = (int[])nArray.clone();
        }

        protected RowAllowedSelectionIterator(ColumnSelectionIterator columnSelectionIterator) {
            this(columnSelectionIterator, raptorGridTable.getSelectedRows());
        }

        @Override
        public RowAllowedSelectionIterator clone() {
            RowAllowedSelectionIterator rowAllowedSelectionIterator = (RowAllowedSelectionIterator)super.clone();
            rowAllowedSelectionIterator.selectedRows = (int[])this.selectedRows.clone();
            return rowAllowedSelectionIterator;
        }

        @Override
        public int getRowCount() {
            return this.selectedRows != null ? this.selectedRows.length : 0;
        }

        @Override
        public boolean hasNext() {
            return this.selectedRows.length > 0 && this.pos < this.selectedRows.length - 1;
        }

        @Override
        public ColumnSelectionIterator next() {
            if (this.hasNext()) {
                this.currentIterator.setNext(this.selectedRows[++this.pos]);
                return this.currentIterator;
            }
            return null;
        }
    }

    public abstract class RowSelectionIterator
    implements Iterator,
    Cloneable {
        protected ColumnSelectionIterator currentIterator;
        protected int pos;

        protected RowSelectionIterator(ColumnSelectionIterator columnSelectionIterator) {
            this.currentIterator = columnSelectionIterator;
            this.pos = -1;
        }

        public RowSelectionIterator clone() {
            try {
                RowSelectionIterator rowSelectionIterator = (RowSelectionIterator)super.clone();
                rowSelectionIterator.currentIterator = this.currentIterator != null ? this.currentIterator.clone() : null;
                rowSelectionIterator.pos = this.pos;
                return rowSelectionIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public abstract int getRowCount();

        @Override
        public abstract boolean hasNext();

        public abstract ColumnSelectionIterator next();

        @Override
        public void remove() {
        }
    }

    protected class MultiColumnIterator
    extends ColumnAllowedSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;
        protected boolean hasColumns;

        protected MultiColumnIterator(int n, int n2, int n3) {
            super(n, null);
            if (!(n2 >= 0 && n3 >= n2 && n3 <= RaptorGridTable.this.getColumnCount() - 1 || n2 == -1 && n3 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n2;
            this.lastIndex = n3;
            this.hasColumns = false;
        }

        protected MultiColumnIterator(int n, int n2) {
            this(-1, n, n2);
        }

        @Override
        public MultiColumnIterator clone() {
            MultiColumnIterator multiColumnIterator = (MultiColumnIterator)super.clone();
            multiColumnIterator.firstIndex = this.firstIndex;
            multiColumnIterator.lastIndex = this.lastIndex;
            multiColumnIterator.hasColumns = this.hasColumns;
            return multiColumnIterator;
        }

        protected void scanRow() {
            boolean bl;
            boolean bl2 = bl = this.selectedColumns != null;
            if (!bl) {
                this.selectedColumns = new ArrayList();
            }
            for (int i = this.firstIndex; i > -1 && i <= this.lastIndex; ++i) {
                if (!RaptorGridTable.this.isCellSelected(this.rowIndex, i)) continue;
                if (!bl) {
                    this.selectedColumns.add(i);
                }
                this.hasColumns = true;
            }
        }

        @Override
        public void setNext(int n) {
            super.setNext(n);
            this.hasColumns = false;
            if (n != -1) {
                this.scanRow();
            }
        }

        @Override
        public boolean hasNext() {
            return this.hasColumns ? super.hasNext() : false;
        }
    }

    protected class AllColumnsIterator
    extends ColumnRangeIterator {
        protected AllColumnsIterator() {
            super(-1, RaptorGridTable.this.getColumnCount() > 0 ? 0 : -1, RaptorGridTable.this.getColumnCount() > 0 ? RaptorGridTable.this.getColumnCount() - 1 : -1);
        }
    }

    protected class SingleColumnIterator
    extends ColumnRangeIterator {
        protected SingleColumnIterator(int n, int n2) {
            super(n, n2, n2);
        }

        protected SingleColumnIterator(int n) {
            this(-1, n);
        }

        protected SingleColumnIterator() {
            this(raptorGridTable.getSelectedColumn());
        }
    }

    protected class ColumnRangeIterator
    extends ColumnSelectionIterator {
        protected int firstIndex;
        protected int lastIndex;

        protected ColumnRangeIterator(int n, int n2, int n3) {
            super(n);
            if (!(n2 >= 0 && n3 >= n2 && n3 <= RaptorGridTable.this.getColumnCount() - 1 || n2 == -1 && n3 == -1)) {
                throw new IllegalArgumentException();
            }
            this.firstIndex = n2;
            this.lastIndex = n3;
        }

        protected ColumnRangeIterator(int n, int n2) {
            this(-1, n, n2);
        }

        @Override
        public ColumnRangeIterator clone() {
            ColumnRangeIterator columnRangeIterator = (ColumnRangeIterator)super.clone();
            columnRangeIterator.firstIndex = this.firstIndex;
            columnRangeIterator.lastIndex = this.lastIndex;
            return columnRangeIterator;
        }

        @Override
        public int getColumnCount() {
            return this.firstIndex != -1 ? this.lastIndex - this.firstIndex + 1 : 0;
        }

        @Override
        public int[] getSelectedColumns() {
            int[] nArray = new int[this.getColumnCount()];
            int n = this.firstIndex;
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = n++;
            }
            return nArray;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.lastIndex;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                this.pos = this.pos < this.firstIndex ? this.firstIndex : this.pos + 1;
                return this.pos;
            }
            return -1;
        }
    }

    protected class ColumnAllowedSelectionIterator
    extends ColumnSelectionIterator {
        protected ArrayList<Integer> selectedColumns;

        protected ColumnAllowedSelectionIterator(int n, int[] nArray) {
            super(n);
            this.setNext(n, nArray);
        }

        protected ColumnAllowedSelectionIterator(int[] nArray) {
            this(-1, nArray);
        }

        protected ColumnAllowedSelectionIterator() {
            this(raptorGridTable.getSelectedColumns());
        }

        @Override
        public ColumnAllowedSelectionIterator clone() {
            ColumnAllowedSelectionIterator columnAllowedSelectionIterator = (ColumnAllowedSelectionIterator)super.clone();
            columnAllowedSelectionIterator.selectedColumns = (ArrayList)this.selectedColumns.clone();
            return columnAllowedSelectionIterator;
        }

        @Override
        public int getColumnCount() {
            return this.selectedColumns != null ? this.selectedColumns.size() : 0;
        }

        @Override
        public int[] getSelectedColumns() {
            if (this.selectedColumns == null) {
                return new int[0];
            }
            int[] nArray = new int[this.selectedColumns.size()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.selectedColumns.get(i);
            }
            return nArray;
        }

        public void setNext(int n, int[] nArray) {
            this.setNext(n);
            if (nArray == null) {
                this.selectedColumns = null;
            } else {
                this.selectedColumns = new ArrayList(nArray.length);
                for (int i = 0; i < nArray.length; ++i) {
                    this.selectedColumns.add(nArray[i]);
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.selectedColumns.size() > 0 && this.pos < this.selectedColumns.size() - 1;
        }

        @Override
        public Integer next() {
            if (this.hasNext()) {
                return this.selectedColumns.get(++this.pos);
            }
            return -1;
        }
    }

    public abstract class ColumnSelectionIterator
    implements Iterator,
    Cloneable {
        protected int rowIndex;
        protected int pos = -1;

        protected ColumnSelectionIterator(int n) {
            this.rowIndex = n;
        }

        protected ColumnSelectionIterator() {
            this(-1);
        }

        public ColumnSelectionIterator clone() {
            try {
                ColumnSelectionIterator columnSelectionIterator = (ColumnSelectionIterator)super.clone();
                columnSelectionIterator.rowIndex = this.rowIndex;
                columnSelectionIterator.pos = this.pos;
                return columnSelectionIterator;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public int getRowIndex() {
            return this.rowIndex;
        }

        public abstract int getColumnCount();

        public abstract int[] getSelectedColumns();

        public void setNext(int n) {
            this.pos = -1;
            this.rowIndex = n;
        }

        @Override
        public abstract boolean hasNext();

        public abstract Integer next();

        @Override
        public void remove() {
        }
    }

    class FireUpdateIdeActionsListener
    implements AncestorListener,
    FocusListener {
        FireUpdateIdeActionsListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.fireUpdateIdeActions();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void ancestorAdded(AncestorEvent ancestorEvent) {
            if (!RaptorGridTable.this.showing) {
                RaptorGridTable.this.showing = true;
                this.fireUpdateIdeActions();
            }
        }

        @Override
        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            RaptorGridTable.this.showing = false;
        }

        @Override
        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        private void fireUpdateIdeActions() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RaptorGridTable.this.updateIdeActions();
                }
            });
        }
    }

    protected class GridColumnHeader
    extends JTableHeader {
        public GridColumnHeader(TableColumnModel tableColumnModel) {
            super(tableColumnModel);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            int n = this.columnAtPoint(point);
            int n2 = RaptorGridTable.this.rowAtPoint(point);
            Rectangle rectangle = RaptorGridTable.this.getCellRect(n2, n, false);
            int n3 = this.columnModel.getColumnIndexAtX(point.x);
            AbstractRaptorGridModel abstractRaptorGridModel = RaptorGridTable.this.getGridModel();
            if (n3 != -1 && abstractRaptorGridModel != null) {
                String string = abstractRaptorGridModel.getColumnName(RaptorGridTable.this.convertColumnIndexToModel(n3));
                int n4 = new Double(new JLabel(string).getPreferredSize().getWidth()).intValue();
                return rectangle.width > n4 ? null : string;
            }
            return null;
        }
    }

    protected class RowHeaderTableColumnModel
    extends DefaultTableColumnModel {
        private static final long serialVersionUID = 1L;

        protected RowHeaderTableColumnModel() {
        }

        @Override
        public TableColumn getColumn(int n) {
            if (n < this.getColumnCount()) {
                return (TableColumn)this.tableColumns.elementAt(n);
            }
            return null;
        }

        @Override
        public void addColumn(TableColumn tableColumn) {
            if (tableColumn.getModelIndex() == 0) {
                tableColumn.setCellRenderer(RowHeaderCellRenderer.INSTANCE);
                tableColumn.setMaxWidth(45);
                super.addColumn(tableColumn);
            }
        }
    }

    protected static class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        static final RowHeaderCellRenderer INSTANCE = new RowHeaderCellRenderer();

        protected RowHeaderCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setHorizontalAlignment(4);
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            Border border = jLabel.getBorder();
            if (border != null) {
                border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(0, 0, 0, 2));
            }
            jLabel.setBorder(border);
            return jLabel;
        }
    }

    private class RaptorGridSettingsPersistor
    extends MouseAdapter
    implements TableColumnModelListener {
        private boolean colMoved = false;
        private boolean marginChanged = false;
        private int movedFrom = -1;
        private int movedTo = -1;

        private RaptorGridSettingsPersistor() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                this.colMoved = true;
                this.movedFrom = tableColumnModelEvent.getFromIndex();
                this.movedTo = tableColumnModelEvent.getToIndex();
                if (this.movedFrom == this.movedTo || this.movedFrom == -1 || this.movedTo != -1) {
                    // empty if block
                }
                this.movedFrom = -1;
                this.movedTo = -1;
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            this.marginChanged = true;
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.colMoved || this.marginChanged) {
                this.colMoved = false;
                this.marginChanged = false;
                RaptorGridTable.this.savePersistentSettings();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }
    }
}

