/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import java.awt.Color;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.table.TableColumn;
import oracle.dbtools.raptor.controls.grid.Messages;
import oracle.dbtools.raptor.controls.grid.RaptorGridTable;
import oracle.javatools.ui.search.SearchMatcher;

public class RaptorGridSearchParameter {
    protected boolean _persist = false;
    protected boolean _isEnabled = true;
    protected CharSequence _searchString = null;
    protected boolean _ignoreCase = false;
    protected boolean _wholeWord = false;
    protected boolean _startsWith = false;
    protected Color _color = null;
    protected boolean _highlightRow = false;
    protected int[] _colViewIndexes = null;

    public RaptorGridSearchParameter() {
    }

    public RaptorGridSearchParameter(CharSequence charSequence, int[] nArray) {
        this._searchString = charSequence;
        this._colViewIndexes = nArray;
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setEnabled(boolean bl) {
        this._isEnabled = bl;
    }

    public CharSequence getSearchString() {
        return this._searchString;
    }

    public void setSearchString(CharSequence charSequence) {
        this._searchString = charSequence;
    }

    public boolean isIgnoreCase() {
        return this._ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this._ignoreCase = bl;
    }

    public boolean isWholeWord() {
        return this._wholeWord;
    }

    public void setWholeWord(boolean bl) {
        this._wholeWord = bl;
    }

    public boolean isStartsWith() {
        return this._startsWith;
    }

    public void setStartsWith(boolean bl) {
        this._startsWith = bl;
    }

    public Color getColor() {
        return this._color;
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public boolean isPersist() {
        return this._persist;
    }

    public void setPersist(boolean bl) {
        this._persist = bl;
    }

    public boolean isHighlightRow() {
        return this._highlightRow;
    }

    public void setHighlightRow(boolean bl) {
        this._highlightRow = bl;
    }

    public int[] getColViewIndexes() {
        return this._colViewIndexes;
    }

    public void setColViewIndexes(int[] nArray) {
        this._colViewIndexes = nArray;
    }

    public boolean matches(RaptorGridTable raptorGridTable, int n, int n2) {
        boolean bl = false;
        if (this.isEnabled()) {
            if (this._colViewIndexes != null && this._colViewIndexes.length > 0) {
                if (this.isHighlightRow()) {
                    for (int n3 : this._colViewIndexes) {
                        bl = this._matches(raptorGridTable, n, n3);
                    }
                } else {
                    for (int n4 : this._colViewIndexes) {
                        if (n4 != n2) continue;
                        bl = this._matches(raptorGridTable, n, n2);
                    }
                }
            } else if (this.isHighlightRow()) {
                boolean bl2 = false;
                Enumeration<TableColumn> enumeration = raptorGridTable.getColumnModel().getColumns();
                while (enumeration.hasMoreElements()) {
                    TableColumn tableColumn = enumeration.nextElement();
                    int n5 = raptorGridTable.convertColumnIndexToView(tableColumn.getModelIndex());
                    if (n5 == -1 || !(bl2 = this._matches(raptorGridTable, n, n5))) continue;
                    return true;
                }
            } else {
                bl = this._matches(raptorGridTable, n, n2);
            }
        }
        return bl;
    }

    private boolean _matches(RaptorGridTable raptorGridTable, int n, int n2) {
        String string = raptorGridTable.getDisplayValueAt(n, n2, Integer.MAX_VALUE);
        if (string != null) {
            SearchMatcher searchMatcher = null;
            if (this.isWholeWord()) {
                if (this.isIgnoreCase()) {
                    return string.intern().equalsIgnoreCase(((Object)this.getSearchString()).toString());
                }
                return string.intern().equals(((Object)this.getSearchString()).toString());
            }
            searchMatcher = this.isStartsWith() ? SearchMatcher.getPrefixMatcher((CharSequence)this.getSearchString(), (boolean)this.isIgnoreCase(), (boolean)true) : SearchMatcher.getSubstringMatcher((CharSequence)this.getSearchString(), (boolean)this.isIgnoreCase());
            return searchMatcher.matches(string.subSequence(0, string.length()));
        }
        return false;
    }

    public int getMatchCount(RaptorGridTable raptorGridTable) {
        int n = 0;
        boolean bl = this.isHighlightRow();
        this.setHighlightRow(false);
        for (int i = 0; i < raptorGridTable.getLoadedRowCount(); ++i) {
            for (int j = 0; j < raptorGridTable.getColumnCount(); ++j) {
                if (!this.matches(raptorGridTable, i, j)) continue;
                ++n;
            }
        }
        this.setHighlightRow(bl);
        return n;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this._colViewIndexes);
        n = 31 * n + (this._color == null ? 0 : this._color.hashCode());
        n = 31 * n + (this._highlightRow ? 1231 : 1237);
        n = 31 * n + (this._ignoreCase ? 1231 : 1237);
        n = 31 * n + (this._isEnabled ? 1231 : 1237);
        n = 31 * n + (this._persist ? 1231 : 1237);
        n = 31 * n + (this._searchString == null ? 0 : this._searchString.hashCode());
        n = 31 * n + (this._startsWith ? 1231 : 1237);
        n = 31 * n + (this._wholeWord ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RaptorGridSearchParameter raptorGridSearchParameter = (RaptorGridSearchParameter)object;
        if (!Arrays.equals(this._colViewIndexes, raptorGridSearchParameter._colViewIndexes)) {
            return false;
        }
        if (this._color == null ? raptorGridSearchParameter._color != null : !this._color.equals(raptorGridSearchParameter._color)) {
            return false;
        }
        if (this._highlightRow != raptorGridSearchParameter._highlightRow) {
            return false;
        }
        if (this._ignoreCase != raptorGridSearchParameter._ignoreCase) {
            return false;
        }
        if (this._persist != raptorGridSearchParameter._persist) {
            return false;
        }
        if (this._searchString == null ? raptorGridSearchParameter._searchString != null : !this._searchString.equals(raptorGridSearchParameter._searchString)) {
            return false;
        }
        if (this._startsWith != raptorGridSearchParameter._startsWith) {
            return false;
        }
        return this._wholeWord == raptorGridSearchParameter._wholeWord;
    }

    public String toString() {
        String string = MessageFormat.format(Messages.getString("RaptorGridSearchParameter.0"), this.getSearchString());
        StringBuilder stringBuilder = new StringBuilder(string);
        int[] nArray = this.getColViewIndexes();
        if (nArray != null && nArray.length > 0) {
            for (int n : nArray) {
                stringBuilder.append(Messages.getString("RaptorGridSearchParameter.2") + n + ",");
            }
            stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        } else {
            stringBuilder.append(Messages.getString("RaptorGridSearchParameter.4"));
        }
        stringBuilder.append(": ");
        if (this.isHighlightRow()) {
            stringBuilder.append(Messages.getString("RaptorGridSearchParameter.6"));
        }
        if (this.isIgnoreCase()) {
            stringBuilder.append(Messages.getString("RaptorGridSearchParameter.7"));
        }
        if (this.isWholeWord()) {
            stringBuilder.append(Messages.getString("RaptorGridSearchParameter.8"));
        }
        if (this.isStartsWith()) {
            stringBuilder.append(Messages.getString("RaptorGridSearchParameter.9"));
        }
        return stringBuilder.toString();
    }
}

