/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls.grid;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.persist.EntityCursor;
import com.sleepycat.persist.EntityStore;
import com.sleepycat.persist.PrimaryIndex;
import com.sleepycat.persist.StoreConfig;
import com.sleepycat.persist.evolve.IncompatibleClassException;
import com.sleepycat.persist.model.AnnotationModel;
import com.sleepycat.persist.model.EntityModel;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.controls.grid.BLOBProxy;
import oracle.dbtools.raptor.controls.grid.CHARProxy;
import oracle.dbtools.raptor.controls.grid.CLOBProxy;
import oracle.dbtools.raptor.controls.grid.DATEProxy;
import oracle.dbtools.raptor.controls.grid.NUMBERProxy;
import oracle.dbtools.raptor.controls.grid.RaptorGridRowModel;
import oracle.dbtools.raptor.controls.grid.TIMESTAMPProxy;
import oracle.ide.ExtensionRegistry;

public class RaptorGridDB {
    public static Environment myEnv;
    private EntityStore store;
    private PrimaryIndex<Integer, RaptorGridRowModel> gridRowById = null;

    RaptorGridDB() {
        try {
            this.openDB();
            this.gridRowById = this.store.getPrimaryIndex(Integer.class, RaptorGridRowModel.class);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    private void openDB() {
        try {
            File file = new File(ExtensionRegistry.getExtensionRegistry().getSystemDirectory("oracle.sqldeveloper.worksheet").getFile());
            EnvironmentConfig environmentConfig = new EnvironmentConfig();
            environmentConfig.setTransactional(false);
            environmentConfig.setAllowCreate(true);
            environmentConfig.setTxnNoSync(true);
            environmentConfig.setTxnWriteNoSync(true);
            environmentConfig.setLocking(false);
            AnnotationModel annotationModel = new AnnotationModel();
            annotationModel.registerClass(CHARProxy.class);
            annotationModel.registerClass(NUMBERProxy.class);
            annotationModel.registerClass(DATEProxy.class);
            annotationModel.registerClass(TIMESTAMPProxy.class);
            annotationModel.registerClass(BLOBProxy.class);
            annotationModel.registerClass(CLOBProxy.class);
            StoreConfig storeConfig = new StoreConfig();
            storeConfig.setTransactional(false);
            storeConfig.setAllowCreate(true);
            storeConfig.setDeferredWrite(true);
            storeConfig.setModel((EntityModel)annotationModel);
            myEnv = new Environment(file, environmentConfig);
            this.store = new EntityStore(myEnv, "RaptorGridDBStore" + Math.random(), storeConfig);
        }
        catch (IncompatibleClassException incompatibleClassException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, incompatibleClassException.getStackTrace()[0].toString(), incompatibleClassException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, illegalArgumentException.getStackTrace()[0].toString(), illegalArgumentException);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
        }
    }

    public RaptorGridRowModel getRowAt(int n) {
        try {
            RaptorGridRowModel raptorGridRowModel = null;
            raptorGridRowModel = (RaptorGridRowModel)this.gridRowById.get((Object)n);
            return raptorGridRowModel;
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return null;
        }
    }

    public boolean addRow(RaptorGridRowModel raptorGridRowModel) {
        try {
            this.gridRowById.putNoReturn(null, (Object)raptorGridRowModel);
            return true;
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return false;
        }
    }

    public long getRowCount() {
        try {
            return this.gridRowById.count();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return 0L;
        }
    }

    public void close() {
        this.truncate();
    }

    public EntityCursor<RaptorGridRowModel> getAllRows() {
        try {
            return this.gridRowById.entities();
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, databaseException.getStackTrace()[0].toString(), databaseException);
            return null;
        }
    }

    public void truncate() {
        try {
            this.store.truncateClass(null, RaptorGridRowModel.class);
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(RaptorGridDB.class.getName()).log(Level.SEVERE, null, databaseException);
        }
    }
}

