/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.raptor.controls.SpringUtilities;

public class PropertyPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JPanel _northPanel;
    private int _northRows = 0;
    private JPanel _southPanel;

    public PropertyPanel() {
        this.init();
        this.addMouseListener(new DebugMouseListener(this));
    }

    public void addSingleComp(String string) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string == null ? "" : "<html>" + string.toString() + "</html>");
        jLabel.setSize(200, jLabel.getSize().height + 20);
        jLabel.setPreferredSize(new Dimension(200, jLabel.getSize().height + 20));
        this._southPanel.add(jLabel);
    }

    public void addSingleComp(JComponent jComponent) {
        this._southPanel.add(jComponent);
    }

    public void addValueAsLabel(String string, Object object) {
        JLabel jLabel = new JLabel();
        jLabel.setText(object == null ? "" : object.toString());
        jLabel.setSize(200, jLabel.getSize().height);
        this.addComp(string, jLabel);
    }

    public void addItem(String string, Object object) {
        this.addValueAsLabel(string, object);
    }

    public void addComp(String string, JComponent jComponent) {
        JLabel jLabel = new JLabel(string);
        jLabel.setSize(jLabel.getPreferredSize());
        this._northPanel.add(jLabel);
        this._northPanel.add(jComponent);
        ++this._northRows;
        SpringUtilities.makeCompactGrid(this._northPanel, this._northRows, 2, 0, 0, 6, 6);
    }

    private void init() {
        this._northPanel = new JPanel();
        this._southPanel = new JPanel();
        this._northPanel.setLayout(new SpringLayout());
        this._southPanel.setLayout(new GridLayout(0, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)this._northPanel, "North");
        this.add((Component)this._southPanel, "South");
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._northPanel != null) {
            this._northPanel.setBackground(color);
        }
        if (this._southPanel != null) {
            this._southPanel.setBackground(color);
        }
    }

    @Override
    public void removeAll() {
        this._northPanel.removeAll();
        this._northRows = 0;
        this._southPanel.removeAll();
    }

    private class DebugMouseListener
    implements MouseListener {
        private JPanel _panel = null;
        private Color[] colors = new Color[]{Color.RED, Color.BLACK, Color.BLUE, Color.ORANGE, Color.YELLOW};
        private int colorIdx = 0;

        public DebugMouseListener(JPanel jPanel) {
            this._panel = jPanel;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.isControlDown() && mouseEvent.isAltDown()) {
                this.colorIdx = 0;
                this.processPanel(this._panel, this.colors[this.colorIdx]);
            }
        }

        public void processPanel(JPanel jPanel, Color color) {
            int n = jPanel.getComponentCount();
            if (jPanel.getBorder() == null) {
                jPanel.setBorder(BorderFactory.createLineBorder(color));
                ++this.colorIdx;
                for (int i = 0; i < n; ++i) {
                    if (jPanel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)jPanel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(jPanel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)jPanel.getComponent(i)).setBorder(BorderFactory.createLineBorder(color));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    jPanel.setBorder(null);
                    if (jPanel.getComponent(i) instanceof JPanel) {
                        this.processPanel((JPanel)jPanel.getComponent(i), this.colors[this.colorIdx++]);
                        continue;
                    }
                    if (!(jPanel.getComponent(i) instanceof JComponent)) continue;
                    ((JComponent)jPanel.getComponent(i)).setBorder(null);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }
    }
}

