/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.controls;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import oracle.dbtools.raptor.controls.grid.RaptorGridFilter;

public abstract class FilteringJList
extends JList {
    private JTextField input;

    public FilteringJList() {
        FilteringModel filteringModel = new FilteringModel();
        this.setModel((ListModel)new FilteringModel());
    }

    public void installJTextField(JTextField jTextField) {
        if (jTextField != null) {
            this.input = jTextField;
            FilteringModel filteringModel = (FilteringModel)this.getModel();
            Document document = jTextField.getDocument();
            if (document != null) {
                document.putProperty("filterNewlines", Boolean.FALSE);
                document.addDocumentListener(filteringModel);
            }
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    Object e;
                    if (mouseEvent.getClickCount() == 1) {
                        Object e2 = FilteringJList.this.getSelectedValue();
                        if (e2 != null && e2 != RaptorGridFilter._ALL_) {
                            FilteringJList.this.input.setText(e2.toString());
                        }
                        FilteringJList.this.input.requestFocus();
                    } else if (mouseEvent.getClickCount() == 2 && (e = FilteringJList.this.getSelectedValue()) != null) {
                        FilteringJList.this.itemSelected(e);
                    }
                }
            });
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    Object e;
                    if (keyEvent.getKeyCode() == 10 && (e = FilteringJList.this.getSelectedValue()) != null) {
                        FilteringJList.this.itemSelected(e);
                    }
                }
            });
            jTextField.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        if (FilteringJList.this.getModel().getSize() == 1 && FilteringJList.this.getModel().getElementAt(0) == RaptorGridFilter._ALL_) {
                            FilteringJList.this.itemSelected(RaptorGridFilter._ALL_);
                        } else {
                            FilteringJList.this.itemSelected(FilteringJList.this.input.getText());
                        }
                    }
                }
            });
        }
    }

    public void uninstallJTextField(JTextField jTextField) {
        if (jTextField != null) {
            FilteringModel filteringModel = (FilteringModel)this.getModel();
            jTextField.getDocument().removeDocumentListener(filteringModel);
            this.input = null;
        }
    }

    public void setModel(ListModel listModel) {
        if (!(listModel instanceof FilteringModel)) {
            throw new IllegalArgumentException();
        }
        super.setModel(listModel);
    }

    public void addElement(Object object) {
        ((FilteringModel)this.getModel()).addElement(object);
    }

    public abstract void itemSelected(Object var1);

    private class FilteringModel
    extends AbstractListModel
    implements DocumentListener {
        List<Object> list = new ArrayList<Object>();
        List<Object> filteredList = new ArrayList<Object>();
        String lastFilter = "";

        public void addElement(Object object) {
            if (object == null) {
                object = RaptorGridFilter._NULL_;
            }
            this.list.add(object);
            this.filter(this.lastFilter);
        }

        @Override
        public int getSize() {
            return this.filteredList.size();
        }

        @Override
        public Object getElementAt(int n) {
            Object object = n < this.filteredList.size() ? this.filteredList.get(n) : null;
            return object;
        }

        void filter(String string) {
            this.filteredList.clear();
            if (string == null) {
                string = "";
            }
            for (Object object : this.list) {
                if (object != null && object != RaptorGridFilter._ALL_ && object.toString().indexOf(string, 0) == -1) continue;
                this.filteredList.add(object);
            }
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                this.lastFilter = document.getText(0, document.getLength());
                this.filter(this.lastFilter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            Document document = documentEvent.getDocument();
            try {
                this.lastFilter = document.getText(0, document.getLength());
                this.filter(this.lastFilter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

