/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IModalTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.util.IdeUtil;

public class TaskDialog {
    public static final String RUN_IN_BACKGROUND = "run_in_background";
    public static final String CANCEL_TASK = "cancel_task";
    public static final String CLOSE_TASK = "close_dialog";
    private JButton _cancelTaskBtn;
    private JButton _runInBckBtn = new JButton(Messages.getString("RaptorTaskManager.2"));
    private JEWTDialog _taskRunnerDlg;

    TaskDialog(ITaskUI iTaskUI, RaptorTask<?> raptorTask, boolean bl) {
        this._runInBckBtn.setMaximumSize(this._runInBckBtn.getMinimumSize());
        this._runInBckBtn.setActionCommand(RUN_IN_BACKGROUND);
        this._runInBckBtn.setAlignmentX(1.0f);
        this._runInBckBtn.setEnabled(false);
        this._cancelTaskBtn = new JButton(Messages.getString("RaptorTaskManager.6"));
        this._cancelTaskBtn.setMaximumSize(this._cancelTaskBtn.getMinimumSize());
        this._cancelTaskBtn.setActionCommand(CANCEL_TASK);
        this._cancelTaskBtn.setAlignmentX(1.0f);
        this._cancelTaskBtn.setEnabled(raptorTask.isCancellable());
        String string = raptorTask.getDescriptor().getName();
        this._taskRunnerDlg = OnePageWizardDialogFactory.createJEWTDialog((Component)iTaskUI.getPanel(), (Component)this._runInBckBtn, (String)string, (int)0);
        this._taskRunnerDlg.addCustomButton((Component)this._runInBckBtn);
        this._taskRunnerDlg.addCustomButton((Component)this._cancelTaskBtn);
        this._runInBckBtn.setEnabled(bl);
        this._taskRunnerDlg.pack();
        if (Ide.getMainWindow().isShowing()) {
            IdeUtil.centerWindow((Container)Ide.getMainWindow(), (Component)this._taskRunnerDlg);
        }
        this.addDialogCloseListener(raptorTask, iTaskUI);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showDelayedDialog(RaptorTask<?> raptorTask) {
        final JDialog jDialog = new JDialog((Frame)Ide.getMainWindow(), "UI Blocker", true);
        jDialog.setSize(0, 0);
        jDialog.setUndecorated(true);
        Timer timer = new Timer(500, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                    IdeMainWindow.updateVisibleActions();
                }
                catch (Throwable throwable) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, throwable.getStackTrace()[0].toString(), actionEvent);
                }
            }
        });
        timer.setRepeats(false);
        timer.start();
        jDialog.setVisible(true);
        JEWTDialog jEWTDialog = this._taskRunnerDlg;
        synchronized (jEWTDialog) {
            if (raptorTask.getDescriptor().getStatus() != IRaptorTaskStatus.FINISHED && raptorTask.getDescriptor().getStatus() != IRaptorTaskStatus.FAILED) {
                this._taskRunnerDlg.setVisible(true);
            }
        }
    }

    private void addDialogCloseListener(RaptorTask<?> raptorTask, final ITaskUI iTaskUI) {
        IRaptorTaskRunMode iRaptorTaskRunMode = raptorTask.getDescriptor().getRunMode();
        if (iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL || iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL_OPTIONAL) {
            raptorTask.getDescriptor().addListener(new RaptorTaskAdapter(){

                @Override
                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    this.closeDialog();
                    if (SwingUtilities.isEventDispatchThread()) {
                        TaskDialog.this._cancelTaskBtn.setText(Messages.getString("RaptorTaskManager.7"));
                        TaskDialog.this._runInBckBtn.setEnabled(false);
                        TaskDialog.this._cancelTaskBtn.setActionCommand(TaskDialog.CLOSE_TASK);
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    TaskDialog.this._cancelTaskBtn.setText(Messages.getString("RaptorTaskManager.7"));
                                    TaskDialog.this._runInBckBtn.setEnabled(false);
                                    TaskDialog.this._cancelTaskBtn.setActionCommand(TaskDialog.CLOSE_TASK);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }

                @Override
                public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                    this.taskFailed(raptorTaskEvent);
                }

                @Override
                public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                    this.closeDialog();
                    TaskDialog.this._cancelTaskBtn.setText(Messages.getString("RaptorTaskManager.7"));
                    TaskDialog.this._runInBckBtn.setEnabled(false);
                    TaskDialog.this._cancelTaskBtn.setActionCommand(TaskDialog.CLOSE_TASK);
                }

                private void closeDialog() {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (iTaskUI instanceof IModalTaskUI && !((IModalTaskUI)iTaskUI).canCloseDialog() && TaskDialog.this._taskRunnerDlg.isVisible()) {
                                return;
                            }
                            JEWTDialog jEWTDialog = TaskDialog.this._taskRunnerDlg;
                            synchronized (jEWTDialog) {
                                TaskDialog.this._taskRunnerDlg.closeDialog(true);
                                IdeMainWindow.updateVisibleActions();
                            }
                        }
                    });
                }
            });
        }
    }

    public void setButtonListener(ActionListener actionListener) {
        this._runInBckBtn.addActionListener(actionListener);
        this._cancelTaskBtn.addActionListener(actionListener);
    }

    public void setWindowCloseListener(WindowListener windowListener) {
        this._taskRunnerDlg.addWindowListener(windowListener);
    }

    public void setVisible(boolean bl) {
        this._taskRunnerDlg.setVisible(bl);
    }

    public boolean isVisible() {
        return this._taskRunnerDlg.isVisible();
    }

    public boolean isDisplayable() {
        return this._taskRunnerDlg.isDisplayable();
    }

    public void dispose() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TaskDialog.this._taskRunnerDlg != null) {
                    TaskDialog.this._taskRunnerDlg.dispose();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }
}

