/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskProgressUpdater;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.TaskDialog;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.backgroundTask.TaskLinkedList;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.backgroundTask.internal.RaptorTaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskUI;
import oracle.dbtools.raptor.backgroundTask.ui.ITaskViewer;
import oracle.dbtools.raptor.backgroundTask.ui.TaskProgressViewer;
import oracle.dbtools.raptor.backgroundTask.utils.RaptorTaskWrapper;
import oracle.ide.Ide;
import oracle.ide.controls.ProgressTrackedTask;
import oracle.ide.controls.ProgressTracker;

public class RaptorTaskManager {
    private static RaptorTaskManager schedulerInstance;
    private final TaskLinkedList<RaptorTask<?>> _schedulerTaskList = new TaskLinkedList();
    private final Map<RaptorTask<?>, Future<?>> _scheduledTaskMap = new ConcurrentHashMap();
    private final RaptorTaskThreadFactory _threadFactory = new RaptorTaskThreadFactory();
    private final ExecutorService _taskExecutor = new ThreadPoolExecutor(1, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), this._threadFactory);
    private SchedulerThread _schedulerThread = new SchedulerThread();
    private ProgressTracker _tracker;
    private IRaptorTaskListener _taskListener;
    private Map<RaptorTaskDescriptor, TaskDialog> _taskDialogMap;

    private RaptorTaskManager() {
        this._schedulerThread.setDaemon(true);
        this._schedulerThread.setName("Scheduler");
        this._taskListener = new RaptorTaskAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(RaptorTaskEvent raptorTaskEvent) {
                IRaptorTaskStatus iRaptorTaskStatus = raptorTaskEvent.getTaskDescriptor().getStatus();
                if (iRaptorTaskStatus == IRaptorTaskStatus.FAILED || iRaptorTaskStatus == IRaptorTaskStatus.FINISHED || iRaptorTaskStatus == IRaptorTaskStatus.PAUSED) {
                    TaskLinkedList taskLinkedList = RaptorTaskManager.this._schedulerTaskList;
                    synchronized (taskLinkedList) {
                        RaptorTaskManager.this._schedulerTaskList.notify();
                    }
                }
            }
        };
        this._schedulerThread.start();
        this._taskDialogMap = new ConcurrentHashMap<RaptorTaskDescriptor, TaskDialog>();
        this._tracker = Ide.getStatusBar().getProgressTracker();
    }

    public static synchronized RaptorTaskManager getInstance() {
        if (schedulerInstance == null) {
            schedulerInstance = new RaptorTaskManager();
        }
        return schedulerInstance;
    }

    public void addTask(RaptorTask<?> raptorTask) {
        this.addTask(raptorTask, new ArrayList());
    }

    public void addTask(RaptorTask<?> raptorTask, List<? extends ITaskViewer> list) {
        this.addTask(raptorTask, new ArrayList(), list);
    }

    public void addTask(RaptorTaskWrapper<?> raptorTaskWrapper) {
        this.addTask(raptorTaskWrapper.getTask(), raptorTaskWrapper.getRaptorTaskUIListeners(), raptorTaskWrapper.getTaskViewers());
    }

    public void addTask(final RaptorTask<?> raptorTask, final List<? extends IRaptorTaskUIListener> list, final List<? extends ITaskViewer> list2) {
        raptorTask.getDescriptor().addListener(this._taskListener);
        IRaptorTaskRunMode iRaptorTaskRunMode = raptorTask.getDescriptor().getRunMode();
        if (iRaptorTaskRunMode == IRaptorTaskRunMode.NO_GUI) {
            this.submitTask(raptorTask);
            return;
        }
        if (iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL || iRaptorTaskRunMode == IRaptorTaskRunMode.MODAL_OPTIONAL) {
            this.submitTask(raptorTask);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ITaskUI iTaskUI = null;
                    if (list2.size() > 0) {
                        iTaskUI = ((ITaskViewer)list2.get(0)).createTaskUI(raptorTask.getDescriptor());
                    }
                    if (iTaskUI == null) {
                        iTaskUI = new RaptorTaskUI(raptorTask.getDescriptor());
                    }
                    RaptorTaskManager.this.initViewers(raptorTask, list2, list);
                    ArrayList<DefaultTaskUIListener> arrayList = null;
                    arrayList = list != null ? new ArrayList(list) : new ArrayList<DefaultTaskUIListener>();
                    arrayList.add(0, new DefaultTaskUIListener(raptorTask, null));
                    RaptorTaskManager.this.setTaskUIState(iTaskUI, raptorTask, arrayList);
                    TaskDialog taskDialog = RaptorTaskManager.this.createBackgroundDialog(raptorTask, list, list2, iTaskUI);
                    RaptorTaskManager.this.showModalDialog(raptorTask, taskDialog);
                }
            });
        } else if (iRaptorTaskRunMode == IRaptorTaskRunMode.TASKVIEWER || iRaptorTaskRunMode == IRaptorTaskRunMode.IDE_STATUSBAR) {
            ArrayList<? extends ITaskViewer> arrayList = new ArrayList<ITaskViewer>(list2);
            arrayList.add(0, TaskProgressViewer.getInstance());
            this.initViewers(raptorTask, arrayList, list);
            this.submitTask(raptorTask);
        }
    }

    private void showModalDialog(RaptorTask<?> raptorTask, TaskDialog taskDialog) {
        taskDialog.showDelayedDialog(raptorTask);
    }

    private TaskDialog createBackgroundDialog(final RaptorTask<?> raptorTask, final List<? extends IRaptorTaskUIListener> list, final List<? extends ITaskViewer> list2, ITaskUI iTaskUI) {
        boolean bl = raptorTask.getDescriptor().getRunMode() == IRaptorTaskRunMode.MODAL_OPTIONAL;
        final TaskDialog taskDialog = new TaskDialog(iTaskUI, raptorTask, bl);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.equals("cancel_task") && IRaptorTaskStatus.isAlive(raptorTask.getDescriptor().getStatus())) {
                    if (!RaptorTaskManager.this.cancelTask(raptorTask)) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", actionEvent);
                    }
                } else if (string.equals("run_in_background")) {
                    ArrayList<TaskProgressViewer> arrayList = new ArrayList<TaskProgressViewer>(list2);
                    arrayList.add(0, TaskProgressViewer.getInstance());
                    RaptorTaskManager.this.initViewers(raptorTask, arrayList, list);
                    taskDialog.setVisible(false);
                } else if (string.equals("close_dialog")) {
                    taskDialog.setVisible(false);
                }
            }
        };
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (IRaptorTaskStatus.isAlive(raptorTask.getDescriptor().getStatus()) && !RaptorTaskManager.this.cancelTask(raptorTask)) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", windowEvent);
                }
            }
        };
        taskDialog.setButtonListener(actionListener);
        taskDialog.setWindowCloseListener(windowAdapter);
        this._taskDialogMap.put(raptorTask.getDescriptor(), taskDialog);
        return taskDialog;
    }

    private void initViewers(RaptorTask<?> raptorTask, List<? extends ITaskViewer> list, List<? extends IRaptorTaskUIListener> list2) {
        for (ITaskViewer iTaskViewer : list) {
            ArrayList<? extends IRaptorTaskUIListener> arrayList = new ArrayList<IRaptorTaskUIListener>(list2);
            ITaskUI iTaskUI = iTaskViewer.createTaskUI(raptorTask.getDescriptor());
            arrayList.add(0, new DefaultTaskUIListener(raptorTask, list));
            this.setTaskUIState(iTaskUI, raptorTask, arrayList);
            iTaskViewer.addTaskUI(iTaskUI);
        }
    }

    private void setTaskUIState(ITaskUI iTaskUI, RaptorTask<?> raptorTask, List<? extends IRaptorTaskUIListener> list) {
        iTaskUI.setCancellable(raptorTask.isCancellable());
        iTaskUI.setPausable(raptorTask.isPausable());
        for (IRaptorTaskUIListener iRaptorTaskUIListener : list) {
            iTaskUI.addListener(iRaptorTaskUIListener);
        }
        raptorTask.getDescriptor().addListener(iTaskUI);
    }

    private void submitTask(RaptorTask<?> raptorTask) {
        if (!this._schedulerThread.isAlive()) {
            throw new IllegalStateException(Messages.getString("RaptorTaskManager.3"));
        }
        raptorTask.setStatus(IRaptorTaskStatus.NEW);
        this._schedulerTaskList.offer(raptorTask);
    }

    public boolean cancelTask(RaptorTask<?> raptorTask) {
        Future<?> future;
        if (raptorTask.getStatus() == IRaptorTaskStatus.NEW) {
            this._schedulerTaskList.remove(raptorTask);
            raptorTask.getDescriptor().setCancelled(true);
            raptorTask.setStatus(IRaptorTaskStatus.FINISHED);
            return true;
        }
        raptorTask.requestCancel();
        if (raptorTask.mayInterrupt() && (future = this._scheduledTaskMap.get(raptorTask)) != null) {
            boolean bl = future.cancel(true);
            raptorTask.getDescriptor().setCancelled(bl);
            return bl;
        }
        return false;
    }

    public void shutdown() {
        this._schedulerThread.interrupt();
        this._taskExecutor.shutdown();
    }

    private void removeDeadTasks() {
        Object object;
        Iterator<Object> iterator = this._scheduledTaskMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((RaptorTask)object).getStatus() != IRaptorTaskStatus.FINISHED && ((RaptorTask)object).getStatus() != IRaptorTaskStatus.FAILED) continue;
            ((RaptorTask)object).getDescriptor().removeAllListeners();
            iterator.remove();
        }
        iterator = this._taskDialogMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (RaptorTaskDescriptor)iterator.next();
            if (((RaptorTaskDescriptor)object).getStatus() != IRaptorTaskStatus.FINISHED && ((RaptorTaskDescriptor)object).getStatus() != IRaptorTaskStatus.FAILED) continue;
            TaskDialog taskDialog = this._taskDialogMap.get(object);
            if (taskDialog != null && !taskDialog.isVisible()) {
                taskDialog.dispose();
            }
            ((RaptorTaskDescriptor)object).removeAllListeners();
            iterator.remove();
        }
    }

    private void shiftToForeGround(ITaskUI iTaskUI) {
        TaskDialog taskDialog = this._taskDialogMap.get(iTaskUI.getTaskDescriptor());
        if (taskDialog != null && taskDialog.isDisplayable()) {
            TaskProgressViewer.getInstance().removeTaskUI(iTaskUI);
            taskDialog.setVisible(true);
        }
    }

    private static class RaptorTaskThreadFactory
    implements ThreadFactory {
        private final ThreadFactory _delegate = Executors.defaultThreadFactory();
        private String _threadName = "";

        private RaptorTaskThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this._delegate.newThread(runnable);
            if (this._threadName != null && !this._threadName.equals("")) {
                thread.setName("RaptorTask: " + this._threadName);
            }
            return thread;
        }

        synchronized void setThreadName(String string) {
            this._threadName = string;
        }
    }

    private class DefaultTaskUIListener
    implements IRaptorTaskUIListener {
        RaptorTask<?> _task = null;
        List<? extends ITaskViewer> _viewers = null;

        public DefaultTaskUIListener(RaptorTask<?> raptorTask, List<? extends ITaskViewer> list) {
            this._task = raptorTask;
            this._viewers = list;
        }

        @Override
        public void cancelClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
            if (this._viewers != null) {
                for (ITaskViewer iTaskViewer : this._viewers) {
                    iTaskViewer.taskCancelRequested(raptorTaskDescriptor);
                }
            }
            RaptorTaskManager.this.cancelTask(this._task);
        }

        @Override
        public void pauseClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
            if (this._viewers != null) {
                for (ITaskViewer iTaskViewer : this._viewers) {
                    iTaskViewer.taskPauseRequested(raptorTaskDescriptor);
                }
            }
            if (this._task.getStatus() == IRaptorTaskStatus.PAUSED) {
                this._task.resume();
            } else if (this._task.getStatus() == IRaptorTaskStatus.RUNNABLE) {
                this._task.requestPause();
            }
        }

        @Override
        public void taskClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
            ITaskUI iTaskUI;
            if (raptorTaskDescriptor.getRunMode() == IRaptorTaskRunMode.MODAL_OPTIONAL && (iTaskUI = TaskProgressViewer.getInstance().getTaskUI(raptorTaskDescriptor)) != null) {
                RaptorTaskManager.this.shiftToForeGround(iTaskUI);
            }
        }
    }

    private class IdeTaskTracker<V>
    implements ProgressTrackedTask {
        private IRaptorTaskProgressUpdater _taskUpdater;
        private Future<?> _future;

        public IdeTaskTracker(IRaptorTaskProgressUpdater iRaptorTaskProgressUpdater, Future<?> future) {
            this._taskUpdater = iRaptorTaskProgressUpdater;
            this._future = future;
        }

        public String getCurrentText() {
            return this._taskUpdater.getDescriptor().getMessage();
        }

        public int getCurrentValue() {
            return this._taskUpdater.getDescriptor().getProgress();
        }

        public int getMaximum() {
            return 100;
        }

        public int getMinimum() {
            return 0;
        }

        public String getTaskDescription() {
            return this._taskUpdater.getDescriptor().getName();
        }

        public boolean isIndeterminate() {
            return this._taskUpdater.getDescriptor().isInDeterminate();
        }

        public void run() {
            try {
                this._future.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (CancellationException cancellationException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    private class RaptorFutureTask<V>
    extends FutureTask<V> {
        RaptorTask<V> _task;

        public RaptorFutureTask(RaptorTask<V> raptorTask) {
            super(raptorTask);
            this._task = null;
            this._task = raptorTask;
        }

        @Override
        protected void done() {
            super.done();
            try {
                try {
                    this.get();
                    this._task.setStatus(IRaptorTaskStatus.FINISHED);
                }
                catch (ExecutionException executionException) {
                    Throwable throwable = executionException.getCause();
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof TaskException) {
                    this._task.getDescriptor().setStatus(IRaptorTaskStatus.FAILED, ((TaskException)throwable).getCause());
                }
                this._task.getDescriptor().setStatus(IRaptorTaskStatus.FAILED, throwable);
            }
        }

        @Override
        public void run() {
            if (this._task.getDescriptor().getRunMode() == IRaptorTaskRunMode.IDE_STATUSBAR) {
                IdeTaskTracker ideTaskTracker = new IdeTaskTracker(this._task.getRaptorTaskProgressUpdater(), this);
                RaptorTaskManager.this._tracker.addTask(ideTaskTracker, this._task.getDescriptor().getName());
            }
            super.run();
        }
    }

    private class SchedulerThread
    extends Thread {
        private SchedulerThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RaptorTask<?> raptorTask;
                        if ((raptorTask = RaptorTaskManager.this._schedulerTaskList.takeNextTask(RaptorTaskManager.this._scheduledTaskMap.keySet())) == null) {
                            continue;
                        }
                        if (raptorTask.getStatus().equals((Object)IRaptorTaskStatus.NEW)) {
                            RaptorFutureTask raptorFutureTask = new RaptorFutureTask(raptorTask);
                            raptorTask.setFuture(raptorFutureTask);
                            RaptorTaskManager.this._threadFactory.setThreadName(raptorTask.getDescriptor().getName());
                            RaptorTaskManager.this._taskExecutor.submit(raptorFutureTask);
                            RaptorTaskManager.this._scheduledTaskMap.put(raptorTask, raptorFutureTask);
                        }
                        RaptorTaskManager.this.removeDeadTasks();
                    }
                }
                catch (Throwable throwable) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, Messages.getString("RaptorTaskManager.4") + throwable.getStackTrace()[0].toString(), throwable);
                    continue;
                }
                break;
            }
        }
    }
}

