/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.backgroundTask;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskStatus;
import oracle.dbtools.raptor.backgroundTask.Messages;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.ui.IImageRegistry;
import oracle.javatools.icons.OracleIcons;

public class RaptorTaskDescriptor {
    private String _name;
    private String _message;
    private long _startTime;
    private long _lastProgressTime;
    private long _elapseTime = -1L;
    private int _progress;
    private IRaptorTaskStatus _status;
    private IRaptorTaskRunMode _runMode = IRaptorTaskRunMode.MODAL_OPTIONAL;
    private List<IRaptorTaskListener> _listenerList;
    private boolean _isInDeterminate;
    private Throwable _throwable;
    private boolean m_isCancelled;
    ReentrantLock _listenerLock = new ReentrantLock();
    static boolean DEBUG_TASK_STATES = false;

    public RaptorTaskDescriptor(String string) {
        this._name = string;
        this.setStatus(IRaptorTaskStatus.NEW);
        this._listenerList = new ArrayList<IRaptorTaskListener>();
    }

    public RaptorTaskDescriptor(String string, boolean bl) {
        this(string);
        this._isInDeterminate = bl;
    }

    public RaptorTaskDescriptor(String string, boolean bl, IRaptorTaskRunMode iRaptorTaskRunMode) {
        this(string, bl);
        this._runMode = iRaptorTaskRunMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IRaptorTaskListener iRaptorTaskListener) {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.remove(iRaptorTaskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeAllListeners() {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IRaptorTaskListener iRaptorTaskListener) {
        List<IRaptorTaskListener> list = this._listenerList;
        synchronized (list) {
            this._listenerList.add(iRaptorTaskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListener(PROPERTY pROPERTY, Object object) {
        Object object2;
        if (this._startTime > 0L && !(object instanceof IRaptorTaskStatus) && this._status != IRaptorTaskStatus.FINISHED && this._status != IRaptorTaskStatus.FAILED) {
            this._lastProgressTime = System.currentTimeMillis();
        }
        if (this._listenerList == null) {
            return;
        }
        try {
            this._listenerLock.lock();
            object2 = this._listenerList;
            synchronized (object2) {
                RaptorTaskEvent raptorTaskEvent = new RaptorTaskEvent(this, System.currentTimeMillis());
                raptorTaskEvent.setChangedProperty(pROPERTY, object);
                raptorTaskEvent.setThrowable(this._throwable);
                block16: for (IRaptorTaskListener iRaptorTaskListener : this._listenerList) {
                    switch (pROPERTY) {
                        case STATUS: {
                            iRaptorTaskListener.stateChanged(raptorTaskEvent);
                            continue block16;
                        }
                        case MESSAGE: {
                            iRaptorTaskListener.messageChanged(raptorTaskEvent);
                            continue block16;
                        }
                        case PROGRESS: {
                            iRaptorTaskListener.progressChanged(raptorTaskEvent);
                            continue block16;
                        }
                    }
                    throw new IllegalStateException(Messages.getString("RaptorTaskDescriptor.0") + (Object)((Object)this.getStatus()));
                }
            }
        }
        finally {
            this._listenerLock.unlock();
        }
        object2 = null;
        if (DEBUG_TASK_STATES) {
            object2 = this.getName() + " " + pROPERTY.toString() + "=";
            switch (pROPERTY) {
                case STATUS: {
                    object2 = (String)object2 + (Object)((Object)this.getStatus());
                    break;
                }
                case MESSAGE: {
                    object2 = (String)object2 + this.getMessage();
                    break;
                }
                case PROGRESS: {
                    object2 = (String)object2 + this.getProgress();
                    break;
                }
            }
            System.err.println((String)object2 + " >listeners notified");
        }
    }

    private boolean tryListenerLocked() {
        try {
            return this._listenerLock.tryLock(500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }

    private void unlockListener() {
        if (this._listenerLock.isHeldByCurrentThread()) {
            this._listenerLock.unlock();
        }
    }

    public boolean isCancelled() {
        if (this.m_isCancelled) {
            return true;
        }
        if (this._throwable instanceof ExecutionException) {
            return ((ExecutionException)this._throwable).getCause() instanceof CancellationException;
        }
        return this._throwable instanceof CancellationException;
    }

    public void setCancelled(boolean bl) {
        this.m_isCancelled = bl;
    }

    public long getElapsedTime() {
        if (this._elapseTime != -1L) {
            return this._elapseTime;
        }
        return this._lastProgressTime - this._startTime;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getLastProgressTime() {
        return this._lastProgressTime;
    }

    public Icon getIcon() {
        if (this.getStatus() == null) {
            return null;
        }
        if (this.getStatus() == IRaptorTaskStatus.FAILED) {
            return IImageRegistry.LIGHT_RED;
        }
        if (this.getStatus() == IRaptorTaskStatus.RUNNABLE) {
            return IImageRegistry.LIGHT_GREEN;
        }
        if (this.getStatus() == IRaptorTaskStatus.NEW || this.getStatus() == IRaptorTaskStatus.PAUSED) {
            return IImageRegistry.LIGHT_YELLOW;
        }
        if (this.getStatus() == IRaptorTaskStatus.FINISHED && !this.isCancelled()) {
            return OracleIcons.getIcon((String)"extras/right.gif");
        }
        return OracleIcons.getIcon((String)"error.png");
    }

    public String getMessage() {
        return this._message;
    }

    public String getName() {
        return this._name;
    }

    public int getProgress() {
        return this._progress;
    }

    public IRaptorTaskStatus getStatus() {
        return this._status;
    }

    public Throwable getThrowable() {
        return this._throwable;
    }

    public void makeProgress(int n) {
        int n2 = this._progress;
        this._progress += n;
        this.notifyListener(PROPERTY.PROGRESS, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeProgress(int n, boolean bl) {
        if (bl) {
            try {
                if (this.tryListenerLocked()) {
                    this.makeProgress(n);
                }
                this._progress += n;
            }
            finally {
                this.unlockListener();
            }
        } else {
            this.makeProgress(n);
            return;
        }
    }

    public void setMessage(String string) {
        String string2 = this._message;
        this._message = string;
        this.notifyListener(PROPERTY.MESSAGE, string2);
    }

    public void setProgress(int n) {
        int n2 = this._progress;
        this._progress = n;
        this.notifyListener(PROPERTY.PROGRESS, n2);
    }

    void setStatus(IRaptorTaskStatus iRaptorTaskStatus) {
        this.setStatus(iRaptorTaskStatus, null);
    }

    void setStatus(IRaptorTaskStatus iRaptorTaskStatus, Throwable throwable) {
        IRaptorTaskStatus iRaptorTaskStatus2 = this._status;
        if (this._startTime == 0L && iRaptorTaskStatus == IRaptorTaskStatus.RUNNABLE) {
            this._lastProgressTime = this._startTime = System.currentTimeMillis();
        }
        this._status = iRaptorTaskStatus;
        this._throwable = throwable;
        if (iRaptorTaskStatus2 != iRaptorTaskStatus || iRaptorTaskStatus == IRaptorTaskStatus.NEW) {
            this.notifyListener(PROPERTY.STATUS, (Object)iRaptorTaskStatus2);
        }
    }

    public boolean isInDeterminate() {
        return this._isInDeterminate;
    }

    public IRaptorTaskRunMode getRunMode() {
        return this._runMode;
    }

    public void overrideElapseTime(long l) {
        this._elapseTime = l;
    }

    public static enum PROPERTY {
        NAME,
        MESSAGE,
        PROGRESS,
        STATUS;

    }
}

