/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.logging;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.logging.ILoggingPage;
import oracle.dbtools.raptor.utils.ExceptionHandler;

public class LogPaneHandler
extends Handler {
    private static final Logger BASE_LOGGER = Logger.getLogger("oracle.dbtools");
    private static final Object LOCK = new Object();
    private static LogPaneHandler INSTANCE;
    private ILoggingPage _logPage = new DefaultLogger();
    private Class<ILoggingPage> _logpageClass;
    private Queue<LogRecord> m_records = new LinkedList<LogRecord>();
    private Runnable m_logRunner;

    private LogPaneHandler() {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger("");
        logger.addHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogPaneHandler getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new LogPaneHandler();
            }
        }
        return INSTANCE;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        Object object = LOCK;
        synchronized (object) {
            if (BASE_LOGGER.isLoggable(logRecord.getLevel())) {
                this.m_records.add(logRecord);
                if (SwingUtilities.isEventDispatchThread()) {
                    this.logMessages();
                } else if (this.m_logRunner == null) {
                    this.m_logRunner = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Object object = LOCK;
                            synchronized (object) {
                                LogPaneHandler.this.m_logRunner = null;
                                LogPaneHandler.this.logMessages();
                            }
                        }
                    };
                    SwingUtilities.invokeLater(this.m_logRunner);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogPage(ILoggingPage iLoggingPage) {
        Object object = LOCK;
        synchronized (object) {
            if (this._logPage instanceof DefaultLogger) {
                ((DefaultLogger)this._logPage).outputTo(iLoggingPage);
            }
            this._logPage = iLoggingPage;
        }
    }

    public void setLogPageClass(Class clazz) {
        this._logPage = null;
        this._logpageClass = clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logMessages() {
        Object object = LOCK;
        synchronized (object) {
            ILoggingPage iLoggingPage = this.getLogPage();
            if (iLoggingPage != null) {
                LogRecord logRecord;
                while ((logRecord = this.m_records.poll()) != null) {
                    iLoggingPage.log(logRecord);
                }
            }
        }
    }

    private ILoggingPage getLogPage() {
        if (this._logPage == null && this._logpageClass != null) {
            try {
                this.setLogPage(this._logpageClass.newInstance());
            }
            catch (InstantiationException instantiationException) {
                ExceptionHandler.handleException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                ExceptionHandler.handleException(illegalAccessException);
            }
        }
        return this._logPage;
    }

    private static class DefaultLogger
    implements ILoggingPage {
        private List<LogRecord> _log = new ArrayList<LogRecord>();

        private DefaultLogger() {
        }

        @Override
        public void log(LogRecord logRecord) {
            this._log.add(logRecord);
        }

        private void outputTo(ILoggingPage iLoggingPage) {
            for (LogRecord logRecord : this._log) {
                iLoggingPage.log(logRecord);
            }
        }
    }
}

