/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.db;

import java.sql.ResultSet;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.MessageLogging;

final class ResultSetHolder {
    private static final String MSG = "Unclosed ResultSetWrapper: {0}.{1} ({2}) called by {3}.{4} ({5})";
    private static final Logger s_logger = Logger.getLogger(ResultSetHolder.class.getName());
    private final UnclosedWrapperException m_ex;
    private final long m_created = System.currentTimeMillis();
    private final ResultSet m_rs;
    private final Statement m_stmt;

    ResultSetHolder(ResultSet resultSet, Statement statement) {
        this.m_rs = resultSet;
        this.m_stmt = statement;
        this.m_ex = DBUtil.DEBUG_BUILD ? new UnclosedWrapperException() : null;
    }

    ResultSet getResultSet() {
        return this.m_rs;
    }

    void logStack(boolean bl) {
        if (this.m_ex != null) {
            StackTraceElement[] stackTraceElementArray = this.m_ex.getStackTrace();
            for (int i = 2; i < stackTraceElementArray.length; ++i) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i - 1];
                StackTraceElement stackTraceElement2 = stackTraceElementArray[i];
                String string = stackTraceElement2.getClassName();
                if (string.startsWith(DBUtil.class.getName())) continue;
                Object[] objectArray = new Object[]{stackTraceElement.getClassName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber(), stackTraceElement2.getClassName(), stackTraceElement2.getMethodName(), stackTraceElement2.getLineNumber()};
                s_logger.log(Level.SEVERE, MSG, objectArray);
                if (!bl) break;
                MessageLogging.getInstance().reportAPIException(MessageFormat.format(MSG, objectArray), this.m_ex, stackTraceElement.getMethodName());
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        ResultSet resultSet = null;
        Statement statement = null;
        ResultSetHolder resultSetHolder = this;
        synchronized (resultSetHolder) {
            resultSet = this.m_rs;
            statement = this.m_stmt;
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class UnclosedWrapperException
    extends Exception {
        private UnclosedWrapperException() {
        }
    }
}

