/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.icons.OracleIcons;

final class PropertiesFolder
extends BaseFolder {
    private Object m_obj;
    private PropertyInfo m_info;
    private DBObjectProvider m_pro;

    public PropertiesFolder(Object obj, PropertyInfo info, DBObjectProvider pro) {
        this.m_obj = obj;
        this.m_info = info;
        this.m_pro = pro;
    }

    @Override
    protected List<Element> createChildren(List<Element> existing) {
        ArrayList<Element> retval = new ArrayList<Element>();
        Object value = this.m_info.getPropertyValue(this.m_obj);
        if (value != null) {
            if (value instanceof Map) {
                ExplorerModelHelper helper = this.getHelper();
                PropertyIterator iter = new PropertyIterator(this.m_obj.getClass(), null);
                Map infos = iter.getPropertyInfos(true, true, false);
                Map beanProps = iter.getPropertyInfos(true, true, true);
                for (Object key : ((Map)value).keySet()) {
                    DBExplorerElement elem;
                    String propName = (String)key;
                    PropertyInfo info = (PropertyInfo)infos.get(propName);
                    if (info == null || beanProps.containsKey(propName) || (elem = helper.findOrCreateElement(this.m_obj, info, this.m_pro, null)) == null) continue;
                    retval.add(elem);
                }
            } else {
                throw new IllegalStateException("PropertiesFolder is only valid for Map properties");
            }
        }
        return retval;
    }

    @Override
    public Object getKey() {
        return this.m_info.getPropertyName();
    }

    public String getShortLabel() {
        return PropertyDisplayRegistry.getDisplayName((String)this.m_info.getPropertyName(), (DBObjectProvider)this.m_pro, this.m_obj instanceof DBObject ? (DBObject)this.m_obj : null);
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public Icon getIcon() {
        return OracleIcons.getIcon((String)"folder.png");
    }

    public String getToolTipText() {
        return this.getLongLabel();
    }
}

