/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.DBTypeFolder;
import oracle.ideimpl.db.explorer.model.PropertiesFolder;
import oracle.ideimpl.db.explorer.model.PropertyNode;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.Schema;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.util.ModelUtil;

final class ExplorerModelHelper {
    private static final Collection<String> m_globallyIgnored = new ArrayList<String>();
    private Context m_context;

    public ExplorerModelHelper(Context context) {
        this.m_context = context;
        if (context == null || !(context.getNode() instanceof DBObjectNode)) {
            throw new IllegalArgumentException("Context must contain a DBObject.");
        }
    }

    public DBExplorerElement findOrCreateElement(Object parent, PropertyInfo info, DBObjectProvider pro, List<Element> existing) {
        DBExplorerElement elem = null;
        String propName = info.getPropertyName();
        if (!ExplorerModelHelper.isIgnoredProperty(propName, pro, parent)) {
            Class propClz = info.getPropertyClass();
            if (DBObject.class.isAssignableFrom(propClz) && Schema.class != propClz) {
                DBObject obj = (DBObject)info.getPropertyValue(parent);
                if (obj != null && (elem = ExplorerModelHelper.find(existing, obj.getName())) == null) {
                    elem = new DBObjectFolder(obj, pro, propName);
                }
            } else {
                elem = ExplorerModelHelper.find(existing, propName);
                if (elem == null || elem instanceof PropertyNode) {
                    if (propClz.isArray()) {
                        if (parent instanceof DBObject) {
                            elem = new DBTypeFolder((DBObject)parent, info, pro);
                        }
                    } else if (Map.class.isAssignableFrom(propClz)) {
                        PropertiesFolder folder = new PropertiesFolder(parent, info, pro);
                        folder.setHelper(this);
                        if (folder.size() > 0) {
                            elem = folder;
                        }
                    } else {
                        elem = new PropertyNode(info, parent, pro);
                    }
                }
            }
        }
        return elem;
    }

    static final DBExplorerElement find(List<Element> elems, Object key) {
        DBExplorerElement retval = null;
        if (key != null && elems != null) {
            for (Element elem : elems) {
                if (!(elem instanceof DBExplorerElement) || !ModelUtil.areEqual((Object)((DBExplorerElement)elem).getKey(), (Object)key)) continue;
                retval = (DBExplorerElement)elem;
                break;
            }
        }
        return retval;
    }

    static Collection<String> getExtraProperties(DBObjectProvider pro, Object object) {
        if (object instanceof Index) {
            return Collections.singletonList("table");
        }
        return Collections.emptyList();
    }

    static boolean isIgnoredProperty(String propertyName, DBObjectProvider pro, Object object) {
        String dispName;
        boolean ignore = m_globallyIgnored.contains(propertyName);
        if (!ignore && object instanceof DBObject && ((dispName = PropertyDisplayRegistry.getDisplayName((String)propertyName, (DBObjectProvider)pro, (DBObject)((DBObject)object))) == null || dispName.equals(propertyName))) {
            ignore = true;
        }
        return ignore;
    }

    static {
        m_globallyIgnored.add("ID");
        m_globallyIgnored.add("name");
        m_globallyIgnored.add("SQLQuery");
        m_globallyIgnored.add("code");
        m_globallyIgnored.add("bodySource");
        m_globallyIgnored.add("source");
    }
}

