/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import oracle.ide.Context;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.model.Element;
import oracle.ideimpl.db.explorer.model.BaseFolder;
import oracle.ideimpl.db.explorer.model.DBExplorerElement;
import oracle.ideimpl.db.explorer.model.DBObjectFolder;
import oracle.ideimpl.db.explorer.model.ExplorerModelHelper;
import oracle.ideimpl.db.explorer.model.PlSqlFolder;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;

public class DBObjectFolderFactory {
    public static Element createRootFolder(DBObjectNode newNode, Context context) {
        if (newNode instanceof DBObjectPlSqlNode) {
            return new PlSqlFolder((DBObjectPlSqlNode)newNode, context);
        }
        return new SimpleRoot(newNode, context);
    }

    public static void update(Element elem) {
        if (elem instanceof DBExplorerElement) {
            ((DBExplorerElement)elem).reset();
        }
    }

    private static class SimpleRoot
    extends BaseFolder {
        private DBObjectNode m_node;
        private Context m_context;
        private DBObjectFolder m_root;

        public SimpleRoot(DBObjectNode newNode, Context context) {
            this.m_node = newNode;
            this.m_context = context;
            this.setHelper(new ExplorerModelHelper(context));
        }

        @Override
        protected List<Element> createChildren(List<Element> existing) {
            DBObject obj;
            ArrayList<Element> l = new ArrayList<Element>();
            if (this.m_root == null && (obj = this.m_node.getDBObject()) != null) {
                DBObjectProvider pro = this.m_node.getProvider();
                this.m_root = new DBObjectFolder(obj, pro, null);
                this.m_root.setContext(this.m_context);
            }
            if (this.m_root != null) {
                l.add(this.m_root);
            }
            return l;
        }

        public String getShortLabel() {
            return "root";
        }

        public String getLongLabel() {
            return this.m_node.getLongLabel();
        }

        public Icon getIcon() {
            return this.m_node.getIcon();
        }

        public String getToolTipText() {
            return this.m_node.getToolTipText();
        }

        @Override
        public Object getKey() {
            return this.m_node.getURL();
        }

        @Override
        protected boolean shouldThread() {
            return DBObjectNodeUtil.isOnlineNode((Object)this.m_node);
        }
    }
}

