/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.explorer;

import java.util.logging.Level;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.model.Element;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.ideimpl.db.explorer.model.PlSqlFragmentElement;
import oracle.javatools.db.DBLog;

class ExplorerController
implements Controller {
    ExplorerController() {
    }

    public boolean update(IdeAction action, Context context) {
        PlSqlFragmentElement elem;
        boolean retval = false;
        int cmd = action.getCommandId();
        if (cmd == ExplorerController.getAction().getCommandId() && (elem = ExplorerController.getFragElem(context)) != null) {
            action.setEnabled(true);
            retval = true;
        }
        return retval;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        PlSqlFragmentElement elem;
        boolean retval = false;
        int cmd = action.getCommandId();
        if (cmd == ExplorerController.getAction().getCommandId() && (elem = ExplorerController.getFragElem(context)) != null) {
            int startOffset = elem.getStartOffset();
            int endOffset = elem.getEndOffset();
            NavigationManager mgr = NavigationManager.getNavigationManager();
            OffsetNavigationPoint point = new OffsetNavigationPoint(context, startOffset, startOffset >= 0 && endOffset > startOffset ? endOffset - startOffset : 0);
            point.setPreferredEditorType(null);
            try {
                if (mgr != null) {
                    mgr.navigateTo((NavigationPoint)point);
                } else {
                    point.navigate();
                }
            }
            catch (Exception e) {
                DBLog.getLogger((Object)this).log(Level.SEVERE, "Error in Go to Source for pl/sql", e);
            }
        }
        return retval;
    }

    static PlSqlFragmentElement getFragElem(Context context) {
        Element elem;
        PlSqlFragmentElement retval = null;
        Element[] sel = context.getSelection();
        Element element = elem = sel != null && sel.length == 1 ? sel[0] : null;
        if (elem instanceof PlSqlFragmentElement) {
            retval = (PlSqlFragmentElement)elem;
        }
        return retval;
    }

    static IdeAction getAction() {
        return IdeActions.getGoToDeclarationAction();
    }
}

