/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels.tablespace;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.NameEditor;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.panels.tablespace.TablespaceTypePanel;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyHelper;

public class TablespaceInfoPanel
extends NameEditor<Tablespace> {
    private JLabel m_tablespaceTypeLabel = new JLabel(UIArb.getString(548));
    private TablespaceTypePanel m_tablespaceTypePanel = new TablespaceTypePanel(false);
    private Tablespace.TablespaceType m_lastType;
    private final Map<String, Object> m_cachedProps = new HashMap<String, Object>();
    private PropertyHelper m_propHelper;
    private final Map<String, Object> m_permProps = new HashMap<String, Object>();

    public TablespaceInfoPanel() {
        this.getHelper().setAllowRecreate(false);
        this.getHelper().registerComponent(this.m_tablespaceTypeLabel, Property.createPath((String[])new String[]{"properties", "TablespaceType"}));
        this.getHelper().registerComponent(this.m_tablespaceTypePanel, Property.createPath((String[])new String[]{"properties", "TablespaceType"}));
        this.m_tablespaceTypePanel.addActionListener(this);
    }

    private void removeTypePanel() {
        this.remove(this.m_tablespaceTypeLabel);
        this.remove(this.m_tablespaceTypePanel);
    }

    private void addTypePanel() {
        this.removeTypePanel();
        this.add(this.m_tablespaceTypeLabel, new GridBagConstraints(0, 30, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 0, 15), 0, 0));
        this.add(this.m_tablespaceTypePanel, new GridBagConstraints(1, 30, 0, 1, 0.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    @Override
    protected void initialisePanel() {
        super.initialisePanel();
        this.addTypePanel();
        Tablespace tablespace = (Tablespace)this.getDBObject();
        this.m_lastType = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT);
        this.m_tablespaceTypePanel.setTablespaceType(this.m_lastType);
        boolean isEditable = this.isEditable();
        this.initialisePermProps();
        if (!isEditable) {
            this.m_tablespaceTypePanel.enableAllComponents(false);
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        this.commitType();
    }

    @Override
    protected void validateObject() throws TraversalException {
        super.validateObject();
        this.m_lastType = null;
    }

    private Tablespace.TablespaceType commitType() {
        Tablespace tablespace = (Tablespace)this.getDBObject();
        Tablespace.TablespaceType type = this.m_tablespaceTypePanel.getTablespaceType();
        tablespace.setProperty("TablespaceType", (Object)type);
        return type;
    }

    private void showPanelsForTablespaceType(Tablespace tablespace) throws TraversalException {
        PanelLibrary panels = (PanelLibrary)this.getDataContext().find("PANEL_LIBRARY");
        Tablespace.TablespaceType newType = this.m_tablespaceTypePanel.getTablespaceType();
        Tablespace copy = (Tablespace)tablespace.copyTo(null, true);
        copy.setProperty("TablespaceType", (Object)newType);
        List<Navigable> navs = this.isEditing() ? panels.getEditNavigables((DBObject)copy, this.getProvider()) : panels.getCreateNavigables((DBObject)copy, this.getProvider());
        Tablespace.TablespaceType defaultType = this.isEditing() ? (Tablespace.TablespaceType)((Tablespace)this.getOriginalObject()).getProperty("TablespaceType") : Tablespace.TablespaceType.PERMANENT;
        String key = newType == defaultType ? "DEFAULT_PANEL" : newType.toString();
        this.changePanels(key, navs.toArray(new Navigable[navs.size()]));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object source = ev.getSource();
        if (source == this.m_tablespaceTypePanel) {
            Tablespace tablespace = (Tablespace)this.getDBObject();
            this.m_lastType = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType");
            if (this.m_lastType != this.m_tablespaceTypePanel.getTablespaceType()) {
                try {
                    this.showPanelsForTablespaceType(tablespace);
                }
                catch (TraversalException te) {
                    te.showMessageDialog((Component)((Object)this));
                    tablespace.setProperty("TablespaceType", (Object)this.m_lastType);
                    this.m_tablespaceTypePanel.setTablespaceType(this.m_lastType);
                }
            }
        } else {
            super.actionPerformed(ev);
        }
    }

    private void validateTablespaceTypePanelChange(Tablespace tablespace) throws TraversalException {
        Tablespace.TablespaceType tablespaceType = this.commitType();
        if (this.m_lastType != null && this.m_lastType != tablespaceType) {
            if (!this.doTypeChange(tablespace, this.m_lastType)) {
                throw new TraversalException(null);
            }
            try {
                this.getProvider().validateObjectProperty((DBObject)tablespace, Property.createPath((String[])new String[]{"properties", "TablespaceType"}));
                this.m_lastType = null;
            }
            catch (ValidationException ve) {
                tablespace.setProperty("TablespaceType", (Object)this.m_lastType);
                throw new TraversalException(ve.getMessage(), ve.getTitle());
            }
        }
    }

    @Override
    public void validatePanelChange(TraversableContext data) throws TraversalException {
        this.validateTablespaceTypePanelChange((Tablespace)this.getDBObject());
    }

    private boolean doTypeChange(Tablespace tablespace, Tablespace.TablespaceType oldType) {
        Tablespace.TablespaceType type = (Tablespace.TablespaceType)tablespace.getProperty("TablespaceType");
        boolean ok = true;
        if (type != oldType) {
            if (this.m_propHelper == null) {
                this.m_propHelper = new PropertyHelper();
            }
            if (oldType == Tablespace.TablespaceType.PERMANENT) {
                this.resetPermanentProperties(tablespace);
            } else if (oldType == Tablespace.TablespaceType.TEMPORARY) {
                this.resetTemporaryProperties(tablespace);
            } else {
                this.resetUndoProperties(tablespace);
            }
            if (type == Tablespace.TablespaceType.PERMANENT) {
                this.restorePermanentProperties(tablespace);
            } else if (type == Tablespace.TablespaceType.TEMPORARY) {
                this.restoreTemporaryProperties(tablespace);
            } else {
                this.restoreUndoProperties(tablespace);
            }
        }
        return ok;
    }

    private void resetPermanentProperties(Tablespace tablespace) {
        for (String key : this.m_permProps.keySet()) {
            this.resetProperty(tablespace, key, this.m_permProps.get(key));
        }
    }

    private void restorePermanentProperties(Tablespace tablespace) {
        Iterator<String> propsIter = this.m_permProps.keySet().iterator();
        while (propsIter.hasNext()) {
            this.restoreProperty(tablespace, propsIter.next());
        }
    }

    private void resetTemporaryProperties(Tablespace tablespace) {
        String tablespceGroup = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "tablespaceGroup"});
        this.resetProperty(tablespace, tablespceGroup, null);
    }

    private void restoreTemporaryProperties(Tablespace tablespace) {
        String tablespceGroup = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "tablespaceGroup"});
        this.restoreProperty(tablespace, tablespceGroup);
    }

    private void resetUndoProperties(Tablespace tablespace) {
        String retention = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "retention"});
        this.resetProperty(tablespace, retention, null);
    }

    private void restoreUndoProperties(Tablespace tablespace) {
        String retention = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "retention"});
        this.restoreProperty(tablespace, retention);
    }

    private void restoreProperty(Tablespace tablespace, String propPath) {
        if (this.m_cachedProps.containsKey(propPath)) {
            this.m_propHelper.setPropertyValue((Object)tablespace, propPath, this.m_cachedProps.get(propPath));
        }
    }

    private void resetProperty(Tablespace tablespace, String propPath, Object value) {
        this.m_cachedProps.put(propPath, this.m_propHelper.getPropertyValue((Object)tablespace, propPath));
        this.m_propHelper.setPropertyValue((Object)tablespace, propPath, value);
    }

    private void initialisePermProps() {
        if (this.m_permProps.size() == 0) {
            String online = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "onlineStatus"});
            this.m_permProps.put(online, null);
            String minExtent = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "minExtent"});
            this.m_permProps.put(minExtent, null);
            String blockSize = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "blockSize"});
            this.m_permProps.put(blockSize, null);
            String logging = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "logging"});
            this.m_permProps.put(logging, null);
            String forceLogging = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "forceLogging"});
            this.m_permProps.put(forceLogging, Boolean.FALSE);
            String autoAlloc = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "autoAllocate"});
            this.m_permProps.put(autoAlloc, Boolean.FALSE);
            String compression = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "defaultTableCompression"});
            this.m_permProps.put(compression, null);
            String segMgmnt = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "segmentManagement"});
            this.m_permProps.put(segMgmnt, null);
            String storageProps = Property.createPath((String[])new String[]{"properties", "OracleTablespaceProperties", "properties", "OracleStorageProperties"});
            this.m_permProps.put(storageProps, null);
        }
    }
}

