/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.lang.reflect.Array;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.panels.BaseEditorPanel;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyManager;

public abstract class ChildListEditorPanel<C extends ChildDBObject, P extends DBObject>
extends BaseEditorPanel<P> {
    private final ChildObjectListModel<C> m_childModel = new ChildObjectListModel();
    private final JList m_childList = new JList<C>(this.m_childModel);
    private ListButtons m_listButtons;
    private ChildObjectEditorPanel<C, P> m_childPanel;
    private C m_currentChild;

    public ChildListEditorPanel() {
        this(null);
    }

    public ChildListEditorPanel(String panelName) {
        super(panelName);
        this.setLayout(new BorderLayout());
        this.add(new JLabel("Error: layoutComponents() has not been called"), "North");
    }

    protected final void layoutComponents(String ... propPath) {
        this.m_listButtons = new ListButtons(this.m_childList, this.createButtonsHelper());
        JLabel listLabel = new JLabel();
        this.getHelper().registerComponent(listLabel, this.m_childList, this.getListLabel(), "ChildList", Property.createPath((String[])propPath));
        JScrollPane scrColumns = new JScrollPane();
        scrColumns.setVerticalScrollBarPolicy(22);
        this.m_childList.setSelectionMode(2);
        this.m_childList.setCellRenderer(new DBObjectRenderer());
        scrColumns.getViewport().add((Component)this.m_childList, null);
        JPanel pnlList = new JPanel(new GridBagLayout());
        pnlList.setName("ChildListPanel");
        pnlList.add((Component)listLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)scrColumns, this.gbc(0, 1, 1, 2, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_listButtons, this.gbc(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_childPanel = this.createChildPanel();
        if (this.isHorizontalSplit()) {
            pnlList.add(Box.createHorizontalStrut(140), this.gbc(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            pnlList.add((Component)((Object)this.m_childPanel), this.gbc(2, 0, 1, 3, 2.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        } else {
            pnlList.add(Box.createVerticalStrut(100), this.gbc(2, 1, 1, 2, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            pnlList.add((Component)((Object)this.m_childPanel), this.gbc(0, 3, 2, 1, 1.0, 2.0, 13, 1, new Insets(10, 0, 0, 0), 0, 0));
        }
        this.setLayout(new BorderLayout(0, 0));
        this.add(pnlList, "Center");
        this.m_childModel.addListDataListener(new ListDataListener(){

            @Override
            public void contentsChanged(ListDataEvent e) {
                ChildListEditorPanel.this.listContentsChangedImpl();
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
                ChildListEditorPanel.this.listContentsChangedImpl();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ChildListEditorPanel.this.listContentsChangedImpl();
            }
        });
        this.m_childList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (ChildListEditorPanel.this.isEntered()) {
                    ChildListEditorPanel.this.listSelectionChanged();
                }
            }
        });
        this.m_childPanel.getNameField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ChildListEditorPanel.this.currentChildNameChangedImpl();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ChildListEditorPanel.this.currentChildNameChangedImpl();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ChildListEditorPanel.this.currentChildNameChangedImpl();
            }
        });
    }

    private void currentChildNameChangedImpl() {
        if (this.isEntered()) {
            this.currentChildNameChanged();
        }
    }

    private void listContentsChangedImpl() {
        if (this.isEntered()) {
            this.listContentsChanged();
        }
    }

    protected void listContentsChanged() {
        this.m_childList.setFocusable(this.m_childModel.size() > 0);
    }

    protected void listSelectionChanged() {
        ChildDBObject newChild = null;
        Object[] sel = this.m_childList.getSelectedValues();
        if (sel.length == 1) {
            newChild = (ChildDBObject)this.m_childList.getSelectedValue();
        }
        if (this.m_currentChild == newChild || this.exitChildPanel()) {
            this.enterChildPanel(newChild);
        } else {
            this.m_childList.setSelectedIndex(this.m_childModel.indexOfChild(this.m_currentChild));
        }
    }

    protected void currentChildNameChanged() {
        if (this.m_currentChild != null) {
            String newName = this.m_childPanel.getNameField().getText();
            this.m_currentChild.setName(newName);
            this.m_childList.repaint();
        }
    }

    protected void enterChildPanel(C child) {
        this.m_currentChild = child;
        this.m_childPanel.onEntry(this.getChildDataContext());
    }

    protected Namespace getChildDataContext() {
        Namespace data = new Namespace(this.getDataContext());
        data.put("NewChildObject", this.m_currentChild);
        return data;
    }

    protected boolean exitChildPanel() {
        boolean retval = false;
        if (this.m_currentChild == null) {
            retval = true;
        } else {
            try {
                this.m_childPanel.onExit(this.getChildDataContext());
                retval = true;
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)((Object)this));
            }
        }
        return retval;
    }

    protected abstract Class<C> getChildClass();

    protected String getChildType() {
        return Metadata.getType(this.getChildClass());
    }

    protected abstract String getListLabel();

    protected boolean isHorizontalSplit() {
        return true;
    }

    protected DefaultButtonsHelper createButtonsHelper() {
        return new DefaultButtonsHelper();
    }

    protected abstract ChildObjectEditorPanel<C, P> createChildPanel();

    protected abstract String getChildProperty();

    protected boolean preserveListOrder() {
        return true;
    }

    @Override
    protected void initialisePanel() {
        block8: {
            Object parObj = this.getDBObject();
            String propPath = this.getChildProperty();
            try {
                this.m_childModel.clear();
                this.m_currentChild = null;
                Object obj = this.getPropertyHelper().getPropertyValueOrFail(parObj, propPath);
                if (obj == null) break block8;
                if (obj instanceof DBObject[]) {
                    DBObject[] childList = (DBObject[])obj;
                    if (!this.preserveListOrder()) {
                        Arrays.sort(childList, DBUtil.getNameComparator());
                    }
                    for (DBObject kid : childList) {
                        this.m_childModel.addChild((ChildDBObject)kid);
                    }
                    break block8;
                }
                throw new IllegalStateException("property must be a list of child objects");
            }
            catch (MissingPropertyException mpe) {
                throw new IllegalStateException("no such property: " + propPath);
            }
        }
        ChildDBObject firstChild = null;
        Object obj = this.getDataContext().find("DefaultChild");
        if (obj != null && this.getChildClass().isAssignableFrom(obj.getClass())) {
            firstChild = (ChildDBObject)obj;
        } else if (this.m_childModel.size() > 0) {
            firstChild = (ChildDBObject)this.m_childModel.getChild(0);
        }
        this.selectChild(firstChild);
    }

    @Override
    protected void commitPanel() throws TraversalException {
        if (!this.exitChildPanel()) {
            throw new TraversalException(null);
        }
        String propPath = this.getChildProperty();
        try {
            this.getPropertyHelper().setPropertyValueOrFail(this.getDBObject(), propPath, (Object)this.m_childModel.getChildren());
        }
        catch (MissingPropertyException mpe) {
            throw new TraversalException(mpe.getMessage());
        }
        try {
            this.getProvider().validateObjectProperty(this.getOriginalObject(), this.getDBObject(), propPath);
        }
        catch (ValidationException ve) {
            throw new TraversalException(ve.getMessage());
        }
    }

    protected C newChild() {
        ChildDBObject newChild = (ChildDBObject)this.getProvider().getObjectFactory().newObject(this.getChildClass(), this.getDBObject());
        newChild.setName(this.getUniqueName(this.getChildType() + "1", this.m_childModel));
        return (C)newChild;
    }

    protected final void selectChild(C child) {
        if (this.m_currentChild != child && (this.m_currentChild == null || this.exitChildPanel())) {
            this.m_childList.setSelectedIndex(this.m_childModel.indexOfChild(child));
            if (!this.isEntered()) {
                this.listSelectionChanged();
            }
        }
        if (child == null && !this.m_childPanel.isEntered()) {
            this.m_listButtons.enableButtons();
            this.enterChildPanel(null);
        }
    }

    private PropertyManager getPropertyManager() {
        return this.getProvider().getPropertyManager();
    }

    private boolean canChangeChildProperty() {
        PropertyAction action = this.getPropertyManager().canChangeProperty(this.getOriginalObject(), this.getDBObject(), this.getChildProperty());
        return action != null;
    }

    protected class DefaultButtonsHelper
    extends ListButtons.Controller {
        protected DefaultButtonsHelper() {
        }

        @Override
        public void addToList() {
            if (ChildListEditorPanel.this.exitChildPanel()) {
                Object child = ChildListEditorPanel.this.newChild();
                ChildListEditorPanel.this.m_childModel.addChild(child);
                ChildListEditorPanel.this.selectChild(child);
            }
        }

        @Override
        public void removeFromList() {
            if (ChildListEditorPanel.this.m_currentChild != null) {
                ChildDBObject removed = ChildListEditorPanel.this.m_currentChild;
                ChildListEditorPanel.this.m_currentChild = null;
                int index = ChildListEditorPanel.this.m_childModel.indexOfChild(removed);
                ChildListEditorPanel.this.m_childModel.removeChild(removed);
                int max = ChildListEditorPanel.this.m_childModel.size() - 1;
                if (index > max) {
                    index = max;
                }
                ChildListEditorPanel.this.selectChild(index >= 0 ? (ChildDBObject)ChildListEditorPanel.this.m_childModel.getChild(index) : null);
            }
        }

        @Override
        public boolean canAdd() {
            return ChildListEditorPanel.this.canChangeChildProperty();
        }

        public boolean canAdd(Object val) {
            return ChildListEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canMoveDown(Object val) {
            return false;
        }

        @Override
        public boolean canMoveUp(Object val) {
            return false;
        }

        @Override
        public boolean canRemove() {
            return ChildListEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canRemove(Object val) {
            return ChildListEditorPanel.this.canChangeChildProperty();
        }

        @Override
        public boolean canReorder() {
            return false;
        }

        @Override
        public void objectMovedDown(Object obj) {
        }

        @Override
        public void objectMovedUp(Object obj) {
        }
    }

    private class ChildObjectListModel<T extends DBObject>
    extends DefaultListModel {
        private ChildObjectListModel() {
        }

        public T[] getChildren() {
            DBObject[] children = (DBObject[])Array.newInstance(ChildListEditorPanel.this.getChildClass(), this.size());
            for (int i = 0; i < this.size(); ++i) {
                children[i] = this.getChild(i);
            }
            return children;
        }

        public int indexOfChild(T child) {
            int retval = -1;
            for (int i = 0; i < this.size(); ++i) {
                DBObject obj = (DBObject)this.get(i);
                if (obj != child) continue;
                retval = i;
                break;
            }
            return retval;
        }

        public T getChild(int i) {
            return (T)((DBObject)this.get(i));
        }

        public void addChild(T child) {
            this.addElement(child);
        }

        public void removeChild(T child) {
            int i = this.indexOfChild(child);
            if (i >= 0) {
                this.remove(i);
            }
        }
    }
}

