/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.panels;

import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.ListModel;
import oracle.bali.ewt.validate.ValidationComponent;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.DBTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.validate.DBValidationHandler;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.util.ModelUtil;

public abstract class BaseEditorPanel<T extends DBObject>
extends DBTraversablePanel {
    private Namespace m_context;
    private DBUIHelper m_helper;
    private boolean m_doValidationSetup = true;
    private boolean m_entered;

    protected BaseEditorPanel() {
        this(null);
    }

    protected BaseEditorPanel(String panelName) {
        if (panelName == null) {
            panelName = ((Object)((Object)this)).getClass().getSimpleName();
        }
        this.m_helper = new DBUIHelper(panelName, (Component)((Object)this));
    }

    protected final Namespace getDataContext() {
        return this.m_context;
    }

    protected final DBObjectProvider getProvider() {
        return (DBObjectProvider)this.m_context.find("DBObjectProvider");
    }

    protected final DBUIHelper getHelper() {
        return this.m_helper;
    }

    protected final PropertyHelper getPropertyHelper() {
        Namespace tc = this.getDataContext();
        PropertyHelper ph = (PropertyHelper)tc.get(PropertyHelper.class);
        if (ph == null) {
            ph = new PropertyHelper();
            tc.put(PropertyHelper.class.getName(), (Object)ph);
        }
        return ph;
    }

    protected final boolean isEditing() {
        return this.getOriginalObject() != null;
    }

    protected final boolean isEntered() {
        return this.m_entered;
    }

    protected final T getOriginalObject() {
        return this.findOriginalObject(this.m_context);
    }

    protected final T getDBObject() {
        return this.findDBObject(this.m_context);
    }

    @Deprecated
    protected final Schema[] getSchemaList() {
        return (Schema[])this.m_context.find("SchemaList");
    }

    public void onEntry(TraversableContext dataContext) {
        this.onEntry((Namespace)dataContext);
    }

    DBObject getHelperObject() {
        return this.getDBObject();
    }

    DBObject getHelperOriginalObject() {
        return this.getOriginalObject();
    }

    final void onEntry(Namespace context) {
        this.m_entered = false;
        this.m_helper.setSuspendValidation(true);
        this.m_context = context;
        this.m_helper.setProvider(this.getProvider());
        this.m_helper.setEditable(this.isEditable());
        this.m_helper.processComponents((DBObject)this.getOriginalObject(), (DBObject)this.getDBObject());
        this.initialisePanel();
        this.setupValidationPane();
        this.m_helper.setSuspendValidation(false);
        this.m_entered = true;
    }

    protected boolean isEditable() {
        return Boolean.TRUE == this.getDataContext().find("DBObjectIsEditable");
    }

    protected final void processComponent(Component comp) {
        this.m_helper.processComponent(comp, (DBObject)this.getOriginalObject(), (DBObject)this.getDBObject());
    }

    protected abstract void initialisePanel();

    protected final void setupValidationPane() {
        if (this.m_doValidationSetup && this.m_helper.hasComponents()) {
            ValidationMessagePane pane = (ValidationMessagePane)this.getDataContext().find("VMP");
            if (pane == null) {
                DBLog.getLogger((Object)((Object)this)).warning("Live validation unavailable - no message pane.");
            } else {
                this.m_doValidationSetup = true;
                DBValidationHandler handler = this.m_helper.getValidationHandler();
                for (ValidationComponent vc : handler.getValidationComponents()) {
                    pane.addValidationComponent(vc);
                }
                handler.init(this.getProvider(), this.getHelperOriginalObject(), this.getHelperObject());
            }
        }
    }

    public final void onExit(TraversableContext dataContext) throws TraversalException {
        this.onExit((Namespace)dataContext);
    }

    final void onExit(Namespace dataContext) throws TraversalException {
        this.m_entered = false;
        this.commitPanel();
        this.validateObject();
        this.m_helper.canCommit((DBObject)this.getOriginalObject(), (DBObject)this.getDBObject(), this.getDataContext());
    }

    protected abstract void commitPanel() throws TraversalException;

    protected void validateObject() throws TraversalException {
        Collection<String> paths = this.getValidationPaths();
        if (paths != null) {
            for (String prop : paths) {
                try {
                    this.getProvider().validateObjectProperty(this.getOriginalObject(), this.getDBObject(), prop);
                }
                catch (ValidationException ve) {
                    this.processValidationException(ve);
                }
            }
        } else {
            try {
                this.getProvider().validateObject(this.getOriginalObject(), this.getDBObject());
            }
            catch (ValidationException ve) {
                this.processValidationException(ve);
            }
        }
    }

    protected void processValidationException(ValidationException ve) throws TraversalException {
        String title = ve.getTitle();
        throw new TraversalException(ve.getMessage(), title == null ? this.getErrorTitle() : title);
    }

    protected final T findOriginalObject(Namespace context) {
        return (T)((DBObject)context.find("OriginalObject"));
    }

    protected final T findDBObject(Namespace context) {
        return (T)((DBObject)context.find("NewObject"));
    }

    protected final String getInternalName(String name) throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        T obj = this.getDBObject();
        String type = obj.getType();
        try {
            pro.validateName(type, name);
        }
        catch (InvalidNameException ine) {
            String reason = ine.getMessage();
            throw new TraversalException(this.getInvalidNameMessage(name, type) + " " + reason, this.getErrorTitle());
        }
        return pro.getInternalName(name);
    }

    protected String getErrorTitle() {
        T obj = this.getDBObject();
        String type = DBTypeDisplayRegistry.getSingularDisplayName(obj.getType());
        return UIArb.format(112, type, obj.getName());
    }

    protected String getInvalidNameMessage(String name, String objtype) {
        String type = DBTypeDisplayRegistry.getSingularDisplayName(objtype);
        if (ModelUtil.hasLength((String)name)) {
            return UIArb.format(110, name, type);
        }
        return UIArb.format(111, type);
    }

    protected final String getExternalName(String name) {
        return this.getProvider().getExternalName(name);
    }

    protected final String getUniqueName(String base, ListModel model) {
        int size = model.getSize();
        HashSet<String> modelNames = new HashSet<String>();
        for (int i = 0; i < size; ++i) {
            Object element = model.getElementAt(i);
            modelNames.add(element.toString());
        }
        return DBUtil.getUniqueName(modelNames, (String)base);
    }

    protected Collection<String> getValidationPaths() {
        return this.getHelper().getPaths();
    }
}

