/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.Arrays;
import java.util.HashSet;
import oracle.ide.db.verifiers.table.AbstractIndexInfoVerifier;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnConstraint;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Index;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;

public class EditIndexInfoVerifier
extends AbstractIndexInfoVerifier {
    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
    }

    @Override
    public boolean canRenameIndex(Index index) {
        return true;
    }

    @Override
    public boolean canRemoveIndex(Index index) {
        boolean constraint = false;
        HashSet<Column> constraintCols = new HashSet<Column>();
        Table table = index.getTable();
        Constraint[] cons = table.getConstraints();
        for (int i = 0; i < cons.length; ++i) {
            if (!"PKConstraint".equals(cons[i].getConstraintType()) && !"UniqueConstraint".equals(cons[i].getConstraintType())) continue;
            constraintCols.addAll(Arrays.asList(((ColumnConstraint)cons[i]).getColumns()));
        }
        IndexObject[] columnExpressions = index.getColumnExpressions();
        for (int i = 0; !constraint && i < columnExpressions.length; ++i) {
            try {
                for (String[] nameComponents : ParserUtils.getColumnNames((String)columnExpressions[i].getExpression().getSQLText(), (ParserUtils.ExpressionType)ParserUtils.ExpressionType.ARITHMETIC)) {
                    String colName = this.getProvider().getInternalName(nameComponents[0]);
                    if (!constraintCols.contains(table.getColumn(colName))) continue;
                    constraint = true;
                }
                continue;
            }
            catch (SQLQueryException e) {
                DBLog.getLogger().warning(e.getMessage());
            }
        }
        return this.isEditable() && (this.isNewIndex(index) || !constraint);
    }

    @Override
    public boolean canReorderIndexes() {
        return this.isEditable();
    }

    @Override
    public boolean canMoveIndexUp(Index index) {
        return this.isNewIndex(index);
    }

    @Override
    public boolean canMoveIndexDown(Index index) {
        return this.isNewIndex(index);
    }

    @Override
    public boolean canAddIndexes() {
        return this.isEditable();
    }

    @Override
    public boolean canAddIndex(Index index) {
        return this.isEditable();
    }
}

