/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers.table;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.verifiers.table.AbstractColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.mysql.MySQL5;
import oracle.javatools.db.ora.Oracle9iR2;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

public class EditColumnInfoVerifier
extends AbstractColumnInfoVerifier {
    private List _colSet = new ArrayList();

    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject changed) {
        super.initializeVerifier(prov, orig, changed);
        Table table = (Table)changed;
        Column[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this._colSet.add(cols[i]);
        }
    }

    @Override
    public boolean canMoveColumnUp(Column col) {
        return this.isNewColumn(col);
    }

    @Override
    public boolean canMoveColumnDown(Column col) {
        return this.isNewColumn(col);
    }

    @Override
    public boolean canChangeColumnComment(Column col) {
        return true;
    }

    @Override
    public boolean canChangeColumnDefaultValue(Column col) {
        return true;
    }

    @Override
    public boolean canChangeColumnType(Column col) {
        PropertyManager pm;
        if (this.isNewColumn(col)) {
            return true;
        }
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof Database && !(pro instanceof OracleDatabase) && !(pro instanceof MySQL5) && (pm = pro.getPropertyManager()) != null) {
            return pm.canAlterProperty(col.getParent(), col.getParent(), Property.createPath((String[])new String[]{"columns", "dataTypeUsage"}));
        }
        return true;
    }

    @Override
    public boolean canChangeColumnSize(Column col) {
        if (!this.isNewColumn(col)) {
            try {
                DataTypeUsage dataTypeUsage = col.getDataTypeUsage();
                DataType dataType = DataTypeHelper.getDataType((DataTypeUsage)dataTypeUsage);
                DataTypeAttribute size = dataType.getDataTypeAttribute("size");
                if (size != null && size.isDeclarable() && !size.isMandatory()) {
                    return dataTypeUsage.getAttributeValue("size") != null;
                }
                return false;
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public boolean canRenameColumn(Column col) {
        PropertyManager pm;
        if (this.isNewColumn(col)) {
            return true;
        }
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof OracleDatabase) {
            return pro instanceof Oracle9iR2;
        }
        if (pro instanceof Database && (pm = pro.getPropertyManager()) != null) {
            return pm.canAlterProperty(col.getParent(), col.getParent(), Property.createPath((String[])new String[]{"columns", "name"}));
        }
        return super.canRenameColumn(col);
    }

    private boolean isNewColumn(Column col) {
        return !this._colSet.contains(col);
    }

    @Override
    public void verifyColumn(Column oldCol, Column newCol) throws TraversalException {
        super.verifyColumn(oldCol, newCol);
        if (ModelUtil.areDifferent((Object)oldCol, (Object)newCol) && !this.isNewColumn(oldCol)) {
            DataTypeUsage dataTypeUsage = newCol.getDataTypeUsage();
            DataTypeUsage oldDataTypeUsage = oldCol.getDataTypeUsage();
            DBObjectID typeID = dataTypeUsage.getDataTypeID();
            DBObjectID oldTypeID = oldDataTypeUsage.getDataTypeID();
            DataType type = null;
            try {
                type = typeID == null ? null : (DataType)typeID.resolveID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (type == null) {
                throw new TraversalException(DBArb.format((int)223, (Object)newCol.getName()), DBArb.getString((int)224));
            }
        }
    }
}

