/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.ora.verifiers;

import javax.swing.JComboBox;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.AbstractSchemaObjectVerifier;
import oracle.ide.db.verifiers.MViewInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.util.ModelUtil;

public class CreateMViewInfoVerifier
extends AbstractSchemaObjectVerifier
implements MViewInfoVerifier {
    private MaterializedView _mview;

    public CreateMViewInfoVerifier() {
    }

    public CreateMViewInfoVerifier(DBObjectProvider prov, MaterializedView mview) {
        this.initializeVerifier(prov, null, (SchemaObject)mview);
    }

    @Override
    public boolean canRefreshMethod() {
        return true;
    }

    @Override
    public boolean canRefreshWhen() {
        return true;
    }

    @Override
    public boolean canRefreshType() {
        return true;
    }

    @Override
    public boolean canRefreshStartOn() {
        return true;
    }

    @Override
    public boolean canRefreshNext() {
        return true;
    }

    @Override
    public boolean canRefreshUseRollback() {
        return true;
    }

    @Override
    public boolean canRefreshConstraints() {
        return true;
    }

    @Override
    public boolean canMVOParallel() {
        return true;
    }

    @Override
    public boolean canMVOEnableCache() {
        return true;
    }

    @Override
    public boolean canMVOQueryRewrite() {
        return true;
    }

    @Override
    public boolean canMVOPrebuilt() {
        return true;
    }

    @Override
    public boolean canUseIndex() {
        return true;
    }

    @Override
    public boolean canEditQuery() {
        return true;
    }

    @Override
    public boolean canEnableQueryReWrite() {
        return this.isEditable();
    }

    @Override
    public boolean canChangeName() {
        return this.isEditable();
    }

    @Override
    public boolean canChangeSchema() {
        return this.isEditable();
    }

    @Override
    public boolean canChangeComment() {
        return this.isEditable();
    }

    @Override
    public void verifyRelation() throws TraversalException {
        DBObjectProvider prov = this.getProvider();
        try {
            if (this.getOriginalObject() == null) {
                prov.validateObject((DBObject)this.getModifiedObject());
            } else {
                prov.validateObject((DBObject)this.getOriginalObject(), (DBObject)this.getModifiedObject());
            }
        }
        catch (ValidationException ve) {
            throw new TraversalException(ve.getMessage());
        }
    }

    @Override
    public void verifyObject() throws TraversalException {
        this.verifyRelation();
    }

    @Override
    public void initializeVerifier(DBObjectProvider prov, SchemaObject orig, SchemaObject change) {
        super.initializeVerifier(prov, orig, change);
        this._mview = (MaterializedView)change;
    }

    @Override
    public boolean canCreateSchema() {
        if (this.getProvider() instanceof Database) {
            return super.canCreateSchema();
        }
        return this.isEditable();
    }

    @Override
    public void verifySchemaName(String name) throws TraversalException {
        if (!this.isValidName(name)) {
            throw new TraversalException(UIArb.format(563, name), UIArb.getString(762), null);
        }
    }

    @Override
    protected String getErrorTitle() {
        return UIArb.getString(762);
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 760 : 763, name);
    }

    public void verifyMView(boolean replace) throws TraversalException {
        try {
            Schema schema = this._mview.getSchema();
            String name = this._mview.getName();
            if (!replace && this.getProvider().getObject("MATERIALIZED VIEW", schema, name) != null) {
                throw new TraversalException(UIArb.format(761, name), UIArb.getString(759), null);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
    }

    @Override
    public void setupRefreshCombo(JComboBox refreshWithComboBox, MaterializedView.RefreshWith refreshWith) {
        if (refreshWith == MaterializedView.RefreshWith.ROWID) {
            refreshWithComboBox.setSelectedItem(UIArb.getString(810));
        } else if (refreshWith == MaterializedView.RefreshWith.PRIMARY_KEY) {
            refreshWithComboBox.setSelectedItem(UIArb.getString(809));
        } else {
            refreshWithComboBox.setSelectedItem("");
        }
    }
}

