/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.dialogs;

import java.awt.Component;
import java.awt.Window;
import java.util.logging.Level;
import oracle.ide.Ide;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.util.IdeUtil;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.javatools.dialogs.MessageDialog;

public class DBMessageDialog {
    public static boolean useDialog() {
        return DBCore.getInstance().getMode() == DBCore.Mode.FULL;
    }

    public static void error(String message, Object loggerContext, Level logLevel, String title, String helpID) {
        if (DBMessageDialog.useDialog()) {
            MessageDialog.error((Component)DBMessageDialog.getDialogParent(), (Object)message, (String)title, (String)helpID);
        } else if (logLevel != null) {
            DBLog.getLogger((Object)loggerContext).log(logLevel, message);
        }
    }

    public static void error(Exception e, Object loggerContext, Level logLevel, String title, String helpID) {
        if (DBMessageDialog.useDialog()) {
            if (e instanceof DBException) {
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), title, (DBException)((Object)e), helpID);
            } else {
                DBMessageDialog.error(e.getMessage(), loggerContext, logLevel, title, helpID);
            }
        } else if (logLevel != null) {
            DBLog.getLogger((Object)loggerContext).log(logLevel, title, e);
        }
    }

    public static void showExceptionDialog(String message, Exception e, Object loggerContext, Level logLevel, String title, String helpID) {
        if (DBMessageDialog.useDialog()) {
            if (e instanceof DBException) {
                DBExceptionDialog.showErrorDialog(DBMessageDialog.getDialogParent(), title, (DBException)((Object)e), helpID);
            } else {
                ExceptionDialog.showExceptionDialog((Component)DBMessageDialog.getDialogParent(), (Throwable)e, (String)title, (String)message, (String)helpID);
            }
        } else {
            DBLog.getLogger((Object)loggerContext).log(logLevel, message, e);
        }
    }

    public static Component getDialogParent() {
        Window c = IdeUtil.findActiveModalWindow();
        if (c == null) {
            c = Ide.getMainWindow();
        }
        return c;
    }
}

