/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.controls.AbstractComboBasedChooser;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Metadata;

public class SystemObjectChooserDelegate
extends AbstractComboBasedChooser {
    private DBObjectCriteria<SystemObject> m_criteria;

    @Override
    protected boolean accept(DBObjectChooser chooser, DBObjectProvider prov) {
        boolean childObjects = false;
        boolean schemaObjects = false;
        boolean nonSchemaSystemObjects = false;
        for (String type : chooser.getTypes()) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                schemaObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            nonSchemaSystemObjects = true;
        }
        return !childObjects && !schemaObjects && nonSchemaSystemObjects;
    }

    public SystemObjectChooserDelegate() {
        this(false);
    }

    public SystemObjectChooserDelegate(boolean editable) {
        super(editable);
    }

    @Override
    List<DBObjectID> getEntries(boolean loadsubset) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        DBObjectFilter filter = this.getChooser().getFilter();
        try {
            for (SystemObject sysOb : this.getProvider().listObjects(this.m_criteria)) {
                if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                DBObjectID id = sysOb.getID();
                if (id == null || sysOb instanceof Schema) {
                    id = TemporaryObjectID.createID((DBObject)sysOb);
                }
                retval.add(id);
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        return retval;
    }

    @Override
    protected DBObject getOrCreateDBObject() {
        if (this.isEditable() && this.getChooser().getDBObjectID() instanceof ReferenceID) {
            if (this.getChooser().getDBObjectID().getType().equals("SCHEMA")) {
                String name = null;
                name = ((ReferenceID)this.getChooser().getDBObjectID()).getName();
                return new Schema(name);
            }
            return this.getChooser().getDBObject();
        }
        return this.getChooser().getDBObject();
    }

    @Override
    protected DBObjectCriteria getDBObjectCriteria() {
        return this.m_criteria;
    }

    @Override
    protected void setProvider(DBObjectProvider prov) {
        super.setProvider(prov);
        this.m_criteria = DBObjectCriteria.createCriteria();
        this.m_criteria.setTypes(this.getTypes());
        if ("SCHEMA".equals(this.getTypes()[0]) && prov instanceof Database) {
            this.m_criteria.setUserOnly(true);
        }
    }
}

