/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.logging.Level;
import oracle.ide.Context;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;

public abstract class DatabasePicker {
    private static Class<? extends DatabasePicker> s_pickerClz;
    private Context m_context;

    public void setContext(Context context) {
        this.m_context = context;
    }

    public Context getContext() {
        return this.m_context;
    }

    public abstract Database getDatabase();

    public abstract void setDatabase(Database var1);

    public abstract Component getComponent();

    public abstract void addListener(ItemListener var1);

    public static DatabasePicker createPicker() {
        DatabasePicker picker = null;
        if (s_pickerClz != null) {
            try {
                picker = s_pickerClz.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger(DatabasePicker.class).log(Level.WARNING, "Cannot instantiate picker of class " + s_pickerClz.getSimpleName(), e);
            }
        }
        return picker;
    }

    public static void registerPickerClass(Class<? extends DatabasePicker> clz) {
        if (s_pickerClz == null) {
            s_pickerClz = clz;
        } else {
            new IllegalStateException("Cannot change picker class").printStackTrace();
        }
    }
}

