/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ideimpl.db.controls.AbstractComboBasedChooser;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;

public class ChildObjectChooserDelegate
extends AbstractComboBasedChooser {
    @Override
    protected boolean accept(DBObjectChooser chooser, DBObjectProvider prov) {
        boolean childObjects = false;
        boolean schemaObjects = false;
        boolean nonSchemaSystemObjects = false;
        for (String type : chooser.getTypes()) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                schemaObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            nonSchemaSystemObjects = true;
        }
        return childObjects && !schemaObjects && !nonSchemaSystemObjects;
    }

    public ChildObjectChooserDelegate() {
        this(false);
    }

    public ChildObjectChooserDelegate(boolean editable) {
        super(editable);
    }

    @Override
    List<DBObjectID> getEntries(boolean loadsubset) {
        ArrayList<DBObjectID> retval = new ArrayList<DBObjectID>();
        DBObjectFilter filter = this.getChooser().getFilter();
        try {
            if (this.getContextDBObjectID() != null) {
                DBObject contextObject = null;
                contextObject = this.getContextDBObjectID().resolveID();
                if (contextObject != null) {
                    for (DBObject kid : contextObject.getOwnedObjects(this.getTypes())) {
                        if (filter != null && !filter.accept(kid)) continue;
                        retval.add(kid.getID());
                    }
                }
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        return retval;
    }
}

