/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db.controls;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooserDelegate;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractComboBasedChooser
extends DBObjectChooserDelegate
implements ListCellRenderer {
    private MyCombo m_cmb;
    private boolean m_gotModel = false;
    private boolean m_editable = false;
    private Map<DBObjectID, List<DBObjectID>> m_contextToIDListMap = new HashMap<DBObjectID, List<DBObjectID>>();
    private Map<String, DBObjectID> m_textToIDMap;
    private boolean m_inMenuWillBecomeVisible = false;
    private static final String s_getFullList = UIArb.getString(1002);
    private boolean m_subsetLoaded = false;
    private DefaultListCellRenderer m_renDelegate = new DefaultListCellRenderer();
    private ActionListener m_listener = null;
    private Set<DBObjectID> m_extraIDs = new HashSet<DBObjectID>();

    protected AbstractComboBasedChooser() {
        this(false);
    }

    protected AbstractComboBasedChooser(boolean editable) {
        this.m_editable = editable;
    }

    @Override
    protected final void initialiseUI() {
        if ("TABLESPACE".equals(this.getTypes()[0]) && !(this.getProvider() instanceof Database)) {
            this.m_editable = true;
        }
        this.m_cmb = new MyCombo();
        this.m_cmb.setEditable(this.m_editable);
        this.add(this.m_cmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cmb.setRenderer(this);
        this.m_cmb.addPopupMenuListener(new PopupMenuListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                if (!AbstractComboBasedChooser.this.m_gotModel && !AbstractComboBasedChooser.this.m_inMenuWillBecomeVisible) {
                    AbstractComboBasedChooser.this.updateComboModel(false);
                    JComboBox list = (JComboBox)e.getSource();
                    AbstractComboBasedChooser.this.m_inMenuWillBecomeVisible = true;
                    try {
                        list.getUI().setPopupVisible(list, true);
                    }
                    finally {
                        AbstractComboBasedChooser.this.m_inMenuWillBecomeVisible = false;
                    }
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    @Override
    protected void addIDToList(DBObjectID id) {
        this.m_extraIDs.add(id);
    }

    abstract List<DBObjectID> getEntries(boolean var1);

    private void updateComboModel(boolean forceFull) {
        String nullText;
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        this.m_textToIDMap = new HashMap<String, DBObjectID>();
        String curVal = this.getStringFromID(this.getChooser().getDBObjectID());
        int setIdx = -1;
        int idx = 0;
        boolean loadsubset = !forceFull && this.subsetAvailable();
        List<DBObjectID> list = this.m_contextToIDListMap.get(this.getContextDBObjectID());
        if (list == null) {
            list = this.getEntries(loadsubset);
            list.addAll(this.m_extraIDs);
            if (!loadsubset) {
                this.m_contextToIDListMap.put(this.getContextDBObjectID(), list);
            }
        }
        if ((nullText = this.getNullText()) != null) {
            model.addElement(nullText);
            this.m_textToIDMap.put(nullText, null);
            if (!ModelUtil.hasLength((String)curVal)) {
                setIdx = idx;
            }
            ++idx;
        }
        if (list != null) {
            for (DBObjectID id : list) {
                String str = this.getStringFromID(id);
                if (!ModelUtil.hasLength((String)str)) continue;
                model.addElement(str);
                this.m_textToIDMap.put(str, id);
                if (str.equals(curVal)) {
                    setIdx = idx;
                }
                ++idx;
            }
        }
        if (setIdx == -1 && this.getChooser().getDBObjectID() != null) {
            for (int i = 0; i < model.getSize(); ++i) {
                if (curVal.compareTo((String)model.getElementAt(i)) >= 0) continue;
                model.insertElementAt(curVal, i);
                setIdx = i;
                break;
            }
            if (setIdx == -1) {
                model.addElement(curVal);
                setIdx = idx;
            }
            this.m_textToIDMap.put(curVal, this.getChooser().getDBObjectID());
            ++idx;
        }
        if (loadsubset) {
            this.m_subsetLoaded = true;
            model.addElement(s_getFullList);
            ++idx;
        }
        this.m_cmb.setModel((ComboBoxModel)model);
        this.m_cmb.setSelectedIndex(setIdx);
        this.m_gotModel = true;
        Logger logger = Logger.getLogger("oracle.abbot.test");
        if (logger != null) {
            logger.log(Level.INFO, "AbstractComboBasedChooser.updateComboModel.DONE");
        }
    }

    protected boolean subsetAvailable() {
        return false;
    }

    @Override
    protected void buildMaintainID() {
        if (this.m_listener == null) {
            this.m_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    boolean done = false;
                    if (AbstractComboBasedChooser.this.m_editable) {
                        Object o = AbstractComboBasedChooser.this.m_cmb.getEditor().getItem();
                        if (AbstractComboBasedChooser.this.m_subsetLoaded && s_getFullList.equals(o)) {
                            AbstractComboBasedChooser.this.updateComboModel(true);
                        } else if (o instanceof String) {
                            DBObjectID id = AbstractComboBasedChooser.this.getIDFromString((String)o);
                            if (!AbstractComboBasedChooser.this.m_gotModel) {
                                AbstractComboBasedChooser.this.updateComboModel(false);
                            }
                            if (id instanceof ReferenceID && AbstractComboBasedChooser.this.m_textToIDMap.get(((ReferenceID)id).getName()) != null) {
                                id = (DBObjectID)AbstractComboBasedChooser.this.m_textToIDMap.get(((ReferenceID)id).getName());
                            }
                            AbstractComboBasedChooser.this.getChooser().setDBObjectID(id);
                            done = true;
                        }
                    } else {
                        Object o = AbstractComboBasedChooser.this.m_cmb.getSelectedItem();
                        if (AbstractComboBasedChooser.this.m_subsetLoaded && s_getFullList.equals(o)) {
                            AbstractComboBasedChooser.this.updateComboModel(true);
                        } else if (o instanceof String) {
                            DBObjectID id = (DBObjectID)AbstractComboBasedChooser.this.m_textToIDMap.get(o);
                            AbstractComboBasedChooser.this.updateID(id);
                            done = true;
                        }
                    }
                    if (!done) {
                        AbstractComboBasedChooser.this.updateID(null);
                    }
                }
            };
        }
        this.m_cmb.addActionListener(this.m_listener);
    }

    @Override
    protected void showID() {
        DBObjectID id = this.getChooser().getDBObjectID();
        String text = this.getNullText();
        if (id != null) {
            String fromID = this.getStringFromID(id);
            if (ModelUtil.hasLength((String)fromID)) {
                text = fromID;
            }
        } else if (this.m_editable) {
            this.m_cmb.getEditor().setItem(text);
            return;
        }
        if (this.m_textToIDMap != null && this.m_textToIDMap.containsKey(text)) {
            this.m_cmb.setSelectedItem(text);
            return;
        }
        this.m_gotModel = false;
        int idx = -1;
        this.m_textToIDMap = new HashMap<String, DBObjectID>();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        if (id == null && this.getNullText() != null) {
            model.addElement(this.getNullText());
            this.m_textToIDMap.put(text, id);
            idx = 0;
        } else if (id != null) {
            model.addElement(text);
            this.m_textToIDMap.put(text, id);
            idx = 0;
        }
        this.m_cmb.removeActionListener(this.m_listener);
        this.m_cmb.setModel((ComboBoxModel)model);
        this.m_cmb.setSelectedIndex(idx);
        this.m_cmb.addActionListener(this.m_listener);
    }

    @Override
    protected void contextChanged() {
        this.m_gotModel = false;
        this.m_extraIDs.clear();
        DBObjectID id = null;
        if (this.m_editable) {
            String val = (String)this.m_cmb.getEditor().getItem();
            id = this.getIDFromString(val);
        } else {
            this.m_cmb.setModel((ComboBoxModel)new DefaultComboBoxModel());
        }
        this.getChooser().setDBObjectID(id);
    }

    @Override
    protected void setName(String name) {
        this.m_cmb.setName(name);
        this.setEditorName();
    }

    @Override
    protected String getName() {
        return this.m_cmb.getName();
    }

    @Override
    protected void setEnabled(boolean enabled) {
        this.m_cmb.setEnabled(enabled);
        this.setEditorName();
    }

    @Override
    protected boolean isEnabled() {
        return this.m_cmb.isEnabled();
    }

    @Override
    protected void setEditable(boolean editable) {
        this.m_cmb.setEditable(editable);
        this.m_editable = editable;
        this.setEditorName();
    }

    @Override
    protected boolean isEditable() {
        return this.m_editable;
    }

    private void setEditorName() {
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        DBObjectID id;
        JLabel label = (JLabel)this.m_renDelegate.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof String && s_getFullList.equals(value)) {
            label.setBorder(new BevelBorder(1));
        } else if (this.getShowIcon() && value instanceof String && (id = this.m_textToIDMap.get(text = (String)value)) != null) {
            String type = null;
            if (value instanceof BaseObjectID) {
                type = ((BaseObjectID)value).getType();
            } else if (value instanceof TemporaryObjectID) {
                TemporaryObjectID tid = (TemporaryObjectID)value;
                try {
                    DBObject o = tid.resolveID();
                    type = o.getType();
                }
                catch (DBException e) {}
            } else if (value instanceof DataTypeID) {
                type = "DATATYPE";
            }
            if (type != null) {
                label.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
            }
        }
        return label;
    }

    @Override
    protected void setProvider(DBObjectProvider prov) {
        super.setProvider(prov);
        this.m_gotModel = false;
        this.m_contextToIDListMap.clear();
    }

    @Override
    protected DBObject getOrCreateDBObject() {
        return this.getChooser().getDBObject();
    }

    private static class MyCombo
    extends JComboBox {
        private boolean m_settingModel = false;

        private MyCombo() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setModel(ComboBoxModel model) {
            try {
                this.m_settingModel = true;
                super.setModel(model);
            }
            finally {
                this.m_settingModel = false;
            }
        }

        @Override
        public void revalidate() {
            if (!this.m_settingModel) {
                super.revalidate();
            }
        }
    }
}

