/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.config.Preferences;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.SqlNode;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.model.DocumentInfo;
import oracle.ide.model.Recognizer;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFilter;
import oracle.ideimpl.db.jdbc.JdbcDBEditorFactory;
import oracle.ideimpl.db.ora.OracleDBEditorFactory;
import oracle.ideimpl.db.ora.OracleLiteDBEditorFactory;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.jdbc.JdbcDDLDatabase;
import oracle.javatools.db.ora.OracleDatabaseImpl;
import oracle.javatools.db.ora.OracleLite;

public class DatabaseIdeCoreAddin
implements Addin {
    public void initialize() {
        DBCore.getInstance().setMode(DBCore.Mode.HEADLESS);
        Class<SqlNode> sn = SqlNode.class;
        Recognizer.mapExtensionToClass((String)".sql", sn);
        Recognizer.mapExtensionToClass((String)".pls", sn);
        Recognizer.mapExtensionToClass((String)".pks", sn);
        Recognizer.mapExtensionToClass((String)".pkb", sn);
        Recognizer.registerDocumentInfo(sn, (DocumentInfo)new DocumentInfo(UIArb.getString(144)));
        DialogUtil.addURLFilter((URLFilter)SqlNode.SQL_FILTER);
        String s = UIArb.getString(143);
        DialogUtil.addURLFilter((URLFilter)new DefaultURLFilter(s, new String[]{".pls", ".pks", ".pkb"}));
        DBEditorFactoryRegistry.registerDBEditorFactory(OracleDatabaseImpl.class, new OracleDBEditorFactory());
        DBEditorFactoryRegistry.registerDBEditorFactory(JdbcDDLDatabase.class, new JdbcDBEditorFactory());
        DBEditorFactoryRegistry.registerDBEditorFactory(OracleLite.class, new OracleLiteDBEditorFactory());
        Preferences p = Preferences.getPreferences();
        if (p != null && GlobalSettings.getInstance() == null) {
            GlobalSettings.initialiseInstance((PropertyStorage)p);
        }
        String version = Ide.getProductVersion();
        if (OracleDatabaseImpl.getAPIVersionForSQLTrace() == null) {
            OracleDatabaseImpl.setAPIVersionForSQLTrace((String)version);
        }
    }
}

