/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.db;

import java.awt.Component;
import javax.swing.JMenuItem;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controls.ToggleAction;
import oracle.ide.db.DBObjectActions;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.db.model.DBObjectNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ide.db.model.DBObjectPlSqlNode;
import oracle.ide.explorer.ExplorerWindow;
import oracle.ideri.util.Product;

public class DBObjectActionsContextMenuListener
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        DBEditorFactory fac;
        Context ctx = contextMenu.getContext();
        DBObjectNode node = DBObjectNodeUtil.getSelectedElement(ctx, DBObjectNode.class);
        if (node != null && (fac = DBEditorFactoryRegistry.getEditFactory(node)) != null) {
            if (!(node instanceof DBObjectPlSqlNode && ((DBObjectPlSqlNode)node).isBody() || Product.isRaptor())) {
                JMenuItem duplicate = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getDuplicateAction());
                contextMenu.add((Component)duplicate, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            if (this.shouldAddProperties(ctx)) {
                JMenuItem edit = contextMenu.createMenuItem((ToggleAction)DBObjectActions.getPropertiesAction());
                contextMenu.add((Component)edit, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
        }
    }

    private boolean shouldAddProperties(Context context) {
        return context.getView() instanceof ExplorerWindow;
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

