/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.verifiers.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.db.UIArb;
import oracle.ide.db.verifiers.relation.AbstractRelationVerifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.ora.BaseOracleDatabase;
import oracle.javatools.db.ora.Oracle10gR2;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleNestedTableProperties;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractColumnInfoVerifier
extends AbstractRelationVerifier
implements ColumnInfoVerifier {
    private static HashSet noDefValDataTypes = new HashSet<String>(Arrays.asList("BLOB", "BFILE", "CLOB", "NCLOB"));
    private static final String[] ORA_TYPES = new String[]{"VARCHAR2", "NUMBER", "DATE", "CLOB", "BLOB"};
    private static final Object[] JDBC_TYPES = new Object[]{new String[]{JdbcDatabase.ANSI_VARCHAR.getName(), JdbcDatabase.ANSI_CHAR.getName(), JdbcDatabase.ANSI_CHARACTER.getName(), JdbcDatabase.ANSI_CHAR_VARYING.getName(), JdbcDatabase.ANSI_CHARACTER_VARYING.getName()}, new String[]{JdbcDatabase.ANSI_INTEGER.getName(), JdbcDatabase.ANSI_INT.getName()}, new String[]{JdbcDatabase.ANSI_DECIMAL.getName(), JdbcDatabase.ANSI_NUMERIC.getName(), JdbcDatabase.ANSI_DEC.getName()}, new String[]{JdbcDatabase.ANSI_TIMESTAMP.getName(), JdbcDatabase.ANSI_DATE.getName(), JdbcDatabase.ANSI_TIME.getName()}, new String[]{JdbcDatabase.ANSI_CLOB.getName(), JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHAR_LARGE_OBJECT.getName()}, new String[]{JdbcDatabase.ANSI_BLOB.getName(), JdbcDatabase.ANSI_BINARY_LARGE_OBJECT.getName()}};

    protected AbstractColumnInfoVerifier() {
    }

    @Override
    public boolean canAddColumns() {
        return this.isEditable() && this.getModifiedRelation().getColumns().length < 1000;
    }

    @Override
    public boolean canAddColumn(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canRemoveColumns() {
        return this.isEditable();
    }

    @Override
    public boolean canRemoveColumn(Column col) {
        boolean retval = false;
        if (this.isEditable()) {
            retval = true;
            for (Constraint con : ((Relation)col.getParent()).getConstraints()) {
                if (DBUtil.findUsagesIn((DBObject)col, (DBObject)con).size() <= 0) continue;
                retval = false;
                break;
            }
        }
        return retval;
    }

    @Override
    public boolean canReorderColumns() {
        return this.isEditable();
    }

    @Override
    public boolean canMoveColumnUp(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canMoveColumnDown(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canRenameColumn(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canChangeColumnType(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canChangeColumnSize(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canChangeColumnNotNullState(Column col) {
        if (col != null) {
            return this.isEditable() && !this.isPrimaryKeyColumn(col);
        }
        return this.isEditable();
    }

    @Override
    public boolean canChangeColumnDefaultValue(Column col) {
        return this.isEditable();
    }

    @Override
    public boolean canChangeColumnComment(Column col) {
        Table.TableType tableType;
        Relation relation;
        Relation relation2 = relation = col != null ? col.getRelation() : null;
        if (relation instanceof Table && Table.TableType.EXTERNAL.equals((Object)(tableType = (Table.TableType)relation.getProperty("TableType")))) {
            return false;
        }
        return this.isEditable();
    }

    @Override
    public boolean canTakeDefaultValue(DataType datatype) {
        boolean result;
        boolean bl = result = null == datatype;
        if (!(result || datatype instanceof ComplexType || noDefValDataTypes.contains(datatype.getName()))) {
            result = true;
        }
        return result;
    }

    @Override
    public void verifyColumn(Column oldCol, Column newCol) throws TraversalException {
        DBObjectProvider pro = this.getProvider();
        if (pro != null) {
            try {
                pro.validateObject((DBObject)oldCol, (DBObject)newCol);
            }
            catch (ValidationException ve) {
                this.processValidationException(ve);
            }
        }
        String oldNTName = this.getNestedTableName(oldCol);
        String newNTName = this.getNestedTableName(newCol);
        if (newNTName != null && !newNTName.equals(oldNTName)) {
            try {
                Table t = (Table)newCol.getParent();
                Schema s = t == null ? null : t.getSchema();
                pro.validateUniqueName("TABLE", (DBObject)s, newNTName);
            }
            catch (NameInUseException niue) {
                throw new TraversalException(StringUtils.stripMnemonic((String)DBArb.getString((int)184)) + ": " + niue.getMessage());
            }
        }
    }

    private String getNestedTableName(Column c) {
        OracleNestedTableProperties ntp;
        OracleColumnProperties ocp;
        String name = null;
        if (c != null && (ocp = (OracleColumnProperties)c.getProperty("OracleColumnProperties")) != null && (ntp = ocp.getNestedTableProperties()) != null) {
            name = ntp.getTableName();
        }
        return name;
    }

    @Override
    protected String getErrorTitle() {
        return UIArb.getString(616);
    }

    @Override
    protected String getInvalidNameMessage(String name) {
        return UIArb.format(ModelUtil.hasLength((String)name) ? 614 : 615, this.getModifiedRelation().getName(), name);
    }

    @Override
    protected String getChildType() {
        return "COLUMN";
    }

    @Override
    public DataType[] getPreferredTypes() {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof BaseOracleDatabase) {
            return this.getOraclePreferredTypes();
        }
        return pro != null ? this.getJdbcPreferredTypes(pro.getClass()) : null;
    }

    protected final DataType[] getOraclePreferredTypes() {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        for (int i = 0; i < ORA_TYPES.length; ++i) {
            DataType type = dtr.findDataType(ORA_TYPES[i], Oracle10gR2.class);
            if (type == null) continue;
            retval.add(type);
        }
        return retval.toArray(new DataType[retval.size()]);
    }

    protected final DataType[] getJdbcPreferredTypes(Class providerClass) {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        block0: for (int i = 0; i < JDBC_TYPES.length; ++i) {
            DataType type = null;
            for (String typeName : (String[])JDBC_TYPES[i]) {
                type = dtr.findDataType(typeName, providerClass);
                if (type == null) continue;
                retval.add(type);
                break;
            }
            if (type != null) continue;
            for (String typeName : (String[])JDBC_TYPES[i]) {
                type = dtr.getMappedType(typeName, providerClass);
                if (type == null) continue;
                retval.add(type);
                continue block0;
            }
        }
        return retval.toArray(new DataType[retval.size()]);
    }

    @Override
    public DataType getDefaultType() {
        DBObjectProvider pro = this.getProvider();
        if (pro instanceof BaseOracleDatabase) {
            return pro.getOrCreateDataType("VARCHAR2");
        }
        if (pro != null) {
            DataType def = pro.getOrCreateDataType("VARCHAR");
            return def != null ? def : pro.getOrCreateDataType("CHAR");
        }
        return null;
    }

    boolean isPrimaryKeyColumn(Column col) {
        PKConstraint pKey = PKConstraint.getPrimaryKey((Relation)((Table)col.getParent()));
        if (pKey != null && pKey.getColumns() != null && pKey.getColumns().length > 0) {
            for (int i = 0; i < pKey.getColumns().length; ++i) {
                if (!pKey.getColumns()[i].getName().equals(col.getName())) continue;
                return true;
            }
        }
        return false;
    }
}

