/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.ListCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JTextComponentUndoSupport;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.javatools.controls.completionfield.CompletionPopupHandler;
import oracle.javatools.controls.completionfield.CompletionTextComponent;
import oracle.javatools.controls.completionfield.FieldInsightProvider;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.JoinObject;
import oracle.javatools.db.sql.RelationUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.SynonymUsage;

public class ExpressionEditSupport
implements FocusListener,
FieldInsightProvider {
    private JTextComponentUndoSupport m_undo;
    private JTextComponent m_registeredExp;
    private CompletionPopupHandler m_handler;
    private Map m_relations;
    private Set m_objs;
    private String m_lastInserted;
    private int m_expFocus = -1;
    private int m_sEnd = -1;
    private static DBObjectRenderer s_rend;

    public ExpressionEditSupport(JTextComponent comp) {
        this.m_registeredExp = comp;
        this.m_registeredExp.addFocusListener(this);
        this.m_undo = new JTextComponentUndoSupport(this.m_registeredExp);
        if (comp instanceof CompletionTextComponent) {
            this.m_handler = ((CompletionTextComponent)comp).getPopupHandler();
            this.m_handler.registerInsightProvider((FieldInsightProvider)this);
            this.m_handler.setAlignWithField(false);
        }
    }

    public void addToExpressionField(String text) {
        this.m_undo.startCombiningEdits();
        this.m_registeredExp.requestFocusInWindow();
        int insert = this.m_registeredExp.getCaretPosition();
        int sStart = this.m_registeredExp.getSelectionStart();
        int sEnd = this.m_registeredExp.getSelectionEnd();
        try {
            Document doc = this.m_registeredExp.getDocument();
            String existing = doc.getText(0, doc.getLength());
            boolean inserted = false;
            int focus = text.indexOf(40);
            if (focus >= 0) {
                if (sStart == sEnd) {
                    int spaceI = existing.indexOf(32);
                    int bracketI = existing.indexOf(40);
                    if (spaceI < 0 && bracketI < 0) {
                        sStart = 0;
                        sEnd = doc.getLength();
                    }
                }
                if (sStart != sEnd) {
                    doc.insertString(sEnd, text.substring(focus + 1), null);
                    doc.insertString(sStart, text.substring(0, focus + 1), null);
                    int comma = text.indexOf(",", focus);
                    this.m_expFocus = comma > 0 ? comma + sEnd + 1 : text.length() + sEnd;
                    inserted = true;
                }
            }
            if (!inserted) {
                if (sStart == sEnd) {
                    if (existing.length() > 0 && this.partOfName(existing.charAt(insert == 0 ? 0 : insert - 1))) {
                        doc.insertString(insert, " ", null);
                        if (insert != 0) {
                            ++insert;
                        }
                    }
                } else {
                    doc.remove(sStart, sEnd - sStart);
                    insert = this.m_registeredExp.getCaretPosition();
                }
                doc.insertString(insert, text, null);
                this.m_expFocus = insert;
                this.m_sEnd = this.m_expFocus + (focus > 0 ? focus + 1 : text.length());
                inserted = true;
            }
            if (!inserted) {
                this.m_expFocus = -1;
                this.m_lastInserted = null;
            } else {
                this.m_lastInserted = text;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_undo.commitCombinedEdit();
    }

    public void clearUndo() {
        this.m_undo.clearUndo();
    }

    public void setInsightMap(Map relsToCols) {
        this.m_relations = relsToCols;
    }

    public void setInsightObjects(Set objs) {
        this.m_objs = objs;
    }

    protected Object[] filter(Object[] objs, String filter) {
        ArrayList<Object> retval = new ArrayList<Object>();
        for (int i = 0; i < objs.length; ++i) {
            String name = this.convertToString(objs[i]);
            if (!name.toUpperCase().startsWith(filter.toUpperCase())) continue;
            retval.add(objs[i]);
        }
        return retval.toArray();
    }

    private String convertToString(Object obj) {
        String retval = null;
        retval = obj instanceof AliasFragment ? ((AliasFragment)obj).getName() : (obj instanceof FunctionDefinition ? ((FunctionDefinition)obj).getSQLText() : (obj instanceof SQLFragment ? ((SQLFragment)obj).getSQLText() : (obj instanceof DBObject ? ((DBObject)obj).getName() : String.valueOf(obj))));
        return retval;
    }

    private int[] lastNonAlphaNumIndex(String text, int i) {
        for (int j = i - 1; j >= 0; --j) {
            char c = text.charAt(j);
            if (this.partOfName(c)) continue;
            return new int[]{j, c};
        }
        return new int[]{-1, -1};
    }

    private int nextNonAlphaNumIndex(String text, int i) {
        for (int j = i; j < text.length(); ++j) {
            char c = text.charAt(j);
            if (this.partOfName(c)) continue;
            return j;
        }
        return text.length();
    }

    private boolean partOfName(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.m_expFocus >= 0) {
            if (this.m_sEnd < 0) {
                try {
                    this.m_registeredExp.setCaretPosition(this.m_expFocus);
                }
                catch (Exception ex) {}
            } else {
                try {
                    this.m_registeredExp.setSelectionStart(this.m_expFocus);
                    this.m_registeredExp.setSelectionEnd(this.m_sEnd);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.m_expFocus = -1;
            this.m_sEnd = -1;
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public ListCellRenderer getCellRenderer() {
        return ExpressionEditSupport.getRenderer();
    }

    public boolean handlesInsight(Document doc, int i) {
        return this.m_relations != null;
    }

    public Object[] getInsightData(Document doc, int i) {
        Object[] retval = null;
        if (this.m_relations != null) {
            try {
                String text = doc.getText(0, doc.getLength());
                if (this.isInQuotes(text.substring(0, i))) {
                    return null;
                }
                if (text.length() > i && this.isDot(text.charAt(i))) {
                    int[] nonchar = this.lastNonAlphaNumIndex(text, i);
                    String relAlias = text.substring(nonchar[0] + 1, i - 1);
                    retval = (Object[])this.m_relations.get(relAlias);
                } else {
                    int[] nonchar = this.lastNonAlphaNumIndex(text, i);
                    String filter = text.substring(nonchar[0] + 1, i);
                    if (filter.equals(this.m_lastInserted)) {
                        this.m_lastInserted = null;
                        return null;
                    }
                    this.m_lastInserted = null;
                    Object[] toFilter = null;
                    if (this.isDot((char)nonchar[1])) {
                        int[] nextnonchar = this.lastNonAlphaNumIndex(text, nonchar[0]);
                        String relAlias = text.substring(nextnonchar[0] + 1, nonchar[0]);
                        toFilter = (Object[])this.m_relations.get(relAlias);
                    } else {
                        toFilter = this.m_objs.toArray();
                        Arrays.sort(toFilter, ExpressionEditSupport.getRenderer());
                    }
                    Object[] objectArray = retval = toFilter == null ? null : this.filter(toFilter, filter);
                    if (retval != null && retval.length == 1 && filter.equals(this.convertToString(retval[0]))) {
                        retval = null;
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
            }
            catch (BadLocationException e) {
                // empty catch block
            }
        }
        if (retval != null && retval.length == 0) {
            retval = null;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completeInsight(Document doc, int i, Object insert) {
        try {
            this.m_undo.startCombiningEdits();
            String text = doc.getText(0, doc.getLength());
            String toInsert = this.convertToString(insert);
            if (text.length() > 0) {
                if (i > 0 && this.partOfName(text.charAt(i - 1))) {
                    int[] nonchar = this.lastNonAlphaNumIndex(text, i);
                    int from = nonchar[0];
                    if (++from != i) {
                        doc.remove(from, i - from);
                        i -= i - from;
                        text = doc.getText(0, doc.getLength());
                    }
                }
                if (text.length() > i && this.partOfName(text.charAt(i))) {
                    int till = this.nextNonAlphaNumIndex(text, i);
                    doc.remove(i, till - i);
                }
            }
            this.addToExpressionField(toInsert);
            this.m_expFocus = -1;
            this.m_sEnd = -1;
        }
        catch (BadLocationException e) {
        }
        finally {
            this.m_undo.commitCombinedEdit();
        }
    }

    private boolean isDot(char c) {
        return c == '.';
    }

    private boolean isInQuotes(String text) {
        return this.hasOddNumberOf('\'', text) || this.hasOddNumberOf('\"', text);
    }

    private boolean hasOddNumberOf(char c, String text) {
        int count = 0;
        int index = text.indexOf(c);
        while (index >= 0) {
            ++count;
            index = text.indexOf(c, index + 1);
        }
        return count % 2 != 0;
    }

    public boolean isAutoPopupChar(char c) {
        if (this.isDot(c)) {
            return this.m_relations != null;
        }
        if (this.partOfName(c)) {
            return this.m_objs != null || this.m_relations != null;
        }
        return false;
    }

    public static Map createInsightMap(FromObject[] froms) {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        for (int i = 0; i < froms.length; ++i) {
            if (froms[i] == null) continue;
            String alias = froms[i].getName();
            Collection cols = ExpressionEditSupport.getColumns(froms[i]);
            map.put(alias, cols.toArray());
        }
        return map;
    }

    public static Collection getColumns(FromObject from) {
        TreeSet<Object> retval = new TreeSet<Object>(ExpressionEditSupport.getRenderer());
        if (from != null) {
            SQLFragment exp = from.getExpression();
            if (exp instanceof DBObjectUsage) {
                SchemaObject obj;
                Relation rel = null;
                if (exp instanceof RelationUsage) {
                    DBObjectID id = ((RelationUsage)exp).getObjectID();
                    if (id != null) {
                        try {
                            rel = (Relation)id.resolveID();
                        }
                        catch (DBException dbe) {}
                    }
                } else if (exp instanceof SynonymUsage && (obj = ((SynonymUsage)exp).getReferencedObject()) instanceof Relation) {
                    rel = (Relation)obj;
                }
                if (rel != null) {
                    Column[] cols = rel.getColumns();
                    for (int i = 0; i < cols.length; ++i) {
                        retval.add(cols[i]);
                    }
                }
            } else if (exp instanceof SQLQuery) {
                SelectObject[] sels = ((SQLQuery)exp).getSelectObjects();
                for (int i = 0; i < sels.length; ++i) {
                    retval.add(sels[i]);
                }
            } else if (exp instanceof JoinObject) {
                FromObject left = ((JoinObject)exp).getLeftExpression();
                retval.addAll(ExpressionEditSupport.getColumns(left));
                FromObject right = ((JoinObject)exp).getRightExpression();
                retval.addAll(ExpressionEditSupport.getColumns(right));
            }
        }
        return retval;
    }

    private static DBObjectRenderer getRenderer() {
        if (s_rend == null) {
            s_rend = new DBObjectRenderer();
            s_rend.setIncludeIcon(true);
        }
        return s_rend;
    }
}

