/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.util;

import java.awt.Component;
import javax.swing.JMenu;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.Menubar;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.ideri.util.Product;

public class DBMenuUtils {
    private static final String VIEW_DATBASE_SUB_MENU = "VIEW_DATBASE_SUB_MENU";
    private static final String TOOLS_DATBASE_SUB_MENU = "TOOLS_DATBASE_SUB_MENU";

    private DBMenuUtils() {
    }

    public static JMenu getViewSubMenu() {
        return DBMenuUtils.findOrCreateSubMenu(VIEW_DATBASE_SUB_MENU, "View", MenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
    }

    public static JMenu getToolsSubMenu() {
        return DBMenuUtils.findOrCreateSubMenu(TOOLS_DATBASE_SUB_MENU, "Tools", MenuConstants.SECTION_TOOLS_ADDINS);
    }

    private static JMenu findOrCreateSubMenu(String subMenuID, String menuID, float weight) {
        JMenu submenu;
        Menubar menubar = Ide.getMenubar();
        if (Product.isRaptor()) {
            submenu = Menubar.getJMenu((String)menuID);
        } else {
            submenu = Menubar.getJMenu((String)subMenuID);
            if (submenu == null) {
                String res = UIBundle.get("VIEW_DB_SUBMENU");
                submenu = menubar.createSubMenu(StringUtils.stripMnemonic((String)res), Integer.valueOf(StringUtils.getMnemonicKeyCode((String)res)));
                Menubar.putJMenu((String)subMenuID, (JMenu)submenu);
                menubar.add((Component)submenu, Menubar.getJMenu((String)menuID), weight);
            }
        }
        return submenu;
    }
}

