/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.panels.trigger.DBTriggerPanel;
import oracle.ide.db.panels.trigger.SchemaTriggerPanel;
import oracle.ide.db.panels.trigger.TableTriggerPanel;
import oracle.ide.db.panels.trigger.ViewTriggerPanel;
import oracle.ide.db.verifiers.SchemaObjectInfoVerifier;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;
import oracle.javatools.util.ModelUtil;

public class TriggerPanel
extends BaseInfoPanel {
    private GridBagLayout m_layMain = new GridBagLayout();
    private Trigger m_origTrigger;
    private Trigger m_trigger;
    private Schema[] m_schemas;
    private JLabel m_lblType = new JLabel();
    private NonNullableComboBoxModel m_mdlType = new NonNullableComboBoxModel((Object[])Trigger.BaseType.values());
    private JComboBox m_cmbType = new JComboBox();
    private JCheckBox m_chkEnabled = new JCheckBox();
    private JPanel m_pnlType = new JPanel();
    private CardLayout m_layType = new CardLayout();
    private BaseTriggerPanel m_pnlTable = new TableTriggerPanel();
    private BaseTriggerPanel m_pnlView = new ViewTriggerPanel();
    private BaseTriggerPanel m_pnlSchema = new SchemaTriggerPanel();
    private BaseTriggerPanel m_pnlDB = new DBTriggerPanel();
    private BaseTriggerPanel[] m_typePanels = new BaseTriggerPanel[]{this.m_pnlTable, this.m_pnlView, this.m_pnlSchema, this.m_pnlDB};
    private BaseTriggerPanel m_currentTypePanel;
    private boolean m_canChangeSchema;
    private boolean m_canEditTrigger = true;
    private boolean m_entered = false;
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("TriggerPanel");

    public TriggerPanel() {
        this.setLayout(this.m_layMain);
        this.setLayout(new GridBagLayout());
        this.m_pnlType.setLayout(this.m_layType);
        this.m_resHelper.resLabel(this.m_lblType, this.m_cmbType, UIArb.getString(769), "_cmbType");
        this.m_cmbType.setName("TriggerType");
        this.m_cmbType.setModel(this.m_mdlType);
        this.m_cmbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                TriggerPanel.this.updateSubPanel();
            }
        });
        this.m_resHelper.resButton(this.m_chkEnabled, UIArb.getString(649), "_chkEnabled");
        this.m_pnlType.add((Component)((Object)this.m_pnlTable), Trigger.BaseType.TABLE.toString());
        this.m_pnlType.add((Component)((Object)this.m_pnlView), Trigger.BaseType.VIEW.toString());
        this.m_pnlType.add((Component)((Object)this.m_pnlSchema), Trigger.BaseType.SCHEMA.toString());
        this.m_pnlType.add((Component)((Object)this.m_pnlDB), Trigger.BaseType.DATABASE.toString());
        this.add(this.m_lblType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this.m_cmbType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 12), 0, 0));
        this.add(this.m_chkEnabled, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_pnlType, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void updateSubPanel() {
        BaseTriggerPanel panel;
        int idx = this.m_cmbType.getSelectedIndex();
        BaseTriggerPanel baseTriggerPanel = panel = idx != -1 ? this.m_typePanels[idx] : null;
        if (this.m_entered && panel != this.m_currentTypePanel) {
            if (this.m_currentTypePanel != null) {
                this.m_currentTypePanel.setParent(null);
            }
            if (panel != null) {
                panel.setParent(this);
                SchemaObjectInfoVerifier v = (SchemaObjectInfoVerifier)this.getVerifier();
                boolean bl = this.m_canChangeSchema = v == null || v.canChangeSchema();
                if (this.m_schemas == null) {
                    try {
                        this.m_schemas = this.getProvider().listSchemas(false);
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                panel.init(this.getProvider(), this.m_trigger, this.m_schemas, this.m_canEditTrigger, this.m_canChangeSchema, (TriggerVerifier)this.getVerifier());
                this.m_layType.show(this.m_pnlType, Trigger.BaseType.values()[idx].toString());
            }
            this.m_currentTypePanel = panel;
        }
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.init(prov, (TriggerVerifier)dataContext.find("SchemaObjectInfoVerifier"));
        this.m_origTrigger = (Trigger)dataContext.find("OriginalObject");
        this.m_trigger = (Trigger)dataContext.find("NewObject");
        this.m_cmbType.setSelectedItem(this.m_trigger.getBaseType());
        this.m_chkEnabled.setSelected(this.m_trigger.isEnabled());
        this.m_canEditTrigger = (Boolean)dataContext.find("DBObjectIsEditable");
        this.m_entered = true;
        this.updateSubPanel();
        boolean canChangeBase = (TriggerVerifier)this.getVerifier() == null || ((TriggerVerifier)this.getVerifier()).canChangeBaseObject();
        this.m_lblType.setEnabled(this.m_canEditTrigger && canChangeBase);
        this.m_cmbType.setEnabled(this.m_canEditTrigger && canChangeBase);
        this.m_chkEnabled.setEnabled(this.m_canEditTrigger);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.m_currentTypePanel.commit();
        if (this.m_origTrigger != null) {
            ArrayList<String> oriList = new ArrayList<String>(Arrays.asList(this.m_origTrigger.getEvents()));
            ArrayList<String> updList = new ArrayList<String>(Arrays.asList(this.m_trigger.getEvents()));
            if (updList.size() > 0 && updList.size() == oriList.size() && updList.containsAll(oriList)) {
                this.m_trigger.setEvents(oriList.toArray(new String[oriList.size()]));
            }
            if (!ModelUtil.hasLength((String)this.m_trigger.getReferencingOldAs()) && !ModelUtil.hasLength((String)this.m_origTrigger.getReferencingOldAs())) {
                this.m_trigger.setReferencingOldAs(this.m_origTrigger.getReferencingOldAs());
            }
            if (!ModelUtil.hasLength((String)this.m_trigger.getReferencingNewAs()) && !ModelUtil.hasLength((String)this.m_origTrigger.getReferencingNewAs())) {
                this.m_trigger.setReferencingNewAs(this.m_origTrigger.getReferencingNewAs());
            }
        }
        this.m_trigger.setBaseType((Trigger.BaseType)this.m_cmbType.getSelectedItem());
        this.m_trigger.setEnabled(this.m_chkEnabled.isSelected());
        this.m_trigger.setSource(null);
        TriggerVerifier verifier = (TriggerVerifier)this.getVerifier();
        if (verifier != null) {
            verifier.verifyTrigger(false);
        }
    }
}

