/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.trigger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.ListModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.trigger.BaseTriggerPanel;
import oracle.ide.db.verifiers.trigger.TriggerVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Trigger;

public class SchemaTriggerPanel
extends BaseTriggerPanel
implements ItemListener {
    private GridBagLayout m_layMain = new GridBagLayout();
    private JRadioButton m_radBefore = new JRadioButton();
    private JRadioButton m_radAfter = new JRadioButton();
    private ButtonGroup m_grpTiming = new ButtonGroup();
    private JLabel m_lblSchema = new JLabel();
    private DBObjectChooser m_cmbSchema = new DBObjectChooser("SCHEMA");
    private Shuttle m_shtEvents = new Shuttle();
    private JLabel m_lblAvail = new JLabel();
    private JList m_lstAvail = new JList();
    private ListPicker m_pckAvail = new ListPicker(this.m_lstAvail);
    private JLabel m_lblSel = new JLabel();
    private JList m_lstSel = new JList();
    private ListPicker m_pckSel = new ListPicker(this.m_lstSel);
    private BaseTriggerPanel.ModelPair m_mdlBefore = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.SCHEMA, (Trigger.Timing)Trigger.Timing.BEFORE));
    private BaseTriggerPanel.ModelPair m_mdlAfter = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.SCHEMA, (Trigger.Timing)Trigger.Timing.AFTER));
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("SchemaTriggerPanel");

    public SchemaTriggerPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean getCurrentOKState() {
        return this.m_lstSel.getModel().getSize() > 0;
    }

    @Override
    public void init(DBObjectProvider prov, Trigger trigger, Schema[] schemas, boolean canEditTrigger, boolean canChangeSchema, TriggerVerifier verifier) {
        super.init(prov, trigger, schemas, canEditTrigger, canChangeSchema, verifier);
        Schema baseSchema = null;
        try {
            baseSchema = prov.getSchema(trigger.getBaseSchemaName());
        }
        catch (DBException dbe) {
            DBExceptionDialog.showErrorDialog((Component)((Object)this), UIArb.getString(518), dbe);
        }
        this.m_cmbSchema.setProvider(prov);
        this.m_cmbSchema.setDBObject((DBObject)trigger.getSchema());
        this.m_cmbSchema.setEnabled(canChangeSchema);
        boolean before = trigger.getTiming() == null ? true : trigger.getTiming() == Trigger.Timing.BEFORE;
        this.m_radBefore.setSelected(before);
        this.m_radAfter.setSelected(!before);
        this.m_mdlBefore = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.SCHEMA, (Trigger.Timing)Trigger.Timing.BEFORE));
        this.m_mdlAfter = SchemaTriggerPanel.createModel(Trigger.getEvents((Trigger.BaseType)Trigger.BaseType.SCHEMA, (Trigger.Timing)Trigger.Timing.AFTER));
        BaseTriggerPanel.ModelPair modelPair = this.m_radBefore.isSelected() ? this.m_mdlBefore : this.m_mdlAfter;
        DefaultListModel availableModel = (DefaultListModel)modelPair.getAvailableModel();
        DefaultListModel selectedModel = (DefaultListModel)modelPair.getSelectedModel();
        block2: for (String event : trigger.getEvents()) {
            for (int i = availableModel.getSize(); i > 0; --i) {
                if (!event.equals((String)availableModel.getElementAt(i - 1))) continue;
                availableModel.removeElementAt(i - 1);
                selectedModel.addElement(event);
                continue block2;
            }
        }
        this.itemStateChanged(null);
        if (verifier != null && !verifier.canChangeBaseObject()) {
            this.m_lblSchema.setEnabled(false);
            this.m_cmbSchema.setEnabled(false);
        } else if (!canEditTrigger) {
            this.m_radBefore.setEnabled(false);
            this.m_radAfter.setEnabled(false);
            this.m_lblSchema.setEnabled(false);
            this.m_cmbSchema.setEnabled(false);
            this.m_shtEvents.setEnabled(false);
            this.m_lblAvail.setEnabled(false);
            this.m_lstAvail.setEnabled(false);
            this.m_lblSel.setEnabled(false);
            this.m_lstSel.setEnabled(false);
        }
    }

    static final BaseTriggerPanel.ModelPair createModel(List list) {
        String[] events = list.toArray(new String[list.size()]);
        return new BaseTriggerPanel.ModelPair(events, false);
    }

    @Override
    public void commit() throws TraversalException {
        Trigger.Timing timing = this.m_radBefore.isSelected() ? Trigger.Timing.BEFORE : Trigger.Timing.AFTER;
        Schema schema = (Schema)this.m_cmbSchema.getOrCreateDBObject();
        ListModel model = this.m_lstSel.getModel();
        int count = model.getSize();
        String[] events = new String[count];
        for (int i = 0; i < count; ++i) {
            events[i] = (String)model.getElementAt(i);
        }
        Trigger trigger = this.getTrigger();
        trigger.setTiming(timing);
        trigger.setBaseSchema(schema);
        trigger.setEvents(events);
        trigger.setStatementLevel(true);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.m_layMain);
        this.m_lstAvail.addFocusListener(this);
        this.m_lstSel.addFocusListener(this);
        this.m_resHelper.resButton(this.m_radBefore, UIArb.getString(770), "_radBefore");
        this.m_grpTiming.add(this.m_radBefore);
        this.m_radBefore.addItemListener(this);
        this.m_resHelper.resButton(this.m_radAfter, UIArb.getString(771), "_radAfter");
        this.m_grpTiming.add(this.m_radAfter);
        this.m_radBefore.setSelected(true);
        this.m_resHelper.resLabel(this.m_lblSchema, this.m_cmbSchema, UIArb.getString(108), "_cmbSchema");
        this.m_resHelper.resLabel(this.m_lblAvail, this.m_lstAvail, UIArb.getString(789), "_lstAvail");
        this.m_resHelper.resLabel(this.m_lblSel, this.m_lstSel, UIArb.getString(790), "_lstSel");
        this.m_shtEvents.setFromPicker((ItemPicker)this.m_pckAvail);
        this.m_shtEvents.setToPicker((ItemPicker)this.m_pckSel);
        this.m_pckAvail.setItemsSorted(true);
        this.m_pckSel.setItemsSorted(true);
        this.m_shtEvents.add((Component)this.m_lblAvail, (Object)"FromHeader");
        this.m_shtEvents.add((Component)this.m_lblSel, (Object)"ToHeader");
        this.add(this.m_radBefore, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_radAfter, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_lblSchema, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 24, 0, 0), 0, 0));
        this.add(this.m_cmbSchema, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 24, 0, 0), 0, 0));
        this.add((Component)this.m_shtEvents, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        BaseTriggerPanel.ModelPair modelPair = this.m_radBefore.isSelected() ? this.m_mdlBefore : this.m_mdlAfter;
        this.m_lstAvail.setModel(modelPair.getAvailableModel());
        this.m_lstSel.setModel(modelPair.getSelectedModel());
        this.m_pckAvail.setItemsSorted(false);
        this.m_pckAvail.setItemsSorted(true);
        this.m_pckSel.setItemsSorted(false);
        this.m_pckSel.setItemsSorted(true);
    }
}

