/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUILayoutHelper;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.XMLTypeColumnProperties;

public class XMLTypeColumnPropertiesPanel
extends DefaultTraversablePanel
implements ActionListener {
    private DBObjectProvider m_prov;
    private XMLTypeColumnProperties m_props;
    private JLabel m_lblStoreAs = new JLabel();
    private JComboBox m_cmbStoreAs = new JComboBox();
    private JLabel m_lblSchema = new JLabel();
    private DBObjectChooser m_schemaChooser = new DBObjectChooser("SCHEMA");
    private JLabel m_lblXmlschema = new JLabel();
    private DBObjectChooser m_xmlSchemaChooser = new DBObjectChooser(this.m_schemaChooser, "XML SCHEMA");
    private JLabel m_lblElement = new JLabel();
    private DBObjectChooser m_xmlElementChooser = new DBObjectChooser(this.m_xmlSchemaChooser, "XMLSchemaElement");
    private JCheckBox m_cbxAllowAnySchema = new JCheckBox();
    private JCheckBox m_cbxAllowNonSchema = new JCheckBox();
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("XMLTypeColumnPropertiesPanel");

    public XMLTypeColumnPropertiesPanel(DBObjectProvider prov, XMLTypeColumnProperties props, boolean readOnly) {
        this.setLayout(new GridBagLayout());
        this.m_resHelper.resLabel(this.m_lblStoreAs, this.m_cmbStoreAs, UIArb.getString(948), "m_cmbStoreAs");
        this.m_resHelper.resLabel(this.m_lblSchema, this.m_schemaChooser, UIArb.getString(949), "m_schemaChooser");
        this.m_resHelper.resLabel(this.m_lblXmlschema, this.m_xmlSchemaChooser, UIArb.getString(950), "m_xmlSchemaChooser");
        this.m_resHelper.resLabel(this.m_lblElement, this.m_xmlElementChooser, UIArb.getString(951), "m_xmlElementChooser");
        this.m_resHelper.resButton(this.m_cbxAllowAnySchema, UIArb.getString(952), "m_cbxAllowAnySchema");
        this.m_resHelper.resButton(this.m_cbxAllowNonSchema, UIArb.getString(953), "m_cbxAllowNonSchema");
        DBUILayoutHelper helper = new DBUILayoutHelper((JPanel)((Object)this));
        helper.add(this.m_lblStoreAs);
        helper.add(this.m_cmbStoreAs);
        helper.nextRowWithGap();
        helper.add(this.m_lblSchema);
        helper.add(this.m_schemaChooser);
        helper.nextRow();
        helper.add(this.m_lblXmlschema);
        helper.add(this.m_xmlSchemaChooser);
        helper.nextRow();
        helper.add(this.m_lblElement);
        helper.add(this.m_xmlElementChooser);
        helper.nextRowWithGap();
        helper.add(this.m_cbxAllowAnySchema, 2, 1);
        helper.nextRow();
        helper.add(this.m_cbxAllowNonSchema, 2, 1);
        helper.pushUp();
        helper.layout();
        this.m_cmbStoreAs.setModel(new DefaultComboBoxModel<XMLTypeColumnProperties.StoreAs>(XMLTypeColumnProperties.StoreAs.values()));
        this.m_prov = prov;
        this.m_props = props;
        this.m_schemaChooser.setProvider(prov);
        this.m_schemaChooser.setNullText(" ");
        this.m_xmlSchemaChooser.setProvider(prov);
        this.m_xmlElementChooser.setProvider(prov);
        this.m_cmbStoreAs.setSelectedItem(this.m_props.getStoreAs());
        DBObjectID elementID = this.m_props.getElementID();
        if (elementID != null) {
            DBObjectID xmlSchemaId = elementID.getParent();
            if (xmlSchemaId instanceof BaseObjectID) {
                try {
                    String schemaName = ((BaseObjectID)xmlSchemaId).getSchemaName();
                    Schema s = this.m_prov.getSchema(schemaName);
                    if (s == null) {
                        s = new Schema(schemaName);
                    }
                    this.m_schemaChooser.setDBObject((DBObject)s);
                    this.m_xmlSchemaChooser.setDBObjectID(xmlSchemaId);
                    this.m_xmlElementChooser.setDBObjectID(elementID);
                }
                catch (DBException e) {
                    elementID = null;
                }
            } else {
                elementID = null;
            }
        }
        if (elementID == null) {
            this.m_schemaChooser.setDBObjectID(null);
            this.m_xmlSchemaChooser.setDBObjectID(null);
            this.m_xmlElementChooser.setDBObjectID(null);
        }
        this.m_cbxAllowAnySchema.setSelected(this.m_props.isAllowAnySchema());
        this.m_cbxAllowNonSchema.setSelected(this.m_props.isAllowNonSchema());
        this.enableComponents(readOnly ? null : this.m_props.getStoreAs());
        this.m_cmbStoreAs.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.m_cmbStoreAs) {
            this.enableComponents((XMLTypeColumnProperties.StoreAs)this.m_cmbStoreAs.getSelectedItem());
        }
    }

    public XMLTypeColumnProperties getProps() throws TraversalException {
        this.m_props.setStoreAs((XMLTypeColumnProperties.StoreAs)this.m_cmbStoreAs.getSelectedItem());
        this.m_props.setElementID(this.m_xmlElementChooser.getDBObjectID());
        this.m_props.setAllowAnySchema(this.m_cbxAllowAnySchema.isSelected());
        this.m_props.setAllowNonSchema(this.m_cbxAllowNonSchema.isSelected());
        try {
            this.m_prov.validateObject((DBObject)this.m_props);
        }
        catch (ValidationException e) {
            throw new TraversalException(e.getMessage(), e.getTitle());
        }
        return this.m_props;
    }

    private void enableComponents(XMLTypeColumnProperties.StoreAs storeAs) {
        boolean anyEnabled = storeAs != null;
        this.m_lblStoreAs.setEnabled(anyEnabled);
        this.m_cmbStoreAs.setEnabled(anyEnabled);
        this.m_lblSchema.setEnabled(anyEnabled);
        this.m_schemaChooser.setEnabled(anyEnabled);
        this.m_lblXmlschema.setEnabled(anyEnabled);
        this.m_xmlSchemaChooser.setEnabled(anyEnabled);
        this.m_lblElement.setEnabled(anyEnabled);
        this.m_xmlElementChooser.setEnabled(anyEnabled);
        this.m_cbxAllowAnySchema.setEnabled(storeAs == XMLTypeColumnProperties.StoreAs.BINARY_XML);
        this.m_cbxAllowNonSchema.setEnabled(storeAs == XMLTypeColumnProperties.StoreAs.BINARY_XML);
        if (anyEnabled && storeAs != XMLTypeColumnProperties.StoreAs.BINARY_XML) {
            this.m_cbxAllowAnySchema.setSelected(false);
            this.m_cbxAllowNonSchema.setSelected(false);
        } else if (anyEnabled && storeAs == XMLTypeColumnProperties.StoreAs.BINARY_XML && !this.m_cbxAllowAnySchema.isSelected() && !this.m_cbxAllowNonSchema.isSelected() && this.m_xmlElementChooser.getDBObjectID() == null) {
            this.m_cbxAllowNonSchema.setSelected(true);
        }
    }

    public XMLTypeColumnProperties getXMLTypeColumnProperties() {
        return this.m_props;
    }
}

