/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.verifiers.Verifier;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.db.verifiers.table.TableInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.Relation;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class SimpleCreateTablePanel
extends BaseInfoPanel {
    private GridBagLayout m_layoutGB = new GridBagLayout();
    private SimpleTableModel m_columnModel = new SimpleTableModel();
    private JTable m_tblColumnList = new JTable();
    private JButton m_btnAddColumn = new JButton();
    private JButton m_btnRemoveColumn = new JButton();
    private DBObjectProvider m_prov;
    private Table m_table;
    private TableInfoVerifier m_tableVerifier = null;
    private ColumnInfoVerifier m_columnVerifier = null;
    private ConstraintsInfoVerifier m_constraintVerifier = null;
    private Collection<DataType> m_typeArray = new TreeSet<DataType>(DBUtil.getNameComparator());
    private TreeSet<String> m_invalidCols = new TreeSet();
    private DataType m_defType;
    private boolean m_initialized = false;
    private String m_columnBaseName;
    public static final String HELP_SIMPLE_TABLE = "f1_odbta_html";
    private static final Long LONG_0 = new Long(0L);
    private static final String[] LOB_TYPE_NAMES = new String[]{JdbcDatabase.ANSI_BLOB.getName(), JdbcDatabase.ANSI_CLOB.getName(), JdbcDatabase.ANSI_BINARY_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHAR_LARGE_OBJECT.getName(), JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT.getName()};

    public SimpleCreateTablePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("SimpleCreateTablePanel");
        this.setLayout(this.m_layoutGB);
        reshelp.resButton(this.m_btnAddColumn, UIArb.getString(565), "Add");
        reshelp.resButton(this.m_btnRemoveColumn, UIArb.getString(566), "Remove");
        this.m_btnAddColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                TableCellEditor ed = SimpleCreateTablePanel.this.m_tblColumnList.getCellEditor();
                if (ed != null) {
                    ed.stopCellEditing();
                }
                row = (row = SimpleCreateTablePanel.this.m_tblColumnList.getSelectedRow()) < 0 ? SimpleCreateTablePanel.this.m_columnModel.size() : ++row;
                SimpleCreateTablePanel.this.m_columnModel.addDefaultRow(row);
                SimpleCreateTablePanel.this.m_tblColumnList.setRowSelectionInterval(row, row);
            }
        });
        this.m_btnRemoveColumn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                TableCellEditor ed = SimpleCreateTablePanel.this.m_tblColumnList.getCellEditor();
                if (ed != null) {
                    ed.stopCellEditing();
                }
                if ((row = SimpleCreateTablePanel.this.m_tblColumnList.getSelectedRow()) >= 0) {
                    SimpleCreateTablePanel.this.m_columnModel.deleteRow(row);
                    if (row > 0) {
                        SimpleCreateTablePanel.this.m_tblColumnList.setRowSelectionInterval(row - 1, row - 1);
                    } else if (SimpleCreateTablePanel.this.m_columnModel.size() > 0) {
                        SimpleCreateTablePanel.this.m_tblColumnList.setRowSelectionInterval(0, 0);
                    }
                }
                SimpleCreateTablePanel.this.m_tblColumnList.requestFocus();
            }
        });
        reshelp.setName(this.m_tblColumnList, "ColumnTable");
        this.m_tblColumnList.setModel(this.m_columnModel);
        TableColumn colType = this.m_tblColumnList.getColumnModel().getColumn(2);
        colType.setCellEditor(new DefaultCellEditor(new IntegerTextField()));
        TableColumnModel tableColumnModel = this.m_tblColumnList.getColumnModel();
        TableColumn col = tableColumnModel.getColumn(0);
        col.setMinWidth(110);
        col = tableColumnModel.getColumn(1);
        col.setMinWidth(110);
        col.setMaxWidth(150);
        col = tableColumnModel.getColumn(2);
        col.setMinWidth(50);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(3);
        col.setMinWidth(60);
        col.setMaxWidth(60);
        col = tableColumnModel.getColumn(4);
        col.setMinWidth(70);
        col.setMaxWidth(70);
        JScrollPane scrollPane = new JScrollPane(this.m_tblColumnList);
        this.m_tblColumnList.setPreferredScrollableViewportSize(new Dimension(500, 100));
        this.m_tblColumnList.setSelectionMode(0);
        ColumnListCellRenderer renderer = new ColumnListCellRenderer();
        try {
            this.m_tblColumnList.setDefaultRenderer(Object.class, renderer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.add(scrollPane, new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_btnAddColumn, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(this.m_btnRemoveColumn, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
    }

    public void init(DBObjectProvider prov) {
        if (this.m_columnBaseName == null) {
            this.m_columnBaseName = prov.getDescriptor().getCasePolicy() == 1 ? "column" : "COLUMN";
        }
        this.m_typeArray.clear();
        if (this.m_columnVerifier != null) {
            for (DataType type : this.m_columnVerifier.getPreferredTypes()) {
                this.m_typeArray.add(type);
            }
            this.m_defType = this.m_columnVerifier.getDefaultType();
            this.m_initialized = true;
        }
    }

    private void initializeVerifier(Verifier v) {
        if (v != null) {
            v.initializeVerifier(this.m_prov, null, (SchemaObject)this.m_table);
        }
    }

    public void onEntry(TraversableContext dataContext) {
        this.m_prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        this.m_table = (Table)dataContext.find("NewObject");
        assert (dataContext.find("OriginalObject") == null) : "simple create panel shouldn't be shown in edit dialog.";
        this.m_tableVerifier = (TableInfoVerifier)dataContext.find("SchemaObjectInfoVerifier");
        this.m_columnVerifier = (ColumnInfoVerifier)dataContext.find("ColumnInfoVerifier");
        this.m_constraintVerifier = (ConstraintsInfoVerifier)dataContext.find("ConstraintsInfoVerifier");
        this.initializeVerifier(this.m_tableVerifier);
        this.initializeVerifier(this.m_columnVerifier);
        this.initializeVerifier(this.m_constraintVerifier);
        this.setup();
        int row = this.m_tblColumnList.getSelectedRow();
        if (row < 0) {
            row = this.m_columnModel.size();
            this.m_tblColumnList.setRowSelectionInterval(row - 1, row - 1);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        String errMessage = null;
        this.m_invalidCols.clear();
        TableCellEditor ed = this.m_tblColumnList.getCellEditor();
        if (ed != null) {
            ed.stopCellEditing();
        }
        int size = this.m_columnModel.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        ArrayList<Column> pkCols = new ArrayList<Column>();
        for (int i = 0; i < size; ++i) {
            String colName = (String)this.m_columnModel.getValueAt(i, 0);
            DataType dt = (DataType)this.m_columnModel.getValueAt(i, 1);
            String colSize = ((String)this.m_columnModel.getValueAt(i, 2)).trim();
            Boolean notNull = (Boolean)this.m_columnModel.getValueAt(i, 3);
            Boolean isPK = (Boolean)this.m_columnModel.getValueAt(i, 4);
            String name = this.m_prov.getInternalName(colName);
            Column col = (Column)this.m_columnModel.getValueAt(i, 5);
            col.setName(name);
            col.setNotNull(notNull.booleanValue());
            DataTypeUsage dtUsage = col.getDataTypeUsage();
            if (dtUsage == null || !dtUsage.getDataTypeID().equals(dt.getID())) {
                dtUsage = dt.createDefaultUsage();
            }
            try {
                if (this.hasDeclarableAttribute(dt, "size")) {
                    if (ModelUtil.hasLength((String)colSize)) {
                        dtUsage.putAttributeValue("size", (Object)DataTypeHelper.toLongOrError((Object)colSize));
                    } else {
                        dtUsage.deleteAttributeValue("size");
                    }
                } else if (this.hasDeclarableAttribute(dt, "precision")) {
                    if (ModelUtil.hasLength((String)colSize)) {
                        dtUsage.putAttributeValue("precision", (Object)DataTypeHelper.toLongOrError((Object)colSize));
                        if (this.hasDeclarableAttribute(dt, "scale") && dtUsage.getAttributeValue("scale") == null) {
                            dtUsage.putAttributeValue("scale", (Object)LONG_0);
                        }
                    } else {
                        dtUsage.deleteAttributeValue("precision");
                        dtUsage.deleteAttributeValue("scale");
                    }
                }
            }
            catch (NumberFormatException ne) {
                throw new TraversalException(DBArb.format((int)193, (Object)colSize, (Object)dt.getName()));
            }
            col.setDataTypeUsage(dtUsage);
            try {
                this.m_prov.validateName("COLUMN", colName);
            }
            catch (InvalidNameException e) {
                this.m_invalidCols.add(colName);
                col.setName(colName);
                if (errMessage != null) continue;
                errMessage = e.getMessage();
                continue;
            }
            cols.add(col);
            if (!isPK.booleanValue()) continue;
            pkCols.add(col);
        }
        if (errMessage != null) {
            throw new TraversalException(errMessage);
        }
        this.m_table.setColumns(cols.toArray(new Column[cols.size()]));
        if (this.m_columnVerifier != null) {
            this.m_columnVerifier.verifyRelation();
        }
        if (pkCols.size() > 0) {
            Constraint[] constraints;
            Constraint[] cons = this.m_table.getConstraints();
            PKConstraint pk = null;
            boolean pkFound = false;
            for (int i = 0; i < cons.length; ++i) {
                if (!"PKConstraint".equals(cons[i].getConstraintType())) continue;
                pk = (PKConstraint)cons[i];
                pkFound = true;
            }
            if (pk == null) {
                pk = (PKConstraint)this.m_prov.getObjectFactory().newObject(PKConstraint.class, (DBObject)this.m_table);
                String pkName = pk.getName();
                if (pkName == null) {
                    pkName = BaseConstraintPanel.findUniqueName((Relation)this.m_table, (Constraint)pk, new Constraint[0], this.m_prov);
                }
                if (this.m_constraintVerifier != null) {
                    try {
                        this.m_constraintVerifier.verifyName(pkName);
                    }
                    catch (TraversalException ex) {
                        ex.printStackTrace();
                    }
                }
                pk.setName(pkName);
                pk.setEnabled(true);
                pk.setID(TemporaryObjectID.createID((DBObject)pk));
            }
            pk.setColumns(pkCols.toArray(new Column[pkCols.size()]));
            if (pkFound) {
                constraints = cons;
            } else {
                constraints = new Constraint[cons.length + 1];
                constraints[0] = pk;
                for (int j = 1; j <= cons.length; ++j) {
                    constraints[j] = cons[j - 1];
                }
            }
            this.m_table.setConstraints(constraints);
        } else {
            Constraint pk = null;
            for (Constraint constraint : this.m_table.getConstraints()) {
                if (!"PKConstraint".equals(constraint.getConstraintType())) continue;
                pk = constraint;
                break;
            }
            if (pk != null) {
                this.m_table.removeConstraint(pk);
            }
        }
    }

    private void setup() {
        if (!this.m_initialized) {
            this.init(this.m_prov);
        }
        this.m_columnModel = new SimpleTableModel();
        this.m_tblColumnList.setModel(this.m_columnModel);
        TableColumn colType = this.m_tblColumnList.getColumnModel().getColumn(1);
        colType.setCellEditor(new DefaultCellEditor(new JComboBox<Object>(this.m_typeArray.toArray())));
        Column[] cols = this.m_table.getColumns();
        if (cols.length == 0 && this.m_columnModel.size() == 0) {
            this.m_columnModel.addDefaultRow(0);
            this.m_tblColumnList.setRowSelectionInterval(0, 0);
        } else {
            int i;
            Constraint[] cons = this.m_table.getConstraints();
            PKConstraint pk = null;
            for (i = 0; i < cons.length; ++i) {
                if (!"PKConstraint".equals(cons[i].getConstraintType())) continue;
                pk = (PKConstraint)cons[i];
            }
            for (i = 0; i < cols.length; ++i) {
                String name = cols[i].getName();
                DataTypeUsage dtusage = cols[i].getDataTypeUsage();
                DataType dt = null;
                boolean primaryKey = false;
                boolean notNull = cols[i].isNotNull();
                String size = "";
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)dtusage);
                }
                catch (DBException ex) {
                    // empty catch block
                }
                if (dt != null) {
                    if (this.hasDeclarableAttribute(dt, "size") && dtusage.getAttributeValue("size") != null) {
                        size = dtusage.getAttributeValue("size").toString();
                    } else if (this.hasDeclarableAttribute(dt, "precision") && dtusage.getAttributeValue("precision") != null) {
                        size = dtusage.getAttributeValue("precision").toString();
                    }
                }
                if (pk != null) {
                    Column[] pkCols = pk.getColumns();
                    for (int j = 0; j < pkCols.length; ++j) {
                        if (!pkCols[j].equals((Object)cols[i])) continue;
                        primaryKey = true;
                        notNull = true;
                        break;
                    }
                }
                this.m_columnModel.addRow(i, name, dt, size, notNull, primaryKey, cols[i]);
            }
        }
    }

    private boolean hasDeclarableAttribute(DataType dt, String attrName) {
        DataTypeAttribute attr = dt.getDataTypeAttribute(attrName);
        return attr != null && attr.isDeclarable();
    }

    private boolean isLOB(DataType dt) {
        String dtName = dt.getName();
        for (String lobTypeName : LOB_TYPE_NAMES) {
            if (!lobTypeName.equals(dtName)) continue;
            return true;
        }
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        DataType ansiEquivalent = dtr.getMappedAnsiType(dt);
        if (ansiEquivalent != null) {
            dtName = ansiEquivalent.getName();
            for (String lobTypeName : LOB_TYPE_NAMES) {
                if (!lobTypeName.equals(dtName)) continue;
                return true;
            }
        }
        return false;
    }

    private String getDefaultSize(DataType dt) {
        DataTypeAttribute dtSize = dt.getDataTypeAttribute("size");
        dtSize = dtSize != null ? dtSize : dt.getDataTypeAttribute("precision");
        String size = dtSize != null && dtSize.isMandatory() ? DataTypeHelper.toString((Object)dtSize.getDefaultValue()) : null;
        return size != null ? size : "";
    }

    private class IntegerTextField
    extends JTextField {
        static final String badchars = "`~!@#$%^&*()_+-=\\|\"':;?/>.<, ";

        private IntegerTextField() {
        }

        @Override
        public void processKeyEvent(KeyEvent ev) {
            char c = ev.getKeyChar();
            if (Character.isLetter(c) && !ev.isAltDown() || badchars.indexOf(c) > -1) {
                ev.consume();
                return;
            }
            super.processKeyEvent(ev);
        }
    }

    private class ColumnListCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component cell = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            cell.setName("SimpleCreateTablePanel.ColumnRow" + row + ":" + column);
            TableModel model = table.getModel();
            if (!table.isRowSelected(row)) {
                if (!model.isCellEditable(row, column)) {
                    cell.setBackground(Color.lightGray);
                } else {
                    cell.setBackground(Color.white);
                }
            } else {
                ((SimpleTableModel)model).setEnableRemoveButton(row, column);
            }
            return cell;
        }
    }

    private class SimpleTableModel
    extends AbstractTableModel {
        public String[] columnNames = new String[]{UIArb.getString(567), UIArb.getString(568), UIArb.getString(569), UIArb.getString(570), UIArb.getString(571)};
        private ArrayList _data = new ArrayList(1);
        private DefaultListModel _mdlColumns = new DefaultListModel();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this._data.size()) {
                return null;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return null;
            }
            return colList.get(col);
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Boolean b;
            if (col == 2) {
                DataType dt = (DataType)this.getValueAt(row, 1);
                return SimpleCreateTablePanel.this.hasDeclarableAttribute(dt, "size") || SimpleCreateTablePanel.this.hasDeclarableAttribute(dt, "precision");
            }
            if (col == 4) {
                return !SimpleCreateTablePanel.this.isLOB((DataType)this.getValueAt(row, 1));
            }
            return col != 3 || (b = (Boolean)this.getValueAt(row, 4)) == false;
        }

        public void setEnableRemoveButton(int row, int col) {
            boolean allowRemove = true;
            if (SimpleCreateTablePanel.this.m_columnVerifier != null) {
                Column column = (Column)this.getValueAt(row, 5);
                if (column != null) {
                    Collection usedBy = DBUtil.findUsagesIn((DBObject)column, (DBObject)column.getParent());
                    for (DBObject usage : usedBy) {
                        if (usage instanceof PKConstraint) {
                            FKConstraint[] fks = DBUtil.getReferences((Constraint)((Constraint)usage), (DBObjectProvider)SimpleCreateTablePanel.this.m_prov);
                            if (fks == null || fks.length <= 0) continue;
                            allowRemove = false;
                            continue;
                        }
                        allowRemove = false;
                    }
                }
                SimpleCreateTablePanel.this.m_btnRemoveColumn.setEnabled(allowRemove);
            }
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this._data.size()) {
                return;
            }
            ArrayList colList = (ArrayList)this._data.get(row);
            if (col >= colList.size()) {
                return;
            }
            if (col == 0) {
                this._mdlColumns.removeElement(colList.get(0));
                this._mdlColumns.addElement(value);
            }
            colList.set(col, value);
            if (col == 1) {
                DataType dt = (DataType)value;
                colList.set(2, SimpleCreateTablePanel.this.getDefaultSize(dt));
                this.fireTableCellUpdated(row, 2);
                if (SimpleCreateTablePanel.this.isLOB(dt)) {
                    colList.set(4, false);
                    this.fireTableCellUpdated(row, 4);
                }
            } else if (col == 4 && ((Boolean)value).booleanValue()) {
                colList.set(3, true);
                this.fireTableCellUpdated(row, 3);
            }
            this.fireTableCellUpdated(row, col);
        }

        public void addDefaultRow(int row) {
            Column defCol = (Column)SimpleCreateTablePanel.this.m_prov.getObjectFactory().newObject(Column.class, (DBObject)SimpleCreateTablePanel.this.m_table);
            SimpleCreateTablePanel.this.m_table.addColumn(defCol);
            String name = defCol.getName();
            if (name == null) {
                name = SimpleCreateTablePanel.getUniqueName(SimpleCreateTablePanel.this.m_columnBaseName, this._mdlColumns);
                defCol.setName(name);
            }
            defCol.setID(TemporaryObjectID.createID((DBObject)defCol));
            DataType dt = SimpleCreateTablePanel.this.m_defType;
            String size = SimpleCreateTablePanel.this.getDefaultSize(SimpleCreateTablePanel.this.m_defType);
            DataTypeUsage dtu = defCol.getDataTypeUsage();
            if (dtu != null) {
                try {
                    dt = DataTypeHelper.getDataType((DataTypeUsage)defCol.getDataTypeUsage());
                }
                catch (DBException e) {
                    dt = SimpleCreateTablePanel.this.m_defType;
                }
                Long p = DataTypeHelper.getLongAttributeValue((DataTypeUsage)defCol.getDataTypeUsage(), (String)"precision");
                Long s = DataTypeHelper.getLongAttributeValue((DataTypeUsage)defCol.getDataTypeUsage(), (String)"size");
                size = Long.toString(p == null ? s : p);
            } else {
                if (dt == null) {
                    dt = SimpleCreateTablePanel.this.m_defType;
                    size = SimpleCreateTablePanel.this.getDefaultSize(SimpleCreateTablePanel.this.m_defType);
                }
                dtu = dt.createDefaultUsage();
                dtu.getAttributeValues().put("size", size);
                defCol.setDataTypeUsage(dtu);
            }
            this.addRow(row, name, dt, size, defCol.isNotNull(), false, defCol);
        }

        public void addRow(int row, String name, DataType dt, String size, boolean notNull, boolean pk, Column col) {
            ArrayList<Object> colList = new ArrayList<Object>(6);
            if (!SimpleCreateTablePanel.this.m_invalidCols.contains(name)) {
                name = SimpleCreateTablePanel.this.m_prov.getExternalName(name, "COLUMN");
            }
            this._mdlColumns.addElement(name);
            colList.add(name);
            colList.add(dt);
            colList.add(size);
            colList.add(notNull);
            colList.add(pk);
            colList.add(col);
            this._data.add(row, colList);
            this.fireTableDataChanged();
        }

        public void deleteRow(int row) {
            ArrayList colList = (ArrayList)this._data.get(row);
            Column remCol = (Column)colList.get(5);
            this._mdlColumns.removeElement(remCol.getName());
            SimpleCreateTablePanel.this.m_table.removeColumn(remCol);
            this._data.remove(row);
            this.fireTableDataChanged();
        }

        public int size() {
            return this._data.size();
        }
    }
}

