/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.table.LobDescriptorPanel;
import oracle.ide.db.panels.table.PartitionDefinitionPanel;
import oracle.ide.db.panels.table.PartitionStoragePanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.verifiers.table.AbstractTableVerifier;
import oracle.ide.db.verifiers.table.LobParamsVerifier;
import oracle.ide.db.verifiers.table.StorageInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.ora.Oracle10g;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class PartitionListPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private static final String LOB_PARAMS_HELP_ID = "f1_odbtalobparams_html";
    private static final String STOR_OPTS_HELP_ID = "f1_odbtastoropts_html";
    private static final String PART_DEFS_HELP_ID = "f1_odbtapartdefs_html";
    private OracleTablePartitions.ObjectType m_objectType;
    private OracleTablePartitions.PartitionType m_partType;
    private OracleTablePartitions.PartitionType m_subpartType;
    protected DBObjectProvider m_pro;
    private Table m_table;
    String m_parentPartitionName;
    private TablePartition m_currentPartition;
    private boolean m_editing;
    private Table m_origTable;
    private Set<TablePartition> m_allPartitions;
    private Map<TablePartition, OracleStorageProperties> m_partitionStoragePropertiesMap = new HashMap<TablePartition, OracleStorageProperties>();
    private Map m_lobColumnPropertiesMap;
    private JWrappedLabel m_descLabel = new JWrappedLabel();
    private JLabel m_nameLabel = new JLabel();
    private JTextField m_nameField = new JTextField("");
    private DefaultListModel m_partListModel = new DefaultListModel();
    private JList m_partList = new JList(this.m_partListModel);
    private JLabel m_partLabel = new JLabel();
    private ListButtons m_partButtons = new ListButtons(this.m_partList, new ButtonsHelper());
    private JPanel m_editPanel = new JPanel();
    private JLabel m_valuesLabel = new JLabel();
    private JTextField m_valuesField = new JTextField();
    private JButton m_storageButton = new JButton();
    private JButton m_subPartsButton = new JButton();
    private JButton m_lobParametersButton = new JButton();
    private JCheckBox m_compressCheckBox = new JCheckBox();
    private final StorageInfoVerifier _partitionStorageInfoVerifier = new PartitionStorageInfoVerifier();
    private final StorageInfoVerifier _editLobPartitionStorageInfoVerifier = new EditLobPartitionStorageInfoVerifier();
    private final StorageInfoVerifier _hashPartitionLobStorageInfoVerifier = new HashPartitionLobStorageInfoVerifier();
    private final LobParamsVerifier _hashPartitionLobParamsVerifier = new HashPartitionLobParamsVerifier();

    public PartitionListPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_partList.setSelectionMode(0);
        this.m_partList.addListSelectionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_nameLabel, (Component)this.m_nameField, (String)UIArb.getString(484));
        ResourceUtils.resButton((AbstractButton)this.m_storageButton, (String)UIArb.getString(504));
        this.m_storageButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_lobParametersButton, (String)UIArb.getString(505));
        this.m_lobParametersButton.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_subPartsButton, (String)UIArb.getString(486));
        ResourceUtils.resButton((AbstractButton)this.m_compressCheckBox, (String)UIArb.getString(503));
        this.m_subPartsButton.addActionListener(this);
        int y = 0;
        this.add((Component)this.m_descLabel, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)new JScrollPane(this.m_partList), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.add((Component)this.m_partButtons, new GridBagConstraints(1, y, 1, 1, 0.0, 1.0, 11, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.setLayout(new GridBagLayout());
        this.add((Component)this.m_editPanel, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        this.setComponentNames(null);
    }

    public void setComponentNames(String baseName) {
        if (ModelUtil.hasLength((String)baseName)) {
            this.setName(baseName);
            baseName = baseName + '.';
        } else {
            baseName = "";
        }
        this.m_nameField.setName(baseName + "FLD_PARTITION_NAME");
        this.m_storageButton.setName(baseName + "BTN_STORAGE");
        this.m_lobParametersButton.setName(baseName + "BTN_LOB_PARAMETERS");
        this.m_subPartsButton.setName(baseName + "BTN_SUB_PARTITIONS");
        this.m_partList.setName(baseName + "LST_PARTITIONS");
        this.m_partButtons.setName(baseName + "BTN_PARTITIONS");
        this.m_partButtons.setButtonNames(baseName + "BTN_PARTITIONS");
        this.m_editPanel.setName(baseName + "PNL_EDIT");
        this.m_valuesField.setName(baseName + "FLD_VALUES");
        this.m_compressCheckBox.setName(baseName + "CBX_COMPRESS");
    }

    private void layoutEditPanel() {
        int descID = 498;
        int titleID = 478;
        OracleTablePartitions.PartitionType topPartType = this.m_partType;
        OracleTablePartitions.PartitionType subType = null;
        if (this.m_objectType != OracleTablePartitions.ObjectType.PARTITION) {
            if (this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION || this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
                descID = 500;
                titleID = 479;
            } else if (this.m_objectType == OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) {
                descID = 499;
                titleID = 480;
            }
            OracleTablePartitions otp = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
            topPartType = otp.getPartitionType();
            subType = this.m_partType;
        }
        this.m_descLabel.setText(UIArb.format(descID, topPartType, subType));
        ResourceUtils.resLabel((JLabel)this.m_partLabel, (Component)this.m_partList, (String)UIArb.getString(titleID));
        this.m_editPanel.removeAll();
        this.m_editPanel.setBorder(BorderFactory.createTitledBorder(this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? UIArb.getString(482) : UIArb.getString(483)));
        int y = 0;
        this.m_editPanel.add((Component)this.m_nameLabel, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_editPanel.add((Component)this.m_nameField, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_partType == OracleTablePartitions.PartitionType.RANGE || this.m_partType == OracleTablePartitions.PartitionType.LIST) {
            String ddlsnippet = this.m_partType == OracleTablePartitions.PartitionType.RANGE ? "VALUES LESS THAN" : "VALUES";
            ResourceUtils.resLabel((JLabel)this.m_valuesLabel, (Component)this.m_valuesField, (String)UIArb.format(485, ddlsnippet));
            this.m_editPanel.add((Component)this.m_valuesLabel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_editPanel.add((Component)this.m_valuesField, new GridBagConstraints(1, y, 3, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
        }
        this.m_editPanel.add((Component)this.m_compressCheckBox, new GridBagConstraints(2, ++y, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 0), 0, 0));
        JPanel buttPnl = new JPanel(new GridBagLayout());
        buttPnl.add((Component)this.m_lobParametersButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        buttPnl.add((Component)this.m_storageButton, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_subpartType != null) {
            buttPnl.add((Component)this.m_subPartsButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.m_editPanel.add((Component)buttPnl, new GridBagConstraints(0, ++y, 4, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.validate();
    }

    @Deprecated
    public void init(DBObjectProvider pro, OracleTablePartitions otp, Table table, Set<TablePartition> allPartitions, String parentPartitionName, String[] tablespaces, Table origTable) {
        this.init(pro, otp, table, allPartitions, parentPartitionName, origTable);
    }

    public void init(DBObjectProvider pro, OracleTablePartitions otp, Table table, Set<TablePartition> allPartitions, String parentPartitionName, Table origTable) {
        this.m_pro = pro;
        this.m_table = table;
        this.m_allPartitions = allPartitions;
        this.m_parentPartitionName = parentPartitionName;
        this.m_editing = origTable != null;
        this.m_origTable = origTable;
        TablePartition[] partitions = otp.getPartitions();
        OracleTablePartitions subparts = otp.getSubpartitionModel();
        this.m_subpartType = subparts == null ? null : subparts.getPartitionType();
        this.m_objectType = otp.getObjectType();
        this.m_partType = otp.getPartitionType();
        this.m_partListModel.removeAllElements();
        if (partitions != null) {
            for (int i = 0; i < partitions.length; ++i) {
                this.m_partListModel.addElement(partitions[i]);
            }
        }
        this.layoutEditPanel();
        this.initCurrentPartition();
        this.m_partButtons.enableButtons();
    }

    public TablePartition[] getPartitions() throws ValidationException {
        if (this.m_currentPartition != null) {
            this.commitCurrentPartition();
        }
        TablePartition[] parts = new TablePartition[this.m_partListModel.getSize()];
        Enumeration model = this.m_partListModel.elements();
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = (TablePartition)model.nextElement();
        }
        return parts;
    }

    private boolean tryCommitCurrentPartition() {
        try {
            this.commitCurrentPartition();
        }
        catch (ValidationException ve) {
            MessageDialog.error((Component)this, (Object)ve.getMessage(), (String)ve.getTitle(), null);
            return false;
        }
        return true;
    }

    private void commitCurrentPartition() throws ValidationException {
        String name = this.m_nameField.getText();
        if (ModelUtil.hasLength((String)name)) {
            this.m_pro.validateName("PARTITION", name);
            this.m_currentPartition.setName(this.m_pro.getInternalName(name));
            this.m_allPartitions.add(this.m_currentPartition);
            this.validateNameIsUnique(this.m_currentPartition.getName());
        } else {
            if (!(this.m_pro instanceof Database)) {
                name = this.m_currentPartition.getName();
                this.m_nameField.setText(this.m_pro.getExternalName(name));
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(497));
            }
            this.m_currentPartition.setName(null);
        }
        this.m_currentPartition.setValues(this.m_valuesField.getText());
        if (this.m_currentPartition.getObjectType().equals((Object)OracleTablePartitions.ObjectType.PARTITION) && !this.m_currentPartition.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH)) {
            this.m_currentPartition.setCompression(this.m_compressCheckBox.isSelected() ? "COMPRESS" : "NOCOMPRESS");
        } else {
            this.m_currentPartition.setCompression(null);
        }
        this.m_pro.validateObject((DBObject)this.m_currentPartition);
    }

    private void initCurrentPartition() {
        boolean en;
        boolean bl = en = this.m_currentPartition != null;
        if (en) {
            String name = this.m_currentPartition.getName();
            if (ModelUtil.hasLength((String)name)) {
                this.m_nameField.setText(this.m_pro.getExternalName(name));
            } else {
                this.m_nameField.setText(null);
            }
            Object[] values = this.m_currentPartition.getValues();
            StringBuffer buff = new StringBuffer();
            for (int i = 0; i < values.length; ++i) {
                buff.append(values[i].toString());
                if (i >= values.length - 1) continue;
                buff.append(",");
            }
            this.m_valuesField.setText(buff.toString());
            this.m_compressCheckBox.setSelected("COMPRESS".equals(this.m_currentPartition.getCompression()));
        } else {
            this.m_nameField.setText(null);
            this.m_valuesField.setText(null);
            this.m_compressCheckBox.setSelected(false);
        }
        this.m_nameField.setEnabled(en);
        this.m_nameLabel.setEnabled(en);
        this.m_valuesField.setEnabled(en && this.enableValuesField());
        this.m_valuesLabel.setEnabled(en);
        this.m_storageButton.setEnabled(en);
        this.m_lobParametersButton.setEnabled(en && this.enableLobParametersButton());
        this.m_subPartsButton.setEnabled(en);
        this.m_compressCheckBox.setEnabled(en && this.enableCompressCbx());
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.m_descLabel.setEnabled(enabled);
        this.m_partLabel.setEnabled(enabled);
        this.m_partList.setEnabled(enabled);
        this.m_partButtons.setEnabled(enabled);
        if (!enabled) {
            this.m_partList.setSelectedValue(null, false);
        }
        this.initCurrentPartition();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        TablePartition p = (TablePartition)this.m_partList.getSelectedValue();
        if (this.m_currentPartition != null && this.m_currentPartition != p && !this.tryCommitCurrentPartition()) {
            this.m_partList.setSelectedValue(this.m_currentPartition, true);
            return;
        }
        this.m_currentPartition = p;
        this.initCurrentPartition();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_subPartsButton) {
            if (this.m_currentPartition != null) {
                final OracleTablePartitions subparts = this.m_currentPartition.getPartitionLevelSubpartitions();
                final OracleTablePartitions editMe = subparts == null ? new OracleTablePartitions(this.m_subpartType, OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION) : subparts;
                JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)UIArb.getString(481), (int)7);
                final PartitionDefinitionPanel panel = new PartitionDefinitionPanel();
                panel.setHelpID(PART_DEFS_HELP_ID);
                dialog.setContent((Component)((Object)panel));
                dialog.setResizable(true);
                dialog.setSize(500, 300);
                if (this.tryCommitCurrentPartition()) {
                    panel.init(this.m_pro, this.m_table, editMe, this.m_allPartitions, this.m_currentPartition.getName(), this.m_origTable);
                    VetoableChangeListener list = new VetoableChangeListener(){

                        @Override
                        public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                            if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                                try {
                                    if (subparts == null) {
                                        PartitionListPanel.this.m_currentPartition.setPartitionLevelSubpartitions(editMe);
                                    }
                                    panel.commit(PartitionListPanel.this.m_table, editMe, null, false);
                                    PartitionListPanel.this.m_allPartitions.remove(PartitionListPanel.this.m_currentPartition);
                                    PartitionListPanel.this.m_pro.validateObjectProperty((DBObject)PartitionListPanel.this.m_currentPartition, "partitionLevelSubpartitions");
                                }
                                catch (ValidationException ve) {
                                    MessageDialog.error((Component)PartitionListPanel.this, (Object)ve.getMessage(), (String)ve.getTitle(), null);
                                    throw new PropertyVetoException(ve.getMessage(), evt);
                                }
                            }
                        }
                    };
                    dialog.addVetoableChangeListener(list);
                    dialog.runDialog();
                }
            }
        } else if (source == this.m_storageButton) {
            String title;
            String string = title = this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? UIArb.getString(492) : UIArb.getString(493);
            if (this.m_objectType == OracleTablePartitions.ObjectType.PARTITION && this.m_partType != OracleTablePartitions.PartitionType.HASH) {
                OracleStorageProperties osp = this.m_currentPartition.getSegmentAttributes();
                osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.TABLE_PARTITION, this.m_pro, (DBObject)this.m_currentPartition, (DBObject)this.m_table, this.getPartitionStorageInfoVerifier(), this);
                this.m_currentPartition.setSegmentAttributes(osp);
                this.m_partitionStoragePropertiesMap.put(this.m_currentPartition, osp);
            } else {
                JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)title, (int)7);
                final PartitionStoragePanel panel = new PartitionStoragePanel();
                panel.init(this.m_pro, this.m_currentPartition);
                panel.setPreferredSize(new Dimension(300, 50));
                panel.setHelpID(STOR_OPTS_HELP_ID);
                dialog.setContent((Component)((Object)panel));
                dialog.setResizable(true);
                VetoableChangeListener list = new VetoableChangeListener(){

                    @Override
                    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                        if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                            try {
                                ((PartitionStoragePanel)panel).commit(PartitionListPanel.this.m_pro, PartitionListPanel.this.m_currentPartition, PartitionListPanel.this.m_table);
                            }
                            catch (ValidationException ve) {
                                MessageDialog.error((Component)PartitionListPanel.this, (Object)ve.getMessage(), (String)ve.getTitle(), null);
                                throw new PropertyVetoException(ve.getMessage(), evt);
                            }
                        }
                    }
                };
                dialog.addVetoableChangeListener(list);
                dialog.runDialog();
            }
        } else if (source == this.m_lobParametersButton) {
            String title = UIArb.getString(494);
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)this), (String)title, (int)7);
            final LobDescriptorPanel panel = new LobDescriptorPanel(this.m_lobColumnPropertiesMap);
            panel.setHelpID(LOB_PARAMS_HELP_ID);
            final ArrayList<LOBDescriptor> lobDescriptorList = new ArrayList<LOBDescriptor>(this.m_currentPartition.getLOBDescriptors().length);
            for (LOBDescriptor lobDescriptor : this.m_currentPartition.getLOBDescriptors()) {
                lobDescriptorList.add(lobDescriptor);
            }
            panel.init(this.m_pro, this.m_table, lobDescriptorList, this.getLobParamsVerifier(), this.getLobPartitionStorageInfoVerifier());
            panel.setPreferredSize(new Dimension(600, 300));
            dialog.setContent((Component)((Object)panel));
            dialog.setResizable(true);
            VetoableChangeListener list = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        try {
                            PartitionListPanel.this.m_lobColumnPropertiesMap = panel.commit(lobDescriptorList);
                            LOBDescriptor[] lobDescriptors = lobDescriptorList.toArray(new LOBDescriptor[lobDescriptorList.size()]);
                            PartitionListPanel.this.m_currentPartition.setLOBDescriptors(lobDescriptors);
                            PartitionListPanel.this.m_pro.validateObjectProperty((DBObject)PartitionListPanel.this.m_currentPartition, "LOBDescriptors");
                        }
                        catch (TraversalException te) {
                            MessageDialog.error((Component)PartitionListPanel.this, (Object)te.getMessage(), null, null);
                            throw new PropertyVetoException(te.getMessage(), evt);
                        }
                        catch (ValidationException ve) {
                            MessageDialog.error((Component)PartitionListPanel.this, (Object)ve.getMessage(), (String)ve.getTitle(), null);
                            throw new PropertyVetoException(ve.getMessage(), evt);
                        }
                    }
                }
            };
            dialog.addVetoableChangeListener(list);
            dialog.runDialog();
        }
    }

    private String getInitialName() {
        Set names;
        String prefix = this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? UIArb.getString(462) : UIArb.getString(463);
        int n = 1;
        String name = this.makeName(prefix, n);
        Set set = names = this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE ? this.getSubpartitionTemplateNames() : this.getPartitionNames();
        while (names.contains(name)) {
            name = this.makeName(prefix, ++n);
        }
        return name;
    }

    private String makeName(String prefix, int n) {
        String name = (ModelUtil.hasLength((String)this.m_parentPartitionName) ? this.m_parentPartitionName + '_' : "") + prefix + n;
        while (name.length() > 30) {
            this.m_parentPartitionName = this.m_parentPartitionName.substring(0, this.m_parentPartitionName.length() - 1);
            name = this.m_parentPartitionName + '_' + prefix + n;
        }
        return name;
    }

    private void validateNameIsUnique(String name) throws ValidationException {
        if (this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            Set names = this.getSubpartitionTemplateNames();
            if (names.contains(name)) {
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(495));
            }
        } else {
            Set names = this.getPartitionNames();
            if (names.contains(name)) {
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(496));
            }
        }
    }

    private Set getSubpartitionTemplateNames() {
        Enumeration subpartitions;
        HashSet<String> names = new HashSet<String>();
        Enumeration enumeration = subpartitions = this.m_partListModel != null ? this.m_partListModel.elements() : null;
        if (subpartitions != null) {
            while (subpartitions.hasMoreElements()) {
                TablePartition subpartition = (TablePartition)subpartitions.nextElement();
                if (subpartition == this.m_currentPartition) continue;
                names.add(subpartition.getName());
            }
        }
        return names;
    }

    private Set getPartitionNames() {
        HashSet<String> names = new HashSet<String>();
        if (this.m_allPartitions != null) {
            for (TablePartition partition : this.m_allPartitions) {
                if (partition == this.m_currentPartition) continue;
                names.add(partition.getName());
            }
        }
        return names;
    }

    private StorageInfoVerifier getPartitionStorageInfoVerifier() {
        this._partitionStorageInfoVerifier.initializeVerifier(this.m_pro, null, (SchemaObject)this.m_table);
        return this._partitionStorageInfoVerifier;
    }

    private StorageInfoVerifier getLobPartitionStorageInfoVerifier() {
        StorageInfoVerifier verifier;
        StorageInfoVerifier storageInfoVerifier = this.m_partType == OracleTablePartitions.PartitionType.HASH && this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? this._hashPartitionLobStorageInfoVerifier : (verifier = this.m_editing && this.m_pro instanceof Database ? this._editLobPartitionStorageInfoVerifier : null);
        if (verifier != null) {
            verifier.initializeVerifier(this.m_pro, null, (SchemaObject)this.m_table);
        }
        return verifier;
    }

    private LobParamsVerifier getLobParamsVerifier() {
        LobParamsVerifier verifier;
        LobParamsVerifier lobParamsVerifier = verifier = this.m_partType == OracleTablePartitions.PartitionType.HASH && this.m_objectType == OracleTablePartitions.ObjectType.PARTITION ? this._hashPartitionLobParamsVerifier : null;
        if (verifier != null) {
            verifier.initializeVerifier(this.m_pro, null, (SchemaObject)this.m_table);
        }
        return verifier;
    }

    private boolean enableValuesField() {
        if (this.m_pro instanceof Database && this.m_currentPartition.getPartitionType() == OracleTablePartitions.PartitionType.RANGE && this.m_origTable != null) {
            OracleTablePartitions otp = (OracleTablePartitions)this.m_origTable.getProperty("OracleTablePartitions");
            for (TablePartition partition : otp.getPartitions()) {
                if (partition.getPartitionType() != OracleTablePartitions.PartitionType.RANGE || !partition.getName().equals(this.m_currentPartition.getName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean enableLobParametersButton() {
        if (this.m_table != null) {
            for (Column column : this.m_table.getColumns()) {
                DBObjectID colID = column.getID();
                if (colID == null) {
                    colID = TemporaryObjectID.createID((DBObject)column);
                }
                if (!LOBDescriptor.isLOBColumn((DBObjectID)colID) && !LOBDescriptor.isVARRAYColumn((DBObjectID)colID)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean enableCompressCbx() {
        return this.m_currentPartition != null && this.m_currentPartition.getObjectType().equals((Object)OracleTablePartitions.ObjectType.PARTITION) && !this.m_currentPartition.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH);
    }

    private class EditLobPartitionStorageInfoVerifier
    extends PartitionStorageInfoVerifier {
        private EditLobPartitionStorageInfoVerifier() {
        }

        @Override
        public boolean canChangePercentUsed() {
            return false;
        }

        @Override
        public boolean canChangeInitrans() {
            return false;
        }

        @Override
        public boolean canChangeMaxtrans() {
            return false;
        }

        @Override
        public boolean canChangeNextExtent() {
            return false;
        }

        @Override
        public boolean canChangeMinExtent() {
            return false;
        }

        @Override
        public boolean canChangeMaxExtent() {
            return false;
        }

        @Override
        public boolean canChangePercentIncrease() {
            return false;
        }

        @Override
        public boolean canChangeLogging() {
            return false;
        }

        @Override
        public boolean canChangeFreelists() {
            return false;
        }

        @Override
        public boolean canChangeFreelistGroups() {
            return false;
        }
    }

    private class PartitionStorageInfoVerifier
    extends AbstractTableVerifier
    implements StorageInfoVerifier {
        private PartitionStorageInfoVerifier() {
        }

        @Override
        public boolean canChangeTablespace() {
            return true;
        }

        @Override
        public boolean canEditTablespace() {
            return true;
        }

        @Override
        public boolean canChangePercentFree() {
            return true;
        }

        @Override
        public boolean canChangePercentUsed() {
            return PartitionListPanel.this.m_table.getProperty("TableType") != Table.TableType.INDEX_ORGANIZED;
        }

        @Override
        public boolean canChangeInitrans() {
            return true;
        }

        @Override
        public boolean canChangeMaxtrans() {
            return true;
        }

        @Override
        public boolean canChangeInitialExtent() {
            return true;
        }

        @Override
        public boolean canChangeNextExtent() {
            return true;
        }

        @Override
        public boolean canChangeMinExtent() {
            return true;
        }

        @Override
        public boolean canChangeMaxExtent() {
            return true;
        }

        @Override
        public boolean canChangePercentIncrease() {
            return true;
        }

        @Override
        public boolean canChangeLogging() {
            return true;
        }

        @Override
        public boolean canChangeFreelists() {
            return true;
        }

        @Override
        public boolean canChangeFreelistGroups() {
            return true;
        }

        @Override
        public boolean canChangeBufferMode() {
            return true;
        }

        @Override
        public void verifyRelation() throws TraversalException {
        }

        @Override
        public void verifyStorage(OracleStorageProperties props) throws TraversalException {
        }
    }

    private class HashPartitionLobStorageInfoVerifier
    extends AbstractTableVerifier
    implements StorageInfoVerifier {
        private HashPartitionLobStorageInfoVerifier() {
        }

        @Override
        public boolean canChangeTablespace() {
            return !(PartitionListPanel.this.m_pro instanceof Oracle10g);
        }

        @Override
        public boolean canEditTablespace() {
            return !(PartitionListPanel.this.m_pro instanceof OracleDatabase);
        }

        @Override
        public boolean canChangePercentFree() {
            return false;
        }

        @Override
        public boolean canChangePercentUsed() {
            return false;
        }

        @Override
        public boolean canChangeInitrans() {
            return false;
        }

        @Override
        public boolean canChangeMaxtrans() {
            return false;
        }

        @Override
        public boolean canChangeInitialExtent() {
            return false;
        }

        @Override
        public boolean canChangeNextExtent() {
            return false;
        }

        @Override
        public boolean canChangeMinExtent() {
            return false;
        }

        @Override
        public boolean canChangeMaxExtent() {
            return false;
        }

        @Override
        public boolean canChangePercentIncrease() {
            return false;
        }

        @Override
        public boolean canChangeLogging() {
            return false;
        }

        @Override
        public boolean canChangeFreelists() {
            return false;
        }

        @Override
        public boolean canChangeFreelistGroups() {
            return false;
        }

        @Override
        public boolean canChangeBufferMode() {
            return false;
        }

        @Override
        public void verifyRelation() throws TraversalException {
        }

        @Override
        public void verifyStorage(OracleStorageProperties props) throws TraversalException {
        }
    }

    private class HashPartitionLobParamsVerifier
    extends AbstractTableVerifier
    implements LobParamsVerifier {
        private HashPartitionLobParamsVerifier() {
        }

        @Override
        public boolean canChangeCache() {
            return false;
        }

        @Override
        public boolean canChangeSegName() {
            return true;
        }

        @Override
        public boolean canChangeChunk() {
            return false;
        }

        @Override
        public boolean canChangePctVersion() {
            return false;
        }

        @Override
        public boolean canChangeFreepools() {
            return false;
        }

        @Override
        public boolean canChangeStoreInRow() {
            return false;
        }

        @Override
        public boolean canChangeRetention() {
            return false;
        }

        @Override
        public void checkPctVersionAndRetention(String pctVersion, boolean retention) throws TraversalException {
        }
    }

    private class ButtonsHelper
    extends ListButtons.Controller {
        private ButtonsHelper() {
        }

        @Override
        public boolean canAdd() {
            TablePartition part;
            Object[] values;
            return !PartitionListPanel.this.m_editing || PartitionListPanel.this.m_partType != OracleTablePartitions.PartitionType.LIST || PartitionListPanel.this.m_partListModel.size() <= 0 || (values = (part = (TablePartition)PartitionListPanel.this.m_partListModel.get(PartitionListPanel.this.m_partListModel.size() - 1)).getValues()).length != 1 || !values[0].equals("DEFAULT");
        }

        public boolean canAdd(Object val) {
            return true;
        }

        @Override
        public boolean canMoveDown(Object val) {
            return true;
        }

        @Override
        public boolean canMoveUp(Object val) {
            return true;
        }

        @Override
        public boolean canRemove() {
            if (PartitionListPanel.this.m_editing && PartitionListPanel.this.m_pro instanceof Database) {
                return PartitionListPanel.this.m_objectType == OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE || PartitionListPanel.this.m_partType != OracleTablePartitions.PartitionType.HASH || PartitionListPanel.this.m_objectType != OracleTablePartitions.ObjectType.PARTITION && PartitionListPanel.this.m_objectType != OracleTablePartitions.ObjectType.PARTITION_LEVEL_SUBPARTITION;
            }
            return true;
        }

        @Override
        public boolean canRemove(Object val) {
            return true;
        }

        @Override
        public boolean canReorder() {
            return !PartitionListPanel.this.m_editing || !(PartitionListPanel.this.m_pro instanceof Database);
        }

        @Override
        public String getAddTooltipText() {
            return null;
        }

        @Override
        public String getDownTooltipText() {
            return null;
        }

        @Override
        public String getRemoveTooltipText() {
            return null;
        }

        @Override
        public String getUpTooltipText() {
            return null;
        }

        @Override
        public boolean includeAddRemoveButtons() {
            return true;
        }

        @Override
        public boolean includeReorderButtons() {
            return true;
        }

        @Override
        public void addToList() {
            if (PartitionListPanel.this.m_currentPartition == null || PartitionListPanel.this.tryCommitCurrentPartition()) {
                PartitionListPanel.this.m_currentPartition = null;
                int i = PartitionListPanel.this.m_partList.getSelectedIndex();
                i = i < 0 ? PartitionListPanel.this.m_partListModel.size() : i + 1;
                TablePartition partition = (TablePartition)PartitionListPanel.this.m_pro.getObjectFactory().newObject(TablePartition.class, (DBObject)((OracleTablePartitions)PartitionListPanel.this.m_table.getProperty("OracleTablePartitions")));
                partition.setObjectType(PartitionListPanel.this.m_objectType);
                partition.setPartitionType(PartitionListPanel.this.m_partType);
                if (partition.getName() == null) {
                    partition.setName(PartitionListPanel.this.getInitialName());
                }
                PartitionListPanel.this.m_partListModel.add(i, partition);
                PartitionListPanel.this.m_partList.setSelectedIndex(i);
                if (PartitionListPanel.this.m_partType == OracleTablePartitions.PartitionType.LIST || PartitionListPanel.this.m_partType == OracleTablePartitions.PartitionType.RANGE) {
                    PartitionListPanel.this.m_valuesField.requestFocus();
                } else {
                    PartitionListPanel.this.m_nameField.requestFocus();
                }
            }
        }

        @Override
        public void removeFromList() {
            int i = PartitionListPanel.this.m_partList.getSelectedIndex();
            if (i >= 0) {
                PartitionListPanel.this.m_allPartitions.remove(PartitionListPanel.this.m_currentPartition);
                PartitionListPanel.this.m_currentPartition = null;
                PartitionListPanel.this.m_partListModel.remove(i);
            }
        }

        @Override
        public void objectMovedUp(Object obj) {
        }

        @Override
        public void objectMovedDown(Object obj) {
        }
    }
}

