/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.HashPartitionQuantityPanel;
import oracle.ide.db.panels.table.PartitionListPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;

public class PartitionDefinitionPanel
extends BaseInfoPanel
implements ActionListener {
    private boolean m_subpartTemplates;
    private boolean m_editing;
    private boolean m_alive;
    private DBObjectProvider m_pro;
    private Table m_table;
    private OracleTablePartitions m_parts;
    private Set<TablePartition> m_allPartitions;
    private String m_parentPartitionName;
    private Table m_origTable;
    private JComboBox m_hashDefinitionTypeComboBox;
    private JLabel m_hashDefinitionTypeLabel = new JLabel();
    private HashPartitionQuantityPanel m_hashPanel;
    private PartitionListPanel m_listPanel;
    private TablePartition[] m_tablePartitions;

    public PartitionDefinitionPanel() {
        this(false);
    }

    public PartitionDefinitionPanel(boolean templates) {
        this.m_subpartTemplates = templates;
    }

    private void layoutComponents() {
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_listPanel == null) {
            this.m_listPanel = new PartitionListPanel();
        }
        this.add(this.m_listPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void layoutHashComponents(HashType hashType) {
        OracleTablePartitions.ObjectType otype = this.m_parts.getObjectType();
        this.removeAll();
        this.setLayout(new GridBagLayout());
        if (this.m_hashDefinitionTypeComboBox == null) {
            this.m_hashDefinitionTypeComboBox = new JComboBox();
            this.m_hashDefinitionTypeComboBox.setName("PartitionDefinitionPanel.CMB_HASH_DEFINITION");
            this.m_hashDefinitionTypeComboBox.addActionListener(this);
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(468));
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(470));
            this.m_hashDefinitionTypeComboBox.addItem(UIArb.getString(471));
            ResourceUtils.resLabel((JLabel)this.m_hashDefinitionTypeLabel, (Component)this.m_hashDefinitionTypeComboBox, (String)UIArb.getString(467));
        }
        int item = hashType == HashType.INDIVIDUAL ? 470 : (hashType == HashType.QUANTITY ? 471 : 468);
        this.m_hashDefinitionTypeComboBox.setSelectedItem(UIArb.getString(item));
        JPanel panel = null;
        if (hashType == HashType.INDIVIDUAL) {
            if (this.m_listPanel == null) {
                this.m_listPanel = new PartitionListPanel();
            }
            panel = this.m_listPanel;
        } else if (hashType == HashType.QUANTITY) {
            if (this.m_hashPanel == null) {
                this.m_hashPanel = new HashPartitionQuantityPanel();
            }
            panel = this.m_hashPanel;
        }
        JPanel hashDefinitionTypePanel = new JPanel(new GridBagLayout());
        hashDefinitionTypePanel.add((Component)this.m_hashDefinitionTypeLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        hashDefinitionTypePanel.add((Component)this.m_hashDefinitionTypeComboBox, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 10, 0, 5), 0, 0));
        int y = 0;
        this.add(hashDefinitionTypePanel, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 18, 0, new Insets(5, 5, 10, 5), 0, 0));
        if (this.m_editing && this.m_pro instanceof Database && otype != OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE) {
            this.m_hashDefinitionTypeComboBox.setEnabled(false);
        } else {
            this.m_hashDefinitionTypeComboBox.setEnabled(true);
        }
        if (panel != null) {
            this.add(panel, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            panel.setEnabled(true);
        } else {
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.setPreferredSize(new Dimension(500, 300));
        this.validate();
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        Table origTab = (Table)dataContext.get("OriginalObject");
        OracleTablePartitions otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions");
        if (this.m_subpartTemplates) {
            OracleTablePartitions oracleTablePartitions = otp = otp == null ? null : otp.getSubpartitionModel();
        }
        if (otp == null) {
            this.setEnabled(false);
        } else {
            this.init(pro, tab, otp, this.getAllPartitions(otp), null, origTab);
            this.setEnabled((Boolean)dataContext.find("DBObjectIsEditable"));
        }
        int arraySize = otp == null ? 0 : otp.getPartitions().length;
        this.m_tablePartitions = new TablePartition[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            this.m_tablePartitions[i] = otp.getPartitions()[i];
        }
    }

    private Set<TablePartition> getAllPartitions(OracleTablePartitions otp) {
        HashSet<TablePartition> allPartitions = new HashSet<TablePartition>();
        for (TablePartition partition : otp.getPartitions()) {
            allPartitions.add(partition);
            if (partition.getPartitionLevelSubpartitions() == null) continue;
            for (TablePartition subpartition : partition.getPartitionLevelSubpartitions().getPartitions()) {
                allPartitions.add(subpartition);
            }
        }
        return allPartitions;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        Table tab = (Table)dataContext.get("NewObject");
        OracleTablePartitions otp = (OracleTablePartitions)tab.getProperty("OracleTablePartitions");
        OracleTablePartitions parentModel = null;
        if (this.m_subpartTemplates) {
            parentModel = otp;
            OracleTablePartitions oracleTablePartitions = otp = otp == null ? null : otp.getSubpartitionModel();
        }
        if (otp != null) {
            try {
                this.commit(tab, otp, parentModel, dataContext.getDirection() != 2);
            }
            catch (ValidationException ve) {
                throw new TraversalException(ve.getMessage(), ve.getTitle());
            }
            int numPartitions = otp.getPartitions().length;
            for (Index ind : tab.getIndexes()) {
                OracleIndexPartitions ip = (OracleIndexPartitions)ind.getProperty("OracleIndexPartitions");
                if (ip == null || ip.getPartitionType() != OracleIndexPartitions.PartitionType.LOCAL_COMP && ip.getPartitionType() != OracleIndexPartitions.PartitionType.LOCAL_HASH && ip.getPartitionType() != OracleIndexPartitions.PartitionType.LOCAL_OTHER && ip.getPartitionType() != OracleIndexPartitions.PartitionType.DOMAIN) continue;
                if (numPartitions == 0) {
                    ip.setPartitions(null);
                    ind.setProperty("OracleIndexPartitions", null);
                    continue;
                }
                IndexPartition[] oldPartns = ip.getPartitions();
                IndexPartition[] newPartns = new IndexPartition[numPartitions];
                for (int newIdx = 0; newIdx < numPartitions; ++newIdx) {
                    newPartns[newIdx] = null;
                    for (int oldIndex = 0; oldIndex < this.m_tablePartitions.length; ++oldIndex) {
                        if (otp.getPartitions()[newIdx].getID() == null || !otp.getPartitions()[newIdx].getID().equals(this.m_tablePartitions[oldIndex].getID())) continue;
                        newPartns[newIdx] = oldPartns[oldIndex];
                        break;
                    }
                    if (newPartns[newIdx] != null) continue;
                    newPartns[newIdx] = new IndexPartition();
                }
                ip.setPartitions(newPartns);
            }
            this.m_tablePartitions = null;
        }
    }

    @Deprecated
    protected void init(DBObjectProvider pro, Table tab, OracleTablePartitions otp, Set<TablePartition> allPartitions, String parentPartitionName, String[] tablespaces, Table origTable) {
        this.init(pro, tab, otp, allPartitions, parentPartitionName, origTable);
    }

    protected void init(DBObjectProvider pro, Table tab, OracleTablePartitions otp, Set<TablePartition> allPartitions, String parentPartitionName, Table origTable) {
        this.m_alive = false;
        this.m_pro = pro;
        this.m_table = tab;
        this.m_parts = otp;
        this.m_allPartitions = allPartitions;
        this.m_parentPartitionName = parentPartitionName;
        this.m_editing = origTable != null;
        this.m_origTable = origTable;
        if (this.m_subpartTemplates) {
            otp.setObjectType(OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE);
        }
        OracleTablePartitions.PartitionType type = otp.getPartitionType();
        TablePartition[] partitions = otp.getPartitions();
        if (type == OracleTablePartitions.PartitionType.HASH) {
            if (partitions != null && partitions.length > 0) {
                this.layoutHashComponents(HashType.INDIVIDUAL);
                this.m_listPanel.init(this.m_pro, otp, this.m_table, allPartitions, parentPartitionName, origTable);
            } else if (otp.getHashQuantity() != null) {
                this.layoutHashComponents(HashType.QUANTITY);
                this.m_hashPanel.init(this.m_pro, otp, this.m_editing);
            } else {
                this.layoutHashComponents(HashType.DEFAULT);
            }
            this.m_alive = true;
        } else if (type == OracleTablePartitions.PartitionType.LIST || type == OracleTablePartitions.PartitionType.RANGE) {
            this.layoutComponents();
            this.m_listPanel.init(this.m_pro, otp, this.m_table, allPartitions, parentPartitionName, origTable);
            this.m_alive = true;
        }
    }

    protected void commit(Table tab, OracleTablePartitions otp, OracleTablePartitions parentModel, boolean validate) throws ValidationException {
        if (this.m_alive) {
            OracleTablePartitions.PartitionType partType = otp.getPartitionType();
            if (partType == OracleTablePartitions.PartitionType.HASH && this.getSelectedHashType() != HashType.INDIVIDUAL) {
                otp.setPartitions(null);
                if (this.getSelectedHashType() == HashType.QUANTITY) {
                    this.m_hashPanel.commit(this.m_pro, tab, otp);
                } else {
                    otp.setHashQuantity(null);
                    otp.setHashQuantityTablespaces(null);
                }
            } else {
                otp.setPartitions(this.m_listPanel.getPartitions());
                otp.setHashQuantity(null);
                otp.setHashQuantityTablespaces(null);
            }
            if (this.m_subpartTemplates) {
                otp.setObjectType(otp.getPartitions().length > 0 ? OracleTablePartitions.ObjectType.SUBPARTITION_TEMPLATE : OracleTablePartitions.ObjectType.SUBPARTITION);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.m_hashPanel != null) {
            this.m_hashPanel.setEnabled(enabled);
        }
        if (this.m_listPanel != null) {
            this.m_listPanel.setEnabled(enabled);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source != null && source == this.m_hashDefinitionTypeComboBox) {
            HashType hashType = this.getSelectedHashType();
            this.layoutHashComponents(hashType);
            if (hashType == HashType.INDIVIDUAL) {
                this.m_listPanel.init(this.m_pro, this.m_parts, this.m_table, this.m_allPartitions, this.m_parentPartitionName, this.m_origTable);
            } else if (hashType == HashType.QUANTITY) {
                this.m_hashPanel.init(this.m_pro, this.m_parts, this.m_editing);
            }
            this.repaint();
        }
    }

    private HashType getSelectedHashType() {
        String selectedType = (String)this.m_hashDefinitionTypeComboBox.getSelectedItem();
        return UIArb.getString(468).equals(selectedType) ? HashType.DEFAULT : (UIArb.getString(471).equals(selectedType) ? HashType.QUANTITY : HashType.INDIVIDUAL);
    }

    private static enum HashType {
        DEFAULT,
        INDIVIDUAL,
        QUANTITY;

    }
}

