/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.StorageInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.OracleTablePartitions;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyFilter;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.util.ModelUtil;

public class IndexPartitionsPanel
extends BaseInfoPanel
implements ActionListener,
ListSelectionListener {
    private boolean m_isFirstEntry = true;
    private boolean m_isEditable = false;
    private boolean m_isCompressed = false;
    private boolean m_failedToCommit = false;
    private PanelType m_panelType;
    private DBObjectProvider m_provider;
    private Index m_index;
    private Table m_table;
    private OracleIndexPartitions m_globalIndexPartitionModel = this.createIndexPartitionModel();
    private OracleIndexPartitions m_localIndexPartitionModel = this.createIndexPartitionModel();
    private OracleIndexPartitions m_indexPartitionModel;
    private OracleTablePartitions m_tablePartitionModel;
    private int m_selectedTablePartitionIdx;
    private IndexPartition m_currentGlobalPartition;
    private OracleIndexPartitions m_subpartitionsModel;
    private Set<IndexPartition> m_sessionPartitions = new HashSet<IndexPartition>();
    private JButton m_btnStorage = new JButton();
    private JButton m_btnSubpartitions = new JButton();
    private JButton m_btnTablespaces = new JButton();
    private JLabel m_lblDescription = new JLabel();
    private JCheckBox m_cbxCompress = new JCheckBox();
    private JPanel m_pnlRegularIndexHeader = new JPanel();
    private JLabel m_lblPartitioning = new JLabel();
    private JRadioButton m_rdbGlobal = new JRadioButton();
    private JRadioButton m_rdbLocal = new JRadioButton();
    private JRadioButton m_rdbNone = new JRadioButton();
    private JLabel m_lblTablespace = new JLabel();
    private DBObjectChooser m_tblspaceChooser = new DBObjectChooser("TABLESPACE");
    private Map<IndexPartition, OracleStorageProperties> m_partitionStoragePropertiesMap = new HashMap<IndexPartition, OracleStorageProperties>();
    private JPanel m_pnlPartitionDefinition = new JPanel();
    private JPanel m_pnlTablePartitions = new JPanel();
    private JLabel m_lblTablePartitions = new JLabel();
    private DefaultListModel m_mdlTablePartitions = new DefaultListModel();
    private JList m_lstTablePartitions = new JList(this.m_mdlTablePartitions);
    private ListSelectionListener m_mdlTablePartitionsSelectionListener = new ListSelectionListener(){

        @Override
        public void valueChanged(ListSelectionEvent lse) {
            try {
                IndexPartitionsPanel.this.saveLocalPartition();
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            IndexPartitionsPanel.this.m_txtName.requestFocusInWindow();
        }
    };
    private FocusListener m_partitionNameFocusListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            block5: {
                try {
                    if (IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() != OracleIndexPartitions.PartitionType.GLOBAL_HASH && IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() != OracleIndexPartitions.PartitionType.GLOBAL_RANGE) break block5;
                    try {
                        if (e.getSource().equals(IndexPartitionsPanel.this.m_txtName)) {
                            IndexPartitionsPanel.this.m_provider.validateName("INDEX PARTITION", IndexPartitionsPanel.this.m_txtName.getText());
                        }
                    }
                    catch (ValidationException v) {
                        MessageDialog.error((Component)((Component)e.getSource()), (Object)v.getMessage(), (String)v.getTitle(), null);
                        return;
                    }
                    IndexPartitionsPanel.this.saveGlobalPartitionColumns();
                    IndexPartitionsPanel.this.saveGlobalPartition();
                }
                catch (ValidationException validationException) {
                    // empty catch block
                }
            }
        }
    };
    private JPanel m_pnlIndividualAndTablespaces = new JPanel();
    private JRadioButton m_rdbIndividual = new JRadioButton();
    private JRadioButton m_rdbTablespaces = new JRadioButton();
    private JPanel m_pnlGlobalIndexPartitions = new JPanel();
    private DefaultListModel m_mdlGlobalIndexPartitions = new DefaultListModel();
    private JList m_lstGlobalIndexPartitions = new JList(this.m_mdlGlobalIndexPartitions);
    private JLabel m_lblGlobalIndexPartitions = new JLabel();
    private ListButtons m_btnsGlobalIndexPartitions = new ListButtons(this.m_lstGlobalIndexPartitions, new ButtonsHelper());
    private JLabel m_lblName = new JLabel();
    private JTextField m_txtName = new JTextField("");
    private JLabel m_lblValuesLessThan = new JLabel();
    private JTextField m_txtValuesLessThan = new JTextField("");
    private JPanel m_pnlTablespacesShuttle = new JPanel();
    private JLabel m_lblTablespacesShuttle = new JLabel();
    private DefaultListModel m_tblsFromModel = new DefaultListModel();
    private ListPicker m_tblsFromPick = new ListPicker(new JList(this.m_tblsFromModel));
    private DefaultListModel m_tblsToModel = new DefaultListModel();
    private ReorderableListPicker m_tblsToPick = new ReorderableListPicker(new JList(this.m_tblsToModel));
    private Shuttle m_tblsShuttle = new Shuttle();
    private JPanel m_pnlGlobalPartitionBy = new JPanel();
    private JLabel m_lblGlobalPartitionColumns = new JLabel();
    private NonNullableComboBoxModel m_mdlGlobalPartitionColumns = new NonNullableComboBoxModel();
    private JComboBox m_cmbGlobalPartitionColumns = new JComboBox(this.m_mdlGlobalPartitionColumns);
    private JLabel m_lblGlobalPartitionBy = new JLabel();
    private JComboBox m_cmbGlobalPartitionBy = new JComboBox();
    private JPanel m_pnlGlobalIndividualAndQuantity = new JPanel();
    private JRadioButton m_rdbGlobalIndividual = new JRadioButton();
    private JRadioButton m_rdbGlobalQuantity = new JRadioButton();
    private JLabel m_hashCountLabel = new JLabel();
    private SpinnerNumberModel m_hashCountModel = new SpinnerNumberModel(new Integer(2), new Integer(1), null, new Integer(1));
    private JSpinner m_hashCountSpinner = new JSpinner(this.m_hashCountModel);
    private JPanel m_pnlDomainIndexHeader = new JPanel();
    private JLabel m_lblDomainPartitioning = new JLabel();
    private JRadioButton m_rdbDomainLocal = new JRadioButton();
    private JRadioButton m_rdbDomainNone = new JRadioButton();
    private JLabel m_lblIndextypeParameters = new JLabel();
    private JTextArea m_txtIndextypeParameters = new JTextArea();
    private static final String DEFAULT = "<DEFAULT>";
    private static final String RANGE = "RANGE";
    private static final String HASH = "HASH";

    public IndexPartitionsPanel() {
        this(PanelType.NONE);
    }

    public IndexPartitionsPanel(PanelType panelType) {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_panelType = panelType;
    }

    public void onEntry(TraversableContext dataContext) {
        if (this.m_failedToCommit) {
            return;
        }
        this.m_provider = (DBObjectProvider)dataContext.get("DBObjectProvider");
        this.m_index = (Index)dataContext.find("NewObject");
        this.m_isEditable = (Boolean)dataContext.find("DBObjectIsEditable");
        this.init(this.m_provider, this.m_index, null, null, -1, this.m_isEditable);
        if (!this.m_isEditable) {
            this.enableAllComponents(false, true);
        }
        this.m_txtName.addFocusListener(this.m_partitionNameFocusListener);
        this.m_txtValuesLessThan.addFocusListener(this.m_partitionNameFocusListener);
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public void commit() throws TraversalException {
        try {
            this.savePanel();
            if (this.m_panelType == PanelType.NONE) {
                this.m_index.setProperty("OracleIndexPartitions", null);
            } else {
                OracleIndexPartitions partitionModel = this.getCleanedIndexPartitionModel();
                this.m_provider.validateObject((DBObject)partitionModel);
                if (partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
                    this.m_currentGlobalPartition.setSubpartitions(partitionModel);
                } else {
                    this.m_index.setProperty("OracleIndexPartitions", (Object)partitionModel);
                    IndexPartition[] partitions = partitionModel.getPartitions();
                    if (partitions.length > 0) {
                        for (int i = 0; i < partitions.length; ++i) {
                            if (partitions[i].getSubpartitions() == null || this.m_subpartitionsModel == null || this.m_subpartitionsModel.getPartitions() == null || this.m_subpartitionsModel.getPartitions()[i].getSubpartitions() == null) continue;
                            partitions[i].setSubpartitions(this.m_subpartitionsModel.getPartitions()[i].getSubpartitions());
                        }
                    }
                }
            }
            this.m_failedToCommit = false;
        }
        catch (ValidationException ve) {
            this.m_failedToCommit = true;
            throw new TraversalException(ve.getMessage());
        }
    }

    @Deprecated
    public void init(DBObjectProvider provider, Index index, OracleIndexPartitions indexPartitionModel, String[] tablespaces, int selectedTablePartitionIdx, boolean isEditable) {
        this.init(provider, index, indexPartitionModel, selectedTablePartitionIdx, isEditable);
    }

    public void init(DBObjectProvider provider, Index index, OracleIndexPartitions indexPartitionModel, int selectedTablePartitionIdx, boolean isEditable) {
        super.init(provider, null);
        this.m_provider = provider;
        this.m_index = index;
        this.m_table = index.getTable();
        this.m_selectedTablePartitionIdx = selectedTablePartitionIdx;
        this.m_currentGlobalPartition = null;
        this.m_isEditable = isEditable;
        boolean bl = this.m_isCompressed = index.getKeyCompression() != null;
        if (!this.m_provider.getDescriptor().supportsFeature("GLOBAL HASH INDEX PARTITIONING")) {
            this.m_cmbGlobalPartitionBy.removeItem(HASH);
        }
        boolean isNullModel = this.isNullModel();
        if (this.m_selectedTablePartitionIdx > -1) {
            this.m_currentGlobalPartition = indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            this.m_indexPartitionModel = this.m_currentGlobalPartition.getSubpartitions();
            if (this.m_indexPartitionModel == null) {
                this.m_indexPartitionModel = this.createIndexPartitionModel();
            }
            isNullModel = false;
        } else if (this.m_isFirstEntry) {
            this.m_indexPartitionModel = (OracleIndexPartitions)this.m_index.getProperty("OracleIndexPartitions");
            this.m_indexPartitionModel = this.m_indexPartitionModel == null ? this.createIndexPartitionModel() : (OracleIndexPartitions)this.m_indexPartitionModel.copyTo(null, true);
        }
        this.initialiseTablespaceModels();
        this.initialiseTablePartitionModel();
        this.initialiseGlobalHashQuantity();
        this.m_rdbGlobal.setEnabled(this.m_index.getIndexType() != Index.IndexType.BITMAP);
        if (this.m_index.getIndexType() == Index.IndexType.DOMAIN) {
            if (isNullModel) {
                this.m_rdbDomainNone.setSelected(true);
            } else {
                this.m_rdbDomainLocal.setSelected(true);
            }
            this.addDomainIndexSubpanel();
        } else if (this.m_selectedTablePartitionIdx > -1) {
            if (this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
                this.m_rdbTablespaces.setSelected(true);
            } else {
                this.m_rdbIndividual.setSelected(true);
            }
            this.addLocalSubpartitionsSubpanel();
        } else if (isNullModel) {
            this.addNoneSubpanel();
        } else if (this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
            if (this.m_isFirstEntry) {
                this.m_globalIndexPartitionModel = this.m_indexPartitionModel;
            }
            this.m_cmbGlobalPartitionBy.removeActionListener(this);
            this.m_cmbGlobalPartitionBy.setSelectedItem(this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH ? HASH : RANGE);
            this.m_cmbGlobalPartitionBy.addActionListener(this);
            this.addGlobalSubpanel();
        } else {
            if (this.m_isFirstEntry) {
                this.m_localIndexPartitionModel = this.m_indexPartitionModel;
            }
            this.addLocalSubpanel();
        }
        this.m_isFirstEntry = false;
        this.m_txtName.addFocusListener(this.m_partitionNameFocusListener);
        this.m_txtValuesLessThan.addFocusListener(this.m_partitionNameFocusListener);
    }

    private boolean isNullModel() {
        boolean isNullModel = false;
        if (this.m_isFirstEntry) {
            if (this.m_index.getProperty("OracleIndexPartitions") == null) {
                isNullModel = true;
            }
        } else {
            isNullModel = this.m_index.getIndexType() == Index.IndexType.DOMAIN ? this.m_rdbDomainNone.isSelected() : this.m_rdbNone.isSelected();
            if (!isNullModel) {
                isNullModel = this.m_indexPartitionModel == null && this.m_index.getProperty("OracleIndexPartitions") == null;
            }
        }
        return isNullModel;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            Object source = ae.getSource();
            if (source == this.m_btnStorage) {
                this.execStorageDialog();
            } else if (source == this.m_btnSubpartitions) {
                this.execSubpartitionsDialog();
            } else if (source == this.m_btnTablespaces) {
                this.execTablespacesDialog();
            } else if (source == this.m_cmbGlobalPartitionBy) {
                this.addGlobalSubpanel();
            } else if (source == this.m_rdbGlobal || source == this.m_rdbGlobalIndividual || source == this.m_rdbGlobalQuantity) {
                this.savePanel();
                this.addGlobalSubpanel();
            } else if (source == this.m_rdbLocal) {
                this.savePanel();
                this.addLocalSubpanel();
                this.populateLocalIndexPartitionNames();
            } else if (source == this.m_rdbNone) {
                this.savePanel();
                this.addNoneSubpanel();
            } else if (source == this.m_rdbIndividual || source == this.m_rdbTablespaces) {
                this.savePanel();
                if (this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
                    this.addLocalSubpartitionsSubpanel();
                } else {
                    this.addLocalHashDefinitionsSubpanel();
                }
            } else if (source == this.m_cmbGlobalPartitionColumns) {
                this.saveGlobalPartitionColumns();
            } else if (source == this.m_rdbDomainLocal || source == this.m_rdbDomainNone) {
                this.savePanel();
                this.addDomainIndexSubpanel();
            }
        }
        catch (ValidationException ve) {
            MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        IndexPartition p = (IndexPartition)this.m_lstGlobalIndexPartitions.getSelectedValue();
        if (this.m_currentGlobalPartition != null && this.m_currentGlobalPartition != p && !this.trySaveGlobalPartition()) {
            this.m_lstGlobalIndexPartitions.setSelectedValue(this.m_currentGlobalPartition, true);
            return;
        }
        this.m_currentGlobalPartition = p;
        this.initialiseCurrentGlobalPartition();
    }

    private void enableAllComponents(boolean boo, boolean incLabels) {
        this.m_btnStorage.setEnabled(boo);
        this.m_btnSubpartitions.setEnabled(boo);
        this.m_btnTablespaces.setEnabled(boo);
        this.m_pnlRegularIndexHeader.setEnabled(boo);
        this.m_rdbNone.setEnabled(boo);
        this.m_rdbGlobal.setEnabled(boo);
        this.m_rdbLocal.setEnabled(boo);
        this.m_tblspaceChooser.setEnabled(boo);
        this.m_pnlPartitionDefinition.setEnabled(boo);
        this.m_pnlTablePartitions.setEnabled(boo);
        this.m_pnlIndividualAndTablespaces.setEnabled(boo);
        this.m_rdbIndividual.setEnabled(boo);
        this.m_rdbTablespaces.setEnabled(boo);
        this.m_pnlGlobalIndexPartitions.setEnabled(boo);
        this.m_txtName.setEnabled(boo);
        this.m_txtValuesLessThan.setEnabled(boo);
        this.m_pnlTablespacesShuttle.setEnabled(boo);
        this.m_tblsShuttle.setEnabled(boo);
        this.m_pnlGlobalPartitionBy.setEnabled(boo);
        this.m_cmbGlobalPartitionBy.setEnabled(boo);
        this.m_cmbGlobalPartitionColumns.setEnabled(boo);
        this.m_pnlGlobalIndividualAndQuantity.setEnabled(boo);
        this.m_rdbGlobalIndividual.setEnabled(boo);
        this.m_rdbGlobalQuantity.setEnabled(boo);
        this.m_pnlDomainIndexHeader.setEnabled(boo);
        this.m_rdbDomainLocal.setEnabled(boo);
        this.m_rdbDomainNone.setEnabled(boo);
        this.m_btnsGlobalIndexPartitions.enableButtons();
        if (boo || incLabels) {
            this.m_lblDescription.setEnabled(boo);
            this.m_lblPartitioning.setEnabled(boo);
            this.m_lblTablespace.setEnabled(boo);
            this.m_lblTablePartitions.setEnabled(boo);
            this.m_lblGlobalIndexPartitions.setEnabled(boo);
            this.m_lblName.setEnabled(boo);
            this.m_lblValuesLessThan.setEnabled(boo);
            this.m_lblTablespacesShuttle.setEnabled(boo);
            this.m_hashCountLabel.setEnabled(boo);
            this.m_lblGlobalPartitionColumns.setEnabled(boo);
            this.m_lblGlobalPartitionBy.setEnabled(boo);
            this.m_lblDomainPartitioning.setEnabled(boo);
            this.m_lblIndextypeParameters.setEnabled(boo);
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_pnlPartitionDefinition.setLayout(new GridBagLayout());
        this.m_pnlDomainIndexHeader.setName("IndexPartitionsPanel.PNL_DOMAIN_INDEX_HEADER");
        this.m_pnlGlobalIndexPartitions.setName("IndexPartitionsPanel.PNL_GLOBAL_INDEX_PARTITIONS");
        this.m_pnlGlobalIndividualAndQuantity.setName("IndexPartitionsPanel.PNL_GLOBAL_I_Q");
        this.m_pnlGlobalPartitionBy.setName("IndexPartitionsPanel.PNL_GLOBAL_PARTITION_BY");
        this.m_pnlIndividualAndTablespaces.setName("IndexPartitionsPanel.PNL_IND_TBLS");
        this.m_pnlPartitionDefinition.setName("IndexPartitionsPanel.PNL_PARTITION_DEFINITION");
        this.m_pnlRegularIndexHeader.setName("IndexPartitionsPanel.PNL_REGULAR_IDX");
        this.m_pnlTablePartitions.setName("IndexPartitionsPanel.PNL_TABLE_PARTITIONS");
        this.m_pnlTablespacesShuttle.setName("IndexPartitionsPanel.PNL_TBLS_SHUTTLE");
        this.m_cbxCompress.setName("IndexPartitionsPanel.CBX_COMPRESS");
        this.m_cmbGlobalPartitionBy.setName("IndexPartitionsPanel.CMB_GLOBAL_PARTITION_BY");
        this.m_cmbGlobalPartitionColumns.setName("IndexPartitionsPanel.CMB_GLOBAL_PARTITION_COLS");
        this.m_tblspaceChooser.setName("IndexPartitionsPanel.CMB_GLOBAL_TABLESPACE");
        this.m_hashCountSpinner.setName("IndexPartitionsPanel.SPN_HASH_COUNT");
        this.m_lstGlobalIndexPartitions.setName("IndexPartitionsPanel.LST_GLOBAL_IDX_PARTITIONS");
        this.m_lstTablePartitions.setName("IndexPartitionsPanel.LST_TABLE_PARTITIONS");
        this.m_txtValuesLessThan.setName("IndexPartitionsPanel.TXT_VALUES_LESS_THAN");
        this.m_txtIndextypeParameters.setName("IndexPartitionsPanel.TXT_IDXTYPE_PARAMETERS");
        this.m_txtName.setName("IndexPartitionsPanel.TXT_NAME");
        this.m_tblsShuttle.setName("IndexPartitionsPanel.TBLS_SHUTTLE");
        this.m_btnsGlobalIndexPartitions.setName("IndexPartitionsPanel.BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnsGlobalIndexPartitions.setButtonNames("BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnsGlobalIndexPartitions.setButtonNames("IndexPartitionsPanel.BTNS_GLOBAL_IDX_PARTITIONS");
        this.m_btnTablespaces.setName("IndexPartitionsPanel.BTN_TBLS");
        this.m_btnSubpartitions.setName("IndexPartitionsPanel.BTN_SUBPARTITIONS");
        this.m_btnStorage.setName("IndexPartitionsPanel.BTN_STORAGE");
        this.m_rdbTablespaces.setName("IndexPartitionsPanel.RDB_TBLS");
        this.m_rdbNone.setName("IndexPartitionsPanel.RDB_NONE");
        this.m_rdbLocal.setName("IndexPartitionsPanel.RDB_LOCAL");
        this.m_rdbGlobal.setName("IndexPartitionsPanel.RDB_GLOBAL");
        this.m_rdbGlobalIndividual.setName("IndexPartitionsPanel.RDB_GLOBAL_INDIVIDUAL");
        this.m_rdbGlobalQuantity.setName("IndexPartitionsPanel.RDB_GLOBAL_QUANTITY");
        this.m_rdbIndividual.setName("IndexPartitionsPanel.RDB_INDIVIDUAL");
        this.m_rdbDomainLocal.setName("IndexPartitionsPanel.RBD_DOMAIN_LOCAL");
        this.m_rdbDomainNone.setName("IndexPartitionsPanel.RBD_DOMAIN_NONE");
        ResourceUtils.resLabel((JLabel)this.m_lblName, (Component)this.m_txtName, (String)UIArb.getString(484));
        this.m_txtName.setColumns(30);
        ResourceUtils.resLabel((JLabel)this.m_lblValuesLessThan, (Component)this.m_txtValuesLessThan, (String)UIArb.getString(926));
        ResourceUtils.resLabel((JLabel)this.m_lblTablespace, (Component)this.m_tblspaceChooser, (String)UIArb.getString(709));
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalPartitionBy, (Component)this.m_cmbGlobalPartitionBy, (String)UIArb.getString(465));
        this.m_cmbGlobalPartitionBy.addItem(HASH);
        this.m_cmbGlobalPartitionBy.addItem(RANGE);
        this.m_cmbGlobalPartitionBy.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalPartitionColumns, (Component)this.m_cmbGlobalPartitionColumns, (String)UIArb.getString(927));
        this.m_cmbGlobalPartitionColumns.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_lblIndextypeParameters, (Component)this.m_txtIndextypeParameters, (String)UIArb.getString(382));
        this.m_pnlGlobalIndexPartitions.setLayout(new GridBagLayout());
        this.m_lstGlobalIndexPartitions.setSelectionMode(0);
        this.m_lstGlobalIndexPartitions.addListSelectionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnStorage, (String)UIArb.getString(504));
        this.m_btnStorage.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnSubpartitions, (String)UIArb.getString(486));
        this.m_btnSubpartitions.addActionListener(this);
        ResourceUtils.resButton((AbstractButton)this.m_btnTablespaces, (String)UIArb.getString(921));
        this.m_btnTablespaces.addActionListener(this);
        ResourceUtils.resLabel((JLabel)this.m_hashCountLabel, (Component)this.m_hashCountSpinner, (String)UIArb.getString(490));
        ResourceUtils.resButton((AbstractButton)this.m_cbxCompress, (String)UIArb.getString(929));
        this.layoutRegularIndexHeaderSubpanel();
        this.layoutDomainIndexHeaderSubpanel();
        this.layoutTablePartitionsSubpanel();
        this.layoutTablespacesShuttleSubpanel();
        this.layoutIndividualAndTablespacesSubpanel();
        this.layoutGlobalIndividualAndQuantitySubpanel();
        this.layoutGlobalPartitionBySubpanel();
    }

    private void layoutIndividualAndTablespacesSubpanel() {
        ResourceUtils.resButton((AbstractButton)this.m_rdbTablespaces, (String)UIArb.getString(907));
        ResourceUtils.resButton((AbstractButton)this.m_rdbIndividual, (String)UIArb.getString(908));
        this.m_pnlIndividualAndTablespaces.setLayout(new GridBagLayout());
        this.m_pnlIndividualAndTablespaces.add((Component)this.m_rdbIndividual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlIndividualAndTablespaces.add((Component)this.m_rdbTablespaces, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbTablespaces);
        bg.add(this.m_rdbIndividual);
        this.m_rdbTablespaces.setSelected(true);
        this.m_rdbTablespaces.addActionListener(this);
        this.m_rdbIndividual.addActionListener(this);
    }

    private void layoutGlobalIndividualAndQuantitySubpanel() {
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobalIndividual, (String)UIArb.getString(908));
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobalQuantity, (String)UIArb.getString(909));
        this.m_pnlGlobalIndividualAndQuantity.setLayout(new GridBagLayout());
        this.m_pnlGlobalIndividualAndQuantity.add((Component)this.m_rdbGlobalIndividual, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndividualAndQuantity.add((Component)this.m_rdbGlobalQuantity, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbGlobalQuantity);
        bg.add(this.m_rdbGlobalIndividual);
        this.m_rdbGlobalIndividual.setSelected(true);
        this.m_rdbGlobalIndividual.addActionListener(this);
        this.m_rdbGlobalQuantity.addActionListener(this);
    }

    protected void layoutTablePartitionsSubpanel() {
        JScrollPane scrTablePartitions = new JScrollPane();
        scrTablePartitions.setVerticalScrollBarPolicy(22);
        this.m_lstTablePartitions.setModel(this.m_mdlTablePartitions);
        this.m_lstTablePartitions.setSelectionMode(0);
        this.m_lstTablePartitions.setCellRenderer(new DBObjectRenderer());
        scrTablePartitions.getViewport().add((Component)this.m_lstTablePartitions, null);
        this.m_pnlTablePartitions.setLayout(new GridBagLayout());
        this.m_pnlTablePartitions.add((Component)this.m_lblTablePartitions, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlTablePartitions.add((Component)scrTablePartitions, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_lstTablePartitions.getSelectionModel().addListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
    }

    protected void layoutPartitionDefinitionPanel(int titleID) {
        this.m_pnlPartitionDefinition.removeAll();
        this.m_pnlPartitionDefinition.setBorder(BorderFactory.createTitledBorder(UIArb.getString(titleID)));
        this.m_pnlPartitionDefinition.add((Component)this.m_lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)this.m_txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 5), 0, 0));
    }

    private void layoutRegularIndexHeaderSubpanel() {
        this.m_pnlRegularIndexHeader.setLayout(new GridBagLayout());
        this.m_lblPartitioning.setText(UIArb.getString(928));
        ResourceUtils.resButton((AbstractButton)this.m_rdbGlobal, (String)UIArb.getString(910));
        ResourceUtils.resButton((AbstractButton)this.m_rdbLocal, (String)UIArb.getString(911));
        ResourceUtils.resButton((AbstractButton)this.m_rdbNone, (String)UIArb.getString(912));
        this.m_pnlRegularIndexHeader.add((Component)this.m_lblPartitioning, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbNone, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbLocal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlRegularIndexHeader.add((Component)this.m_rdbGlobal, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbGlobal);
        bg.add(this.m_rdbLocal);
        bg.add(this.m_rdbNone);
        this.m_rdbNone.setSelected(true);
        this.m_rdbGlobal.addActionListener(this);
        this.m_rdbLocal.addActionListener(this);
        this.m_rdbNone.addActionListener(this);
    }

    private void layoutDomainIndexHeaderSubpanel() {
        this.m_pnlDomainIndexHeader.setLayout(new GridBagLayout());
        this.m_lblDomainPartitioning.setText(UIArb.getString(928));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomainLocal, (String)UIArb.getString(911));
        ResourceUtils.resButton((AbstractButton)this.m_rdbDomainNone, (String)UIArb.getString(912));
        this.m_pnlDomainIndexHeader.add((Component)this.m_lblDomainPartitioning, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.m_pnlDomainIndexHeader.add((Component)this.m_rdbDomainNone, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        this.m_pnlDomainIndexHeader.add((Component)this.m_rdbDomainLocal, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 20), 0, 0));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbDomainLocal);
        bg.add(this.m_rdbDomainNone);
        this.m_rdbDomainLocal.addActionListener(this);
        this.m_rdbDomainNone.addActionListener(this);
    }

    private void layoutIndexPartitionsPanel() {
        int y = 0;
        ResourceUtils.resLabel((JLabel)this.m_lblGlobalIndexPartitions, (Component)this.m_lstGlobalIndexPartitions, (String)UIArb.getString(917));
        this.m_pnlGlobalIndexPartitions.removeAll();
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_lblGlobalIndexPartitions, new GridBagConstraints(0, y, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)new JScrollPane(this.m_lstGlobalIndexPartitions), new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_btnsGlobalIndexPartitions, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.m_pnlGlobalIndexPartitions.add((Component)this.m_pnlPartitionDefinition, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.layoutPartitionDefinitionPanel(919);
    }

    private void layoutGlobalPartitionBySubpanel() {
        this.m_pnlGlobalPartitionBy.setLayout(new GridBagLayout());
        this.m_pnlGlobalPartitionBy.add((Component)this.m_lblGlobalPartitionBy, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_cmbGlobalPartitionBy, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_lblGlobalPartitionColumns, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 5), 0, 0));
        this.m_pnlGlobalPartitionBy.add((Component)this.m_cmbGlobalPartitionColumns, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
    }

    private void layoutTablespacesShuttleSubpanel() {
        this.m_pnlTablespacesShuttle.setLayout(new GridBagLayout());
        this.m_tblsShuttle.setFromPicker((ItemPicker)this.m_tblsFromPick);
        this.m_tblsShuttle.setToPicker((ItemPicker)this.m_tblsToPick);
        this.m_pnlTablespacesShuttle.add((Component)this.m_lblTablespacesShuttle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.m_pnlTablespacesShuttle.add((Component)this.m_tblsShuttle, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private void addNoneSubpanel() {
        this.m_panelType = PanelType.NONE;
        this.removeAll();
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_rdbNone.setSelected(true);
        this.validate();
        this.repaint();
    }

    private void addLocalSubpanel() {
        this.m_indexPartitionModel = this.m_localIndexPartitionModel;
        OracleTablePartitions tablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        boolean isHashPartitionedTable = tablePartitions != null && tablePartitions.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH);
        this.initialiseSessionPartitions();
        this.removeAll();
        if (tablePartitions == null || !isHashPartitionedTable && tablePartitions.getPartitions().length == 0) {
            int y = 0;
            this.m_lblDescription.setText(UIArb.getString(936));
            this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        } else {
            if (isHashPartitionedTable) {
                if (this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_tblsToModel.getSize() > 0 && this.m_panelType != PanelType.LOCAL_HASH_INDIVIDUAL) {
                    this.m_rdbTablespaces.setSelected(true);
                } else {
                    this.m_rdbIndividual.setSelected(true);
                }
                this.addLocalHashDefinitionsSubpanel();
            } else if (tablePartitions.getSubpartitionModel() != null) {
                this.addLocalCompDefinitionsSubpanel();
            } else {
                this.addLocalRangeListDefinitionsSubpanel();
            }
            if (this.m_selectedTablePartitionIdx == -1) {
                this.m_selectedTablePartitionIdx = 0;
            }
            this.populateIndexPartition();
        }
        this.m_rdbLocal.setSelected(true);
        this.validate();
        this.repaint();
    }

    private void addLocalRangeListDefinitionsSubpanel() {
        this.m_panelType = PanelType.LOCAL_OTHER;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_OTHER);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(914));
        this.m_lblDescription.setText(UIArb.getString(933));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(919);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_cbxCompress, new GridBagConstraints(1, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)this.m_btnStorage, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
            this.m_lstTablePartitions.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
    }

    private void addLocalHashDefinitionsSubpanel() {
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_HASH);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(914));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_pnlIndividualAndTablespaces, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_rdbIndividual.isSelected()) {
            this.m_panelType = PanelType.LOCAL_HASH_INDIVIDUAL;
            this.m_lblDescription.setText(UIArb.getString(933));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.layoutPartitionDefinitionPanel(919);
            this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_tblspaceChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
            if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
                this.m_lstTablePartitions.setSelectedIndex(0);
            }
        } else {
            this.m_panelType = PanelType.LOCAL_HASH_TABLESPACES;
            this.m_lblTablespacesShuttle.setText(UIArb.getString(942));
            this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 5), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addLocalSubpartitionsSubpanel() {
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.SUBPARTITION);
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(915));
        int y = 0;
        this.add(this.m_pnlIndividualAndTablespaces, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_rdbIndividual.isSelected()) {
            this.m_panelType = PanelType.SUBPARTITION_INDIVIDUAL;
            this.m_lblDescription.setText(UIArb.getString(934));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
            this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
            this.layoutPartitionDefinitionPanel(920);
            this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_tblspaceChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_selectedTablePartitionIdx = this.m_lstTablePartitions.getSelectedIndex();
            if (this.m_selectedTablePartitionIdx == -1) {
                this.m_lstTablePartitions.setSelectedIndex(0);
            }
            this.m_txtName.setEnabled(this.m_isEditable && this.m_tablePartitionModel != null);
            this.m_tblspaceChooser.setEnabled(this.m_isEditable && this.m_tablePartitionModel != null);
            this.m_btnStorage.setEnabled(this.m_isEditable && this.m_tablePartitionModel != null);
        } else {
            this.m_panelType = PanelType.SUBPARTITION_TABLESPACES;
            this.m_lblTablespacesShuttle.setText(UIArb.getString(943));
            this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addDomainIndexSubpanel() {
        this.m_panelType = PanelType.NONE;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.DOMAIN);
        OracleTablePartitions tablePartitions = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        this.removeAll();
        if (tablePartitions == null || tablePartitions.getPartitions().length == 0) {
            this.m_lblDescription.setText(UIArb.getString(936));
            this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        } else if (tablePartitions.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.RANGE) && tablePartitions.getSubpartitionModel() == null) {
            if (this.m_rdbDomainNone.isSelected()) {
                this.m_panelType = PanelType.NONE;
                this.add(this.m_pnlDomainIndexHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
                this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            } else {
                this.addLocalDomainSubpanel();
            }
        } else {
            String type = tablePartitions.getSubpartitionModel() != null ? UIArb.getString(932) : tablePartitions.getPartitionType().toString();
            this.m_lblDescription.setText(UIArb.format(937, type));
            this.add(this.m_lblDescription, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
            this.add(Box.createVerticalGlue(), new GridBagConstraints(0, 1, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        this.validate();
        this.repaint();
    }

    private void addLocalDomainSubpanel() {
        this.m_panelType = PanelType.DOMAIN;
        this.initialiseSessionPartitions();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(914));
        this.m_lblDescription.setText(UIArb.getString(933));
        int y = 0;
        this.add(this.m_pnlDomainIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(919);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_lblIndextypeParameters, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.m_pnlPartitionDefinition.add((Component)new JScrollPane(this.m_txtIndextypeParameters), new GridBagConstraints(0, ++y, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        if (this.m_selectedTablePartitionIdx == -1) {
            this.m_selectedTablePartitionIdx = 0;
        }
        this.populateIndexPartition();
    }

    private void addLocalCompDefinitionsSubpanel() {
        this.m_panelType = PanelType.LOCAL_COMPOSITE;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.LOCAL_COMP);
        int y = 0;
        this.removeAll();
        ResourceUtils.resLabel((JLabel)this.m_lblTablePartitions, (Component)this.m_lstTablePartitions, (String)UIArb.getString(914));
        this.m_lblDescription.setText(UIArb.getString(933));
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.add(this.m_pnlTablePartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 15), 0, 0));
        this.add(this.m_pnlPartitionDefinition, new GridBagConstraints(1, y, 1, 1, 1.0, 1.0, 17, 1, new Insets(15, 0, 0, 5), 0, 0));
        this.add(this.m_btnTablespaces, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 10, 5, 5), 0, 0));
        this.layoutPartitionDefinitionPanel(919);
        y = 0;
        this.m_pnlPartitionDefinition.add((Component)this.m_cbxCompress, new GridBagConstraints(1, ++y, 1, 1, 1.0, 0.0, 17, 1, new Insets(10, 5, 0, 0), 0, 0));
        this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        JPanel buttons = new JPanel();
        this.m_pnlPartitionDefinition.add((Component)buttons, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 5), 0, 0));
        buttons.add((Component)this.m_btnStorage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        buttons.add((Component)this.m_btnSubpartitions, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        if (this.m_lstTablePartitions.getSelectedIndex() == -1) {
            this.m_lstTablePartitions.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
    }

    private void addGlobalSubpanel() {
        this.m_indexPartitionModel = this.m_globalIndexPartitionModel;
        this.initialiseGlobalIndexPartitionColumnModel();
        this.initialiseGlobalIndexPartitionsModel();
        this.initialiseSessionPartitions();
        int y = 0;
        String partitionBy = (String)this.m_cmbGlobalPartitionBy.getSelectedItem();
        this.removeAll();
        this.add(this.m_pnlRegularIndexHeader, new GridBagConstraints(0, y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_pnlGlobalPartitionBy, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        if (this.m_mdlGlobalPartitionColumns.getSize() == 0) {
            this.m_lblDescription.setText(UIArb.getString(938));
            this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        } else if (HASH.equals(partitionBy)) {
            this.add(this.m_pnlGlobalIndividualAndQuantity, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
            if (this.m_rdbGlobalQuantity.isSelected()) {
                this.addGlobalHashQuantitySubpanel(y);
            } else {
                this.m_panelType = PanelType.GLOBAL_HASH_INDIVIDUAL;
                this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_HASH);
                this.add(this.m_pnlGlobalIndexPartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 0, 0, 5), 0, 0));
                this.layoutIndexPartitionsPanel();
                this.m_pnlPartitionDefinition.add((Component)this.m_lblTablespace, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
                this.m_pnlPartitionDefinition.add((Component)this.m_tblspaceChooser, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
            }
        } else {
            this.m_panelType = PanelType.GLOBAL_RANGE;
            this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_RANGE);
            this.add(this.m_pnlGlobalIndexPartitions, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
            this.layoutIndexPartitionsPanel();
            y = 0;
            this.m_pnlPartitionDefinition.add((Component)this.m_lblValuesLessThan, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_txtValuesLessThan, new GridBagConstraints(1, y, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
            this.m_pnlPartitionDefinition.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
            this.m_pnlPartitionDefinition.add((Component)this.m_btnStorage, new GridBagConstraints(0, ++y, 2, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        }
        this.add(Box.createVerticalGlue(), new GridBagConstraints(0, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_rdbGlobal.setSelected(true);
        this.initialiseCurrentGlobalPartition();
        this.validate();
        this.repaint();
    }

    private void addGlobalHashQuantitySubpanel(int y) {
        this.m_panelType = PanelType.GLOBAL_HASH_QUANTITY;
        this.m_indexPartitionModel.setPartitionType(OracleIndexPartitions.PartitionType.GLOBAL_HASH);
        this.m_lblDescription.setText(UIArb.getString(941));
        this.add(this.m_lblDescription, new GridBagConstraints(0, ++y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.add((Component)this.m_hashCountLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)this.m_hashCountSpinner, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add(panel, new GridBagConstraints(0, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.m_lblTablespacesShuttle.setText(UIArb.getString(491));
        this.add(this.m_pnlTablespacesShuttle, new GridBagConstraints(0, ++y, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 5), 0, 0));
    }

    private void initialiseCurrentGlobalPartition() {
        boolean enabled;
        boolean bl = enabled = this.m_currentGlobalPartition != null;
        if (enabled) {
            this.m_currentGlobalPartition.setParent((DBObject)this.m_indexPartitionModel);
            String name = this.m_currentGlobalPartition.getName();
            if (ModelUtil.hasLength((String)name)) {
                this.m_txtName.setText(this.m_provider.getExternalName(name));
            } else {
                this.m_txtName.setText(null);
            }
            if (this.m_panelType == PanelType.GLOBAL_RANGE) {
                Object[] values = this.m_currentGlobalPartition.getValuesLessThan();
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < values.length; ++i) {
                    buff.append(values[i].toString());
                    if (i >= values.length - 1) continue;
                    buff.append(",");
                }
                this.m_txtValuesLessThan.setText(buff.toString());
            } else {
                OracleStorageProperties osp = this.m_currentGlobalPartition.getSegmentAttributes();
                this.m_tblspaceChooser.setDBObjectID(osp == null ? null : osp.getTablespaceID());
            }
        } else {
            this.m_txtName.setText(null);
            this.m_txtValuesLessThan.setText(null);
            this.m_txtIndextypeParameters.setText(null);
            this.m_tblspaceChooser.setDBObjectID(null);
        }
        this.m_txtName.setEnabled(this.m_isEditable && enabled);
        this.m_txtValuesLessThan.setEnabled(this.m_isEditable && enabled);
        this.m_txtIndextypeParameters.setEnabled(this.m_isEditable && enabled);
        this.m_tblspaceChooser.setEnabled(this.m_isEditable && enabled);
        this.m_btnStorage.setEnabled(this.m_isEditable && enabled);
    }

    private void initialiseSessionPartitions() {
        this.m_sessionPartitions.clear();
        if (this.m_indexPartitionModel != null) {
            for (IndexPartition partition : this.m_indexPartitionModel.getPartitions()) {
                this.m_sessionPartitions.add(partition);
            }
        }
    }

    private boolean trySaveGlobalPartition() {
        try {
            this.saveGlobalPartition();
        }
        catch (ValidationException ve) {
            MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
            return false;
        }
        return true;
    }

    private void saveGlobalPartition() throws ValidationException {
        this.m_currentGlobalPartition.setParent((DBObject)this.m_indexPartitionModel);
        String name = this.m_txtName.getText();
        if (ModelUtil.hasLength((String)name)) {
            this.m_provider.validateName("INDEX PARTITION", name);
            this.m_sessionPartitions.remove(this.m_currentGlobalPartition);
            this.m_currentGlobalPartition.setName(this.m_provider.getInternalName(name));
            this.validateNameIsUnique(this.m_currentGlobalPartition.getName());
            this.m_sessionPartitions.add(this.m_currentGlobalPartition);
        } else {
            if (this.isOfflineProvider()) {
                name = this.m_currentGlobalPartition.getName();
                this.m_txtName.setText(this.m_provider.getExternalName(name));
                throw new ValidationException((DBObject)this.m_table, UIArb.getString(497));
            }
            this.m_currentGlobalPartition.setName(null);
        }
        if (this.m_panelType == PanelType.GLOBAL_RANGE) {
            this.m_currentGlobalPartition.setValuesLessThan(this.m_txtValuesLessThan.getText());
            this.m_provider.validateObjectProperty((DBObject)this.m_currentGlobalPartition, "globalPartitionColumns");
        } else {
            OracleStorageProperties osp = this.m_currentGlobalPartition.getSegmentAttributes();
            if (osp == null) {
                osp = new OracleStorageProperties();
                this.m_currentGlobalPartition.setSegmentAttributes(osp);
            }
            osp.setTablespaceID(this.m_tblspaceChooser.getDBObjectID());
        }
    }

    protected void initialiseTablespaceModels() {
        PropertyFilter permFilter = new PropertyFilter("properties/TablespaceType", (Object)Tablespace.TablespaceType.PERMANENT);
        this.m_tblspaceChooser.setFilter((DBObjectFilter)permFilter);
        this.m_tblspaceChooser.setNullText(DEFAULT);
        this.m_tblspaceChooser.setProvider(this.m_provider);
        DBObjectCriteria critter = new DBObjectCriteria(Tablespace.class, new String[0]);
        critter.addFilter((DBObjectFilter)permFilter);
        this.m_tblsFromModel.removeAllElements();
        try {
            for (Tablespace t : this.m_provider.listObjects(critter)) {
                this.m_tblsFromModel.addElement(this.m_provider.getExternalName(t.getName()));
            }
        }
        catch (DBException e) {
            // empty catch block
        }
        this.m_tblsToModel.removeAllElements();
        if (this.m_indexPartitionModel != null) {
            String[] chosenTbls = this.m_indexPartitionModel.getTablespaces();
            for (int i = 0; i < chosenTbls.length; ++i) {
                String tablespaceName = this.m_provider.getExternalName(chosenTbls[i]);
                this.m_tblsFromModel.removeElement(tablespaceName);
                this.m_tblsToModel.addElement(tablespaceName);
            }
        }
    }

    private void initialiseGlobalIndexPartitionsModel() {
        this.m_lstGlobalIndexPartitions.removeListSelectionListener(this);
        this.m_mdlGlobalIndexPartitions.removeAllElements();
        if (this.m_indexPartitionModel != null && this.m_indexPartitionModel.getPartitions() != null) {
            for (IndexPartition partition : this.m_indexPartitionModel.getPartitions()) {
                this.m_mdlGlobalIndexPartitions.addElement(partition);
            }
        }
        this.m_lstGlobalIndexPartitions.addListSelectionListener(this);
    }

    private void initialiseTablePartitionModel() {
        boolean isSubpartitions = this.m_selectedTablePartitionIdx > -1;
        this.m_lstTablePartitions.getSelectionModel().removeListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
        this.m_mdlTablePartitions.clear();
        this.m_tablePartitionModel = (OracleTablePartitions)this.m_table.getProperty("OracleTablePartitions");
        String tablePartitionName = null;
        if (isSubpartitions) {
            TablePartition tablePartition = this.m_tablePartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            tablePartitionName = tablePartition.getName();
            this.m_tablePartitionModel = tablePartition.getPartitionLevelSubpartitions();
        }
        if (this.m_tablePartitionModel != null && this.m_tablePartitionModel.getPartitions().length == 0 && this.m_tablePartitionModel.getPartitionType().equals((Object)OracleTablePartitions.PartitionType.HASH)) {
            int quantity = this.m_tablePartitionModel.getHashQuantity() == null ? 1 : this.m_tablePartitionModel.getHashQuantity();
            for (int suffix = 1; suffix <= quantity; ++suffix) {
                String name = UIArb.getString(isSubpartitions ? 463 : 462) + suffix;
                if (isSubpartitions) {
                    int maxPrefixLength = 30 - name.length();
                    int prefixLength = maxPrefixLength > tablePartitionName.length() ? tablePartitionName.length() : maxPrefixLength - 1;
                    name = tablePartitionName.substring(0, prefixLength) + '_' + name;
                }
                this.m_tablePartitionModel.addPartition(new TablePartition(name));
            }
        }
        if (this.m_tablePartitionModel != null) {
            for (TablePartition partition : this.m_tablePartitionModel.getPartitions()) {
                String name = ModelUtil.hasLength((String)partition.getName()) ? partition.getName() : UIArb.getString(931);
                this.m_mdlTablePartitions.addElement(name);
            }
        }
        this.m_lstTablePartitions.getSelectionModel().addListSelectionListener(this.m_mdlTablePartitionsSelectionListener);
    }

    private void initialiseGlobalIndexPartitionColumnModel() {
        DBObjectID[] colIDs;
        this.m_cmbGlobalPartitionColumns.removeActionListener(this);
        this.m_mdlGlobalPartitionColumns.removeAllElements();
        for (Column col : OracleIndexPartitions.getValidGlobalPartitionColumns((Index)this.m_index)) {
            this.m_mdlGlobalPartitionColumns.addElement((Object)col.getName());
        }
        if (this.m_indexPartitionModel != null && (colIDs = this.m_indexPartitionModel.getGlobalPartitionColumns()).length > 0) {
            DBObjectID colID = colIDs[colIDs.length - 1];
            Column column = (Column)this.m_table.findOwnedObject(colID);
            if (column == null) {
                try {
                    column = (Column)colID.resolveID();
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            if (column != null) {
                this.m_cmbGlobalPartitionColumns.setSelectedItem(column.getName());
            }
        }
        this.m_cmbGlobalPartitionColumns.addActionListener(this);
    }

    private void initialiseGlobalHashQuantity() {
        Integer q;
        if (this.m_indexPartitionModel != null && (q = this.m_indexPartitionModel.getGlobalHashQuantity()) != null) {
            this.m_hashCountModel.setValue(q);
            this.m_rdbGlobalIndividual.setSelected(false);
            this.m_rdbGlobalQuantity.setSelected(true);
        }
    }

    private void savePanel() throws ValidationException {
        if (this.m_panelType == PanelType.DOMAIN) {
            this.saveLocalPartition();
        } else if (this.m_panelType == PanelType.GLOBAL_HASH_QUANTITY) {
            this.saveGlobalPartitionColumns();
            this.saveTablespaces();
            Number num = this.m_hashCountModel.getNumber();
            this.m_indexPartitionModel.setGlobalHashQuantity(num == null ? null : new Integer(num.intValue()));
        } else if (this.m_panelType == PanelType.GLOBAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.GLOBAL_RANGE) {
            this.saveGlobalPartitionColumns();
            this.savePartitions();
        } else if (this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_COMPOSITE || this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            this.saveLocalPartition();
        } else if (this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
            this.saveTablespaces();
        }
    }

    private OracleIndexPartitions createIndexPartitionModel() {
        OracleIndexPartitions model = new OracleIndexPartitions();
        model.setParent((DBObject)this.m_index);
        DBObjectID id = TemporaryObjectID.createID((DBObject)model);
        model.setID(id);
        return model;
    }

    private IndexPartition createIndexPartition() {
        IndexPartition partition = (IndexPartition)this.m_provider.getObjectFactory().newObject(IndexPartition.class, (DBObject)this.m_indexPartitionModel);
        DBObjectID id = TemporaryObjectID.createID((DBObject)partition);
        partition.setID(id);
        return partition;
    }

    private IndexPartition[] createIndexPartitions(int length) {
        IndexPartition[] indexPartitions = new IndexPartition[length];
        for (int i = 0; i < length; ++i) {
            indexPartitions[i] = this.createIndexPartition();
        }
        return indexPartitions;
    }

    private OracleIndexPartitions getCleanedIndexPartitionModel() {
        OracleIndexPartitions partitionModel = (OracleIndexPartitions)this.m_indexPartitionModel.copyTo(null, true);
        partitionModel.setParent((DBObject)this.m_index);
        if (this.m_panelType == PanelType.GLOBAL_RANGE || this.m_panelType == PanelType.GLOBAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            partitionModel.setTablespaces(null);
            partitionModel.setGlobalHashQuantity(null);
        }
        if (this.m_panelType == PanelType.GLOBAL_HASH_QUANTITY || this.m_panelType == PanelType.LOCAL_HASH_TABLESPACES || this.m_panelType == PanelType.SUBPARTITION_TABLESPACES) {
            partitionModel.setPartitions(null);
        }
        if (this.m_panelType != PanelType.GLOBAL_RANGE) {
            for (IndexPartition indexPartition : partitionModel.getPartitions()) {
                indexPartition.setValuesLessThan((Object[])null);
            }
        }
        if (partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.LOCAL_HASH || partitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.SUBPARTITION) {
            for (IndexPartition indexPartition : partitionModel.getPartitions()) {
                if (indexPartition.getSegmentAttributes() == null) continue;
                OracleStorageProperties segmentAttrs = new OracleStorageProperties();
                segmentAttrs.setTablespaceID(indexPartition.getSegmentAttributes().getTablespaceID());
                indexPartition.setSegmentAttributes(segmentAttrs);
            }
        }
        return partitionModel;
    }

    private void execSubpartitionsDialog() {
        if (this.m_selectedTablePartitionIdx > -1) {
            try {
                this.savePanel();
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
                return;
            }
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIArb.getString(925), (int)3);
            final IndexPartitionsPanel subpartitionsPanel = new IndexPartitionsPanel(this.getSubpartitionsPanelType());
            subpartitionsPanel.setPreferredSize(new Dimension(500, 250));
            subpartitionsPanel.init(this.m_provider, this.m_index, this.m_indexPartitionModel, this.m_selectedTablePartitionIdx, this.m_isEditable);
            final IndexPartition currentIndexPartition = this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            dialog.setContent((Component)((Object)subpartitionsPanel));
            dialog.setResizable(true);
            VetoableChangeListener list = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        try {
                            subpartitionsPanel.commit();
                            IndexPartitionsPanel.this.saveSubpartitionModel(currentIndexPartition.getSubpartitions());
                            currentIndexPartition.setSubpartitions(subpartitionsPanel.m_indexPartitionModel);
                        }
                        catch (TraversalException x) {
                            MessageDialog.error((Component)((Object)IndexPartitionsPanel.this), (Object)x.getMessage(), null, null);
                            throw new PropertyVetoException(x.getMessage(), evt);
                        }
                    }
                }
            };
            dialog.addVetoableChangeListener(list);
            dialog.runDialog();
        }
    }

    private PanelType getSubpartitionsPanelType() {
        OracleIndexPartitions subpartitions = null;
        if (this.m_subpartitionsModel != null && this.m_subpartitionsModel.getPartitions().length > this.m_selectedTablePartitionIdx) {
            subpartitions = this.m_subpartitionsModel.getPartitions()[this.m_selectedTablePartitionIdx].getSubpartitions();
        } else if (this.m_indexPartitionModel.getPartitions().length > this.m_selectedTablePartitionIdx) {
            subpartitions = this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx].getSubpartitions();
        }
        return subpartitions != null && subpartitions.getPartitions().length > 0 ? PanelType.SUBPARTITION_INDIVIDUAL : PanelType.SUBPARTITION_TABLESPACES;
    }

    private void saveSubpartitionModel(OracleIndexPartitions subpartitionModel) {
        if (this.m_subpartitionsModel == null) {
            this.m_subpartitionsModel = this.createIndexPartitionModel();
            int partitionCount = this.m_tablePartitionModel.getPartitions().length;
            this.m_subpartitionsModel.setPartitions(this.createIndexPartitions(partitionCount));
        }
        this.m_subpartitionsModel.getPartitions()[this.m_selectedTablePartitionIdx].setSubpartitions(subpartitionModel);
    }

    private void execTablespacesDialog() {
        JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIArb.getString(923), (int)3);
        this.m_pnlTablespacesShuttle.setPreferredSize(new Dimension(600, 200));
        this.m_lblTablespacesShuttle.setText(UIArb.getString(942));
        dialog.setContent((Component)this.m_pnlTablespacesShuttle);
        dialog.setResizable(true);
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    IndexPartitionsPanel.this.saveTablespaces();
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        dialog.runDialog();
    }

    private void execStorageDialog() {
        if (this.m_selectedTablePartitionIdx > -1 && (this.m_panelType == PanelType.LOCAL_OTHER || this.m_panelType == PanelType.LOCAL_COMPOSITE) || this.m_currentGlobalPartition != null && this.m_panelType == PanelType.GLOBAL_RANGE) {
            try {
                this.savePanel();
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
                return;
            }
            IndexPartition indexPartition = this.m_currentGlobalPartition != null ? this.m_currentGlobalPartition : this.m_indexPartitionModel.getPartitions()[this.m_selectedTablePartitionIdx];
            OracleStorageProperties osp = indexPartition.getSegmentAttributes();
            osp = StorageInfoPanel.edit(osp, StorageInfoPanel.StorageInfoFor.INDEX_PARTITION, this.m_provider, (DBObject)indexPartition, (DBObject)this.m_index, null, (Component)((Object)this));
            indexPartition.setSegmentAttributes(osp);
            this.m_partitionStoragePropertiesMap.put(indexPartition, null);
        }
    }

    private void saveTablespaces() {
        Enumeration tblsEnum = this.m_tblsToModel.elements();
        String[] tbls = new String[this.m_tblsToModel.size()];
        for (int i = 0; i < tbls.length; ++i) {
            tbls[i] = this.m_provider.getInternalName((String)tblsEnum.nextElement());
        }
        this.m_indexPartitionModel.setTablespaces(tbls);
    }

    private void saveGlobalPartitionColumns() {
        ArrayList<DBObjectID> columnIDs = new ArrayList<DBObjectID>();
        String selectedColumn = (String)this.m_cmbGlobalPartitionColumns.getSelectedItem();
        for (int i = 0; i < this.m_mdlGlobalPartitionColumns.getSize(); ++i) {
            String columnName = (String)this.m_mdlGlobalPartitionColumns.getElementAt(i);
            Column column = this.m_table.getColumn(columnName);
            if (column.getID() == null) {
                column.setID(TemporaryObjectID.createID((DBObject)column));
            }
            columnIDs.add(column.getID());
            if (columnName.equals(selectedColumn)) break;
        }
        this.m_indexPartitionModel.setGlobalPartitionColumns(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
    }

    private void savePartitions() throws ValidationException {
        if (this.m_currentGlobalPartition != null) {
            this.saveGlobalPartition();
        }
        IndexPartition[] partitions = new IndexPartition[this.m_mdlGlobalIndexPartitions.getSize()];
        Enumeration model = this.m_mdlGlobalIndexPartitions.elements();
        for (int i = 0; i < partitions.length; ++i) {
            partitions[i] = (IndexPartition)model.nextElement();
        }
        this.m_indexPartitionModel.setPartitions(partitions);
    }

    private void saveLocalPartition() throws ValidationException {
        if (this.m_selectedTablePartitionIdx > -1) {
            int length;
            IndexPartition[] indexPartitions = this.m_indexPartitionModel.getPartitions();
            if (indexPartitions.length != (length = this.m_tablePartitionModel.getPartitions().length)) {
                indexPartitions = this.createIndexPartitions(length);
                this.m_indexPartitionModel.setPartitions(indexPartitions);
            }
            IndexPartition indexPartition = indexPartitions[this.m_selectedTablePartitionIdx];
            String internalName = "";
            String externalName = this.m_txtName.getText();
            if (ModelUtil.hasLength((String)externalName)) {
                this.m_provider.validateName("INDEX PARTITION", externalName);
            }
            try {
                internalName = this.getInternalName(externalName);
            }
            catch (TraversalException e) {
                MessageDialog.error((Component)((Object)this), (Object)e.getMessage(), null, null);
            }
            indexPartition.setName(internalName);
            if (this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
                OracleStorageProperties osp = indexPartition.getSegmentAttributes();
                if (osp == null) {
                    osp = new OracleStorageProperties();
                    indexPartition.setSegmentAttributes(osp);
                }
                osp.setTablespaceID(this.m_tblspaceChooser.getDBObjectID());
            } else if (this.m_panelType == PanelType.DOMAIN) {
                indexPartition.setDomainParameters(ModelUtil.hasLength((String)this.m_txtIndextypeParameters.getText()) ? this.m_txtIndextypeParameters.getText() : null);
            }
            if (this.m_cbxCompress.isEnabled()) {
                indexPartition.setKeyCompression(Boolean.valueOf(this.m_cbxCompress.isSelected()));
            }
        }
        this.m_selectedTablePartitionIdx = this.m_lstTablePartitions.getSelectedIndex();
        if (this.m_selectedTablePartitionIdx > -1) {
            this.populateIndexPartition();
        }
    }

    private void populateIndexPartition() {
        String name;
        IndexPartition[] indexPartitions = this.m_indexPartitionModel.getPartitions();
        String string = name = this.m_selectedTablePartitionIdx > -1 && indexPartitions.length > this.m_selectedTablePartitionIdx && indexPartitions[this.m_selectedTablePartitionIdx] != null ? indexPartitions[this.m_selectedTablePartitionIdx].getName() : this.getInitialPartitionName(false);
        if (name == null) {
            name = this.getInitialPartitionName(false);
        }
        this.m_txtName.setText(this.getExternalName(name));
        this.m_txtName.setEnabled(this.m_isEditable);
        this.m_btnStorage.setEnabled(this.m_isEditable);
        this.m_cbxCompress.setEnabled(this.m_isCompressed && this.m_isEditable);
        if (this.m_selectedTablePartitionIdx > -1 && indexPartitions.length > 0) {
            Boolean compress = indexPartitions[this.m_selectedTablePartitionIdx].getKeyCompression();
            this.m_cbxCompress.setSelected(compress != null && compress != false);
        } else {
            this.m_cbxCompress.setSelected(false);
        }
        if (this.m_panelType == PanelType.LOCAL_HASH_INDIVIDUAL || this.m_panelType == PanelType.SUBPARTITION_INDIVIDUAL) {
            OracleStorageProperties osp = indexPartitions.length > this.m_selectedTablePartitionIdx ? indexPartitions[this.m_selectedTablePartitionIdx].getSegmentAttributes() : null;
            this.m_tblspaceChooser.setDBObjectID(osp != null ? osp.getTablespaceID() : null);
            this.m_tblspaceChooser.setEnabled(this.m_isEditable);
        } else if (this.m_panelType == PanelType.DOMAIN) {
            String indextypeParameters = indexPartitions.length > this.m_selectedTablePartitionIdx ? indexPartitions[this.m_selectedTablePartitionIdx].getDomainParameters() : null;
            this.m_txtIndextypeParameters.setText(indextypeParameters);
        }
    }

    private String getInitialPartitionName(boolean isGlobalPartition) {
        String tablePartitionName;
        Set indexPartitionNames = this.getIndexPartitionNames();
        String string = tablePartitionName = isGlobalPartition ? "" : this.m_tablePartitionModel.getPartitions()[this.m_selectedTablePartitionIdx].getName();
        if (!isGlobalPartition && !ModelUtil.hasLength((String)tablePartitionName)) {
            return "";
        }
        int suffix = 1;
        String indexPartitionName = this.makelIndexPartitionName(tablePartitionName, suffix);
        while (indexPartitionNames.contains(indexPartitionName)) {
            indexPartitionName = this.makelIndexPartitionName(tablePartitionName, ++suffix);
        }
        return indexPartitionName;
    }

    private String makelIndexPartitionName(String tablePartitionName, int suffix) {
        String indexPartitionName;
        String string = indexPartitionName = ModelUtil.hasLength((String)tablePartitionName) ? tablePartitionName : UIArb.getString(462) + suffix;
        while (indexPartitionName.length() > 30) {
            indexPartitionName = ModelUtil.hasLength((String)(tablePartitionName = tablePartitionName.substring(0, tablePartitionName.length() - 1))) ? tablePartitionName : UIArb.getString(462) + suffix;
        }
        return indexPartitionName;
    }

    private Set getIndexPartitionNames() {
        HashSet<String> indexPartitionNames = new HashSet<String>();
        for (IndexPartition indexPartition : this.m_sessionPartitions) {
            String name = indexPartition.getName();
            if (!ModelUtil.hasLength((String)name)) continue;
            indexPartitionNames.add(name);
        }
        return indexPartitionNames;
    }

    private void validateNameIsUnique(String name) throws ValidationException {
        Set names = this.getIndexPartitionNames();
        if (names.contains(name)) {
            throw new ValidationException((DBObject)this.m_index, UIArb.getString(944));
        }
    }

    private boolean isOfflineProvider() {
        return !(this.m_provider instanceof Database);
    }

    private void populateLocalIndexPartitionNames() {
        if (this.m_indexPartitionModel.getPartitions().length == 0 && this.m_tablePartitionModel != null && this.m_tablePartitionModel.getPartitions() != null) {
            int length = this.m_tablePartitionModel.getPartitions().length;
            IndexPartition[] indexPartitions = this.createIndexPartitions(length);
            for (int i = 0; i < length; ++i) {
                TablePartition tp = this.m_tablePartitionModel.getPartitions()[i];
                indexPartitions[i].setName(tp.getName());
            }
            this.m_indexPartitionModel.setPartitions(indexPartitions);
        }
    }

    private static enum PanelType {
        NONE,
        DOMAIN,
        GLOBAL_RANGE,
        GLOBAL_HASH_INDIVIDUAL,
        GLOBAL_HASH_QUANTITY,
        LOCAL_OTHER,
        LOCAL_HASH_INDIVIDUAL,
        LOCAL_HASH_TABLESPACES,
        LOCAL_COMPOSITE,
        SUBPARTITION_INDIVIDUAL,
        SUBPARTITION_TABLESPACES;

    }

    private class ButtonsHelper
    extends ListButtons.Controller {
        private ButtonsHelper() {
        }

        @Override
        public boolean canAdd() {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        public boolean canAdd(Object val) {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public boolean canMoveDown(Object val) {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public boolean canMoveUp(Object val) {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public boolean canRemove() {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public boolean canRemove(Object val) {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public boolean canReorder() {
            return IndexPartitionsPanel.this.m_isEditable;
        }

        @Override
        public String getAddTooltipText() {
            return null;
        }

        @Override
        public String getDownTooltipText() {
            return null;
        }

        @Override
        public String getRemoveTooltipText() {
            return null;
        }

        @Override
        public String getUpTooltipText() {
            return null;
        }

        @Override
        public boolean includeAddRemoveButtons() {
            return true;
        }

        @Override
        public boolean includeReorderButtons() {
            return true;
        }

        @Override
        public void addToList() {
            if (IndexPartitionsPanel.this.m_currentGlobalPartition == null || IndexPartitionsPanel.this.trySaveGlobalPartition()) {
                IndexPartitionsPanel.this.m_currentGlobalPartition = null;
                int i = IndexPartitionsPanel.this.m_lstGlobalIndexPartitions.getSelectedIndex();
                i = i < 0 ? IndexPartitionsPanel.this.m_mdlGlobalIndexPartitions.size() : i + 1;
                IndexPartition partition = IndexPartitionsPanel.this.createIndexPartition();
                if (partition.getName() == null) {
                    partition.setName(IndexPartitionsPanel.this.getInitialPartitionName(true));
                }
                IndexPartitionsPanel.this.m_mdlGlobalIndexPartitions.add(i, partition);
                IndexPartitionsPanel.this.m_lstGlobalIndexPartitions.setSelectedIndex(i);
                IndexPartitionsPanel.this.m_txtName.requestFocus();
                IndexPartitionsPanel.this.m_indexPartitionModel.addPartition(partition);
            }
        }

        @Override
        public void removeFromList() {
            int i = IndexPartitionsPanel.this.m_lstGlobalIndexPartitions.getSelectedIndex();
            if (i >= 0) {
                IndexPartitionsPanel.this.m_sessionPartitions.remove(IndexPartitionsPanel.this.m_currentGlobalPartition);
                IndexPartitionsPanel.this.m_currentGlobalPartition = null;
                IndexPartitionsPanel.this.m_mdlGlobalIndexPartitions.remove(i);
            }
        }

        @Override
        public void objectMovedUp(Object obj) {
            try {
                if (IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                    IndexPartitionsPanel.this.saveGlobalPartitionColumns();
                    IndexPartitionsPanel.this.saveGlobalPartition();
                }
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)IndexPartitionsPanel.this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
            }
        }

        @Override
        public void objectMovedDown(Object obj) {
            try {
                if (IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_HASH || IndexPartitionsPanel.this.m_indexPartitionModel.getPartitionType() == OracleIndexPartitions.PartitionType.GLOBAL_RANGE) {
                    IndexPartitionsPanel.this.saveGlobalPartitionColumns();
                    IndexPartitionsPanel.this.saveGlobalPartition();
                }
            }
            catch (ValidationException ve) {
                MessageDialog.error((Component)((Object)IndexPartitionsPanel.this), (Object)ve.getMessage(), (String)ve.getTitle(), null);
            }
        }
    }
}

