/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.panels.table.PKDialog;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.PKConstraint;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class FKPanel
extends JPanel
implements ConstraintPanel,
ActionListener,
FocusListener,
Traversable {
    private static final String[] ON_DELETE_LABELS = new String[]{"RESTRICT", "CASCADE", "SET NULL"};
    private static final String ADD_CMD = "ADD";
    private static final String REMOVE_CMD = "REMOVE";
    private static final String SETOBJECTBASED = "SetObjectBased";
    private static final String SETNAMEBASED = "SetNameBased";
    private static final int DELAY = 1500;
    private JLabel m_lblRefSchema = new JLabel();
    private JLabel m_lblRefTable = new JLabel();
    private JLabel m_lblRefCon = new JLabel();
    private JButton m_btnAddPK = new JButton();
    private DBObjectChooser m_refSchemaPicker = new DBObjectChooser("SCHEMA");
    private DBObjectChooser m_cmbRefTable = new DBObjectChooser(this.m_refSchemaPicker, "TABLE");
    private DBObjectChooser m_cmbRefCon = new DBObjectChooser(this.m_cmbRefTable, "CONSTRAINT");
    private JTextField m_txtRefSchema = new JTextField();
    private JTextField m_txtRefTable = new JTextField();
    private JTextField m_txtRefCon = new JTextField();
    protected JPanel pnlColumns = new JPanel();
    private GridBagLayout m_layColumns = new GridBagLayout();
    private JLabel m_lblColAssoc = new JLabel();
    private JScrollPane m_scrColumns = new JScrollPane();
    private JTable m_tblColumns = new JTable();
    private JButton m_btnAdd = new JButton();
    private JButton m_btnRemove = new JButton();
    private L m_listener = new L();
    private JLabel m_lblDelete = new JLabel();
    private JComboBox m_cmbDelete = new JComboBox();
    private JPanel m_pnlRef = new JPanel();
    private DBObjectRenderer m_renderer = new DBObjectRenderer();
    private TableColumn m_colLocal = new TableColumn(0);
    private TableColumn m_colRef = new TableColumn(1);
    private NameListener m_nameListener = new NameListener();
    private DefaultTableColumnModel m_mdlCols = new DefaultTableColumnModel();
    private FKTableCellEditor m_edTblCols = new FKTableCellEditor(new JComboBox());
    private NonNullableComboBoxModel m_mdlDelete = new NonNullableComboBoxModel((Object[])ON_DELETE_LABELS);
    private ColumnsModel m_mdlColumns = new ColumnsModel();
    private JCheckBox m_chkEnabled = new JCheckBox();
    private JRadioButton m_rdbObjectBased = new JRadioButton();
    private JRadioButton m_rdbNameBased = new JRadioButton();
    private ButtonGroup m_rbgBased = new ButtonGroup();
    private GridBagLayout m_gridBagLayout1 = new GridBagLayout();
    private JLabel m_lblName = new JLabel();
    private JTextField m_fldName = new JTextField();
    protected DBObjectProvider m_prov;
    private boolean m_modifiable;
    private Schema m_currSchema;
    private Table m_table;
    private Relation m_original;
    private Table m_sourceTable;
    private String m_currTableName;
    protected FKConstraint m_con;
    private Constraint[] m_otherCons;
    private ConstraintsInfoVerifier m_verifier;
    private boolean m_standalone;
    private HashMap m_loadingTables = new HashMap();
    private HashMap m_loadingConstraints = new HashMap();
    private boolean m_showNameBasedUI = false;
    private boolean m_nameBased = false;
    private DBObjectID m_lastObjectBasedRef = null;
    private ReferenceID m_lastNameBasedRef = null;
    private boolean m_initialising = false;
    private BaseConstraintPanel m_baseConstraintPanel;
    public static final String SOURCE_TABLE = "sourceTable";

    public FKPanel() {
        this(false);
    }

    public FKPanel(boolean showNameBasedUI) {
        this.m_showNameBasedUI = showNameBasedUI;
        try {
            this.jbInit();
            this._updateEnabledState(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper("FKPanel");
        reshelp.resLabel(this.m_lblRefSchema, this.m_refSchemaPicker, UIArb.getString(657), "RefSchema");
        reshelp.resLabel(this.m_lblRefTable, this.m_cmbRefTable, UIArb.getString(658), "RefTable");
        reshelp.resLabel(this.m_lblRefCon, this.m_cmbRefCon, UIArb.getString(659), "RefCon");
        reshelp.resLabel(this.m_lblRefSchema, this.m_txtRefSchema, UIArb.getString(657), "RefSchemaText");
        reshelp.resLabel(this.m_lblRefTable, this.m_txtRefTable, UIArb.getString(658), "RefTableText");
        reshelp.resLabel(this.m_lblRefCon, this.m_txtRefCon, UIArb.getString(659), "RefConText");
        this.m_refSchemaPicker.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                if (FKPanel.this.m_original != null && FKPanel.this.m_refSchemaPicker.getDBObject().equals(FKPanel.this.m_table.getSchema())) {
                    FKPanel.this.m_cmbRefTable.addIDToList(FKPanel.this.m_table.getID());
                }
            }
        });
        this.m_cmbRefCon.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                UniqueConstraint con = (UniqueConstraint)FKPanel.this.m_cmbRefCon.getDBObject();
                FKPanel.this.m_mdlColumns.init(con, false);
                if (con != null && !FKPanel.this.m_initialising) {
                    FKPanel.this.m_lastObjectBasedRef = con.getID();
                }
            }
        });
        this.m_txtRefSchema.addFocusListener(this);
        this.m_txtRefTable.addFocusListener(this);
        this.m_txtRefCon.addFocusListener(this);
        reshelp.resButton(this.m_rdbObjectBased, UIArb.getString(347), "ObjectBased");
        this.m_rdbObjectBased.setActionCommand(SETOBJECTBASED);
        this.m_rdbObjectBased.addActionListener(this);
        reshelp.resButton(this.m_rdbNameBased, UIArb.getString(348), "NameBased");
        this.m_rdbNameBased.setActionCommand(SETNAMEBASED);
        this.m_rdbNameBased.addActionListener(this);
        this.m_rbgBased.add(this.m_rdbObjectBased);
        this.m_rbgBased.add(this.m_rdbNameBased);
        reshelp.resButton(this.m_chkEnabled, UIArb.getString(649), "Enabled");
        this.m_btnAddPK.setPreferredSize(new Dimension(70, 25));
        reshelp.resButton(this.m_btnAddPK, UIArb.getString(665), "AddPK");
        this.m_btnAddPK.addActionListener(this);
        reshelp.resLabel(this.m_lblName, this.m_fldName, UIArb.getString(109), "Name");
        this.m_renderer.setNullLabel(UIArb.getString(69));
        reshelp.resLabel(this.m_lblColAssoc, this.m_tblColumns, UIArb.getString(660), "AssociationsTable");
        this.pnlColumns.setLayout(this.m_layColumns);
        this._setAssociationsColumnHeadings(null);
        this.m_colLocal.setCellEditor(this.m_edTblCols);
        this.m_colLocal.setCellRenderer(this.m_renderer);
        this.m_colRef.setCellRenderer(this.m_renderer);
        this.m_pnlRef.setLayout(this.m_gridBagLayout1);
        this.m_mdlCols.addColumn(this.m_colLocal);
        this.m_mdlCols.addColumn(this.m_colRef);
        reshelp.resLabel(this.m_lblDelete, this.m_cmbDelete, UIArb.getString(664), "OnDelete");
        this.m_cmbDelete.setModel(this.m_mdlDelete);
        this.m_tblColumns.setModel(this.m_mdlColumns);
        this.m_tblColumns.setColumnModel(this.m_mdlCols);
        this.m_scrColumns.getViewport().add((Component)this.m_tblColumns, null);
        this.m_tblColumns.getSelectionModel().addListSelectionListener(this.m_listener);
        Dimension size = new Dimension(28, 25);
        this.m_btnAdd.setPreferredSize(size);
        this.m_btnAdd.setIcon(OracleIcons.getIcon((String)"add.png"));
        DBObjectRenderer.setToolTipText(this.m_btnAdd, UIArb.getString(577));
        this.m_btnAdd.setActionCommand(ADD_CMD);
        this.m_btnAdd.addActionListener(this.m_listener);
        this.m_btnRemove.setPreferredSize(size);
        this.m_btnRemove.setIcon(OracleIcons.getIcon((String)"delete.png"));
        DBObjectRenderer.setToolTipText(this.m_btnRemove, UIArb.getString(578));
        this.m_btnRemove.setActionCommand(REMOVE_CMD);
        this.m_btnRemove.setEnabled(false);
        this.m_btnRemove.addActionListener(this.m_listener);
        this.pnlColumns.add((Component)this.m_lblColAssoc, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_showNameBasedUI) {
            JPanel pnlButtons = new JPanel(new GridBagLayout());
            pnlButtons.add((Component)this.m_scrColumns, new GridBagConstraints(0, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            pnlButtons.add((Component)this.m_btnAdd, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 5, 0, 0), 0, 0));
            pnlButtons.add((Component)this.m_btnRemove, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(2, 5, 0, 0), 0, 0));
            this.pnlColumns.add((Component)pnlButtons, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            this.pnlColumns.add((Component)this.m_scrColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.pnlColumns.add((Component)this.m_lblDelete, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.pnlColumns.add((Component)this.m_cmbDelete, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 0, 0), 0, 0));
        if (this.m_showNameBasedUI) {
            JPanel nameNasedUIRadioPanel = new JPanel(new GridBagLayout());
            nameNasedUIRadioPanel.add((Component)this.m_rdbObjectBased, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            nameNasedUIRadioPanel.add((Component)this.m_rdbNameBased, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 12, 5, 0), 0, 0));
            this.m_pnlRef.add((Component)nameNasedUIRadioPanel, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.m_pnlRef.add((Component)this.m_lblName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 12), 0, 0));
        this.m_pnlRef.add((Component)this.m_fldName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_chkEnabled, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_lblRefSchema, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.m_pnlRef.add((Component)this.m_refSchemaPicker, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_lblRefTable, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.m_pnlRef.add((Component)this.m_cmbRefTable, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_lblRefCon, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.m_pnlRef.add((Component)this.m_cmbRefCon, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_btnAddPK, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 5, 0), 0, 0));
        this.m_txtRefSchema.setVisible(false);
        this.m_txtRefTable.setVisible(false);
        this.m_txtRefCon.setVisible(false);
        this.m_pnlRef.add((Component)this.m_txtRefSchema, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_txtRefTable, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        this.m_pnlRef.add((Component)this.m_txtRefCon, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_pnlRef, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.pnlColumns, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Namespace namespace) throws TraversalException {
        this.m_prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this.m_table = (Table)namespace.find("NewObject");
        this.m_con = (FKConstraint)namespace.find("NewChildObject");
        this.m_otherCons = (Constraint[])namespace.find("otherCons");
        this.m_verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        this.m_original = (Table)namespace.find("OriginalObject");
        this.m_sourceTable = (Table)namespace.find(SOURCE_TABLE);
        this.m_baseConstraintPanel = (BaseConstraintPanel)((Object)namespace.find("constraintPanel"));
        this.m_refSchemaPicker.setProvider(this.m_prov);
        this.m_cmbRefCon.setProvider(this.m_prov);
        this.m_cmbRefTable.setProvider(this.m_prov);
        this.m_cmbRefCon.setFilter(new DBObjectFilter(){

            public boolean accept(DBObject obj) {
                return obj instanceof UniqueConstraint;
            }
        });
        this.m_modifiable = true;
        if (namespace.find("Modifiable") != null) {
            this.m_modifiable = (Boolean)namespace.find("Modifiable");
        }
        this.m_standalone = false;
        if (namespace.find("standAlone") != null) {
            this.m_standalone = (Boolean)namespace.find("standAlone");
        }
        if (this.m_con != null && this.m_con.getReferenceID() != null) {
            try {
                Constraint ref = (Constraint)this.m_con.getReferenceID().resolveID();
                if (ref != null) {
                    this.m_sourceTable = (Table)ref.getRelation();
                }
            }
            catch (DBException e) {
                e.printStackTrace();
            }
        }
        this.m_lastObjectBasedRef = null;
        this.m_lastNameBasedRef = null;
        if (this.m_con != null && this.m_con.getReferenceID() instanceof ReferenceID) {
            this.m_lastNameBasedRef = (ReferenceID)this.m_con.getReferenceID();
            this.m_rdbNameBased.setSelected(true);
            try {
                this.m_initialising = true;
                this.setNamedBased(true);
            }
            finally {
                this.m_initialising = false;
            }
        }
        this.m_lastObjectBasedRef = this.m_con == null ? null : this.m_con.getReferenceID();
        this.m_rdbObjectBased.setSelected(true);
        try {
            this.m_initialising = true;
            this.setNamedBased(false);
        }
        finally {
            this.m_initialising = false;
        }
        if (this.m_mdlColumns.m_fkCols == null || this.m_mdlColumns.m_fkCols.length > 0) {
            // empty if block
        }
        if (!this.m_standalone) {
            this.m_btnAddPK.setVisible(false);
        } else {
            this.m_btnAddPK.setEnabled(FKPanel.getPKConstraint(this.m_sourceTable) == null);
        }
        if (!this.m_initialising && this.m_original == null && this.m_refSchemaPicker.getDBObject().equals(this.m_table.getSchema())) {
            this.m_cmbRefTable.addIDToList(this.m_table.getID());
        }
    }

    protected boolean isPukkaConstraint() {
        DBObjectID refID;
        boolean ok;
        boolean bl = ok = this.m_con != null && !this.m_nameBased;
        if (ok && null != (refID = this.m_con.getReferenceID())) {
            try {
                DBObject refOb = refID.resolveID();
                ok = null != refOb;
            }
            catch (DBException dbe) {
                ok = false;
            }
        }
        return ok;
    }

    private void _initConstraint() throws TraversalException {
        Relation rel;
        String cName = "";
        boolean cEnabled = false;
        DBObject refObj = null;
        Column[] fkCols = new Column[]{};
        int cDelMode = 0;
        if (this.m_nameBased) {
            boolean WhatAreWeDoingHere = true;
        }
        if (this.m_con != null) {
            cName = this.m_prov.getExternalName(this.m_con.getName());
        }
        if (this.isPukkaConstraint()) {
            cEnabled = this.m_con.isEnabled();
            try {
                DBObjectID refID = this.m_con.getReferenceID();
                if (refID != null) {
                    refObj = refID.resolveID();
                }
            }
            catch (DBException ex) {
                // empty catch block
            }
            fkCols = this.m_con.getColumns();
            cDelMode = this.m_con.getDeleteMode();
        } else if (this.m_con != null) {
            this._updateEnabledState(false);
        }
        this.m_chkEnabled.setSelected(cEnabled);
        this.m_mdlDelete.setSelectedItem((Object)ON_DELETE_LABELS[cDelMode]);
        Schema refSchema = null;
        UniqueConstraint ref = refObj instanceof UniqueConstraint ? (UniqueConstraint)refObj : null;
        Object object = rel = ref != null ? ref.getRelation() : this.m_sourceTable;
        if (rel != null) {
            refSchema = rel.getSchema();
        }
        Schema schema = refSchema != null ? refSchema : this.m_currSchema;
        this.m_refSchemaPicker.setDBObject((DBObject)schema);
        this.m_fldName.setText(cName);
        if (schema != null && this.m_loadingTables.containsKey(schema.getName())) {
            throw new TraversalException(null);
        }
        if (rel != null) {
            this.m_cmbRefTable.setDBObject((DBObject)rel);
        } else {
            this._setAssociationsColumnHeadings(this.m_cmbRefTable.getDBObject() == null ? null : this.m_cmbRefTable.getDBObject().getName());
        }
        if (ref != null) {
            this.m_cmbRefCon.setDBObject((DBObject)ref);
        }
        for (int i = 0; i < fkCols.length; ++i) {
            this.m_mdlColumns.setValueAt(fkCols[i], i, 0);
        }
        this.m_fldName.getDocument().addDocumentListener(this.m_nameListener);
    }

    private void initNameBasedConstraint(String schemaName, String tableName, String consName, String[] columnNames) {
        Schema schema = new Schema(schemaName);
        Table table = new Table(tableName, schema);
        UniqueConstraint uk = new UniqueConstraint(consName, (Relation)table);
        if (columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                Column c = new Column(columnNames[i]);
                table.addColumn(c);
                uk.addColumn(c);
            }
        }
        this.m_currSchema = schema;
        this.m_currTableName = tableName;
        this._updateEnabledState(this.m_modifiable);
        this.m_fldName.setText(this.m_prov.getExternalName(this.m_con.getName()));
        this.m_chkEnabled.setSelected(this.m_con.isEnabled());
        this.m_mdlDelete.setSelectedItem((Object)ON_DELETE_LABELS[this.m_con.getDeleteMode()]);
        this.m_txtRefSchema.setText(schemaName);
        this.m_txtRefTable.setText(tableName);
        this.m_txtRefCon.setText(consName);
        this._setAssociationsColumnHeadings(this.m_currTableName);
        this.m_mdlColumns.init(uk, this.m_modifiable);
        this.m_btnAdd.setEnabled(this.m_mdlColumns.canAddRow(0));
        Column[] fkCols = this.m_con.getColumns();
        for (int i = 0; i < fkCols.length; ++i) {
            this.m_mdlColumns.setValueAt(fkCols[i], i, 0);
        }
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_tblColumns.isEditing()) {
            int currRow = this.m_tblColumns.getSelectedRow();
            int currCol = this.m_tblColumns.getSelectedColumn();
            this.m_tblColumns.editCellAt(currRow, 2 - currCol);
            this.m_tblColumns.editCellAt(currRow, currCol);
        }
        if (this.isPukkaConstraint()) {
            String oldRelName = null;
            DBObjectID oldRefID = this.m_con.getReferenceID();
            if (oldRefID != null) {
                try {
                    Relation oldRel;
                    DBObject oldRef = oldRefID.resolveID();
                    if (oldRef instanceof UniqueConstraint && (oldRel = ((UniqueConstraint)oldRef).getRelation()) != null) {
                        oldRelName = oldRel.getName();
                    }
                }
                catch (DBException ex) {
                    // empty catch block
                }
            }
            String conName = this.m_fldName.getText();
            UniqueConstraint ref = (UniqueConstraint)this.m_cmbRefCon.getDBObject();
            if (ref == null) {
                if (oldRelName == null) {
                    oldRelName = this.m_currTableName;
                }
                if (conName.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this.m_currTableName, oldRelName, this.m_prov))) {
                    conName = BaseConstraintPanel.findUniqueName((Relation)this.m_table, (Constraint)this.m_con, this.m_otherCons, this.m_prov);
                }
                this.m_con.setReferenceID(null);
            } else {
                String refTableName;
                Relation refRel = ref.getRelation();
                String string = refTableName = refRel != null ? refRel.getName() : this.m_currTableName;
                if (ModelUtil.areDifferent((Object)oldRelName, (Object)refTableName) && this.isNewConstraint() && conName.startsWith(BaseConstraintPanel.getDefaultFKBaseName(this.m_currTableName, oldRelName, this.m_prov))) {
                    conName = BaseConstraintPanel.findUniqueName(BaseConstraintPanel.getDefaultFKBaseName(this.m_currTableName, refTableName, this.m_prov), (Constraint)this.m_con, this.m_otherCons);
                }
                this.m_con.setReferenceID(ref.getID());
            }
            if (this.m_verifier != null) {
                this.m_verifier.verifyName(conName);
            }
            this.m_con.setName(this.m_prov.getInternalName(conName));
            this.m_fldName.getDocument().removeDocumentListener(this.m_nameListener);
            this.m_fldName.setText(conName);
            this.m_fldName.getDocument().addDocumentListener(this.m_nameListener);
            this.m_con.setEnabled(this.m_chkEnabled.isSelected());
            Column[] cols = this.m_mdlColumns.getTableColumns();
            this.m_con.setColumns(cols);
            this.m_con.setDeleteMode(this.m_cmbDelete.getSelectedIndex());
        } else if (this.m_nameBased) {
            String conName = this.m_fldName.getText();
            if (this.m_verifier != null) {
                this.m_verifier.verifyName(conName);
            }
            this.m_con.setName(this.m_prov.getInternalName(conName));
            this.m_fldName.setText(conName);
            this.m_con.setEnabled(this.m_chkEnabled.isSelected());
            Column[] cols = this.m_mdlColumns.getTableColumns();
            Column[] refCols = this.m_mdlColumns.getRefTableColumns();
            this.m_con.setColumns(cols);
            this.m_con.setDeleteMode(this.m_cmbDelete.getSelectedIndex());
            String schemaName = this.m_prov.getInternalName(this.m_txtRefSchema.getText());
            String tableName = this.m_prov.getInternalName(this.m_txtRefTable.getText());
            String ukName = this.m_prov.getInternalName(this.m_txtRefCon.getText());
            String[] colNames = new String[refCols.length];
            for (int i = 0; i < refCols.length; ++i) {
                colNames[i] = refCols[i].getName();
            }
            this.validateCCReferenceID(this.m_con, schemaName, tableName, ukName, colNames);
            this.setCCReferenceID(this.m_con, schemaName, tableName, ukName, colNames);
        }
        if (this.m_standalone) {
            try {
                this.m_prov.validateObject((DBObject)this.m_con);
                this.m_mdlColumns.removeUnusedColumns();
            }
            catch (ValidationException e) {
                throw new TraversalException(e.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (this.m_rdbNameBased.isSelected()) {
            if (src == this.m_rdbNameBased) {
                this.setNamedBased(true);
            }
        } else if (src == this.m_rdbObjectBased) {
            this.setNamedBased(false);
        } else if (src == this.m_btnAddPK) {
            try {
                PKDialog.createOrEditPK(this.m_prov, this.m_sourceTable, this);
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
    }

    private void setNamedBased(boolean enable) {
        if (this.m_con != null && enable) {
            this.m_nameBased = true;
            String schemaName = "";
            String tableName = "";
            String ukName = "";
            String[] colNames = new String[]{};
            this.m_con.setReferenceID((DBObjectID)this.m_lastNameBasedRef);
            if (this.m_lastNameBasedRef == null) {
                if (this.m_lastObjectBasedRef != null) {
                    schemaName = this.m_refSchemaPicker.getDBObject().getName();
                    if (schemaName == null) {
                        schemaName = "";
                    }
                    tableName = this.m_cmbRefTable.getDBObject() == null ? "" : this.m_prov.getInternalName(this.m_cmbRefTable.getDBObject().getName());
                    ukName = this.m_cmbRefCon.getDBObject() == null ? "" : this.m_prov.getInternalName(this.m_cmbRefCon.getDBObject().getName());
                    Column[] refCols = this.m_mdlColumns.getRefTableColumns();
                    colNames = new String[refCols.length];
                    for (int i = 0; i < refCols.length; ++i) {
                        colNames[i] = this.m_prov.getInternalName(refCols[i].getName());
                    }
                }
                this.setCCReferenceID(this.m_con, schemaName, tableName, ukName, colNames);
                this.m_lastNameBasedRef = (ReferenceID)this.m_con.getReferenceID();
            }
            this.initNameBasedConstraint(this.getSchemaName(this.m_lastNameBasedRef), this.getTableName(this.m_lastNameBasedRef), this.getConstraintName(this.m_lastNameBasedRef), this.getColumnNames(this.m_lastNameBasedRef));
        } else if (!enable) {
            if (this.m_nameBased && this.m_lastNameBasedRef != null) {
                try {
                    this.commit();
                    this.m_lastNameBasedRef = (ReferenceID)this.m_con.getReferenceID();
                }
                catch (TraversalException e) {
                    // empty catch block
                }
            }
            this.m_nameBased = false;
            if (this.m_con != null) {
                this.m_con.setReferenceID(this.m_lastObjectBasedRef);
            }
            this.m_btnAdd.setEnabled(false);
            this.m_btnRemove.setEnabled(false);
            if (this.isPukkaConstraint()) {
                Schema schema = this.m_table.getSchema();
                String tName = this.m_table.getName();
                this.m_currSchema = schema;
                this.m_currTableName = tName;
                this.m_renderer.setNullLabel(UIArb.getString(69));
            } else {
                this.m_currSchema = this.m_table.getSchema();
                this.m_currTableName = this.m_table.getName();
                this.m_renderer.setNullLabel("");
            }
            this._updateEnabledState(this.m_modifiable && this.isPukkaConstraint());
            if (this.m_con != null) {
                this.m_refSchemaPicker.setDBObject((DBObject)this.m_currSchema);
            } else {
                Schema tableSchema = this.m_table.getSchema();
                this.m_refSchemaPicker.setDBObject((DBObject)tableSchema);
            }
            try {
                this._initConstraint();
            }
            catch (TraversalException traversalException) {
                // empty catch block
            }
        }
        if (this.m_con == null) {
            this.m_fldName.setText("");
            this.m_mdlColumns.init(null, false);
        }
        this.m_refSchemaPicker.setVisible(!enable);
        this.m_cmbRefTable.setVisible(!enable);
        this.m_cmbRefCon.setVisible(!enable);
        this.m_txtRefSchema.setVisible(enable);
        this.m_txtRefTable.setVisible(enable);
        this.m_txtRefCon.setVisible(enable);
        this.validate();
    }

    private boolean isNewConstraint() {
        DBObjectID id = this.m_con.getID();
        if (id != null && id instanceof TemporaryObjectID) {
            try {
                if (((TemporaryObjectID)id).resolveOriginalID() != null) {
                    return false;
                }
            }
            catch (DBException dBException) {}
        } else if (id != null) {
            return false;
        }
        return true;
    }

    private void _setDefaultConstraintName(String tableName) {
        if (this.m_con == null || this.isNewConstraint() && this.m_con.getName().startsWith(this.m_currTableName) && this.m_con.getName().contains("_FK")) {
            String candidate = BaseConstraintPanel.getDefaultFKBaseName(this.m_currTableName, tableName, this.m_prov);
            if (this.m_con == null || !candidate.equals(this.m_con.getName())) {
                String conName = BaseConstraintPanel.findUniqueName(candidate, (Constraint)this.m_con, this.m_otherCons);
                this.m_fldName.setText(conName);
            }
        }
    }

    private void _setAssociationsColumnHeadings(String tableName) {
        this.m_colLocal.setHeaderValue(UIArb.getString(661));
        String header = tableName != null && this.m_con != null ? UIArb.format(663, tableName) : UIArb.getString(662);
        this.m_colRef.setHeaderValue(header);
        this.repaint();
    }

    protected void _updateEnabledState(boolean enabled) {
        boolean enableAndNotStandalone = enabled && !this.m_standalone;
        this.m_lblName.setEnabled(enabled);
        this.m_fldName.setEnabled(enabled);
        this.m_chkEnabled.setEnabled(enabled);
        this.m_lblRefSchema.setEnabled(enableAndNotStandalone);
        this.m_refSchemaPicker.setEnabled(enableAndNotStandalone);
        this.m_txtRefSchema.setEnabled(enableAndNotStandalone);
        this.m_lblRefTable.setEnabled(enableAndNotStandalone);
        this.m_cmbRefTable.setEnabled(enableAndNotStandalone);
        this.m_txtRefTable.setEnabled(enableAndNotStandalone);
        this.m_lblRefCon.setEnabled(enabled);
        this.m_cmbRefCon.setEnabled(enabled);
        this.m_txtRefCon.setEnabled(enabled);
        this.m_lblColAssoc.setEnabled(enabled);
        this.m_tblColumns.setEnabled(enabled);
        this.m_lblDelete.setEnabled(enabled);
        this.m_cmbDelete.setEnabled(enabled);
        this.m_rdbObjectBased.setEnabled(enabled);
        this.m_rdbNameBased.setEnabled(enabled);
    }

    private static Object[] insert(Object value, Object[] dest) {
        Arrays.sort(dest);
        int idx = Arrays.binarySearch(dest, value);
        if (idx < 0) {
            int i = -(idx + 1);
            int size = dest.length + 1;
            Object[] tmp = (Object[])Array.newInstance(dest.getClass().getComponentType(), size);
            System.arraycopy(dest, 0, tmp, 0, i);
            tmp[i] = value;
            System.arraycopy(dest, i, tmp, i + 1, dest.length - i);
            dest = tmp;
        }
        return dest;
    }

    protected final void validateCCReferenceID(FKConstraint fk, String schemaName, String tableName, String consName, String[] columnNames) throws TraversalException {
        if (!ModelUtil.hasLength((String)schemaName)) {
            throw new TraversalException(UIArb.getString(670));
        }
        if (!ModelUtil.hasLength((String)tableName)) {
            throw new TraversalException(UIArb.getString(671));
        }
        if (!ModelUtil.hasLength((String)consName)) {
            throw new TraversalException(UIArb.getString(672));
        }
        if (columnNames == null || columnNames.length == 0) {
            throw new TraversalException(UIArb.getString(673));
        }
    }

    protected final void setCCReferenceID(FKConstraint fk, String schemaName, String tableName, String consName, String[] columnNames) {
        DBObjectID existing = fk.getReferenceID();
        boolean skip = false;
        if (existing instanceof ReferenceID && existing.getParent() instanceof ReferenceID) {
            ReferenceID ref = (ReferenceID)existing;
            ReferenceID par = (ReferenceID)existing.getParent();
            boolean bl = skip = ModelUtil.areEqual((Object)ref.getName(), (Object)consName) && ModelUtil.areEqual((Object)ref.getType(), (Object)"CONSTRAINT") && Arrays.equals(ref.getChildObjectNames(), columnNames) && ModelUtil.areEqual((Object)par.getName(), (Object)tableName) && ModelUtil.areEqual((Object)par.getSchemaName(), (Object)schemaName);
        }
        if (!skip) {
            ReferenceID tabID = new ReferenceID("TABLE", schemaName, tableName);
            tabID.setProvider(this.m_prov);
            ReferenceID conID = new ReferenceID("CONSTRAINT", (DBObjectID)tabID, consName, null, columnNames);
            fk.setReferenceID((DBObjectID)conID);
        }
    }

    protected final String getSchemaName(ReferenceID ccRefID) {
        DBObjectID id;
        String schemaName = null;
        if (ccRefID != null && (id = ccRefID.getParent()) instanceof ReferenceID) {
            schemaName = ((ReferenceID)id).getSchemaName();
        }
        return schemaName;
    }

    protected final String getTableName(ReferenceID ccRefID) {
        DBObjectID id;
        String tableName = null;
        if (ccRefID != null && (id = ccRefID.getParent()) instanceof ReferenceID) {
            tableName = ((ReferenceID)id).getName();
        }
        return tableName;
    }

    protected final String getConstraintName(ReferenceID ccRefID) {
        return ccRefID == null ? null : ccRefID.getName();
    }

    protected final String[] getColumnNames(ReferenceID ccRefID) {
        return ccRefID == null ? null : ccRefID.getChildObjectNames();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object src = e.getSource();
        if (src == this.m_txtRefSchema) {
            String t = this.m_txtRefSchema.getText();
            t = this.m_prov.getExternalName(this.m_prov.getInternalName(t));
            this.m_txtRefSchema.setText(t);
        } else if (src == this.m_txtRefTable) {
            String t = this.m_txtRefTable.getText();
            t = this.m_prov.getExternalName(this.m_prov.getInternalName(t));
            this.m_txtRefTable.setText(t);
            this._setAssociationsColumnHeadings(ModelUtil.hasLength((String)t) ? t : null);
        } else if (src == this.m_txtRefCon) {
            String t = this.m_txtRefCon.getText();
            t = this.m_prov.getExternalName(this.m_prov.getInternalName(t));
            this.m_txtRefCon.setText(t);
        }
    }

    private static final PKConstraint getPKConstraint(Table tbl) {
        Constraint[] cons;
        if (tbl == null) {
            return null;
        }
        PKConstraint pk = null;
        for (Constraint con : cons = tbl.getConstraints()) {
            if (!(con instanceof PKConstraint)) continue;
            pk = (PKConstraint)con;
            break;
        }
        return pk;
    }

    public void onEntry(TraversableContext dataContext) {
        try {
            this.init((Namespace)dataContext);
        }
        catch (TraversalException e) {
            e.printStackTrace();
        }
    }

    public Component getComponent() {
        return this;
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    public Object getExitTransition() {
        return null;
    }

    public String getHelpID() {
        return null;
    }

    private class NameListener
    implements DocumentListener {
        private NameListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (FKPanel.this.m_initialising) {
                return;
            }
            String conName = FKPanel.this.m_fldName.getText();
            if (FKPanel.this.m_verifier != null) {
                try {
                    FKPanel.this.m_verifier.verifyName(conName);
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
            }
            if (FKPanel.this.m_con != null) {
                FKPanel.this.m_con.setName(FKPanel.this.m_prov.getInternalName(conName));
            }
            FKPanel.this.m_baseConstraintPanel.updateListUI();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!FKPanel.this.m_initialising) {
                String conName = FKPanel.this.m_fldName.getText();
                if (FKPanel.this.m_verifier != null) {
                    try {
                        FKPanel.this.m_verifier.verifyName(conName);
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                }
                if (FKPanel.this.m_con != null) {
                    FKPanel.this.m_con.setName(FKPanel.this.m_prov.getInternalName(conName));
                }
                FKPanel.this.m_baseConstraintPanel.updateListUI();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }

    private class FKColListener
    implements ItemListener {
        private int m_colPos;
        private int m_rowPos;

        public FKColListener(int column, int row) {
            this.m_colPos = column;
            this.m_rowPos = row;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() != 2) {
                JComboBox src = (JComboBox)e.getSource();
                FKPanel.this.m_mdlColumns.setValueAt(src.getSelectedItem(), this.m_rowPos, this.m_colPos);
            }
        }
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        private L() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int row = FKPanel.this.m_tblColumns.getSelectedRow();
            this.updateButtons(row);
        }

        private void updateButtons(int row) {
            FKPanel.this.m_btnAdd.setEnabled(FKPanel.this.m_mdlColumns.canAddRow(row));
            FKPanel.this.m_btnRemove.setEnabled(FKPanel.this.m_mdlColumns.canRemoveRow(row));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int sel = FKPanel.this.m_tblColumns.getSelectedRow();
            String cmd = e.getActionCommand();
            if (FKPanel.ADD_CMD.equals(cmd)) {
                if (sel >= 0) {
                    FKPanel.this.m_mdlColumns.addConsColumn(sel);
                } else {
                    FKPanel.this.m_mdlColumns.addConsColumn();
                }
            } else if (FKPanel.REMOVE_CMD.equals(cmd)) {
                FKPanel.this.m_mdlColumns.removeConsColumn(sel);
            }
        }
    }

    private class FKTableCellEditor
    extends DefaultCellEditor {
        private JComboBox m_cmbColumns;
        private FKColListener m_fkColListener;

        FKTableCellEditor(JComboBox cmbColumns) {
            super(cmbColumns);
            this.m_cmbColumns = cmbColumns;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this.m_fkColListener != null) {
                this.m_cmbColumns.removeItemListener(this.m_fkColListener);
            }
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            ColumnsModel cm = (ColumnsModel)table.getModel();
            Column[] refCols = cm.getRefTableColumns();
            Column refCol = refCols[row];
            return this.filterInvalidTypes(refCol, row);
        }

        private Component filterInvalidTypes(Column refCol, int row) {
            ArrayList<Column> includeCols = new ArrayList<Column>();
            for (Column col : FKPanel.this.m_table.getColumns()) {
                if (!FKPanel.this.m_prov.getDescriptor().isValidFKDataType(this.getDataType(col), this.getDataType(refCol))) continue;
                includeCols.add(col);
            }
            DefaultComboBoxModel<Object> mdlRelCols = new DefaultComboBoxModel<Object>(FKPanel.this.m_nameBased ? FKPanel.this.m_table.getColumns() : includeCols.toArray());
            this.m_cmbColumns.setModel(mdlRelCols);
            this.m_cmbColumns.setRenderer(FKPanel.this.m_renderer);
            this.m_cmbColumns.setEditable(FKPanel.this.m_standalone);
            this.m_fkColListener = new FKColListener(0, row);
            this.m_cmbColumns.addItemListener(this.m_fkColListener);
            return this.m_cmbColumns;
        }

        private DataType getDataType(Column column) {
            DataType dt = null;
            try {
                dt = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            return dt;
        }
    }

    private class ColumnsModel
    extends AbstractTableModel {
        private Column[] m_fkCols = new Column[0];
        private Column[] m_refCols = new Column[0];
        private List<Column> m_newCols = new ArrayList<Column>();
        private List<Column> m_excludeCols = new ArrayList<Column>();
        private Boolean[] m_isDefaultName = new Boolean[0];
        private boolean m_refColsEditable;

        public void init(UniqueConstraint cons, boolean editable) {
            this.m_refCols = cons != null ? cons.getColumns() : new Column[]{};
            this.m_fkCols = new Column[this.m_refCols.length];
            this.m_isDefaultName = new Boolean[this.m_refCols.length];
            this.m_refColsEditable = editable;
            for (int i = 0; i < this.m_refCols.length; ++i) {
                this.m_isDefaultName[i] = Boolean.FALSE;
                this.m_excludeCols.clear();
                ArrayList<Column> localCols = new ArrayList<Column>();
                for (int j = 0; j < FKPanel.this.m_table.getColumns().length; ++j) {
                    Column col = FKPanel.this.m_table.getColumns()[j];
                    if (FKPanel.this.m_prov.getDescriptor().isValidFKDataType(this.getDataType(col), this.getDataType(this.m_refCols[i]))) {
                        localCols.add(col);
                        continue;
                    }
                    this.m_excludeCols.add(col);
                }
                for (Column col : localCols) {
                    if (!col.getName().equals(this.m_refCols[i].getName())) continue;
                    if (!this.isFKColumn(col)) {
                        this.m_fkCols[i] = col;
                    }
                    for (int k = 0; k < i; ++k) {
                        if (!col.equals((Object)this.m_fkCols[k])) continue;
                        this.m_fkCols[k] = this.getFkColumn(localCols);
                    }
                }
                if (this.m_fkCols[i] != null) continue;
                if (!FKPanel.this.m_standalone) {
                    this.m_fkCols[i] = this.getFkColumn(localCols);
                    continue;
                }
                Column fkCol = this.createFkColBasedOnRefCol(this.m_refCols[i], i, 0, this.m_excludeCols);
            }
            this.fireTableDataChanged();
        }

        private Column getFkColumn(List<Column> localCols) {
            Column retCol = null;
            localCols.removeAll(this.m_excludeCols);
            List<Column> fkCols = Arrays.asList(this.m_fkCols);
            for (Column col : localCols) {
                if (fkCols.contains(col)) continue;
                retCol = col;
                break;
            }
            return retCol;
        }

        public Column[] getTableColumns() {
            return this.m_fkCols;
        }

        public Column[] getRefTableColumns() {
            return this.m_refCols;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.m_fkCols[rowIndex];
                }
                case 1: {
                    if (this.m_refColsEditable) {
                        return FKPanel.this.m_prov.getExternalName(this.m_refCols[rowIndex].getName());
                    }
                    return this.m_refCols[rowIndex];
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue != null) {
                Column c;
                Column column = c = aValue instanceof Column ? (Column)aValue : null;
                if (columnIndex == 0 && rowIndex < this.m_fkCols.length && (this.m_fkCols[rowIndex] != c || c == null)) {
                    if (c == null && ((String)aValue).length() > 0) {
                        Column refCol = this.m_refCols[rowIndex];
                        c = this.determineFKColumn(refCol, (String)aValue);
                    }
                    this.m_fkCols[rowIndex] = c;
                    if (this.m_isDefaultName[rowIndex].booleanValue()) {
                        this.m_refCols[rowIndex].setName(this.getDefaultName(c));
                        this.fireTableRowsUpdated(rowIndex, rowIndex);
                    } else {
                        this.fireTableCellUpdated(rowIndex, columnIndex);
                    }
                } else if (columnIndex == 1) {
                    String name = c.getName();
                    name = FKPanel.this.m_prov.getInternalName(name);
                    c.setName(name);
                    this.m_refCols[rowIndex] = c;
                    this.m_isDefaultName[rowIndex] = Boolean.FALSE;
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
            }
        }

        public Column createFkColBasedOnRefCol(Column refCol, int rowIndex, int columnIndex, List<Column> cols) {
            Column retCol;
            Column compareCol2 = null;
            String candidateName = refCol.getName();
            Constraint[] cons = FKPanel.this.m_table.getConstraints();
            for (int i = 0; i < cons.length; ++i) {
                Constraint con = cons[i];
                if (!(con instanceof FKConstraint)) continue;
                Column[] fkcols = ((FKConstraint)con).getColumns();
                cols.addAll(Arrays.asList(fkcols));
            }
            cols.addAll(Arrays.asList(this.m_fkCols));
            ArrayList<String> colNames = new ArrayList<String>();
            for (Column compareCol2 : cols) {
                if (compareCol2 == null) continue;
                colNames.add(compareCol2.getName());
            }
            candidateName = DBUtil.getUniqueName(colNames, (String)candidateName, (boolean)true);
            this.m_fkCols[rowIndex] = retCol = this.determineFKColumn(refCol, candidateName);
            if (this.m_isDefaultName[rowIndex].booleanValue()) {
                this.m_refCols[rowIndex].setName(this.getDefaultName(retCol));
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            } else {
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
            return retCol;
        }

        private Column determineFKColumn(Column refCol, String candidateName) {
            Column retCol = null;
            Column[] tabCols = FKPanel.this.m_table.getColumns();
            for (int i = 0; i < tabCols.length; ++i) {
                Column compareCol = tabCols[i];
                if (!compareCol.getName().equals(candidateName)) continue;
                retCol = compareCol;
                break;
            }
            if (retCol == null) {
                retCol = new Column();
                retCol.setName(candidateName);
                FKPanel.this.m_table.addColumn(retCol);
                DataTypeUsage dtu = refCol.getDataTypeUsage();
                retCol.setDataTypeUsage((DataTypeUsage)dtu.copyTo(null));
                this.m_newCols.add(retCol);
            }
            return retCol;
        }

        public void removeUnusedColumns() {
            List<Column> keepColList = Arrays.asList(this.getTableColumns());
            for (Column compareCol : this.m_newCols) {
                if (keepColList.contains(compareCol)) continue;
                FKPanel.this.m_table.removeColumn(compareCol);
            }
        }

        @Override
        public int getRowCount() {
            return this.m_fkCols.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return FKPanel.this.m_modifiable && (columnIndex == 0 || this.m_refColsEditable);
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return UIArb.getString(661);
                }
                case 1: {
                    return UIArb.getString(662);
                }
            }
            return null;
        }

        public Class getColumnClass(int columnIndex) {
            return Column.class;
        }

        private DataType getDataType(Column column) {
            DataType dt = null;
            try {
                dt = DataTypeHelper.getDataType((DataTypeUsage)column.getDataTypeUsage());
            }
            catch (DBException dBException) {
                // empty catch block
            }
            return dt;
        }

        public void addConsColumn() {
            this.addConsColumn(this.m_fkCols.length - 1);
        }

        public void addConsColumn(int idx) {
            ++idx;
            ArrayList<Column> fkCols = new ArrayList<Column>();
            ArrayList<Column> refCols = new ArrayList<Column>();
            ArrayList<Boolean> isDefaultName = new ArrayList<Boolean>();
            for (int i = 0; i < this.m_fkCols.length; ++i) {
                fkCols.add(this.m_fkCols[i]);
                refCols.add(this.m_refCols[i]);
                isDefaultName.add(this.m_isDefaultName[i]);
            }
            Column defFKCol = FKPanel.this.m_table.getColumns()[0];
            for (int i = 0; i < FKPanel.this.m_table.getColumns().length; ++i) {
                if (fkCols.contains(FKPanel.this.m_table.getColumns()[i])) continue;
                defFKCol = FKPanel.this.m_table.getColumns()[i];
                break;
            }
            Column c = new Column(this.getDefaultName(defFKCol));
            refCols.add(idx, c);
            fkCols.add(idx, defFKCol);
            isDefaultName.add(idx, Boolean.TRUE);
            this.m_refCols = refCols.toArray(new Column[refCols.size()]);
            this.m_fkCols = fkCols.toArray(new Column[fkCols.size()]);
            this.m_isDefaultName = isDefaultName.toArray(new Boolean[isDefaultName.size()]);
            this.fireTableRowsInserted(idx, idx);
            FKPanel.this.m_btnAdd.setEnabled(FKPanel.this.m_mdlColumns.canAddRow(idx));
            FKPanel.this.m_btnRemove.setEnabled(FKPanel.this.m_mdlColumns.canRemoveRow(idx));
        }

        private String getDefaultName(Column fkCol) {
            String base = fkCol.getName();
            String defName = null;
            int i = 0;
            while (true) {
                defName = base;
                if (i > 0) {
                    defName = defName + i;
                }
                boolean found = false;
                for (Column c : this.m_refCols) {
                    if (!c.getName().equals(defName)) continue;
                    found = true;
                    break;
                }
                if (!found) break;
                ++i;
            }
            return defName;
        }

        private boolean isFKColumn(Column col) {
            boolean isFKCol = false;
            Constraint[] cons = FKPanel.this.m_table.getConstraints();
            for (int i = 0; i < cons.length; ++i) {
                Constraint con = cons[i];
                if (!(con instanceof FKConstraint)) continue;
                Column[] fkcols = ((FKConstraint)con).getColumns();
                for (int k = 0; k < fkcols.length; ++k) {
                    Column compareCol = fkcols[k];
                    if (!compareCol.equals((Object)col)) continue;
                    return true;
                }
            }
            return isFKCol;
        }

        public boolean canAddRow(int rowIndex) {
            return this.m_refColsEditable && this.m_fkCols.length < FKPanel.this.m_table.getColumns().length;
        }

        public boolean canRemoveRow(int rowIndex) {
            return this.m_refColsEditable && rowIndex >= 0;
        }

        public void removeConsColumn(int idx) {
            ArrayList<Column> fkCols = new ArrayList<Column>();
            ArrayList<Column> refCols = new ArrayList<Column>();
            for (int i = 0; i < this.m_fkCols.length; ++i) {
                fkCols.add(this.m_fkCols[i]);
                refCols.add(this.m_refCols[i]);
            }
            fkCols.remove(idx);
            refCols.remove(idx);
            this.m_refCols = refCols.toArray(new Column[refCols.size()]);
            this.m_fkCols = fkCols.toArray(new Column[fkCols.size()]);
            this.fireTableRowsDeleted(idx, idx);
        }
    }
}

