/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.ide.db.UIArb;
import oracle.ide.db.dialogs.DBExceptionDialog;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.Directory;
import oracle.javatools.db.ora.OracleExternalTableProperties;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public class ExternalTablePropPanel
extends BaseInfoPanel
implements ActionListener,
ListSelectionListener {
    private DBObjectRenderer m_rend = new DBObjectRenderer();
    private boolean m_editing;
    private List<Directory> m_dirs;
    private boolean m_popDirs;
    private JLabel m_driverLabel = new JLabel();
    private JComboBox m_driverComboBox = new JComboBox();
    private JLabel m_defDirLabel = new JLabel();
    private JComboBox m_defDirComboBox = new JComboBox();
    private JLabel m_projColLabel = new JLabel();
    private JComboBox m_projColComboBox = new JComboBox();
    private JLabel m_rejectLabel = new JLabel();
    private JTextField m_rejectField = new JTextField();
    private JCheckBox m_usingClobCheckBox = new JCheckBox();
    private JLabel m_accessLabel = new JLabel();
    private JTextArea m_accessText = new JTextArea();
    private JLabel m_locLabel = new JLabel();
    private LocationTableModel m_locTableModel = new LocationTableModel();
    private JTable m_locTable = new JTable(this.m_locTableModel);
    private JButton m_addLocButton = new JButton();
    private JButton m_delLocButton = new JButton();
    private static final Schema SCHEMA_SYS = new Schema("SYS");

    public ExternalTablePropPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.m_driverComboBox.setName("CMB_DRIVER");
        ResourceUtils.resLabel((JLabel)this.m_driverLabel, (Component)this.m_driverComboBox, (String)UIArb.getString(439));
        this.m_defDirComboBox.setName("CMB_DEF_DIR");
        ResourceUtils.resLabel((JLabel)this.m_defDirLabel, (Component)this.m_defDirComboBox, (String)UIArb.getString(441));
        this.m_rejectField.setName("FLD_REJECT");
        ResourceUtils.resLabel((JLabel)this.m_rejectLabel, (Component)this.m_rejectField, (String)UIArb.getString(442));
        this.m_projColComboBox.setName("CMB_PROJ_COL");
        ResourceUtils.resLabel((JLabel)this.m_projColLabel, (Component)this.m_projColComboBox, (String)UIArb.getString(446));
        this.m_accessText.setName("TXT_ACCESS");
        ResourceUtils.resLabel((JLabel)this.m_accessLabel, (Component)this.m_accessText, (String)UIArb.getString(444));
        this.m_usingClobCheckBox.setName("CB_USING_CLOB");
        ResourceUtils.resButton((AbstractButton)this.m_usingClobCheckBox, (String)UIArb.getString(445));
        this.m_locTable.setName("TBL_LOCATION");
        ResourceUtils.resLabel((JLabel)this.m_locLabel, (Component)this.m_locTable, (String)UIArb.getString(443));
        Dimension size = new Dimension(28, 25);
        Insets margin = new Insets(5, 5, 5, 5);
        this.m_addLocButton.setPreferredSize(size);
        this.m_addLocButton.setMargin(margin);
        this.m_addLocButton.setIcon(OracleIcons.getIcon((String)"add.png"));
        this.m_addLocButton.addActionListener(this);
        this.m_addLocButton.getAccessibleContext().setAccessibleName(UIArb.getString(450));
        this.m_delLocButton.setPreferredSize(size);
        this.m_delLocButton.setMargin(margin);
        this.m_delLocButton.setIcon(OracleIcons.getIcon((String)"delete.png"));
        this.m_delLocButton.addActionListener(this);
        this.m_delLocButton.setEnabled(false);
        this.m_delLocButton.getAccessibleContext().setAccessibleName(UIArb.getString(451));
        this.m_defDirComboBox.setRenderer(this.m_rend);
        this.m_locTable.setSelectionMode(0);
        this.m_locTable.getSelectionModel().addListSelectionListener(this);
        this.m_locTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        int y = 0;
        int x = 0;
        this.add(this.m_defDirLabel, new GridBagConstraints(x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_defDirComboBox, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(this.m_rejectLabel, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_rejectField, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        x = 0;
        this.add(this.m_driverLabel, new GridBagConstraints(x, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_driverComboBox, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        this.add(this.m_projColLabel, new GridBagConstraints(++x, y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_projColComboBox, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 10), 0, 0));
        x = 0;
        this.add(this.m_accessLabel, new GridBagConstraints(x, ++y, 4, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        this.add(this.m_usingClobCheckBox, new GridBagConstraints(++x, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 25, 0, 5), 0, 0));
        x = 0;
        this.add(new JScrollPane(this.m_accessText), new GridBagConstraints(x, ++y, 4, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 0, 5), 0, 0));
        x = 0;
        JPanel locPanel = new JPanel();
        this.layoutLocationComponents(locPanel);
        this.add(locPanel, new GridBagConstraints(x, ++y, 4, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        for (OracleExternalTableProperties.ProjectColumn pc : OracleExternalTableProperties.ProjectColumn.values()) {
            this.m_projColComboBox.addItem(pc);
        }
        this.m_driverComboBox.addItem("ORACLE_LOADER");
        this.m_driverComboBox.addItem("ORACLE_DATAPUMP");
        this.m_rejectField.setText("0");
    }

    private void layoutLocationComponents(JPanel panel) {
        panel.setLayout(new GridBagLayout());
        panel.add((Component)this.m_locLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(15, 5, 0, 5), 0, 0));
        panel.add((Component)new JScrollPane(this.m_locTable), new GridBagConstraints(0, 1, 1, 1, 2.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridBagLayout());
        buttons.add((Component)this.m_addLocButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        buttons.add((Component)this.m_delLocButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 5), 0, 0));
        buttons.add(Box.createVerticalGlue(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.1, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)buttons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        boolean edit = dataContext.get("OriginalObject") != null;
        OracleExternalTableProperties oetp = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
        this.init(pro, tab, oetp, edit);
        if (!((Boolean)dataContext.find("DBObjectIsEditable")).booleanValue()) {
            this.enablePropertiesWidgets(false);
        }
    }

    private void init(DBObjectProvider pro, Table tab, OracleExternalTableProperties oetp, boolean edit) {
        super.init(pro, null);
        this.m_editing = edit;
        this.populateDirectories();
        this.enablePropertiesWidgets(true);
        if (!(pro instanceof Database)) {
            this.m_defDirComboBox.setEditable(true);
            this.m_defDirComboBox.getEditor().getEditorComponent().setName("CMB_DEF_DIR_Editor");
        }
        if (oetp != null) {
            this.m_driverComboBox.setSelectedItem(oetp.getAccessDriverType());
            this.m_rejectField.setText(oetp.getRejectLimit());
            this.m_usingClobCheckBox.setSelected(oetp.isAccessUsingClob());
            Object accessParams = oetp.getAccessParameters();
            this.m_accessText.setText(accessParams == null ? null : accessParams.toString());
            this.m_locTableModel.setLocations(oetp.getLocationSpecifiers());
            String dirName = DBUtil.getDBObjectName((DBObjectID)oetp.getDefaultDirectory());
            this.m_defDirComboBox.setSelectedItem(pro.getExternalName(dirName));
            if (this.m_editing) {
                this.m_projColComboBox.setSelectedItem(oetp.getProjectColumn());
            }
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        DBObjectProvider pro = (DBObjectProvider)dataContext.get("DBObjectProvider");
        Table tab = (Table)dataContext.get("NewObject");
        OracleExternalTableProperties oetp = (OracleExternalTableProperties)tab.getProperty("OracleExternalTableProperties");
        if (oetp == null) {
            oetp = new OracleExternalTableProperties();
            tab.setProperty("OracleExternalTableProperties", (Object)oetp);
        }
        this.commit(pro, tab, oetp);
    }

    protected List<Directory> getDirectories() {
        return this.m_dirs;
    }

    private void commit(DBObjectProvider pro, Table tab, OracleExternalTableProperties oetp) throws TraversalException {
        String name;
        if (this.m_locTable.getCellEditor() != null) {
            this.m_locTable.getCellEditor().stopCellEditing();
        }
        oetp.setAccessDriverType((String)this.m_driverComboBox.getSelectedItem());
        oetp.setRejectLimit(this.m_rejectField.getText());
        oetp.setAccessUsingClob(this.m_usingClobCheckBox.isSelected());
        String accessParameters = this.m_accessText.getText();
        if (ModelUtil.hasLength((String)accessParameters)) {
            oetp.setAccessParameters((Object)accessParameters);
        } else {
            oetp.setAccessParameters(null);
        }
        Object selection = this.m_defDirComboBox.getSelectedItem();
        String string = name = selection != null ? pro.getInternalName((String)selection) : null;
        if (name != null) {
            oetp.setDefaultDirectory((DBObjectID)new ReferenceID("DIRECTORY", SCHEMA_SYS, name));
        }
        oetp.setLocationSpecifiers(this.m_locTableModel.getLocations());
        oetp.setProjectColumn((OracleExternalTableProperties.ProjectColumn)this.m_projColComboBox.getSelectedItem());
    }

    private void populateDirectories() {
        DBObjectProvider pro = this.getProvider();
        if (this.m_dirs == null && pro != null) {
            this.m_popDirs = false;
            ArrayList<Directory> dirs = new ArrayList<Directory>();
            try {
                SchemaObject[] objs = pro.listObjects(new String[]{"DIRECTORY"}, new Schema("SYS"));
                if (objs != null) {
                    for (int i = 0; i < objs.length; ++i) {
                        dirs.add((Directory)objs[i]);
                    }
                }
                this.m_dirs = dirs;
            }
            catch (DBException dbe) {
                DBExceptionDialog.showErrorDialog((Component)((Object)this), UIArb.getString(437), dbe);
            }
        }
        if (this.m_dirs != null && !this.m_popDirs) {
            JComboBox<String> cb = new JComboBox<String>();
            cb.setName("CMB_LocationDirectory");
            cb.addItem(UIArb.getString(447));
            cb.setRenderer(this.m_rend);
            if (!(this.getProvider() instanceof Database)) {
                cb.setEditable(true);
                cb.getEditor().getEditorComponent().setName("CMB_LocationDirectory_Editor");
            }
            this.m_defDirComboBox.removeAllItems();
            for (Directory dir : this.m_dirs) {
                String dirName = pro.getExternalName(dir.getName());
                this.m_defDirComboBox.addItem(dirName);
                cb.addItem(dirName);
            }
            TableColumn col = this.m_locTable.getColumn(UIArb.getString(448));
            col.setCellEditor(new DefaultCellEditor(cb));
            this.m_popDirs = true;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_addLocButton) {
            int addAt = this.m_locTable.getSelectedRow() + 1;
            if (addAt == 0) {
                addAt = this.m_locTableModel.getRowCount();
            }
            this.m_locTableModel.addLocation(addAt, new OracleExternalTableProperties.LocationSpecifier());
            this.m_locTable.setRowSelectionInterval(addAt, addAt);
        } else if (source == this.m_delLocButton) {
            int row = this.m_locTable.getSelectedRow();
            this.m_locTableModel.removeLocation(row);
            int left = this.m_locTableModel.getRowCount();
            if (row >= left) {
                if (left > 0) {
                    this.m_locTable.setRowSelectionInterval(left - 1, left - 1);
                }
            } else {
                this.m_locTable.setRowSelectionInterval(row, row);
            }
        }
    }

    private void enablePropertiesWidgets(boolean ext) {
        boolean editable = !this.m_editing || this.m_editing && !(this.getProvider() instanceof Database);
        this.m_driverLabel.setEnabled(ext && editable);
        this.m_driverComboBox.setEnabled(ext && editable);
        this.m_rejectLabel.setEnabled(ext);
        this.m_rejectField.setEnabled(ext);
        this.m_accessLabel.setEnabled(ext);
        this.m_accessText.setEnabled(ext);
        this.m_usingClobCheckBox.setEnabled(ext);
        this.m_defDirLabel.setEnabled(ext);
        this.m_defDirComboBox.setEnabled(ext);
        this.m_locLabel.setEnabled(ext);
        this.m_locTable.setEnabled(ext);
        this.m_addLocButton.setEnabled(ext);
        this.m_delLocButton.setEnabled(ext);
        if (ext) {
            this.valueChanged(null);
        }
        boolean x = this.getProvider().getDescriptor().supportsFeature("ORACLE_EXTERNAL_TABLE_PROJECT_COLUMN");
        this.m_projColLabel.setEnabled(ext && x);
        this.m_projColComboBox.setEnabled(ext && x);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        int i = this.m_locTable.getSelectedRow();
        this.m_delLocButton.setEnabled(i >= 0 && i < this.m_locTableModel.getRowCount());
    }

    private class LocationTableModel
    extends AbstractTableModel {
        private List<OracleExternalTableProperties.LocationSpecifier> m_locs = new ArrayList<OracleExternalTableProperties.LocationSpecifier>();

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.m_locs.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OracleExternalTableProperties.LocationSpecifier loc = this.m_locs.get(rowIndex);
            if (loc != null) {
                switch (columnIndex) {
                    case 0: {
                        String dirName = DBUtil.getDBObjectName((DBObjectID)loc.getDirectory());
                        if (ModelUtil.hasLength((String)dirName)) {
                            return ExternalTablePropPanel.this.getProvider().getExternalName(dirName);
                        }
                        return UIArb.getString(447);
                    }
                    case 1: {
                        return loc.getSpecifier();
                    }
                }
            }
            return null;
        }

        public void addLocation(OracleExternalTableProperties.LocationSpecifier l) {
            this.m_locs.add(l);
            int length = this.m_locs.size();
            this.fireTableRowsInserted(length - 1, length - 1);
        }

        public void addLocation(int i, OracleExternalTableProperties.LocationSpecifier l) {
            this.m_locs.add(i, l);
            this.fireTableRowsInserted(i, i);
        }

        public OracleExternalTableProperties.LocationSpecifier removeLocation(int i) {
            OracleExternalTableProperties.LocationSpecifier gone = this.m_locs.remove(i);
            if (gone != null) {
                this.fireTableRowsDeleted(i, i);
            }
            return gone;
        }

        public void removeAllLocations() {
            this.m_locs.clear();
            this.fireTableDataChanged();
        }

        public OracleExternalTableProperties.LocationSpecifier[] getLocations() {
            return this.m_locs.toArray(new OracleExternalTableProperties.LocationSpecifier[this.m_locs.size()]);
        }

        public void setLocations(OracleExternalTableProperties.LocationSpecifier[] locSpecs) {
            this.m_locs.clear();
            if (locSpecs != null) {
                for (OracleExternalTableProperties.LocationSpecifier l : locSpecs) {
                    this.m_locs.add(l);
                }
            }
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return UIArb.getString(448);
                }
            }
            return UIArb.getString(449);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            OracleExternalTableProperties.LocationSpecifier loc = this.m_locs.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (aValue == UIArb.getString(447)) {
                        loc.setDirectory(null);
                    } else if (aValue instanceof Directory) {
                        loc.setDirectory(((Directory)aValue).getID());
                    } else if (aValue instanceof String) {
                        String dirName = ExternalTablePropPanel.this.getProvider().getInternalName((String)aValue);
                        loc.setDirectory((DBObjectID)new ReferenceID("DIRECTORY", SCHEMA_SYS, dirName));
                    }
                    return;
                }
                case 1: {
                    loc.setSpecifier((String)aValue);
                    return;
                }
            }
        }
    }
}

