/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.ReorderableListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.table.BaseConstraintPanel;
import oracle.ide.db.panels.table.ConstraintPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ConstraintsInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Table;
import oracle.javatools.db.UniqueConstraint;

public class ConstraintColumnSelectionPanel
extends JPanel
implements ConstraintPanel {
    private JList lstFrom = new JList();
    private JList lstTo = new JList();
    private ListPicker pckFrom = new ListPicker(this.lstFrom);
    private ListPicker pckTo = new ReorderableListPicker(this.lstTo);
    private Shuttle shtColumns = new Shuttle();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JLabel lblFrom = new JLabel();
    private JLabel lblTo = new JLabel();
    private JCheckBox chkEnabled = new JCheckBox();
    private JLabel lblName = new JLabel();
    private JTextField fldName = new JTextField();
    private DBObjectRenderer renderer = new DBObjectRenderer();
    private NameListener _nameListener = new NameListener();
    protected Table _table;
    private UniqueConstraint _con;
    private ConstraintsInfoVerifier _verifier;
    protected DBObjectProvider _prov;
    private boolean _initialising = false;
    private BaseConstraintPanel _baseConstraintPanel;
    protected DefaultListModel mdlFrom;
    protected DefaultListModel mdlTo;

    public ConstraintColumnSelectionPanel(String pnlName) {
        try {
            this.jbInit(pnlName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit(String pnlName) throws Exception {
        DBUIResourceHelper reshelp = new DBUIResourceHelper(pnlName);
        this.setLayout(this.gridBagLayout1);
        this.shtColumns.setFromPicker((ItemPicker)this.pckFrom);
        this.shtColumns.setToPicker((ItemPicker)this.pckTo);
        reshelp.resButton(this.chkEnabled, UIArb.getString(649), "Enabled");
        reshelp.resLabel(this.lblName, this.fldName, UIArb.getString(648), "Name");
        this.shtColumns.add((Component)this.lblFrom, (Object)"FromHeader");
        this.shtColumns.add((Component)this.lblTo, (Object)"ToHeader");
        reshelp.resLabel(this.lblFrom, this.lstFrom, UIArb.getString(677), "Available");
        reshelp.resLabel(this.lblTo, this.lstTo, UIArb.getString(678), "Selected");
        this.lstFrom.setCellRenderer(this.renderer);
        this.lstTo.setCellRenderer(this.renderer);
        this.add((Component)this.shtColumns, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.chkEnabled, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 12, 0, 0), 0, 0));
        this.add((Component)this.lblName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 12), 0, 0));
        this.add((Component)this.fldName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void init(Namespace namespace) {
        this._prov = (DBObjectProvider)namespace.find("DBObjectProvider");
        this._table = (Table)namespace.find("NewObject");
        this._con = (UniqueConstraint)namespace.find("NewChildObject");
        this._verifier = (ConstraintsInfoVerifier)namespace.find("ConstraintsInfoVerifier");
        this._baseConstraintPanel = (BaseConstraintPanel)((Object)namespace.find("constraintPanel"));
        boolean modifiable = (Boolean)namespace.find("Modifiable");
        this.mdlFrom = new DefaultListModel();
        this.mdlTo = new DefaultListModel();
        this._initialising = true;
        if (this._con != null) {
            int i;
            this.fldName.setText(this._prov.getExternalName(this._con.getName()));
            this.chkEnabled.setSelected(this._con.isEnabled());
            Column[] tblCols = this._table.getColumns();
            Column[] consCols = this._con.getColumns();
            for (i = 0; i < tblCols.length; ++i) {
                this.mdlFrom.addElement(tblCols[i]);
            }
            for (i = 0; i < consCols.length; ++i) {
                if (this.mdlFrom.contains(consCols[i])) {
                    this.mdlFrom.removeElement(consCols[i]);
                }
                this.mdlTo.addElement(consCols[i]);
            }
        } else {
            this.fldName.setText("");
            this.chkEnabled.setSelected(false);
        }
        this.lstFrom.setModel(this.mdlFrom);
        this.lstTo.setModel(this.mdlTo);
        this.lstFrom.setSelectedIndex(0);
        this.shtColumns.setEnabled(modifiable);
        this.lstFrom.setEnabled(modifiable);
        this.lstTo.setEnabled(modifiable);
        this.fldName.setEnabled(modifiable);
        this.chkEnabled.setEnabled(modifiable);
        this.shtColumns.validate();
        this.fldName.getDocument().addDocumentListener(this._nameListener);
        this._initialising = false;
    }

    public void addShuttleListener(ShuttleListener listener) {
        this.shtColumns.addShuttleListener(listener);
    }

    public void removeShuttleListener(ShuttleListener listener) {
        this.shtColumns.removeShuttleListener(listener);
    }

    public boolean canCommit() {
        DefaultListModel mdl = (DefaultListModel)this.lstTo.getModel();
        return mdl.getSize() > 0;
    }

    @Override
    public void commit() throws TraversalException {
        if (this._con != null) {
            this._con.setEnabled(this.chkEnabled.isSelected());
            DefaultListModel mdl = (DefaultListModel)this.lstTo.getModel();
            Object[] cols = new Column[mdl.getSize()];
            mdl.copyInto(cols);
            this._con.setColumns((Column[])cols);
            String conName = this.fldName.getText();
            if (this._verifier != null) {
                this._verifier.verifyName(conName);
            }
            this._con.setName(this._prov.getInternalName(conName));
        }
    }

    private class NameListener
    implements DocumentListener {
        private NameListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (ConstraintColumnSelectionPanel.this._initialising) {
                return;
            }
            String conName = ConstraintColumnSelectionPanel.this.fldName.getText();
            if (ConstraintColumnSelectionPanel.this._verifier != null) {
                try {
                    ConstraintColumnSelectionPanel.this._verifier.verifyName(conName);
                }
                catch (TraversalException traversalException) {
                    // empty catch block
                }
            }
            if (ConstraintColumnSelectionPanel.this._con != null) {
                ConstraintColumnSelectionPanel.this._con.setName(ConstraintColumnSelectionPanel.this._prov == null ? conName : ConstraintColumnSelectionPanel.this._prov.getInternalName(conName));
            }
            if (ConstraintColumnSelectionPanel.this._baseConstraintPanel != null) {
                ConstraintColumnSelectionPanel.this._baseConstraintPanel.updateListUI();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (!ConstraintColumnSelectionPanel.this._initialising) {
                String conName = ConstraintColumnSelectionPanel.this.fldName.getText();
                if (ConstraintColumnSelectionPanel.this._verifier != null) {
                    try {
                        ConstraintColumnSelectionPanel.this._verifier.verifyName(conName);
                    }
                    catch (TraversalException traversalException) {
                        // empty catch block
                    }
                }
                if (ConstraintColumnSelectionPanel.this._con != null) {
                    ConstraintColumnSelectionPanel.this._con.setName(ConstraintColumnSelectionPanel.this._prov.getInternalName(conName));
                }
                if (ConstraintColumnSelectionPanel.this._baseConstraintPanel != null) {
                    ConstraintColumnSelectionPanel.this._baseConstraintPanel.updateListUI();
                }
            }
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    }
}

