/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.controls.JComboCardPanel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.db.Column;
import oracle.javatools.db.ColumnSequenceExpander;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Sequence;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.CharacterDataType;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.util.ModelUtil;

public class ColumnSequencePanel
extends BaseInfoPanel
implements ActionListener {
    private DBObjectProvider m_prov;
    private JPanel m_mainPanel = new JPanel();
    private JLabel m_lblColumns = new JLabel();
    private JComboBox m_cmbColumns = new JComboBox();
    private JCheckBox m_cbxColSeq = new JCheckBox();
    private JLabel m_lblSchema = new JLabel();
    private DBObjectChooser m_cmbSchemaPicker = new DBObjectChooser("SCHEMA");
    private JLabel m_lblSequence = new JLabel();
    private JComboBox m_cmbSequenceNames = new JComboBox();
    private JCheckBox m_cbxReuseWhenTemplating = new JCheckBox();
    private JLabel m_lblTrigger = new JLabel();
    private JComboBox m_cmbTriggerNames = new JComboBox();
    private JTextField m_txtTriggerName = new JTextField();
    private JCheckBox m_cbxTrigCheckForNull = new JCheckBox();
    private Table m_table;
    private Column m_lastColSelection = null;
    private ArrayList<String> m_allTriggerNames = new ArrayList();
    private ArrayList<String> m_relevantTriggerNames = new ArrayList();
    private HashMap<Schema, String[][]> m_schemaSeqsCache = new HashMap();
    private boolean m_edit = false;
    private boolean m_initialised = false;
    private DBUIResourceHelper m_resHelper = new DBUIResourceHelper("ColumnSequencePanel");

    public ColumnSequencePanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
        this.m_mainPanel.setLayout(new GridBagLayout());
        this.m_resHelper.resButton(this.m_cbxColSeq, UIArb.getString(898), "m_cbxColSeq");
        this.m_resHelper.resLabel(this.m_lblColumns, this.m_cmbColumns, UIArb.getString(897), "m_cmbColumns");
        this.m_resHelper.resLabel(this.m_lblSchema, this.m_cmbSchemaPicker, UIArb.getString(899), "m_cmbSchemaPicker");
        this.m_resHelper.resLabel(this.m_lblSequence, this.m_cmbSequenceNames, UIArb.getString(900), "m_cmbSequenceNames");
        this.m_resHelper.resButton(this.m_cbxTrigCheckForNull, UIArb.getString(902), "m_cbxTrigCheckForNull");
        this.m_resHelper.resButton(this.m_cbxReuseWhenTemplating, UIArb.getString(903), "m_cbxReuseWhenTemplating");
        this.add(this.m_lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 10, 0), 0, 0));
        this.add(this.m_cmbColumns, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 10, 0), 0, 0));
        JComboCardPanel cardPanel = new JComboCardPanel(new JLabel(), (JComponent)this.m_cbxColSeq);
        cardPanel.showSubPanel((JComponent)this.m_mainPanel);
        this.add((Component)cardPanel, new GridBagConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        int y = 0;
        this.m_mainPanel.add((Component)this.m_lblSchema, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.m_mainPanel.add((Component)this.m_cmbSchemaPicker, new GridBagConstraints(2, y, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.m_mainPanel.add((Component)this.m_lblSequence, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        this.m_mainPanel.add((Component)this.m_cmbSequenceNames, new GridBagConstraints(2, y, 1, 1, 2.0, 0.0, 17, 2, new Insets(5, 0, 0, 20), 0, 0));
        this.m_mainPanel.add((Component)this.m_lblTrigger, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 10, 10), 0, 0));
        GridBagConstraints trigGBC = new GridBagConstraints(2, y, 1, 1, 2.0, 0.0, 17, 2, new Insets(20, 0, 10, 20), 0, 0);
        this.m_mainPanel.add((Component)this.m_txtTriggerName, trigGBC);
        this.m_mainPanel.add((Component)this.m_cmbTriggerNames, trigGBC);
        this.m_mainPanel.add((Component)this.m_cbxTrigCheckForNull, new GridBagConstraints(1, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        if (this.templatingSupported()) {
            this.m_mainPanel.add((Component)this.m_cbxReuseWhenTemplating, new GridBagConstraints(1, ++y, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 0, 10), 0, 0));
        }
        this.m_mainPanel.add(Box.createVerticalGlue(), new GridBagConstraints(1, ++y, 1, 1, 0.0, 1.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.m_cmbSequenceNames.setEditable(true);
        this.m_cmbTriggerNames.setEditable(true);
        this.m_cmbColumns.addActionListener(this);
        this.m_cbxColSeq.addActionListener(this);
        this.m_cmbSchemaPicker.addChangeListener(new DBObjectChooser.ChangeListener(){

            @Override
            public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
                ColumnSequencePanel.this.setupSequenceNames((Schema)ColumnSequencePanel.this.m_cmbSchemaPicker.getDBObject());
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.m_cmbColumns) {
            try {
                this.commit();
            }
            catch (TraversalException te) {
                te.showMessageDialog((Component)this.m_cmbColumns);
                this.m_cmbColumns.setSelectedItem(this.m_lastColSelection);
                return;
            }
            this.setupPanelForColumn();
        } else if (source == this.m_cbxColSeq) {
            if (this.m_cbxColSeq.isSelected()) {
                if (this.m_lastColSelection.getProperty("AUTO_GENERATED_SEQUENCE") == null && this.m_lastColSelection.getProperty("ColumnSequenceExpander.NewSequenceName") == null) {
                    this.m_lastColSelection.setProperty("ColumnSequenceExpander.NewSequenceName", (Object)"ColumnSequenceExpander.NewSequenceName");
                    this.m_lastColSelection.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)Boolean.TRUE);
                }
            } else {
                this.clearSettings();
            }
            this.setupPanelForColumn();
        }
    }

    public void onEntry(TraversableContext dataContext) {
        DBObjectProvider prov = (DBObjectProvider)dataContext.find("DBObjectProvider");
        Table table = (Table)dataContext.find("NewObject");
        boolean edit = dataContext.find("OriginalObject") != null;
        this.init(prov, table, edit);
        if (!((Boolean)dataContext.find("DBObjectIsEditable")).booleanValue()) {
            this.enableAllComponents(false);
        }
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit();
    }

    private void init(DBObjectProvider prov, Table table, boolean edit) {
        super.init(prov, null);
        this.m_prov = prov;
        this.m_table = table;
        this.m_edit = edit;
        this.m_cmbSchemaPicker.setProvider(prov);
        this.m_cmbSchemaPicker.setDBObject((DBObject)table.getSchema());
        this.setupSequenceNames(table.getSchema());
        ArrayList<Column> columns = new ArrayList<Column>();
        for (Column col : table.getColumns()) {
            try {
                DBObject datatype = col.getDataTypeUsage().getDataTypeID().resolveID();
                if (datatype instanceof DataTypeSynonym) {
                    datatype = ((DataTypeSynonym)datatype).getBaseType();
                }
                if (!(datatype instanceof NumericDataType) && !(datatype instanceof CharacterDataType)) continue;
                columns.add(col);
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        this.m_cmbColumns.setModel(new DefaultComboBoxModel<Object>(columns.toArray()));
        if (!this.m_initialised) {
            if (edit) {
                this.m_resHelper.resLabel(this.m_lblTrigger, this.m_cmbTriggerNames, UIArb.getString(901), "m_cmbTriggerNames");
                this.m_cmbTriggerNames.setVisible(true);
                this.m_txtTriggerName.setVisible(false);
            } else {
                this.m_resHelper.resLabel(this.m_lblTrigger, this.m_txtTriggerName, UIArb.getString(901), "m_txtTriggerName");
                this.m_txtTriggerName.setVisible(true);
                this.m_cmbTriggerNames.setVisible(false);
            }
            String[] trigType = new String[]{"TRIGGER"};
            if (edit) {
                SchemaObject[] sos = null;
                try {
                    sos = prov.listObjects(trigType, table.getSchema());
                }
                catch (DBException e) {
                    // empty catch block
                }
                if (sos != null) {
                    for (SchemaObject so : sos) {
                        if (!(so instanceof Trigger)) continue;
                        this.m_allTriggerNames.add(so.getName());
                        Trigger trig = (Trigger)so;
                        if (trig.getTableID() == null || !trig.getTableID().equals(table.getID(), false)) continue;
                        boolean onInsert = false;
                        for (String event : trig.getEvents()) {
                            if (!"INSERT".equals(event)) continue;
                            onInsert = true;
                            break;
                        }
                        if (!onInsert) continue;
                        this.m_relevantTriggerNames.add(trig.getName());
                    }
                }
            }
            this.m_cmbTriggerNames.setModel(new DefaultComboBoxModel<Object>(this.m_relevantTriggerNames.toArray()));
            this.m_initialised = true;
        }
        this.enableAllComponents(columns.size() > 0);
        if (columns.size() == 0) {
            return;
        }
        this.m_cmbColumns.removeActionListener(this);
        if (this.m_lastColSelection != null && columns.contains(this.m_lastColSelection)) {
            this.m_cmbColumns.setSelectedItem(this.m_lastColSelection);
        }
        this.m_cmbColumns.addActionListener(this);
        this.setupPanelForColumn();
    }

    private void commit() throws TraversalException {
        if (this.m_lastColSelection != null) {
            this.clearSettings();
            if (this.m_cbxColSeq.isSelected()) {
                Schema schema = (Schema)this.m_cmbSchemaPicker.getDBObject();
                String seqName = (String)this.m_cmbSequenceNames.getSelectedItem();
                if (this.isExistingSequence(schema, seqName = this.getInternalName(seqName, "SEQUENCE"))) {
                    Sequence seq = null;
                    try {
                        seq = (Sequence)this.m_prov.getObject("SEQUENCE", schema, seqName);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                    if (seq != null) {
                        this.m_lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE", (Object)seq.getID());
                    }
                } else {
                    this.m_lastColSelection.setProperty("ColumnSequenceExpander.NewSequenceName", (Object)(schema.getName() + "\n" + seqName));
                }
                String trigName = this.getTriggerNameValue();
                trigName = this.getInternalName(trigName, "TRIGGER");
                if (this.isExistingTrigger(trigName, false)) {
                    Trigger trig = null;
                    try {
                        trig = (Trigger)this.m_prov.getObject("TRIGGER", this.m_table.getSchema(), trigName);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                    if (trig != null) {
                        this.m_lastColSelection.setProperty("AUTO_GENERATED_SEQUENCE_TRIGGER", (Object)trig.getID());
                    }
                } else {
                    this.m_lastColSelection.setProperty("ColumnSequenceExpander.NewTriggerName", (Object)trigName);
                }
                this.m_lastColSelection.setProperty("ColumnSequenceExpander.TriggerNullCheck", (Object)this.m_cbxTrigCheckForNull.isSelected());
                this.m_lastColSelection.setProperty("ColumnSequenceExpander.ReuseSequence", (Object)this.m_cbxReuseWhenTemplating.isSelected());
            }
        }
    }

    private String getInternalName(String extName, String type) throws TraversalException {
        if (!ModelUtil.hasLength((String)extName)) {
            throw new TraversalException(UIArb.getString("TRIGGER".equals(type) ? 904 : 905));
        }
        String intName = this.getProvider().getInternalName(extName, type);
        try {
            this.getProvider().validateName(type, intName);
        }
        catch (InvalidNameException e) {
            throw new TraversalException(type + " : " + e.getMessage());
        }
        return intName;
    }

    private void setupSequenceNames(Schema schema) {
        String[] sequenceNames = this.getSequenceNames(schema, false);
        this.m_cmbSequenceNames.setModel(new DefaultComboBoxModel<String>(sequenceNames));
    }

    private String[] getSequenceNames(Schema schema, boolean internal) {
        if (schema != null) {
            String[][] seqsCache = this.m_schemaSeqsCache.get(schema);
            if (seqsCache == null) {
                Object[] intNames = null;
                try {
                    intNames = this.getProvider().listObjects("SEQUENCE", schema);
                    if (intNames == null) {
                        intNames = new String[]{};
                    } else {
                        Arrays.sort(intNames);
                    }
                    String[] extNames = new String[intNames.length];
                    for (int i = 0; i < intNames.length; ++i) {
                        extNames[i] = this.m_prov.getExternalName((String)intNames[i]);
                    }
                    seqsCache = new String[][]{intNames, extNames};
                    this.m_schemaSeqsCache.put(schema, seqsCache);
                }
                catch (DBException e) {
                    // empty catch block
                }
            }
            return internal ? seqsCache[0] : seqsCache[1];
        }
        return new String[0];
    }

    private void setupPanelForColumn() {
        Map m;
        this.m_cbxColSeq.removeActionListener(this);
        this.m_lastColSelection = (Column)this.m_cmbColumns.getSelectedItem();
        Map map = m = this.m_lastColSelection == null ? null : this.m_lastColSelection.getProperties();
        if (m != null && (m.containsKey("AUTO_GENERATED_SEQUENCE") || m.containsKey("ColumnSequenceExpander.NewSequenceName"))) {
            DBObjectID trigID;
            this.m_cbxColSeq.setSelected(true);
            this.enableCSComponents(true);
            String schemaName = null;
            String seqName = null;
            String trigName = null;
            DBObjectID seqID = (DBObjectID)m.get("AUTO_GENERATED_SEQUENCE");
            if (seqID != null) {
                Sequence seq = null;
                try {
                    seq = (Sequence)seqID.resolveID();
                    seqName = seq.getName();
                    schemaName = seq.getSchema().getName();
                }
                catch (DBException e) {}
            } else {
                String prop = (String)m.get("ColumnSequenceExpander.NewSequenceName");
                if (prop != null && !"ColumnSequenceExpander.NewSequenceName".equals(prop)) {
                    String[] bits = prop.split("\n");
                    schemaName = bits[0];
                    seqName = bits[1];
                }
            }
            if ((trigID = (DBObjectID)m.get("AUTO_GENERATED_SEQUENCE_TRIGGER")) != null) {
                Trigger trig = null;
                try {
                    trig = (Trigger)trigID.resolveID();
                    trigName = trig.getName();
                }
                catch (DBException e) {}
            } else {
                trigName = (String)m.get("ColumnSequenceExpander.NewTriggerName");
            }
            if (!ModelUtil.hasLength((String)schemaName)) {
                schemaName = this.m_table.getSchema().getName();
            }
            if (!ModelUtil.hasLength((String)seqName)) {
                seqName = ColumnSequenceExpander.getUniqueName((DBObjectProvider)this.getProvider(), (String)"SEQUENCE", (Schema)this.m_table.getSchema(), (String)this.m_table.getName());
            }
            if (!ModelUtil.hasLength((String)trigName)) {
                trigName = ColumnSequenceExpander.getUniqueName((DBObjectProvider)this.getProvider(), (String)"TRIGGER", (Schema)this.m_table.getSchema(), (String)this.m_table.getName());
            }
            Schema schema = null;
            try {
                schema = this.m_prov.getSchema(schemaName);
            }
            catch (DBException e) {
                // empty catch block
            }
            this.m_cmbSchemaPicker.setDBObject((DBObject)schema);
            this.setupSequenceNames(schema);
            this.m_cmbSequenceNames.setSelectedItem(this.m_prov.getExternalName(seqName));
            this.setTriggerNameValue(this.m_prov.getExternalName(trigName));
            Boolean tnc = (Boolean)this.m_lastColSelection.getProperty("ColumnSequenceExpander.TriggerNullCheck");
            this.m_cbxTrigCheckForNull.setSelected(tnc != null && tnc != false);
            Boolean rwt = (Boolean)this.m_lastColSelection.getProperty("ColumnSequenceExpander.ReuseSequence");
            this.m_cbxReuseWhenTemplating.setSelected(rwt != null && rwt != false);
        } else {
            this.m_cbxColSeq.setSelected(false);
            this.m_cmbSequenceNames.setSelectedItem(null);
            this.setTriggerNameValue(null);
            this.m_cbxTrigCheckForNull.setSelected(false);
            this.m_cbxReuseWhenTemplating.setSelected(false);
            this.enableCSComponents(false);
        }
        this.m_cbxColSeq.addActionListener(this);
    }

    protected void enableAllComponents(boolean boo) {
        this.m_lblColumns.setEnabled(boo);
        this.m_cmbColumns.setEnabled(boo);
        this.m_cbxColSeq.setEnabled(boo);
        this.enableCSComponents(boo);
    }

    protected void enableCSComponents(boolean boo) {
        this.m_mainPanel.setEnabled(boo);
        this.m_cmbSchemaPicker.setEnabled(boo);
        this.m_cmbSequenceNames.setEnabled(boo);
        this.m_txtTriggerName.setEnabled(boo);
        this.m_cmbTriggerNames.setEnabled(boo);
        this.m_lblSchema.setEnabled(boo);
        this.m_lblSequence.setEnabled(boo);
        this.m_cbxReuseWhenTemplating.setEnabled(boo);
        this.m_lblTrigger.setEnabled(boo);
        this.m_cbxTrigCheckForNull.setEnabled(boo);
    }

    private boolean isExistingSequence(Schema schema, String seqName) {
        boolean found = false;
        for (String sequenceName : this.getSequenceNames(schema, true)) {
            if (!ModelUtil.areEqual((Object)sequenceName, (Object)seqName)) continue;
            found = true;
            break;
        }
        return found;
    }

    private boolean isExistingTrigger(String triggerName, boolean all) {
        return all ? this.m_allTriggerNames.contains(triggerName) : this.m_relevantTriggerNames.contains(triggerName);
    }

    private void clearSettings() {
        Map m = this.m_lastColSelection.getProperties();
        if (m != null) {
            m.remove("AUTO_GENERATED_SEQUENCE");
            m.remove("AUTO_GENERATED_SEQUENCE_TRIGGER");
            m.remove("ColumnSequenceExpander.NewSequenceName");
            m.remove("ColumnSequenceExpander.NewTriggerName");
            m.remove("ColumnSequenceExpander.ReuseSequence");
            m.remove("ColumnSequenceExpander.TriggerNullCheck");
        }
    }

    protected boolean templatingSupported() {
        return false;
    }

    protected String getTriggerNameValue() {
        if (this.m_edit) {
            return (String)this.m_cmbTriggerNames.getSelectedItem();
        }
        return this.m_txtTriggerName.getText();
    }

    protected void setTriggerNameValue(String val) {
        if (this.m_edit) {
            this.m_cmbTriggerNames.setSelectedItem(val);
        } else {
            this.m_txtTriggerName.setText(val);
        }
    }
}

