/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.ListButtons;
import oracle.ide.db.panels.BaseInfoPanel;
import oracle.ide.db.panels.table.ColumnEditorPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.wizard.WizardCallbacks;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.panels.table.CopyColumnPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.dialogs.DialogUtil;
import oracle.javatools.icons.OracleIcons;

public class ColumnInfoPanel
extends BaseInfoPanel
implements ListSelectionListener,
ListDataListener,
DocumentListener,
ActionListener {
    private DefaultListModel m_mdlColumns = new DefaultListModel();
    private JList m_lstColumns = new JList(this.m_mdlColumns);
    private ButtonsHelper m_buttHelper = new ButtonsHelper();
    private ListButtons m_pnlButtons = new ListButtons(this.m_lstColumns, this.m_buttHelper);
    private JButton m_copyButton = new JButton();
    private ColumnEditorPanel m_pnlColumn = new ColumnEditorPanel();
    private DataType m_defaultType;
    private Relation m_relation;
    private Column m_col;
    private WizardCallbacks m_callbacks;
    private String m_columnBaseName;
    private int m_currentSelection = 0;
    private boolean m_edit = false;

    public ColumnInfoPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String pnlName = "ColumnInfoPanel.";
        DBUIResourceHelper reshelp = new DBUIResourceHelper("ColumnInfoPanel.");
        this.m_pnlButtons.setButtonNames("ColumnInfoPanel.");
        JLabel lblColumns = new JLabel();
        reshelp.resLabel(lblColumns, this.m_lstColumns, UIArb.getString(576), "ColumnList");
        JScrollPane scrColumns = new JScrollPane();
        scrColumns.setVerticalScrollBarPolicy(22);
        this.m_lstColumns.setSelectionMode(2);
        this.m_lstColumns.setCellRenderer(new DBObjectRenderer());
        scrColumns.getViewport().add((Component)this.m_lstColumns, null);
        this.m_copyButton.setIcon(OracleIcons.getIcon((String)"copy.png"));
        Dimension size = new Dimension(28, 25);
        this.m_copyButton.setPreferredSize(size);
        this.m_copyButton.setMaximumSize(size);
        this.m_copyButton.setMinimumSize(size);
        this.m_copyButton.addActionListener(this);
        this.m_copyButton.setToolTipText(UIArb.getString(590));
        JPanel pnlList = new JPanel(new GridBagLayout());
        pnlList.setName("ColumnInfoPanelList");
        pnlList.add((Component)lblColumns, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)scrColumns, new GridBagConstraints(0, 1, 1, 3, 0.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        pnlList.add((Component)this.m_pnlButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(5, 5, 0, 0), 0, 0));
        pnlList.add((Component)this.m_copyButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 5, 0, 0), 0, 0));
        pnlList.add(Box.createHorizontalStrut(140), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        pnlList.add((Component)((Object)this.m_pnlColumn), new GridBagConstraints(2, 0, 1, 3, 2.0, 1.0, 13, 1, new Insets(0, 10, 0, 0), 0, 0));
        this.setLayout(new BorderLayout(0, 0));
        this.add(pnlList, "Center");
    }

    public void onEntry(TraversableContext dataContext) {
        WizardCallbacks callbacks = dataContext.getWizardCallbacks();
        this.m_edit = dataContext.find("OriginalObject") != null;
        this.init((DBObjectProvider)dataContext.find("DBObjectProvider"), (Relation)dataContext.find("NewObject"), (ColumnInfoVerifier)dataContext.find("ColumnInfoVerifier"), callbacks);
        if (callbacks != null) {
            callbacks.wizardSetInitialFocus((Component)this.m_lstColumns);
        }
        this.setInitialSelection(dataContext.find("DefaultChild"));
    }

    public void onExit(TraversableContext dataContext) throws TraversalException {
        this.commit((Relation)dataContext.find("OriginalObject"), (Relation)dataContext.find("NewObject"), dataContext.getDirection() == 2);
    }

    protected void init(DBObjectProvider prov, Relation relation, ColumnInfoVerifier verifier, WizardCallbacks callbacks) {
        super.init(prov, verifier);
        this.m_relation = relation;
        if (this.m_columnBaseName == null) {
            this.m_columnBaseName = prov.getDescriptor().getCasePolicy() == 1 ? "column" : "COLUMN";
        }
        this.m_defaultType = verifier.getDefaultType();
        if (this.m_defaultType == null) {
            this.m_defaultType = prov.getOrCreateDataType("VARCHAR2");
            this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getOrCreateDataType("VARCHAR");
            this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getOrCreateDataType("CHAR");
            DataType dataType = this.m_defaultType = this.m_defaultType != null ? this.m_defaultType : prov.getOrCreateDataType("CHARACTER");
        }
        if (relation.getColumns().length == 0 && !this.m_edit) {
            Column c = (Column)this.getProvider().getObjectFactory().newObject(Column.class, (DBObject)relation);
            if (c.getName() == null) {
                c.setName(this.m_columnBaseName + 1);
            }
            if (c.getDataTypeUsage() == null) {
                c.setDataTypeUsage(this.m_defaultType.createDefaultUsage());
            }
            c.setID(TemporaryObjectID.createID((DBObject)c));
            relation.addColumn(c);
        }
        this.m_lstColumns.getSelectionModel().removeListSelectionListener(this);
        this.m_mdlColumns.removeListDataListener(this);
        this.m_mdlColumns.removeAllElements();
        this.m_mdlColumns.clear();
        this.m_col = null;
        this.m_callbacks = callbacks;
        this.m_pnlColumn.init(prov, relation, verifier);
        this.m_mdlColumns.addListDataListener(this);
        this.m_lstColumns.getSelectionModel().addListSelectionListener(this);
        this.updateColumnData(null);
        Column[] cols = relation.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            this.m_mdlColumns.addElement(cols[i]);
        }
        this.updateButtons();
        this.updateListContents();
        if (verifier != null) {
            this.m_copyButton.setEnabled(verifier.canAddColumns());
        }
    }

    protected void commit(Relation oldTable, Relation newTable, boolean backwards) throws TraversalException {
        if (this.m_col != null) {
            this.commitColumnChanges(this.m_col);
        }
        int size = this.m_mdlColumns.size();
        ArrayList<Column> cols = new ArrayList<Column>(size);
        for (int i = 0; i < size; ++i) {
            Column col = (Column)this.m_mdlColumns.getElementAt(i);
            cols.add(col);
        }
        newTable.setColumns(cols.toArray(new Column[cols.size()]));
        ColumnInfoVerifier verifier = (ColumnInfoVerifier)this.getVerifier();
        if (!backwards && verifier != null) {
            verifier.verifyRelation();
        }
    }

    private void setInitialSelection(Object selObj) {
        int idx;
        int sel = 0;
        if (selObj != null && (idx = this.m_mdlColumns.indexOf(selObj)) != -1) {
            sel = idx;
        }
        if (this.m_mdlColumns.size() > 0) {
            this.setSelectedColumn(sel);
        }
    }

    private void commitColumnChanges(Column col) throws TraversalException {
        this.m_pnlColumn.commit(col);
        this.m_pnlColumn.getNameField().getDocument().removeDocumentListener(this);
    }

    private void updateColumnData(Column col) {
        this.m_col = col;
        this.m_pnlColumn.setColumn(col);
        if (col != null) {
            this.m_pnlColumn.getNameField().getDocument().addDocumentListener(this);
        }
        this.validate();
        this.repaint();
    }

    private void updateSelection(Object sel) {
        if (sel != this.m_col) {
            if (this.m_col != null) {
                try {
                    this.commitColumnChanges(this.m_col);
                }
                catch (TraversalException e) {
                    this.showColumnError(e);
                    return;
                }
            }
            this.updateColumnData((Column)sel);
        }
        this.updateButtons();
    }

    private void showColumnError(TraversalException ex) {
        ex.showMessageDialog((Component)((Object)this));
        int indexOfSelectedColumn = this.m_lstColumns.getSelectedIndex();
        if (indexOfSelectedColumn < 0 || this.m_mdlColumns.elementAt(indexOfSelectedColumn).equals(this.m_mdlColumns.elementAt(this.m_currentSelection))) {
            this.setSelectedColumn(this.m_currentSelection);
        } else if (this.m_currentSelection != indexOfSelectedColumn) {
            this.setSelectedColumn(this.m_col);
        }
    }

    private void updateButtons() {
        this.m_pnlButtons.enableButtons();
    }

    private void updateListContents() {
        boolean notEmpty = this.m_mdlColumns.getSize() > 0;
        this.m_lstColumns.setFocusable(notEmpty);
        if (this.m_callbacks != null) {
            Boolean val = notEmpty;
            this.m_callbacks.wizardEnableButtons(Boolean.TRUE, val, val);
        }
    }

    private void swap(int i1, int i2) {
        Object o1 = this.m_mdlColumns.getElementAt(i1);
        Object o2 = this.m_mdlColumns.getElementAt(i2);
        this.m_mdlColumns.setElementAt(o1, i2);
        this.m_mdlColumns.setElementAt(o2, i1);
    }

    private void updateColumnName() {
        if (this.m_col != null) {
            String colName = this.m_pnlColumn.getNameField().getText();
            this.m_col.setName(colName);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        Object[] sel = this.m_lstColumns.getSelectedValues();
        if (sel.length == 1) {
            this.updateSelection(this.m_lstColumns.getSelectedValue());
        } else {
            this.updateSelection(null);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent p0) {
        this.updateListContents();
    }

    @Override
    public void intervalRemoved(ListDataEvent p0) {
        this.updateListContents();
    }

    @Override
    public void contentsChanged(ListDataEvent p0) {
        this.updateListContents();
    }

    @Override
    public void insertUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    @Override
    public void removeUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    @Override
    public void changedUpdate(DocumentEvent p0) {
        this.updateColumnName();
    }

    private void setSelectedColumn(int indexOfColumn) {
        this.m_currentSelection = indexOfColumn;
        this.m_lstColumns.setSelectedIndex(this.m_currentSelection);
    }

    private void setSelectedColumn(Column column) {
        this.m_lstColumns.setSelectedValue(column, true);
        this.m_currentSelection = this.m_lstColumns.getSelectedIndex();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_copyButton) {
            this.showCopyDialog();
        }
    }

    private void showCopyDialog() {
        if ("TABLE".equals(this.m_relation.getType())) {
            if (this.m_col != null) {
                try {
                    this.commitColumnChanges(this.m_col);
                }
                catch (TraversalException e) {
                    this.showColumnError(e);
                    return;
                }
            }
            int buttonMask = 7;
            JEWTDialog dialog = JEWTDialog.createDialog((Component)DialogUtil.getAncestorDialog((Component)((Object)this)), (String)UIArb.format(603, this.m_relation.getName()), (int)buttonMask);
            final CopyColumnPanel panel = new CopyColumnPanel(this.getProvider(), (Relation)((Table)this.m_relation), this.m_edit);
            dialog.setContent((Component)panel);
            VetoableChangeListener list = new VetoableChangeListener(){

                @Override
                public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                    if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                        for (Column col : panel.getSelectedColumns()) {
                            String name = col.getName();
                            ColumnInfoPanel.this.m_buttHelper.addColumnToList(col, name, true);
                        }
                    }
                }
            };
            dialog.addVetoableChangeListener(list);
            dialog.runDialog();
        }
    }

    private class ButtonsHelper
    extends ListButtons.Controller {
        private ButtonsHelper() {
        }

        @Override
        public void addToList() {
            Column col = (Column)ColumnInfoPanel.this.getProvider().getObjectFactory().newObject(Column.class, (DBObject)ColumnInfoPanel.this.m_relation);
            if (col.getDataTypeUsage() == null) {
                col.setDataTypeUsage(ColumnInfoPanel.this.m_defaultType.createDefaultUsage());
            }
            if (col.getName() == null) {
                this.addColumnToList(col, ColumnInfoPanel.this.m_columnBaseName, false);
            } else {
                this.addColumnToList(col, col.getName(), true);
            }
        }

        public void addColumnToList(Column col, String baseName, boolean tryBase) {
            ColumnInfoPanel.this.m_currentSelection = ColumnInfoPanel.this.m_lstColumns.getSelectedIndex();
            int idx = ColumnInfoPanel.this.m_lstColumns.getSelectedIndex();
            ColumnInfoPanel.this.m_lstColumns.clearSelection();
            if (ColumnInfoPanel.this.m_lstColumns.getSelectedValue() == null) {
                Column next;
                int total;
                boolean insert;
                String name = ColumnInfoPanel.getUniqueName(baseName, ColumnInfoPanel.this.m_mdlColumns, tryBase);
                col.setName(name);
                col.setID(TemporaryObjectID.createID((DBObject)col));
                ColumnInfoPanel.this.m_relation.addColumn(col);
                ColumnInfoVerifier verifier = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
                boolean bl = insert = idx >= 0 && (verifier == null || verifier.canReorderColumns());
                if (insert && idx < (total = ColumnInfoPanel.this.m_mdlColumns.getSize()) - 1 && !verifier.canMoveColumnDown(next = (Column)ColumnInfoPanel.this.m_mdlColumns.getElementAt(idx))) {
                    insert = false;
                }
                if (insert) {
                    ColumnInfoPanel.this.m_mdlColumns.insertElementAt(col, idx + 1);
                } else {
                    ColumnInfoPanel.this.m_mdlColumns.addElement(col);
                }
                ColumnInfoPanel.this.setSelectedColumn(col);
                ColumnInfoPanel.this.m_pnlColumn.getNameField().requestFocusInWindow();
            }
        }

        @Override
        public void removeFromList() {
            ColumnInfoPanel.this.m_currentSelection = ColumnInfoPanel.this.m_lstColumns.getSelectedIndex();
            int[] selectedIndicies = ColumnInfoPanel.this.m_lstColumns.getSelectedIndices();
            ColumnInfoPanel.this.m_relation.removeColumn(ColumnInfoPanel.this.m_col);
            ColumnInfoPanel.this.m_col = null;
            for (int i = selectedIndicies.length - 1; i >= 0; --i) {
                ColumnInfoPanel.this.m_mdlColumns.remove(selectedIndicies[i]);
            }
            int newIdx = -1;
            newIdx = selectedIndicies.length > 0 && ColumnInfoPanel.this.m_mdlColumns.size() > selectedIndicies[0] ? selectedIndicies[0] : ColumnInfoPanel.this.m_mdlColumns.size() - 1;
            ColumnInfoPanel.this.setSelectedColumn(newIdx);
            if (newIdx == -1) {
                ColumnInfoPanel.this.updateSelection(null);
                ColumnInfoPanel.this.updateColumnData(null);
            }
        }

        @Override
        public String getAddTooltipText() {
            return UIArb.getString(577);
        }

        @Override
        public String getDownTooltipText() {
            return UIArb.getString(580);
        }

        @Override
        public String getRemoveTooltipText() {
            return UIArb.getString(578);
        }

        @Override
        public String getUpTooltipText() {
            return UIArb.getString(579);
        }

        @Override
        public boolean canAdd() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v.canAddColumns();
        }

        public boolean canAdd(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canAddColumn((Column)val);
        }

        @Override
        public boolean canMoveUp(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canMoveColumnUp((Column)val);
        }

        @Override
        public boolean canRemove() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canRemoveColumns();
        }

        @Override
        public boolean canRemove(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canRemoveColumn((Column)val);
        }

        @Override
        public boolean canReorder() {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canReorderColumns();
        }

        @Override
        public boolean canMoveDown(Object val) {
            ColumnInfoVerifier v = (ColumnInfoVerifier)ColumnInfoPanel.this.getVerifier();
            return v == null || v.canMoveColumnDown((Column)val);
        }
    }
}

