/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.table;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import oracle.ide.controls.NonNullableComboBoxModel;
import oracle.ide.db.UIArb;
import oracle.ide.db.controls.DBObjectChooser;
import oracle.ide.db.panels.DataTypePanel;
import oracle.ide.db.verifiers.table.ColumnInfoVerifier;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIHelper;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.diff.DBObjectComparator;
import oracle.javatools.db.ora.LOBDescriptor;
import oracle.javatools.db.property.Property;
import oracle.javatools.util.ModelUtil;

public class ColumnEditorPanel
extends ChildObjectEditorPanel<Column, Relation>
implements ActionListener,
DBObjectChooser.ChangeListener {
    private boolean m_listening;
    private boolean m_inErrorState = false;
    private JLabel m_lblColName = new JLabel();
    private JTextField m_fldName = new JTextField();
    private JLabel m_lblDataType = new JLabel();
    private JRadioButton m_rdbSimpleType = new JRadioButton();
    private JRadioButton m_rdbComplexType = new JRadioButton();
    private boolean m_simple = true;
    private JPanel m_typePanel = new JPanel();
    private JLabel m_lblType = new JLabel();
    private JComboBox m_cmbType = new JComboBox();
    private DataTypePanel m_pnlDataType = new DataTypePanel();
    private JLabel m_lblSchemas = new JLabel();
    private DBObjectChooser m_cmbSchemas = new DBObjectChooser("SCHEMA");
    private JLabel m_lblComplexType = new JLabel();
    private DBObjectChooser m_cmbComplexType = new DBObjectChooser(this.m_cmbSchemas, "TYPE");
    private JLabel m_lblDefault = new JLabel();
    private JTextField m_fldDefault = new JTextField();
    private JCheckBox m_chkNotNull = new JCheckBox();
    private JLabel m_lblComment = new JLabel();
    private JTextArea m_fldComment = new JTextArea();
    private JScrollPane m_scrComment = new JScrollPane();
    private DefaultComboBoxModel m_mdlTypes = new NonNullableComboBoxModel();
    private ColumnInfoVerifier m_verifier;
    private DBObjectProvider m_prov;
    private Schema m_defaultSchema;
    private Column m_col;
    private HashMap<String, ArrayList<String>> m_schemaTypeMap = new HashMap();
    private TreeSet<Column> m_invalidCols = new TreeSet(new DBObjectComparator());
    private String m_lastSchemaName = null;

    public ColumnEditorPanel() {
        super("ColumnEditorPanel", "columns");
        this.layoutComponents();
    }

    private void layoutComponents() {
        DBUIHelper helper = this.getHelper();
        helper.setBasePath("columns");
        helper.registerComponent(this.m_lblColName, this.m_fldName, UIArb.getString(574), "Name", "name");
        helper.registerComponent(this.m_lblType, this.m_cmbType, UIArb.getString(586), "SimpleTypeList", "dataTypeUsage");
        helper.registerComponent(this.m_lblComplexType, this.m_cmbComplexType, UIArb.getString(586), "ComplexTypeList", "dataTypeUsage");
        helper.registerComponent(this.m_lblSchemas, this.m_cmbSchemas, UIArb.getString(108), "ComplexTypeSchema", "dataTypeUsage");
        helper.registerComponent(this.m_lblDefault, this.m_fldDefault, UIArb.getString(587), "Default", "default");
        helper.registerComponent(this.m_chkNotNull, UIArb.getString(588), "NotNull", "notNull");
        helper.registerComponent(this.m_lblComment, this.m_fldComment, UIArb.getString(589), "Comment", Property.createPath((String[])new String[]{"properties", "Comment"}));
        helper.registerComponent(this.m_scrComment, Property.createPath((String[])new String[]{"properties", "Comment"}));
        helper.registerComponent(this.m_rdbSimpleType, UIArb.getString(583), "SimpleType", "dataTypeUsage");
        helper.registerComponent(this.m_rdbComplexType, UIArb.getString(584), "ComplexType", "dataTypeUsage");
        this.m_fldName.setColumns(30);
        this.m_cmbType.setModel(this.m_mdlTypes);
        this.m_cmbType.addActionListener(this);
        this.m_cmbComplexType.addChangeListener(this);
        AccessibleContext actx = this.m_rdbSimpleType.getAccessibleContext();
        if (actx != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(582)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(583)));
        }
        if ((actx = this.m_rdbComplexType.getAccessibleContext()) != null) {
            actx.setAccessibleName(DataTypeHelper.getNameFromLabel((String)UIArb.getString(582)) + DataTypeHelper.getNameFromLabel((String)UIArb.getString(584)));
        }
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.m_rdbSimpleType);
        bg.add(this.m_rdbComplexType);
        this.m_rdbSimpleType.setSelected(true);
        this.m_simple = true;
        this.m_rdbSimpleType.addActionListener(this);
        this.m_rdbComplexType.addActionListener(this);
        this.m_lblDataType.setText(UIArb.getString(582));
        this.m_scrComment.setVerticalScrollBarPolicy(22);
        this.m_fldComment.setWrapStyleWord(true);
        this.m_fldComment.setLineWrap(true);
        this.m_scrComment.getViewport().add((Component)this.m_fldComment, null);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(UIArb.getString(581)));
        this.add(this.m_lblColName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.m_fldName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 13, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(this.m_lblDataType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 12), 0, 0));
        this.add(this.m_rdbSimpleType, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.add(this.m_rdbComplexType, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 5), 0, 0));
        this.createSimpleTypePanel(this.m_typePanel);
        this.add(this.m_typePanel, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 24, 0, 5), 0, 0));
        this.add(Box.createVerticalStrut(100), new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.m_chkNotNull, new GridBagConstraints(0, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_lblComment, new GridBagConstraints(0, 11, 3, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.add(this.m_scrComment, new GridBagConstraints(0, 12, 3, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.m_listening = true;
    }

    private void createSimpleTypePanel(JPanel p) {
        p.removeAll();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.m_lblType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbType, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.m_pnlDataType, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
        p.add((Component)this.m_lblDefault, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 5), 0, 0));
        p.add((Component)this.m_fldDefault, new GridBagConstraints(1, 8, 2, 1, 0.0, 0.0, 13, 2, new Insets(10, 0, 0, 5), 0, 0));
    }

    private void createComplexTypePanel(JPanel p) {
        p.removeAll();
        p.setLayout(new GridBagLayout());
        p.add((Component)this.m_lblSchemas, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbSchemas, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        p.add((Component)this.m_lblComplexType, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        p.add((Component)this.m_cmbComplexType, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        p.add((Component)this.m_pnlDataType, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    private ComplexType getSelectedComplexType() {
        return (ComplexType)this.m_cmbComplexType.getDBObject();
    }

    private DataType getSelectedSimpleType() {
        Object selected = this.m_mdlTypes.getSelectedItem();
        if (selected instanceof TypeComboListMember) {
            return ((TypeComboListMember)selected).getDataType();
        }
        return null;
    }

    private ComplexType getComplexType(Schema schema, String name) {
        if (ModelUtil.hasLength((String)name) && schema != null) {
            SchemaObject type;
            try {
                type = this.m_prov.getObject("TYPE", schema, name);
                if (type != null) {
                    return (ComplexType)type;
                }
            }
            catch (DBException e) {
                // empty catch block
            }
            try {
                type = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
                if (type instanceof ComplexType && ModelUtil.areEqual((Object)type.getName(), (Object)name) && ModelUtil.areEqual((Object)((ComplexType)type).getSchema().getName(), (Object)schema.getName())) {
                    return (ComplexType)type;
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return null;
    }

    private SchemaObject[] getComplexTypes(Schema schema) {
        try {
            return this.m_prov.listObjects(new String[]{"TYPE"}, schema);
        }
        catch (DBException dBException) {
            return null;
        }
    }

    @Override
    protected void initialisePanel() {
        this.initImpl(this.getProvider());
        this.setColumn((Column)this.getChildObject());
    }

    public void init(DBObjectProvider prov, Relation rel, ColumnInfoVerifier verifier) {
        this.init(prov, rel == null ? null : rel.getSchema(), verifier);
        this.getHelper().setProvider(prov);
        this.getHelper().processComponents(null, (DBObject)rel);
    }

    public void init(DBObjectProvider prov, Schema schema, ColumnInfoVerifier verifier) {
        this.m_defaultSchema = schema;
        this.m_verifier = verifier;
        this.initImpl(prov);
    }

    public void initImpl(DBObjectProvider prov) {
        this.m_prov = prov;
        if (this.m_mdlTypes.getSize() < 1) {
            DataType[] types = prov.listSupportedDataTypes();
            TreeSet<DataType> sortedTypes = new TreeSet<DataType>(new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof PredefinedDataType && o2 instanceof ComplexType) {
                        return -1;
                    }
                    if (o1 instanceof ComplexType && o2 instanceof PredefinedDataType) {
                        return 1;
                    }
                    return o1.toString().compareTo(o2.toString());
                }
            });
            for (int i = 0; i < types.length; ++i) {
                sortedTypes.add(types[i]);
            }
            Collection topTypes = this.m_prov.getDescriptor().listPreferredDataTypes();
            if (topTypes != null && topTypes.size() > 0) {
                for (DataType topType : topTypes) {
                    TypeComboListMember currTyp = new TypeComboListMember(topType, "TOP");
                    this.m_mdlTypes.addElement(currTyp);
                }
                this.m_mdlTypes.addElement("--------");
            }
            Iterator iterTypes = sortedTypes.iterator();
            while (iterTypes.hasNext()) {
                TypeComboListMember currTyp = new TypeComboListMember((DataType)iterTypes.next(), "BOTTOM");
                this.m_mdlTypes.addElement(currTyp);
            }
        }
        this.m_cmbSchemas.setProvider(prov);
        this.m_cmbComplexType.setProvider(prov);
    }

    private void initSchemas() {
        Schema schema = this.m_defaultSchema;
        if (schema == null) {
            schema = DBUtil.getSchema(this.getDBObject());
        }
        if (schema != null) {
            this.m_cmbSchemas.setDBObject((DBObject)schema);
        }
    }

    public void setColumn(Column col) {
        if (col == null) {
            this.m_col = null;
        } else {
            this.m_col = (Column)col.copyTo(null);
            this.m_col.setRelation(col.getRelation());
        }
        this.updateColumnData();
    }

    @Override
    protected void commitPanel() throws TraversalException {
        Column col = (Column)this.getChildObject();
        this.commit(col);
        Relation rel = col.getRelation();
        if (rel.getColumn(col.getName()) == null) {
            rel.addColumn(col);
        }
    }

    public void commit(Column col) throws TraversalException {
        Column newCol = (Column)col.copyTo(null);
        newCol.setRelation(col.getRelation());
        try {
            this.m_prov.validateName("COLUMN", this.m_fldName.getText());
        }
        catch (InvalidNameException e) {
            this.m_invalidCols.add(col);
            throw new TraversalException(e.getMessage());
        }
        if (this.m_invalidCols.contains(col)) {
            this.m_invalidCols.remove(col);
        }
        String name = this.m_prov.getInternalName(this.m_fldName.getText());
        newCol.setName(name);
        ComplexType dataType = null;
        if (this.m_rdbSimpleType.isSelected()) {
            String def = this.m_fldDefault.getText();
            newCol.setDefault((Object)(ModelUtil.hasLength((String)def) ? def : null));
            dataType = this.getSelectedSimpleType();
            if (!LOBDescriptor.isLOBColumn((Column)newCol) && newCol.getProperty("OracleColumnProperties") != null) {
                newCol.setProperty("OracleColumnProperties", null);
            }
        } else {
            dataType = this.getSelectedComplexType();
            newCol.setDefault(null);
        }
        if (dataType == null) {
            throw new TraversalException(DBArb.format((int)223, (Object)newCol.getName()));
        }
        try {
            DataTypeUsage dataTypeUsage = this.m_pnlDataType.commit(newCol);
            dataType.validateUsage(dataTypeUsage, (DBObject)newCol);
            newCol.setDataTypeUsage(dataTypeUsage);
        }
        catch (ValidationException ex) {
            throw new TraversalException(ex.getMessage());
        }
        newCol.setNotNull(this.m_chkNotNull.isSelected());
        String comment = this.m_fldComment.getText();
        newCol.setProperty("Comment", (Object)(ModelUtil.hasLength((String)comment) ? comment : null));
        newCol.copyTo((Object)col);
        if (this.m_verifier != null) {
            this.m_verifier.verifyColumn(this.m_col, newCol);
        }
    }

    @Override
    public JTextField getNameField() {
        return this.m_fldName;
    }

    private void updateColumnData() {
        if (this.m_col == null) {
            this.m_fldName.setText("");
            this.m_fldDefault.setText("");
            this.m_chkNotNull.setSelected(false);
            this.m_fldComment.setText("");
            this.m_lblColName.setEnabled(false);
            this.m_fldName.setEnabled(false);
            this.m_lblDataType.setEnabled(false);
            this.m_rdbSimpleType.setEnabled(false);
            this.m_rdbComplexType.setEnabled(false);
            this.m_lblType.setEnabled(false);
            this.m_cmbType.setEnabled(false);
            this.m_pnlDataType.setEnabled(false);
            this.m_lblSchemas.setEnabled(false);
            this.m_cmbSchemas.setEnabled(false);
            this.m_lblComplexType.setEnabled(false);
            this.m_cmbComplexType.setEnabled(false);
            this.m_lblDefault.setEnabled(false);
            this.m_fldDefault.setEnabled(false);
            this.m_chkNotNull.setEnabled(false);
            this.m_lblComment.setEnabled(false);
            this.m_scrComment.setEnabled(false);
            this.m_fldComment.setEnabled(false);
            this.m_fldComment.setOpaque(false);
        } else {
            boolean canChangeType;
            String name = this.m_col.getName();
            if (!this.m_invalidCols.contains(this.m_col)) {
                name = this.m_prov.getExternalName(name, "COLUMN");
            }
            this.m_fldName.setText(name);
            this.m_fldName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            this.m_lblColName.setEnabled(this.m_verifier == null || this.m_verifier.canRenameColumn(this.m_col));
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType((DataTypeUsage)this.m_col.getDataTypeUsage());
            }
            catch (DBException dbe) {
                // empty catch block
            }
            boolean bl = canChangeType = this.m_verifier == null || this.m_verifier.canChangeColumnType(this.m_col);
            if (dataType instanceof ComplexType) {
                this.initSchemas();
                this.m_rdbComplexType.getModel().setSelected(true);
                this.m_simple = false;
                Schema schema = ((ComplexType)dataType).getSchema();
                this.m_cmbSchemas.setDBObject((DBObject)schema);
                this.m_cmbComplexType.setDBObject((DBObject)dataType);
                this.createComplexTypePanel(this.m_typePanel);
            } else {
                TypeComboListMember comboTyp = new TypeComboListMember(dataType, "TOP");
                this.m_mdlTypes.setSelectedItem(comboTyp);
                this.m_rdbSimpleType.getModel().setSelected(true);
                this.createSimpleTypePanel(this.m_typePanel);
                this.m_simple = true;
            }
            this.m_pnlDataType.initialise(this.m_col.getDataTypeUsage(), this.m_prov, this.m_col, this.m_verifier);
            this.m_lblDataType.setEnabled(canChangeType);
            this.m_rdbSimpleType.setEnabled(canChangeType);
            Table.TableType tableType = (Table.TableType)this.m_col.getRelation().getProperty("TableType");
            this.m_rdbComplexType.setEnabled(canChangeType && tableType != Table.TableType.EXTERNAL && this.m_prov.supportsObjectType("TYPE"));
            this.m_lblSchemas.setEnabled(canChangeType);
            this.m_cmbSchemas.setEnabled(canChangeType);
            this.m_lblComplexType.setEnabled(canChangeType);
            this.m_cmbComplexType.setEnabled(canChangeType);
            this.m_cmbType.setEnabled(canChangeType);
            this.m_lblType.setEnabled(canChangeType);
            this.m_pnlDataType.setEnabled(canChangeType);
            boolean canChangeDef = this.m_verifier == null || this.m_verifier.canChangeColumnDefaultValue(this.m_col);
            Object def = this.m_col.getDefault();
            this.m_fldDefault.setText(def != null ? def.toString() : "");
            this.m_fldDefault.setEnabled(canChangeDef);
            this.m_lblDefault.setEnabled(canChangeDef);
            this.m_chkNotNull.setSelected(this.m_col.isNotNull());
            this.m_chkNotNull.setEnabled(this.m_verifier == null || this.m_verifier.canChangeColumnNotNullState(this.m_col));
            String comment = (String)this.m_col.getProperty("Comment");
            this.m_fldComment.setText(comment != null ? comment : "");
            boolean commentEnabled = this.m_verifier == null || this.m_verifier.canChangeColumnComment(this.m_col);
            this.m_fldComment.setEnabled(commentEnabled);
            this.m_fldComment.setOpaque(commentEnabled);
            this.m_lblComment.setEnabled(commentEnabled);
            this.m_scrComment.setEnabled(commentEnabled);
        }
        this.validate();
        this.repaint();
    }

    private void updateDefault(DataType datatype, boolean visibilityOnly) {
        boolean canTakeDef = true;
        boolean canEditDef = true;
        if (null != this.m_verifier) {
            canTakeDef = this.m_verifier.canTakeDefaultValue(datatype);
            canEditDef = this.m_verifier.canChangeColumnDefaultValue(this.m_col);
        }
        if (canTakeDef) {
            Object def;
            Object object = def = null == this.m_col ? null : this.m_col.getDefault();
            if (!visibilityOnly) {
                this.m_fldDefault.setText(def != null ? def.toString() : "");
            }
            this.m_fldDefault.setEnabled(canEditDef);
            this.m_lblDefault.setEnabled(canEditDef);
        } else {
            if (!visibilityOnly) {
                this.m_fldDefault.setText("");
            }
            this.m_fldDefault.setEnabled(false);
            this.m_lblDefault.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.m_listening) {
            Object src = ae.getSource();
            if (src == this.m_cmbType) {
                DataType dataType = this.getSelectedSimpleType();
                if (dataType != null) {
                    this.m_pnlDataType.initialise(dataType.createDefaultUsage(), this.m_prov, this.m_col, this.m_verifier);
                }
                this.updateDefault(dataType, false);
            } else if (src == this.m_rdbSimpleType && !this.m_simple || src == this.m_rdbComplexType && this.m_simple) {
                DataType dataType;
                if (this.m_rdbSimpleType.isSelected()) {
                    this.createSimpleTypePanel(this.m_typePanel);
                    dataType = this.getSelectedSimpleType();
                    this.m_simple = true;
                } else {
                    this.createComplexTypePanel(this.m_typePanel);
                    this.m_simple = false;
                    this.initSchemas();
                    dataType = this.getSelectedComplexType();
                }
                this.m_pnlDataType.initialise(dataType == null ? null : dataType.createDefaultUsage(), this.m_prov, this.m_col, this.m_verifier);
                if (this.m_rdbSimpleType.isSelected()) {
                    this.updateDefault(dataType, true);
                }
                this.validate();
                this.repaint();
            }
        }
    }

    @Override
    public void chooserChanged(DBObjectChooser chooser, DBObjectID id) {
        ComplexType dataType;
        if (this.m_listening && (dataType = this.getSelectedComplexType()) != null) {
            this.m_pnlDataType.initialise(dataType.createDefaultUsage(), this.m_prov, this.m_col, this.m_verifier);
        }
    }

    private class TypeComboListMember {
        DataType m_dataType;
        String m_position;
        public static final String BOTTOM_OF_LIST = "BOTTOM";
        public static final String TOP_OF_LIST = "TOP";

        public TypeComboListMember(DataType dataType, String position) {
            this.m_dataType = dataType;
            this.m_position = position;
        }

        public boolean equals(Object obj) {
            if (obj instanceof TypeComboListMember) {
                return ModelUtil.areEqual((Object)this.getDataType(), (Object)((TypeComboListMember)obj).getDataType()) && ModelUtil.areEqual((Object)this.getPosition(), (Object)((TypeComboListMember)obj).getPosition());
            }
            return false;
        }

        public String toString() {
            return this.m_dataType == null ? "" : this.m_dataType.toString();
        }

        public DataType getDataType() {
            return this.m_dataType;
        }

        public String getPosition() {
            return this.m_position;
        }
    }
}

