/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql.tester;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.db.panels.sql.tester.TesterComponent;
import oracle.ide.db.panels.sql.tester.TesterPanel;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.Database;

public class SQLQueryTester {
    private static Collection<Class<? extends TesterComponent>> s_registry;
    private final Database m_db;
    private final TesterPanel m_panel;

    public SQLQueryTester(Database db) {
        this.m_db = db;
        this.m_panel = new TesterPanel();
        for (TesterComponent comp : SQLQueryTester.createComponents()) {
            this.m_panel.addPanel(comp);
        }
    }

    private String getTitle() {
        return UIBundle.get("TESTSQL_TITLE");
    }

    public void showDialog(Component owner, String sqlText) {
        int buttonMask = 20;
        JEWTDialog dialog = JEWTDialog.createDialog((Component)owner, (String)this.getTitle(), (int)20);
        dialog.setMinimumSize(new Dimension(500, 400));
        dialog.setPreferredSize(new Dimension(500, 600));
        dialog.setResizable(true);
        dialog.setContent((Component)this.m_panel);
        dialog.setDefaultCloseOperation(2);
        dialog.setButtonMask(20);
        dialog.setDefaultButton(16);
        dialog.setInitialFocus(this.m_panel.getDefaultFocusComponent());
        this.m_panel.testSQL(this.m_db, sqlText);
        dialog.runDialog();
    }

    public void setSQLText(String txt) {
        this.m_panel.testSQL(this.m_db, txt);
    }

    public static void registerComponent(Class<? extends TesterComponent> clz) {
        if (clz != null) {
            if (s_registry == null) {
                s_registry = new ArrayList<Class<? extends TesterComponent>>();
            }
            if (!s_registry.contains(clz)) {
                s_registry.add(clz);
            }
        }
    }

    private static Collection<TesterComponent> createComponents() {
        List<TesterComponent> retval;
        if (s_registry == null) {
            retval = Collections.emptyList();
        } else {
            retval = new ArrayList();
            for (Class<? extends TesterComponent> clz : s_registry) {
                try {
                    retval.add(clz.newInstance());
                }
                catch (Exception e) {
                    DBLog.getLogger(SQLQueryTester.class).log(Level.WARNING, "Error creating query test component " + clz.getSimpleName(), e);
                }
            }
        }
        return retval;
    }
}

