/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.panels.sql;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.db.UIArb;
import oracle.ide.db.panels.sql.BaseSQLQueryBuilderPanel;
import oracle.ide.db.panels.sql.ExpressionPanel;
import oracle.ide.db.util.DBObjectRenderer;
import oracle.ide.db.util.ExpressionEditSupport;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.javatools.controls.completionfield.CompletionTextField;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.View;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FunctionDefinition;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public class OrderByPanel
extends BaseSQLQueryBuilderPanel
implements ActionListener,
DocumentListener,
ExpressionPanel.FragmentProvider {
    private SQLQueryBuilder m_builder;
    private JWrappedLabel m_desc = new JWrappedLabel(UIArb.getString(256));
    private ExpressionPanel m_expPanel;
    private boolean m_init;
    private JPanel m_editor;
    private JLabel m_expLabel = new JLabel();
    private CompletionTextField m_exp = new CompletionTextField();
    private ExpressionEditSupport m_editSupport = new ExpressionEditSupport((JTextComponent)this.m_exp);
    private JLabel m_ascLabel = new JLabel();
    private JComboBox m_asc = new JComboBox();
    private JLabel m_nullsLabel = new JLabel();
    private JComboBox m_nulls = new JComboBox();
    private JButton m_validate = new JButton();
    private OrderByObject m_current;
    private boolean m_commitPending;
    private boolean m_new;

    public OrderByPanel() {
        try {
            this.layoutComponents();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void layoutComponents() {
        Object par = this.getObject();
        String r = par instanceof View ? ((View)par).getQueryRestriction() : null;
        this.removeAll();
        if (ModelUtil.hasLength((String)r)) {
            this.layoutMessageOnly(UIArb.format(262, r));
        } else {
            this.setLayout(new BorderLayout(0, 5));
            this.add((Component)this.m_desc, "North");
            if (this.m_expPanel == null) {
                this.m_expPanel = new ExpressionPanel(this);
            }
            this.add(this.m_expPanel, "Center");
        }
    }

    @Override
    protected void init(SQLQueryBuilder builder, DBObject defaultObject) {
        this.m_builder = builder;
        this.enableButtons(true);
        this.layoutComponents();
        FunctionDefinition[] funcs = this.m_builder.getBuiltInFunctions();
        if (!this.m_init) {
            this.m_expPanel.setDBObjectProvider(this.m_pro);
            for (int i = 0; i < funcs.length; ++i) {
                this.m_expPanel.addFunction(funcs[i]);
            }
            this.m_init = true;
        }
        HashSet<Object> objs = new HashSet<Object>();
        this.m_expPanel.clearTemplates();
        FromObject[] froms = this.m_builder.listAllFromObjects();
        for (int i = 0; i < froms.length; ++i) {
            this.m_expPanel.addTemplate((SQLFragment)froms[i], true);
            objs.add(froms[i]);
        }
        objs.addAll(Arrays.asList(funcs));
        this.m_editSupport.setInsightMap(ExpressionEditSupport.createInsightMap(froms));
        this.m_editSupport.setInsightObjects(objs);
        OrderByObject orderby = defaultObject instanceof OrderByObject ? (OrderByObject)defaultObject : null;
        this.m_expPanel.entered((SQLFragment[])this.m_builder.getSQLQuery().getOrderByObjects(), (SQLFragment)orderby);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (this.m_expPanel != null) {
            this.m_expPanel.exited();
        }
    }

    private void updateCurrentFrag() throws SQLQueryException {
        String expression = this.m_exp.getText().trim();
        if (this.m_current != null) {
            OrderByObject old = new OrderByObject(this.m_current.getExpression(), this.m_current.getOrder(), this.m_current.getNullOrdering());
            SQLFragment exp = this.m_builder.parseOrderByExpression(expression);
            this.m_current.setExpression(exp);
            this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
            if (this.m_new) {
                this.m_builder.addOrderByObject(this.m_current);
                this.m_new = false;
            } else {
                this.m_builder.replaceOrderByObject(old, this.m_current);
            }
        }
    }

    private void enableComponents(boolean en) {
        this.m_expLabel.setEnabled(en);
        this.m_exp.setEnabled(en);
        this.m_ascLabel.setEnabled(en);
        this.m_asc.setEnabled(en);
        this.m_nullsLabel.setEnabled(en);
        this.m_nulls.setEnabled(en);
        this.m_validate.setEnabled(en);
        if (!en) {
            this.m_exp.setText(null);
            this.m_asc.setSelectedItem("");
            this.m_nulls.setSelectedItem("");
            this.m_commitPending = false;
        }
    }

    @Override
    public SQLFragment newFragment() {
        this.m_current = new OrderByObject();
        this.edit((SQLFragment)this.m_current);
        this.m_commitPending = true;
        this.m_new = true;
        return this.m_current;
    }

    @Override
    public boolean removeFragment(SQLFragment frag) {
        if (this.m_new) {
            this.m_new = false;
            return true;
        }
        return this.m_builder.removeOrderByObject((OrderByObject)frag);
    }

    @Override
    public void moveFragment(SQLFragment frag, int newIndex) {
        this.m_builder.getSQLQuery().moveOrderByObject((OrderByObject)frag, newIndex);
    }

    @Override
    public void commit() throws TraversalException {
        if (this.m_commitPending) {
            SQLFragment exp = this.m_current == null ? null : this.m_current.getExpression();
            String existing = exp == null ? null : exp.getSQLText();
            String expression = this.m_exp.getText().trim();
            if (ModelUtil.areDifferent((Object)expression, (Object)existing)) {
                try {
                    this.updateCurrentFrag();
                }
                catch (SQLQueryException e) {
                    throw new TraversalException(UIArb.getString(164) + " " + e.getMessage());
                }
            } else {
                this.m_current.setNullOrdering((String)this.m_nulls.getSelectedItem());
                this.m_current.setOrder((String)this.m_asc.getSelectedItem());
            }
            this.m_commitPending = false;
        }
    }

    @Override
    public void edit(SQLFragment frag) {
        this.m_editSupport.clearUndo();
        OrderByObject orderByObject = this.m_current = frag instanceof OrderByObject ? (OrderByObject)frag : null;
        if (this.m_current == null) {
            this.enableComponents(false);
        } else {
            this.enableComponents(true);
            SQLFragment exp = this.m_current == null ? null : this.m_current.getExpression();
            this.m_exp.getDocument().removeDocumentListener(this);
            this.m_exp.setText(exp == null ? "" : exp.getSQLText());
            this.m_exp.getDocument().addDocumentListener(this);
            String order = this.m_current.getOrder();
            order = ModelUtil.hasLength((String)order) ? order.toUpperCase() : "";
            String nullOrdering = this.m_current.getNullOrdering();
            nullOrdering = ModelUtil.hasLength((String)nullOrdering) ? nullOrdering.toUpperCase() : "";
            this.m_asc.setSelectedItem(order);
            this.m_nulls.setSelectedItem(nullOrdering);
            this.m_exp.requestFocusInWindow();
            this.m_exp.selectAll();
            this.m_commitPending = false;
        }
    }

    @Override
    public String getComponentNamePrefix() {
        return "OrderByPanel";
    }

    @Override
    public JPanel getEditorUI() {
        if (this.m_editor == null) {
            this.m_editor = new JPanel();
            this.m_editor.setLayout(new GridBagLayout());
            this.m_editor.setName(this.getComponentNamePrefix());
            DBUIResourceHelper reshelp = new DBUIResourceHelper(this.getComponentNamePrefix());
            ToolTipManager.sharedInstance().registerComponent((JComponent)this.m_exp);
            reshelp.resLabel(this.m_expLabel, (Component)this.m_exp, UIArb.getString(161), "Expression");
            this.m_editor.add((Component)this.m_expLabel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_editor.add((Component)this.m_exp, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_validate.addActionListener(this);
            reshelp.resButton(this.m_validate, UIArb.getString(166), "Validate");
            this.m_editor.add((Component)this.m_validate, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 0, 5, 5), 0, 0));
            this.m_asc.addActionListener(this);
            reshelp.resLabel(this.m_ascLabel, this.m_asc, UIArb.getString(258), "Order");
            this.m_editor.add((Component)this.m_ascLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            this.m_asc.setEditable(false);
            this.m_asc.addItem("");
            this.m_asc.addItem("ASC");
            this.m_asc.addItem("DESC");
            this.m_editor.add((Component)this.m_asc, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
            reshelp.resLabel(this.m_nullsLabel, this.m_nulls, UIArb.getString(259), "Nulls");
            this.m_editor.add((Component)this.m_nullsLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_nulls.addActionListener(this);
            this.m_nulls.setEditable(false);
            this.m_nulls.addItem("");
            this.m_nulls.addItem("NULLS FIRST");
            this.m_nulls.addItem("NULLS LAST");
            this.m_editor.add((Component)this.m_nulls, new GridBagConstraints(2, 5, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 0, 5), 0, 0));
            this.m_editor.add(Box.createVerticalGlue(), new GridBagConstraints(1, 6, 1, 1, 0.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.enableComponents(false);
        return this.m_editor;
    }

    @Override
    public void addToExpression(String text) {
        this.m_editSupport.addToExpressionField(text);
    }

    @Override
    public String getEditorName() {
        return UIArb.getString(260);
    }

    @Override
    public String getListTitle() {
        return UIArb.getString(257);
    }

    @Override
    public String getTemplateTitle() {
        return UIArb.getString(165);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.m_validate) {
            try {
                this.updateCurrentFrag();
                DBObjectRenderer.setToolTipText((JComponent)this.m_exp, null);
                this.m_expPanel.repaint();
            }
            catch (SQLQueryException sqe) {
                String message = sqe.getMessage();
                this.m_expPanel.showInvalidExpressionDialog(new TraversalException(message));
                DBObjectRenderer.setToolTipText((JComponent)this.m_exp, message);
            }
        } else {
            this.m_commitPending = true;
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.m_commitPending = true;
    }
}

